/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.Basic;
import com.sun.j3d.utils.geometry.Numerics;
import com.sun.j3d.utils.geometry.Triangulator;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

class Project {
    Project() {
    }

    static void projectFace(Triangulator triangulator, int n, int n2) {
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Project.determineNormal(triangulator, triangulator.loops[n], vector3f);
        int n3 = n + 1;
        if (n3 < n2) {
            for (int i = n3; i < n2; ++i) {
                Project.determineNormal(triangulator, triangulator.loops[i], vector3f2);
                if (Basic.dotProduct(vector3f, vector3f2) < 0.0) {
                    Basic.invertVector(vector3f2);
                }
                Basic.vectorAdd(vector3f, vector3f2, vector3f);
            }
            double d = Basic.lengthL2(vector3f);
            if (Numerics.gt(d, 1.0E-8)) {
                Basic.divScalar(d, vector3f);
            } else {
                vector3f.y = 0.0f;
                vector3f.x = 0.0f;
                vector3f.z = 1.0f;
            }
        }
        Project.projectPoints(triangulator, n, n2, vector3f);
    }

    static void determineNormal(Triangulator triangulator, int n, Vector3f vector3f) {
        int n2 = n;
        int n3 = triangulator.fetchData(n2);
        int n4 = triangulator.fetchPrevData(n2);
        int n5 = triangulator.fetchData(n4);
        int n6 = triangulator.fetchNextData(n2);
        int n7 = triangulator.fetchData(n6);
        Vector3f vector3f2 = new Vector3f();
        Basic.vectorSub(triangulator.vertices[n5], triangulator.vertices[n3], vector3f2);
        Vector3f vector3f3 = new Vector3f();
        Basic.vectorSub(triangulator.vertices[n7], triangulator.vertices[n3], vector3f3);
        Vector3f vector3f4 = new Vector3f();
        Basic.vectorProduct(vector3f2, vector3f3, vector3f4);
        double d = Basic.lengthL2(vector3f4);
        if (Numerics.gt(d, 1.0E-8)) {
            Basic.divScalar(d, vector3f4);
            vector3f.set(vector3f4);
        } else {
            vector3f.z = 0.0f;
            vector3f.y = 0.0f;
            vector3f.x = 0.0f;
        }
        vector3f2.set(vector3f3);
        n2 = n6;
        n6 = triangulator.fetchNextData(n2);
        n7 = triangulator.fetchData(n6);
        while (n2 != n) {
            Basic.vectorSub(triangulator.vertices[n7], triangulator.vertices[n3], vector3f3);
            Basic.vectorProduct(vector3f2, vector3f3, vector3f4);
            d = Basic.lengthL2(vector3f4);
            if (Numerics.gt(d, 1.0E-8)) {
                Basic.divScalar(d, vector3f4);
                if (Basic.dotProduct(vector3f, vector3f4) < 0.0) {
                    Basic.invertVector(vector3f4);
                }
                Basic.vectorAdd(vector3f, vector3f4, vector3f);
            }
            vector3f2.set(vector3f3);
            n2 = n6;
            n6 = triangulator.fetchNextData(n2);
            n7 = triangulator.fetchData(n6);
        }
        d = Basic.lengthL2(vector3f);
        if (Numerics.gt(d, 1.0E-8)) {
            Basic.divScalar(d, vector3f);
        } else {
            vector3f.y = 0.0f;
            vector3f.x = 0.0f;
            vector3f.z = 1.0f;
        }
    }

    static void projectPoints(Triangulator triangulator, int n, int n2, Vector3f vector3f) {
        Matrix4f matrix4f = new Matrix4f();
        Point3f point3f = new Point3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        if ((double)Math.abs(vector3f.x) > 0.1 || (double)Math.abs(vector3f.y) > 0.1) {
            vector3f2.x = -vector3f.y;
            vector3f2.y = vector3f.x;
            vector3f2.z = 0.0f;
        } else {
            vector3f2.x = vector3f.z;
            vector3f2.z = -vector3f.x;
            vector3f2.y = 0.0f;
        }
        double d = Basic.lengthL2(vector3f2);
        Basic.divScalar(d, vector3f2);
        Basic.vectorProduct(vector3f2, vector3f, vector3f3);
        d = Basic.lengthL2(vector3f3);
        Basic.divScalar(d, vector3f3);
        matrix4f.m00 = vector3f2.x;
        matrix4f.m01 = vector3f2.y;
        matrix4f.m02 = vector3f2.z;
        matrix4f.m03 = 0.0f;
        matrix4f.m10 = vector3f3.x;
        matrix4f.m11 = vector3f3.y;
        matrix4f.m12 = vector3f3.z;
        matrix4f.m13 = 0.0f;
        matrix4f.m20 = vector3f.x;
        matrix4f.m21 = vector3f.y;
        matrix4f.m22 = vector3f.z;
        matrix4f.m23 = 0.0f;
        matrix4f.m30 = 0.0f;
        matrix4f.m31 = 0.0f;
        matrix4f.m32 = 0.0f;
        matrix4f.m33 = 1.0f;
        triangulator.initPnts(20);
        for (int i = n; i < n2; ++i) {
            int n3;
            int n4 = n3 = triangulator.loops[i];
            int n5 = triangulator.fetchData(n4);
            matrix4f.transform(triangulator.vertices[n5], point3f);
            n5 = triangulator.storePoint(point3f.x, point3f.y);
            triangulator.updateIndex(n4, n5);
            n4 = triangulator.fetchNextData(n4);
            n5 = triangulator.fetchData(n4);
            while (n4 != n3) {
                matrix4f.transform(triangulator.vertices[n5], point3f);
                n5 = triangulator.storePoint(point3f.x, point3f.y);
                triangulator.updateIndex(n4, n5);
                n4 = triangulator.fetchNextData(n4);
                n5 = triangulator.fetchData(n4);
            }
        }
    }
}

