/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.apng;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.DataFormatException;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import jp.sourceforge.acerola3d.apng.APNGMetadata;
import jp.sourceforge.acerola3d.apng.Chunk;
import jp.sourceforge.acerola3d.apng.Frame;

public class APNGImageReader
extends ImageReader {
    static byte[] pngSignature = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    ImageInputStream stream = null;
    int width;
    int height;
    int bitDepth;
    int colorType;
    int compressionMethod;
    int filterMethod;
    int interlaceMethod;
    byte[][] palette;
    HashMap<Integer, Integer> alpha;
    Frame currentFrame;
    ArrayList<Frame> frames = new ArrayList();
    int chunkSequence = 0;
    int num_frames;
    int num_plays;
    boolean gotAllData = false;
    APNGMetadata metadata = null;

    public APNGImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public void setInput(Object input, boolean isStreamable) {
        super.setInput(input, isStreamable);
        if (input == null) {
            this.stream = null;
            return;
        }
        if (!(input instanceof ImageInputStream)) {
            throw new IllegalArgumentException("bad input");
        }
        this.stream = (ImageInputStream)input;
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IIOException {
        this.readAll();
        return this.num_frames;
    }

    private void checkIndex(int imageIndex) throws IIOException {
        this.readAll();
        if (imageIndex < 0 || imageIndex >= this.num_frames) {
            throw new IndexOutOfBoundsException("bad index");
        }
    }

    @Override
    public int getWidth(int imageIndex) throws IIOException {
        this.checkIndex(imageIndex);
        return this.width;
    }

    @Override
    public int getHeight(int imageIndex) throws IIOException {
        this.checkIndex(imageIndex);
        return this.height;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IIOException {
        this.checkIndex(imageIndex);
        ArrayList<ImageTypeSpecifier> al = new ArrayList<ImageTypeSpecifier>();
        if (this.colorType == 0) {
            al.add(ImageTypeSpecifier.createGrayscale(8, 0, false));
        } else if (this.colorType == 2) {
            al.add(ImageTypeSpecifier.createGrayscale(8, 0, false));
        } else if (this.colorType == 3) {
            al.add(ImageTypeSpecifier.createGrayscale(8, 0, false));
        } else if (this.colorType == 4) {
            al.add(ImageTypeSpecifier.createGrayscale(8, 0, false));
            int datatype = 0;
            ColorSpace rgb = ColorSpace.getInstance(1000);
            int[] bandOffsets = new int[]{0, 1, 2};
            al.add(ImageTypeSpecifier.createInterleaved(rgb, bandOffsets, datatype, false, false));
        } else if (this.colorType == 6) {
            int datatype = 0;
            ColorSpace rgb = ColorSpace.getInstance(1000);
            int[] bandOffsets = new int[]{0, 1, 2, 3};
            al.add(ImageTypeSpecifier.createInterleaved(rgb, bandOffsets, datatype, true, false));
        }
        return al.iterator();
    }

    public void readAll() throws IIOException {
        if (this.gotAllData) {
            return;
        }
        this.gotAllData = true;
        if (this.stream == null) {
            throw new IllegalStateException("No input stream");
        }
        byte[] signature = new byte[8];
        try {
            this.stream.readFully(signature);
        }
        catch (IOException e) {
            throw new IIOException("Error reading signature", e);
        }
        for (int i = 0; i < pngSignature.length; ++i) {
            if (signature[i] == pngSignature[i]) continue;
            throw new IIOException("Bad file signature!");
        }
        try {
            Chunk c;
            ArrayList<Chunk> chunks = new ArrayList<Chunk>();
            do {
                c = new Chunk(this.stream);
                chunks.add(c);
            } while (!c.typeStr.equals("IEND"));
            this.stream.close();
            for (Chunk c2 : chunks) {
                if (c2.typeStr.equals("IHDR")) {
                    this.process_IHDR(c2);
                    continue;
                }
                if (c2.typeStr.equals("cHRM")) {
                    this.process_cHRM(c2);
                    continue;
                }
                if (c2.typeStr.equals("gAMA")) {
                    this.process_gAMA(c2);
                    continue;
                }
                if (c2.typeStr.equals("iCCP")) {
                    this.process_iCCP(c2);
                    continue;
                }
                if (c2.typeStr.equals("sBIT")) {
                    this.process_sBIT(c2);
                    continue;
                }
                if (c2.typeStr.equals("sRGB")) {
                    this.process_sRGB(c2);
                    continue;
                }
                if (c2.typeStr.equals("PLTE")) {
                    this.process_PLTE(c2);
                    continue;
                }
                if (c2.typeStr.equals("bKGD")) {
                    this.process_bKGD(c2);
                    continue;
                }
                if (c2.typeStr.equals("hIST")) {
                    this.process_hIST(c2);
                    continue;
                }
                if (c2.typeStr.equals("tRNS")) {
                    this.process_tRNS(c2);
                    continue;
                }
                if (c2.typeStr.equals("pHYs")) {
                    this.process_pHYs(c2);
                    continue;
                }
                if (c2.typeStr.equals("sPLT")) {
                    this.process_sPLT(c2);
                    continue;
                }
                if (c2.typeStr.equals("IDAT")) {
                    this.process_IDAT(c2);
                    continue;
                }
                if (c2.typeStr.equals("IEND")) {
                    this.process_IEND(c2);
                    continue;
                }
                if (c2.typeStr.equals("tIME")) {
                    this.process_tIME(c2);
                    continue;
                }
                if (c2.typeStr.equals("iTXt")) {
                    this.process_iTXt(c2);
                    continue;
                }
                if (c2.typeStr.equals("tEXt")) {
                    this.process_tEXt(c2);
                    continue;
                }
                if (c2.typeStr.equals("zTXt")) {
                    this.process_zTXt(c2);
                    continue;
                }
                if (c2.typeStr.equals("acTL")) {
                    this.process_acTL(c2);
                    continue;
                }
                if (c2.typeStr.equals("fcTL")) {
                    this.process_fcTL(c2);
                    continue;
                }
                if (c2.typeStr.equals("fdAT")) {
                    this.process_fdAT(c2);
                    continue;
                }
                this.process_OTHER(c2);
            }
            this.metadata = new APNGMetadata();
        }
        catch (Exception e) {
            throw new IIOException("Exception reading data", e);
        }
    }

    void process_IHDR(Chunk c) throws IOException {
        DataInputStream dis = c.getDataInputStream();
        this.width = dis.readInt();
        this.height = dis.readInt();
        this.bitDepth = dis.readByte();
        this.colorType = dis.readByte();
        this.compressionMethod = dis.readByte();
        this.filterMethod = dis.readByte();
        this.interlaceMethod = dis.readByte();
    }

    void process_cHRM(Chunk c) {
        System.out.println("cHRM: not implemented.");
    }

    void process_gAMA(Chunk c) {
        System.out.println("gAMA: not implemented.");
    }

    void process_iCCP(Chunk c) {
        System.out.println("iCCP: not implemented.");
    }

    void process_sBIT(Chunk c) {
        System.out.println("sBIT: not implemented.");
    }

    void process_sRGB(Chunk c) {
        System.out.println("sRGB: not implemented.");
    }

    void process_PLTE(Chunk c) {
        this.palette = new byte[c.data.length / 3][];
        for (int i = 0; i < c.data.length / 3; ++i) {
            byte[] rgb = new byte[]{c.data[3 * i], c.data[3 * i + 1], c.data[3 * i + 2]};
            this.palette[i] = rgb;
        }
    }

    void process_bKGD(Chunk c) {
        System.out.println("bKGD: not implemented.");
    }

    void process_hIST(Chunk c) {
        System.out.println("hIST: not implemented.");
    }

    void process_tRNS(Chunk c) {
        this.alpha = new HashMap();
        if (this.colorType == 0) {
            for (int i = 0; i < c.data.length; i += 2) {
                byte b0 = c.data[i + 0];
                byte b1 = c.data[i + 1];
                int color = 0xFF & b0;
                color <<= 8;
                this.alpha.put(color |= 0xFF & b1, 0);
            }
        } else if (this.colorType == 2) {
            for (int i = 0; i < c.data.length; i += 6) {
                byte b0 = c.data[i + 0];
                byte b1 = c.data[i + 1];
                byte b2 = c.data[i + 2];
                byte b3 = c.data[i + 3];
                byte b4 = c.data[i + 4];
                byte b5 = c.data[i + 5];
                int color = 0xFF & b0;
                color <<= 8;
                color |= 0xFF & b1;
                color <<= 8;
                color |= 0xFF & b2;
                color <<= 8;
                color |= 0xFF & b3;
                color <<= 8;
                color |= 0xFF & b4;
                color <<= 8;
                this.alpha.put(color |= 0xFF & b5, 0);
            }
        } else if (this.colorType == 3) {
            for (int i = 0; i < c.data.length; ++i) {
                this.alpha.put(i, Integer.valueOf(c.data[i]));
            }
        } else {
            System.out.println("tRNS: ERROR!");
            System.out.println("colorType=" + this.colorType + " must not have tRNS.");
        }
    }

    void process_pHYs(Chunk c) {
        System.out.println("pHYs: not implemented.");
    }

    void process_sPLT(Chunk c) {
        System.out.println("sPLT: not implemented.");
    }

    void process_IDAT(Chunk c) throws IOException {
        if (this.currentFrame == null) {
            this.currentFrame = new Frame(this, null, -1);
        }
        this.currentFrame.addChunk(c, this.chunkSequence);
    }

    void process_IEND(Chunk c) throws DataFormatException {
        this.currentFrame.createImage();
        this.frames.add(this.currentFrame);
    }

    void process_tIME(Chunk c) {
        System.out.println("tIME: not implemented.");
    }

    void process_iTXt(Chunk c) {
        System.out.println("iTXt: not implemented.");
    }

    void process_tEXt(Chunk c) {
        System.out.println("tEXt: not implemented.");
    }

    void process_zTXt(Chunk c) {
        System.out.println("zTXt: not implemented.");
    }

    void process_acTL(Chunk c) throws IOException {
        DataInputStream dis = c.getDataInputStream();
        this.num_frames = dis.readInt();
        if (this.num_frames == 0) {
            System.out.println("num_frams must not 0.");
        }
        this.num_plays = dis.readInt();
    }

    void process_fcTL(Chunk c) throws IOException, DataFormatException {
        if (this.currentFrame != null) {
            this.currentFrame.createImage();
            this.frames.add(this.currentFrame);
        }
        this.currentFrame = new Frame(this, c, this.chunkSequence++);
    }

    void process_fdAT(Chunk c) {
        this.currentFrame.addChunk(c, this.chunkSequence++);
    }

    void process_OTHER(Chunk c) {
        System.out.println(c.typeStr + " : not implemented.");
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IIOException {
        this.readAll();
        return this.frames.get(imageIndex).getImage();
    }

    public BufferedImage read_BAK(int imageIndex, ImageReadParam param) throws IIOException {
        Rectangle sourceRegion = APNGImageReader.getSourceRegion(param, this.width, this.height);
        int sourceXSubsampling = 1;
        int sourceYSubsampling = 1;
        int[] sourceBands = null;
        int[] destinationBands = null;
        Point destinationOffset = new Point(0, 0);
        if (param != null) {
            sourceXSubsampling = param.getSourceXSubsampling();
            sourceYSubsampling = param.getSourceYSubsampling();
            sourceBands = param.getSourceBands();
            destinationBands = param.getDestinationBands();
            destinationOffset = param.getDestinationOffset();
        }
        BufferedImage dst = APNGImageReader.getDestination(param, this.getImageTypes(imageIndex), this.width, this.height);
        int inputBands = 0;
        if (this.colorType == 0) {
            inputBands = 1;
        } else if (this.colorType == 2) {
            inputBands = 3;
        } else if (this.colorType == 3) {
            inputBands = 1;
        } else if (this.colorType == 4) {
            inputBands = 2;
        } else if (this.colorType == 6) {
            inputBands = 4;
        }
        System.out.println("GAHA:" + dst.getSampleModel().getNumBands());
        APNGImageReader.checkReadParamBandSettings(param, inputBands, dst.getSampleModel().getNumBands());
        int[] bandOffsets = new int[inputBands];
        for (int i = 0; i < inputBands; ++i) {
            bandOffsets[i] = i;
        }
        int bytesPerRow = this.width * inputBands;
        DataBufferByte rowDB = new DataBufferByte(bytesPerRow);
        WritableRaster rowRas = Raster.createInterleavedRaster(rowDB, this.width, 1, bytesPerRow, inputBands, bandOffsets, new Point(0, 0));
        byte[] rowBuf = rowDB.getData();
        int[] pixel = rowRas.getPixel(0, 0, (int[])null);
        WritableRaster imRas = dst.getWritableTile(0, 0);
        int dstMinX = imRas.getMinX();
        int dstMaxX = dstMinX + imRas.getWidth() - 1;
        int dstMinY = imRas.getMinY();
        int dstMaxY = dstMinY + imRas.getHeight() - 1;
        if (sourceBands != null) {
            rowRas = rowRas.createWritableChild(0, 0, this.width, 1, 0, 0, sourceBands);
        }
        if (destinationBands != null) {
            imRas = imRas.createWritableChild(0, 0, imRas.getWidth(), imRas.getHeight(), 0, 0, destinationBands);
        }
        block3: for (int srcY = 0; srcY < this.height; ++srcY) {
            int dstY;
            try {
                this.stream.readFully(rowBuf);
            }
            catch (IOException e) {
                throw new IIOException("Error reading line " + srcY, e);
            }
            if (srcY < sourceRegion.y || srcY >= sourceRegion.y + sourceRegion.height || (srcY - sourceRegion.y) % sourceYSubsampling != 0 || (dstY = destinationOffset.y + (srcY - sourceRegion.y) / sourceYSubsampling) < dstMinY) continue;
            if (dstY > dstMaxY) break;
            for (int srcX = sourceRegion.x; srcX < sourceRegion.x + sourceRegion.width; ++srcX) {
                int dstX;
                if ((srcX - sourceRegion.x) % sourceXSubsampling != 0 || (dstX = destinationOffset.x + (srcX - sourceRegion.x) / sourceXSubsampling) < dstMinX) continue;
                if (dstX > dstMaxX) continue block3;
                rowRas.getPixel(srcX, 0, pixel);
                imRas.setPixel(dstX, dstY, pixel);
            }
        }
        return dst;
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IIOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IIOException {
        this.readAll();
        return this.metadata;
    }
}

