/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.PrefetchCompleteEvent;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;
import javax.media.Renderer;
import javax.media.ResourceUnavailableEvent;
import javax.media.Time;
import javax.media.control.TrackControl;
import javax.media.format.VideoFormat;
import jp.sourceforge.acerola3d.a3.A3VideoRenderer;

class A3VideoController
implements ControllerListener {
    Processor p;
    int[] waitSync = new int[0];
    boolean stateTransOK = true;
    A3VideoRenderer a3VideoRenderer;

    public boolean open(MediaLocator ml) {
        try {
            this.p = Manager.createProcessor((MediaLocator)ml);
        }
        catch (Exception ex) {
            System.out.println("failed to create a processor for movie " + ml);
            return false;
        }
        this.p.addControllerListener((ControllerListener)this);
        this.p.configure();
        if (!this.waitForState(180)) {
            System.out.println("Failed to configure the processor");
            return false;
        }
        this.p.setContentDescriptor(null);
        TrackControl[] tc = this.p.getTrackControls();
        if (tc == null) {
            System.out.println("Failed to get the track control from processor");
            return false;
        }
        TrackControl vtc = null;
        for (int i = 0; i < tc.length; ++i) {
            if (!(tc[i].getFormat() instanceof VideoFormat)) continue;
            vtc = tc[i];
            break;
        }
        if (vtc == null) {
            System.out.println("can't find video track");
            return false;
        }
        try {
            this.a3VideoRenderer = new A3VideoRenderer();
            vtc.setRenderer((Renderer)this.a3VideoRenderer);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("the processor does not support effect");
            return false;
        }
        this.p.prefetch();
        if (!this.waitForState(500)) {
            System.out.println("Failed to prefech the processor");
            return false;
        }
        System.out.println("end of prefetch");
        return true;
    }

    public void start() {
        this.p.start();
        System.out.println("p start");
    }

    public void stop() {
        this.p.stop();
        System.out.println("p stop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForState(int state) {
        int[] nArray = this.waitSync;
        synchronized (this.waitSync) {
            try {
                while (this.p.getState() != state && this.stateTransOK) {
                    this.waitSync.wait();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.stateTransOK;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void controllerUpdate(ControllerEvent evt) {
        if (evt instanceof ConfigureCompleteEvent || evt instanceof RealizeCompleteEvent || evt instanceof PrefetchCompleteEvent) {
            int[] nArray = this.waitSync;
            synchronized (this.waitSync) {
                this.stateTransOK = true;
                this.waitSync.notifyAll();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        } else if (evt instanceof ResourceUnavailableEvent) {
            int[] nArray = this.waitSync;
            synchronized (this.waitSync) {
                this.stateTransOK = false;
                this.waitSync.notifyAll();
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return;
            }
        } else {
            if (!(evt instanceof EndOfMediaEvent)) return;
            this.p.setMediaTime(new Time(0L));
            this.p.start();
        }
    }
}

