/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.vrml97.impl;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.loaders.vrml97.impl.Geometry;
import org.jdesktop.j3d.loaders.vrml97.impl.Loader;
import org.jdesktop.j3d.loaders.vrml97.impl.MFRotation;
import org.jdesktop.j3d.loaders.vrml97.impl.MFVec2f;
import org.jdesktop.j3d.loaders.vrml97.impl.MFVec3f;
import org.jdesktop.j3d.loaders.vrml97.impl.Ownable;
import org.jdesktop.j3d.loaders.vrml97.impl.SFBool;
import org.jdesktop.j3d.loaders.vrml97.impl.SFFloat;
import org.jdesktop.j3d.loaders.vrml97.impl.Shape;
import vrml.InvalidVRMLSyntaxException;

class Extrusion
extends Geometry
implements Ownable {
    SFBool beginCap;
    SFBool ccw;
    SFBool convex;
    SFFloat creaseAngle;
    MFVec2f crossSection;
    SFBool endCap;
    MFRotation orientation;
    MFVec2f scale;
    SFBool solid;
    MFVec3f spine;
    GeometryArray impl;
    BoundingBox bounds;
    GeometryInfo gi;
    Shape owner;
    Point3f[] spines;
    Vector3f[] scales;
    AxisAngle4f[] orientations;
    Transform3D[] spineTransforms;
    Point3f[] crossSectionPts;
    Matrix3f[] rotations;
    Transform3D[] transforms;
    Point3f[] coords;
    int[] coordIndex;
    int[] stripCounts;
    boolean collinear = false;
    boolean closed = false;
    float[] a2 = new float[2];
    float[] a3 = new float[3];
    float[] a4 = new float[4];
    int numTris = 0;
    boolean hardDebug = false;

    public Extrusion(Loader loader) {
        super(loader);
        this.beginCap = new SFBool(true);
        this.endCap = new SFBool(true);
        this.ccw = new SFBool(true);
        this.convex = new SFBool(true);
        this.solid = new SFBool(true);
        this.creaseAngle = loader.autoSmooth ? new SFFloat(0.9f) : new SFFloat(0.0f);
        this.crossSection = new MFVec2f(5, new float[10]);
        this.crossSection.set1Value(0, 1.0f, 1.0f);
        this.crossSection.set1Value(1, 1.0f, -1.0f);
        this.crossSection.set1Value(2, -1.0f, -1.0f);
        this.crossSection.set1Value(3, -1.0f, 1.0f);
        this.crossSection.set1Value(4, 1.0f, 1.0f);
        this.spine = new MFVec3f(2, new float[6]);
        this.spine.set1Value(0, 0.0f, 0.0f, 0.0f);
        this.spine.set1Value(1, 0.0f, 1.0f, 0.0f);
        this.orientation = new MFRotation(1, new float[4]);
        this.orientation.set1Value(0, 0.0f, 0.0f, 1.0f, 0.0f);
        this.scale = new MFVec2f(new float[2]);
        this.scale.set1Value(0, 1.0f, 1.0f);
        this.initFields();
    }

    Extrusion(Loader loader, SFBool beginCap, SFBool ccw, SFBool convex, SFFloat creaseAngle, MFVec2f crossSection, SFBool endCap, MFRotation orientation, MFVec2f scale, SFBool solid, MFVec3f spine) {
        super(loader);
        this.beginCap = beginCap;
        this.ccw = ccw;
        this.convex = convex;
        this.creaseAngle = creaseAngle;
        this.crossSection = crossSection;
        this.endCap = endCap;
        this.orientation = orientation;
        this.scale = scale;
        this.solid = solid;
        this.spine = spine;
        this.initFields();
    }

    public boolean haveTexture() {
        return false;
    }

    public int getNumTris() {
        return this.numTris;
    }

    javax.media.j3d.Geometry getImplGeom() {
        return this.impl;
    }

    BoundingBox getBoundingBox() {
        Point3d epsilon = new Point3d(1.0E-6, 1.0E-6, 1.0E-6);
        Point3d lower = new Point3d(this.coords[0]);
        Point3d upper = new Point3d(this.coords[0]);
        lower.sub((Tuple3d)epsilon);
        upper.add((Tuple3d)epsilon);
        this.bounds = new BoundingBox(lower, upper);
        for (int c = 1; c < this.coords.length; ++c) {
            this.bounds.combine(new Point3d(this.coords[c]));
        }
        if (this.loader.debug) {
            System.out.println(this.bounds);
        }
        return this.bounds;
    }

    void initImpl() {
        this.gi = new GeometryInfo(5);
        this.initSetup();
        this.calculateSCP();
        this.createExtrusion();
        this.createIndices();
        if (this.hardDebug) {
            int i;
            System.out.println("coords");
            for (i = 0; i < this.coords.length; ++i) {
                System.out.println(this.coords[i]);
            }
            System.out.println("coordIndex");
            for (i = 0; i < this.coordIndex.length; ++i) {
                System.out.println(this.coordIndex[i]);
            }
            System.out.println("stripCounts");
            for (i = 0; i < this.stripCounts.length; ++i) {
                System.out.println(this.stripCounts[i]);
            }
        }
        this.gi.setCoordinates(this.coords);
        this.gi.setCoordinateIndices(this.coordIndex);
        this.gi.setStripCounts(this.stripCounts);
        float ca = this.creaseAngle.getValue();
        if (ca < 0.0f) {
            ca = 0.0f;
        }
        if (ca > (float)Math.PI) {
            ca -= (float)Math.PI;
        }
        NormalGenerator ng = new NormalGenerator((double)ca);
        ng.generateNormals(this.gi);
        this.impl = this.gi.getGeometryArray();
        this.implReady = true;
    }

    void initSetup() {
        int i;
        this.crossSectionPts = new Point3f[this.crossSection.getSize()];
        if (this.hardDebug) {
            System.out.println(this.crossSection.getSize());
        }
        for (i = 0; i < this.crossSectionPts.length; ++i) {
            this.crossSection.get1Value(i, this.a2);
            this.crossSectionPts[i] = new Point3f(this.a2[0], 0.0f, this.a2[1]);
        }
        this.scales = new Vector3f[this.spine.getSize()];
        for (i = 0; i < this.scales.length; ++i) {
            if (i < this.scale.getSize()) {
                this.scale.get1Value(i, this.a2);
            }
            this.scales[i] = new Vector3f(this.a2[0], 1.0f, this.a2[1]);
        }
        this.spines = new Point3f[this.spine.getSize()];
        for (i = 0; i < this.spines.length; ++i) {
            this.spine.get1Value(i, this.a3);
            this.spines[i] = new Point3f(this.a3);
        }
        this.orientations = new AxisAngle4f[this.spine.getSize()];
        for (i = 0; i < this.orientations.length; ++i) {
            if (i < this.orientation.getSize()) {
                this.orientation.get1Value(i, this.a4);
            }
            this.orientations[i] = new AxisAngle4f(this.a4);
        }
        this.rotations = new Matrix3f[this.spines.length];
        if (this.spines[0].equals((Tuple3f)this.spines[this.spines.length - 1])) {
            this.closed = true;
        }
        Vector3d v2 = new Vector3d();
        Vector3d v1 = new Vector3d();
        Vector3d v0 = new Vector3d();
        double d = 0.0;
        for (int i2 = 1; i2 < this.spines.length - 1; ++i2) {
            v2.set((Tuple3f)this.spines[i2 + 1]);
            v1.set((Tuple3f)this.spines[i2]);
            v0.set((Tuple3f)this.spines[i2 - 1]);
            v2.sub((Tuple3d)v1);
            v1.sub((Tuple3d)v0);
            v0.cross(v2, v1);
            d += v0.dot(v0);
        }
        boolean bl = this.collinear = d == 0.0;
        if (this.hardDebug && this.collinear) {
            System.out.println("spine is straight");
        }
    }

    void calculateSCP() {
        int i;
        Vector3f zero = new Vector3f(0.0f, 0.0f, 0.0f);
        int last = this.spines.length - 1;
        Vector3f[] x = new Vector3f[this.spines.length];
        Vector3f[] y = new Vector3f[this.spines.length];
        Vector3f[] z = new Vector3f[this.spines.length];
        if (this.collinear) {
            if (this.closed) {
                throw new InvalidVRMLSyntaxException("invalid Extrusion data; looks like a solid of revolution");
            }
            for (int i2 = 0; i2 < this.spines.length; ++i2) {
                x[i2] = new Vector3f(1.0f, 0.0f, 0.0f);
                y[i2] = new Vector3f(0.0f, 1.0f, 0.0f);
                z[i2] = new Vector3f(0.0f, 0.0f, 1.0f);
            }
        } else {
            Vector3f v;
            Vector3f u;
            for (int i3 = 1; i3 < last; ++i3) {
                y[i3] = new Vector3f();
                y[i3].sub((Tuple3f)this.spines[i3 + 1], (Tuple3f)this.spines[i3 - 1]);
                try {
                    this.norm(y[i3]);
                    continue;
                }
                catch (ArithmeticException ae) {
                    if (this.hardDebug) {
                        System.out.println(ae + " " + y[i3]);
                    }
                    try {
                        y[i3].sub((Tuple3f)this.spines[i3 + 1], (Tuple3f)this.spines[i3]);
                        this.norm(y[i3]);
                        continue;
                    }
                    catch (ArithmeticException ae1) {
                        if (this.hardDebug) {
                            System.out.println(ae1 + " " + y[i3]);
                        }
                        try {
                            y[i3].sub((Tuple3f)this.spines[i3], (Tuple3f)this.spines[i3 - 1]);
                            this.norm(y[i3]);
                            continue;
                        }
                        catch (ArithmeticException ae2) {
                            int w;
                            if (this.hardDebug) {
                                System.out.println(ae2 + " " + y[i3]);
                            }
                            for (w = i3 + 2; w < last + 1 && this.spines[i3 - 1].equals((Tuple3f)this.spines[w]); ++w) {
                            }
                            if (w < last + 1) {
                                y[i3].sub((Tuple3f)this.spines[w], (Tuple3f)this.spines[i3 - 1]);
                                if (this.hardDebug) {
                                    System.out.println("did something " + y[i3]);
                                }
                                this.norm(y[i3]);
                                continue;
                            }
                            if (this.hardDebug) {
                                System.out.println("worst worst y " + y[i3]);
                            }
                            y[i3] = new Vector3f(0.0f, 1.0f, 0.0f);
                        }
                    }
                }
            }
            if (this.closed) {
                y[0] = new Vector3f();
                y[0].sub((Tuple3f)this.spines[1], (Tuple3f)this.spines[last - 1]);
                try {
                    this.norm(y[0]);
                }
                catch (ArithmeticException ae) {
                    int w;
                    for (w = last - 2; w > 1 && this.spines[1].equals((Tuple3f)this.spines[w]); --w) {
                    }
                    if (w > 1) {
                        y[0].sub((Tuple3f)this.spines[1], (Tuple3f)this.spines[w]);
                        this.norm(y[0]);
                    }
                    y[0].set(0.0f, 0.0f, 1.0f);
                }
                y[last] = new Vector3f(y[0]);
            } else {
                y[0] = new Vector3f();
                y[last] = new Vector3f();
                y[0].sub((Tuple3f)this.spines[1], (Tuple3f)this.spines[0]);
                try {
                    this.norm(y[0]);
                }
                catch (ArithmeticException ae) {
                    int w;
                    for (w = 2; w < last && this.spines[0].equals((Tuple3f)this.spines[w]); ++w) {
                    }
                    if (w < last) {
                        y[0].sub((Tuple3f)this.spines[w], (Tuple3f)this.spines[0]);
                        this.norm(y[0]);
                    }
                    y[0].set(0.0f, 0.0f, 1.0f);
                }
                y[last] = new Vector3f();
                y[last].sub((Tuple3f)this.spines[last], (Tuple3f)this.spines[last - 1]);
                try {
                    this.norm(y[last]);
                }
                catch (ArithmeticException ae) {
                    int w;
                    for (w = last - 2; w > -1 && this.spines[last].equals((Tuple3f)this.spines[w]); --w) {
                    }
                    if (w > -1) {
                        y[last].sub((Tuple3f)this.spines[last], (Tuple3f)this.spines[w]);
                        this.norm(y[last]);
                    }
                    y[last].set(0.0f, 0.0f, 1.0f);
                }
            }
            boolean recheck = false;
            for (int i4 = 1; i4 < last; ++i4) {
                u = new Vector3f();
                v = new Vector3f();
                z[i4] = new Vector3f();
                u.sub((Tuple3f)this.spines[i4 - 1], (Tuple3f)this.spines[i4]);
                v.sub((Tuple3f)this.spines[i4 + 1], (Tuple3f)this.spines[i4]);
                z[i4].cross(u, v);
                try {
                    this.norm(z[i4]);
                    continue;
                }
                catch (ArithmeticException ae) {
                    recheck = true;
                }
            }
            if (this.closed) {
                z[0] = z[last] = new Vector3f();
                u = new Vector3f();
                v = new Vector3f();
                u.sub((Tuple3f)this.spines[last - 1], (Tuple3f)this.spines[0]);
                v.sub((Tuple3f)this.spines[1], (Tuple3f)this.spines[0]);
                try {
                    z[0].cross(u, v);
                }
                catch (ArithmeticException ae) {
                    recheck = true;
                }
            } else {
                z[0] = new Vector3f(z[1]);
                z[last] = new Vector3f(z[last - 1]);
            }
            if (recheck) {
                if (this.hardDebug) {
                    System.out.println("rechecking, found adjacent collinear spines");
                }
                if (z[0].dot(z[0]) == 0.0f) {
                    for (int i5 = 1; i5 < this.spines.length; ++i5) {
                        if (!(z[i5].dot(z[i5]) > 0.0f)) continue;
                        z[0] = new Vector3f(z[i5]);
                    }
                    if (z[0].dot(z[0]) == 0.0f) {
                        z[0] = new Vector3f(0.0f, 0.0f, 1.0f);
                    }
                }
                for (int i6 = 1; i6 < last + 1; ++i6) {
                    if (z[i6].dot(z[i6]) != 0.0f) continue;
                    z[i6] = new Vector3f(z[i6 - 1]);
                }
            }
            for (i = 0; i < this.spines.length; ++i) {
                if (i > 0 && z[i].dot(z[i - 1]) < 0.0f) {
                    z[i].negate();
                }
                x[i] = new Vector3f();
                x[i].cross(z[i], y[i]);
                try {
                    this.norm(x[i]);
                }
                catch (ArithmeticException ae) {
                    ae.printStackTrace();
                }
                if (!this.hardDebug) continue;
                System.out.println("x[" + i + "] " + x[i]);
            }
        }
        Matrix3f m = new Matrix3f();
        this.transforms = new Transform3D[this.spines.length];
        for (i = 0; i < this.spines.length; ++i) {
            this.rotations[i] = new Matrix3f();
            if (this.hardDebug) {
                System.out.println("orthos " + i + " " + x[i] + " " + y[i] + " " + z[i] + " " + this.orientations[i]);
            }
            this.rotations[i].setRow(0, x[i]);
            this.rotations[i].setRow(1, y[i]);
            this.rotations[i].setRow(2, z[i]);
            m.set(this.orientations[i]);
            this.rotations[i].mul(m);
            this.transforms[i] = new Transform3D();
            this.transforms[i].setScale(new Vector3d(this.scales[i]));
            this.transforms[i].setTranslation(new Vector3d((Tuple3f)this.spines[i]));
            this.transforms[i].setRotation(this.rotations[i]);
        }
    }

    void createExtrusion() {
        this.coords = new Point3f[this.spines.length * this.crossSectionPts.length];
        for (int i = 0; i < this.spines.length; ++i) {
            for (int j = 0; j < this.crossSectionPts.length; ++j) {
                int ind = i * this.crossSectionPts.length + j;
                this.coords[ind] = new Point3f(this.crossSectionPts[j]);
                this.transforms[i].transform(this.coords[ind]);
            }
        }
    }

    void createIndices() {
        int i;
        int ind;
        int m = 0;
        int k = this.crossSectionPts.length;
        int l = this.coords.length;
        int s = 0;
        int n = 0;
        if (this.endCap.value) {
            m += k - 1;
            ++s;
        }
        if (this.beginCap.value) {
            m += k - 1;
            ++s;
        }
        this.coordIndex = new int[m += (this.spines.length - 1) * (4 * (k - 1))];
        if (this.hardDebug) {
            System.out.println("coordIndexSize" + m);
        }
        this.stripCounts = new int[s + (this.spines.length - 1) * (k - 1)];
        s = 0;
        if (this.hardDebug) {
            System.out.println("stripCounts.length" + this.stripCounts.length);
        }
        if (this.hardDebug) {
            System.out.println("spines.length" + this.spines.length);
        }
        for (int i2 = 0; i2 < this.spines.length - 1; ++i2) {
            if (this.hardDebug) {
                System.out.println(" i " + i2);
            }
            for (int j = 0; j < k - 1; ++j) {
                if (this.hardDebug) {
                    System.out.println(" j " + j);
                }
                if (this.ccw.value) {
                    if (this.hardDebug) {
                        System.out.println("i " + i2 + " j " + j + " k " + k);
                    }
                    this.coordIndex[n++] = i2 * k + j;
                    if (this.hardDebug) {
                        System.out.println(n - 1 + " " + (i2 * k + j));
                    }
                    this.coordIndex[n++] = i2 * k + j + 1;
                    if (this.hardDebug) {
                        System.out.println(n - 1 + " " + (i2 * k + (j + 1)));
                    }
                    this.coordIndex[n++] = (i2 + 1) * k + j + 1;
                    if (this.hardDebug) {
                        System.out.println(n - 1 + " " + ((i2 + 1) * k + (j + 1)));
                    }
                    this.coordIndex[n++] = (i2 + 1) * k + j;
                    if (this.hardDebug) {
                        System.out.println(n - 1 + " " + ((i2 + 1) * k + j));
                    }
                } else {
                    this.coordIndex[n++] = i2 * k + j;
                    this.coordIndex[n++] = (i2 + 1) * k + j;
                    this.coordIndex[n++] = (i2 + 1) * k + j + 1;
                    this.coordIndex[n++] = i2 * k + j + 1;
                }
                this.stripCounts[s++] = 4;
                this.numTris += 2;
            }
        }
        if (this.beginCap.value && this.endCap.value) {
            int indB = m - 2 * (k - 1);
            int indE = m - (k - 1);
            if (!this.ccw.value) {
                int i3 = 0;
                while (i3 < k - 1) {
                    this.coordIndex[indB++] = i3++;
                }
                i3 = l - 1;
                while (i3 > l - k) {
                    this.coordIndex[indE++] = i3--;
                }
            } else {
                int i4 = k - 1;
                while (i4 > 0) {
                    this.coordIndex[indB++] = i4--;
                }
                for (i4 = 0; i4 < k - 1; ++i4) {
                    this.coordIndex[indE++] = l - (k - 1) + i4;
                }
            }
            this.stripCounts[s++] = k - 1;
            this.stripCounts[s++] = k - 1;
            this.numTris += k - 1;
        } else if (this.beginCap.value) {
            ind = m - (k - 1);
            if (!this.ccw.value) {
                i = 0;
                while (i < k - 1) {
                    this.coordIndex[ind++] = i++;
                }
            } else {
                i = k - 1;
                while (i > 0) {
                    this.coordIndex[ind++] = i--;
                }
            }
            this.stripCounts[s++] = k - 1;
            this.numTris += k - 1;
        } else if (this.endCap.value) {
            ind = m - (k - 1);
            if (this.ccw.value) {
                i = l - (k - 1);
                while (i < l) {
                    this.coordIndex[ind++] = i++;
                }
            } else {
                i = l - 1;
                while (i > l - k) {
                    this.coordIndex[ind++] = i--;
                }
            }
            this.stripCounts[s++] = k - 1;
            this.numTris += k - 1;
        }
    }

    void norm(Vector3f n) {
        float norml = (float)Math.sqrt(n.x * n.x + n.y * n.y + n.z * n.z);
        if (norml == 0.0f) {
            throw new ArithmeticException();
        }
        n.x /= norml;
        n.y /= norml;
        n.z /= norml;
    }

    public void notifyMethod(String eventInName, double time) {
        if (!eventInName.startsWith("route_")) {
            this.initImpl();
            ((Shape3D)this.owner.implNode).setGeometry((javax.media.j3d.Geometry)this.impl);
        } else {
            ((Shape3D)this.owner.implNode).setCapability(13);
        }
    }

    void initFields() {
        this.beginCap.init(this, this.FieldSpec, 0, "beginCap");
        this.ccw.init(this, this.FieldSpec, 0, "ccw");
        this.convex.init(this, this.FieldSpec, 0, "convex");
        this.creaseAngle.init(this, this.FieldSpec, 0, "creaseAngle");
        this.crossSection.init(this, this.FieldSpec, 1, "crossSection");
        this.endCap.init(this, this.FieldSpec, 0, "endCap");
        this.orientation.init(this, this.FieldSpec, 1, "orientation");
        this.scale.init(this, this.FieldSpec, 1, "scale");
        this.solid.init(this, this.FieldSpec, 0, "solid");
        this.spine.init(this, this.FieldSpec, 1, "spine");
    }

    public Object clone() {
        return new Extrusion(this.loader, (SFBool)this.beginCap.clone(), (SFBool)this.ccw.clone(), (SFBool)this.convex.clone(), (SFFloat)this.creaseAngle.clone(), (MFVec2f)this.crossSection.clone(), (SFBool)this.endCap.clone(), (MFRotation)this.orientation.clone(), (MFVec2f)this.scale.clone(), (SFBool)this.solid.clone(), (MFVec3f)this.spine.clone());
    }

    public String getType() {
        return "Extrusion";
    }

    public boolean getSolid() {
        return this.solid.value;
    }

    public void setOwner(Shape owner) {
        this.owner = owner;
    }
}

