/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.util.TreeMap;
import java.util.Vector;
import org.sablecc.sablecc.StringComparator;

final class Symbol
implements Comparable {
    private static Vector terminals;
    private static Vector nonterminals;
    private static TreeMap names;
    private static boolean modified_;
    private static Symbol[] symbols_;
    private static Symbol[] terminals_;
    private static Symbol[] nonterminals_;
    final String name;
    final String errorName;
    final boolean terminal;
    final int index;

    public static final void reinit() {
        terminals = new Vector();
        nonterminals = new Vector();
        names = new TreeMap(StringComparator.instance);
        modified_ = true;
        symbols_ = null;
        terminals_ = null;
        nonterminals_ = null;
    }

    static final Symbol symbol(String string) {
        return (Symbol)names.get(string);
    }

    static final Symbol symbol(int n, boolean bl) {
        if (bl) {
            return (Symbol)terminals.elementAt(n);
        }
        return (Symbol)nonterminals.elementAt(n);
    }

    private static final void computeArrays() {
        symbols_ = new Symbol[terminals.size() + nonterminals.size()];
        terminals_ = new Symbol[terminals.size()];
        nonterminals_ = new Symbol[nonterminals.size()];
        terminals.copyInto(terminals_);
        nonterminals.copyInto(nonterminals_);
        System.arraycopy(terminals_, 0, symbols_, 0, terminals_.length);
        System.arraycopy(nonterminals_, 0, symbols_, terminals_.length, nonterminals_.length);
        modified_ = false;
    }

    static final Symbol[] symbols() {
        if (modified_) {
            Symbol.computeArrays();
        }
        return symbols_;
    }

    static final Symbol[] terminals() {
        if (modified_) {
            Symbol.computeArrays();
        }
        return terminals_;
    }

    static final Symbol[] nonterminals() {
        if (modified_) {
            Symbol.computeArrays();
        }
        return nonterminals_;
    }

    public final String toString() {
        return this.name;
    }

    public final int compareTo(Object object) {
        Symbol symbol = (Symbol)object;
        if (this.terminal != symbol.terminal) {
            if (this.terminal) {
                return 1;
            }
            return -1;
        }
        return this.index - symbol.index;
    }

    Symbol(String string, String string2, boolean bl) {
        if (names.get(string) != null) {
            throw new IllegalArgumentException("The symbol " + string + " aready exists.");
        }
        if (bl) {
            terminals.addElement(this);
            this.index = terminals.indexOf(this);
        } else {
            nonterminals.addElement(this);
            this.index = nonterminals.indexOf(this);
        }
        this.name = string;
        this.errorName = string2;
        this.terminal = bl;
        names.put(string, this);
        modified_ = true;
    }

    static {
        modified_ = true;
        Symbol.reinit();
    }
}

