/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.sourceforge.acerola3d.A23;
import jp.sourceforge.acerola3d.a3.A3Canvas;
import jp.sourceforge.acerola3d.a3.A3Controller;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.Action3D;
import jp.sourceforge.acerola3d.a3.Motion;
import jp.sourceforge.acerola3d.a3viewer.A3PHtmlViewer;
import jp.sourceforge.acerola3d.a3viewer.JTextAreaOutputStream;
import jp.sourceforge.acerola3d.a3viewer.MyExamController;

public class A3Panel
extends JPanel
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    static String defaultURL = "x-res:///jp/sourceforge/acerola3d/a3viewer/resources/acerola3d.a3";
    JMenuBar menuBar;
    JMenu configMenu;
    JMenuItem consoleMenuItem;
    JMenuItem resetViewMenuItem;
    JMenuItem snapshotMenuItem;
    JMenuItem backgroundMenuItem;
    JMenuItem headLightMenuItem;
    JMenuItem balloonRightMenuItem;
    JMenuItem balloonLeftMenuItem;
    JMenuItem balloonTopMenuItem;
    JMenuItem balloonBottomMenuItem;
    JMenuItem balloonDelMenuItem;
    JMenuItem labelMenuItem;
    JMenuItem labelDelMenuItem;
    JMenuItem htmlMenuItem;
    JMenuItem metadataMenuItem;
    JMenuItem helpMenuItem;
    JMenuItem aboutMenuItem;
    JTextField urlTextField;
    JButton refButton;
    JFileChooser fileChooser;
    A3Canvas a3canvas;
    JComboBox actionNameCB;
    JCheckBox immediatelyCheckBox;
    JButton resetViewButton;
    JTextArea commentTextArea;
    JSlider volumeSlider;
    JLabel statusBarLabel;
    JFrame consoleFrame;
    JTextArea consoleTextArea;
    JButton clearConsoleButton;
    JCheckBox pauseCheckBox;
    JSlider slider;
    int sliderLength = 100;
    double motionLength;
    boolean headLight = true;
    A3PHtmlViewer htmlViewer;
    A3PHtmlViewer helpViewer;
    Action3D a3;
    String actionName = "0";
    MyExamController controller;
    ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);

    public A3Panel(Frame frame, URL url) {
        this.setLayout(new BorderLayout());
        MyVerticalBox baseBox = new MyVerticalBox();
        this.add((Component)baseBox, "Center");
        this.menuBar = new JMenuBar();
        this.menuBar.setMinimumSize(new Dimension(100, 20));
        baseBox.myAdd(this.menuBar, 0.0);
        this.menuBar.add(Box.createHorizontalGlue());
        this.configMenu = new JMenu("Config");
        this.menuBar.add(this.configMenu);
        this.consoleMenuItem = new JMenuItem("Console");
        this.consoleMenuItem.addActionListener(this);
        this.configMenu.add(this.consoleMenuItem);
        this.resetViewMenuItem = new JMenuItem("ResetView");
        this.resetViewMenuItem.addActionListener(this);
        this.configMenu.add(this.resetViewMenuItem);
        this.snapshotMenuItem = new JMenuItem("Snapshot");
        this.snapshotMenuItem.addActionListener(this);
        this.configMenu.add(this.snapshotMenuItem);
        this.backgroundMenuItem = new JMenuItem("Background");
        this.backgroundMenuItem.addActionListener(this);
        this.configMenu.add(this.backgroundMenuItem);
        this.headLightMenuItem = new JMenuItem("HeadLight");
        this.headLightMenuItem.addActionListener(this);
        this.configMenu.add(this.headLightMenuItem);
        this.balloonRightMenuItem = new JMenuItem("Balloon on (right)");
        this.balloonRightMenuItem.addActionListener(this);
        this.configMenu.add(this.balloonRightMenuItem);
        this.balloonLeftMenuItem = new JMenuItem("Balloon on (left)");
        this.balloonLeftMenuItem.addActionListener(this);
        this.configMenu.add(this.balloonLeftMenuItem);
        this.balloonTopMenuItem = new JMenuItem("Balloon on (top)");
        this.balloonTopMenuItem.addActionListener(this);
        this.configMenu.add(this.balloonTopMenuItem);
        this.balloonBottomMenuItem = new JMenuItem("Balloon on (bottom)");
        this.balloonBottomMenuItem.addActionListener(this);
        this.configMenu.add(this.balloonBottomMenuItem);
        this.balloonDelMenuItem = new JMenuItem("Balloon off");
        this.balloonDelMenuItem.addActionListener(this);
        this.configMenu.add(this.balloonDelMenuItem);
        this.labelMenuItem = new JMenuItem("Label on");
        this.labelMenuItem.addActionListener(this);
        this.configMenu.add(this.labelMenuItem);
        this.labelDelMenuItem = new JMenuItem("Label off");
        this.labelDelMenuItem.addActionListener(this);
        this.configMenu.add(this.labelDelMenuItem);
        this.htmlMenuItem = new JMenuItem("Html");
        this.htmlMenuItem.addActionListener(this);
        this.configMenu.add(this.htmlMenuItem);
        this.metadataMenuItem = new JMenuItem("Metadata");
        this.metadataMenuItem.addActionListener(this);
        this.configMenu.add(this.metadataMenuItem);
        this.helpMenuItem = new JMenuItem("Help");
        this.helpMenuItem.addActionListener(this);
        this.configMenu.add(this.helpMenuItem);
        this.aboutMenuItem = new JMenuItem("About");
        this.aboutMenuItem.addActionListener(this);
        this.configMenu.add(this.aboutMenuItem);
        this.consoleFrame = new JFrame("Console");
        Box b = Box.createVerticalBox();
        this.consoleTextArea = new JTextArea(20, 60);
        this.consoleTextArea.setEditable(false);
        JScrollPane sp = new JScrollPane(this.consoleTextArea);
        b.add(sp);
        this.clearConsoleButton = new JButton("Clear");
        this.clearConsoleButton.addActionListener(this);
        b.add(this.clearConsoleButton);
        this.consoleFrame.getContentPane().add(b);
        this.consoleFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                A3Panel.this.consoleFrame.setVisible(false);
            }
        });
        PrintStream systemOut = System.out;
        JTextAreaOutputStream jtaos = new JTextAreaOutputStream(this.consoleTextArea, systemOut);
        PrintStream ps = new PrintStream(jtaos, true);
        System.setOut(ps);
        System.setErr(ps);
        this.consoleFrame.pack();
        MyHorizontalBox addressBox = new MyHorizontalBox();
        baseBox.myAdd(addressBox, 0.0);
        addressBox.myAdd(new JLabel("URL:"), 0.0);
        this.urlTextField = new JTextField();
        this.urlTextField.addActionListener(this);
        if (url == null) {
            this.urlTextField.setText(defaultURL);
        } else {
            this.urlTextField.setText(url.toString());
        }
        addressBox.myAdd(this.urlTextField, 1.0);
        this.refButton = new JButton("ref");
        this.refButton.addActionListener(this);
        addressBox.myAdd(this.refButton, 0.0);
        MyHorizontalBox mainBox = new MyHorizontalBox();
        baseBox.myAdd(mainBox, 1.0);
        this.a3canvas = A3Canvas.createA3Canvas((int)300, (int)300);
        this.controller = new MyExamController();
        this.a3canvas.setA3Controller((A3Controller)this.controller);
        mainBox.myAdd((Component)this.a3canvas, 1.0);
        MyVerticalBox controlBox = this.makeControlBox();
        mainBox.myAdd(controlBox, 0.0);
        MyHorizontalBox pauseBox = new MyHorizontalBox();
        baseBox.myAdd(pauseBox, 0.0);
        this.pauseCheckBox = new JCheckBox("pause");
        this.pauseCheckBox.setSelected(false);
        this.pauseCheckBox.addActionListener(this);
        pauseBox.myAdd(this.pauseCheckBox, 0.0);
        this.slider = new JSlider();
        this.slider.setMinimum(0);
        this.slider.setMaximum(this.sliderLength);
        this.slider.addChangeListener(this);
        pauseBox.myAdd(this.slider, 1.0);
        this.statusBarLabel = new JLabel("Status:");
        baseBox.myAdd(this.statusBarLabel, 0.0);
        this.htmlViewer = new A3PHtmlViewer(frame);
        this.helpViewer = new A3PHtmlViewer(null);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                A3Panel.this.loadAction3D();
            }
        };
        this.executor.schedule(r, 100L, TimeUnit.MILLISECONDS);
    }

    MyVerticalBox makeControlBox() {
        MyVerticalBox controlBox = new MyVerticalBox();
        MyHorizontalBox actionBox = new MyHorizontalBox();
        controlBox.myAdd(actionBox, 0.0);
        actionBox.myAdd(new JLabel("ActionName:"), 0.0);
        this.actionNameCB = new JComboBox();
        this.actionNameCB.addActionListener(this);
        actionBox.myAdd(this.actionNameCB, 1.0);
        this.immediatelyCheckBox = new JCheckBox("immediatelyChange");
        this.immediatelyCheckBox.setSelected(true);
        controlBox.myAdd(this.immediatelyCheckBox, 0.0);
        this.resetViewButton = new JButton("Reset View");
        this.resetViewButton.addActionListener(this);
        controlBox.myAdd(this.resetViewButton, 0.0);
        controlBox.myAdd(new JLabel("Left drag: rotation"), 0.0);
        controlBox.myAdd(new JLabel("Center drag: translation"), 0.0);
        controlBox.myAdd(new JLabel("Right drag: scale"), 0.0);
        controlBox.myAdd(new JLabel("***Comment***"), 0.0);
        this.commentTextArea = new JTextArea(10, 30);
        this.commentTextArea.setEditable(false);
        JScrollPane sp = new JScrollPane(this.commentTextArea);
        sp.setPreferredSize(new Dimension(50, 150));
        controlBox.myAdd(sp, 1.0);
        Box volBox = Box.createHorizontalBox();
        controlBox.myAdd(volBox, 0.0);
        volBox.add(new JLabel("SoundVol"));
        this.volumeSlider = new JSlider();
        this.volumeSlider.setMinimum(0);
        this.volumeSlider.setMaximum(this.sliderLength);
        this.volumeSlider.addChangeListener(this);
        volBox.add(this.volumeSlider);
        String buildTime = null;
        try {
            URL url = this.getClass().getClassLoader().getResource("buildTime.txt");
            InputStreamReader isr = new InputStreamReader(url.openStream(), "UTF-8");
            BufferedReader br = new BufferedReader(isr);
            buildTime = br.readLine();
        }
        catch (Exception e) {
            buildTime = "???";
        }
        controlBox.myAdd(new JLabel("build time:" + buildTime), 0.0);
        return controlBox;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.actionNameCB) {
            this.actionName = (String)this.actionNameCB.getSelectedItem();
            if (this.actionName == null) {
                System.out.println("gaha1");
                return;
            }
            System.out.println("actionName:" + this.actionName);
            this.repaint();
        } else if (ae.getSource() == this.urlTextField) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    A3Panel.this.loadAction3D();
                }
            };
            this.executor.schedule(r, 100L, TimeUnit.MILLISECONDS);
        } else if (ae.getSource() == this.resetViewButton) {
            this.controller.reset(this.a3);
        } else if (ae.getSource() == this.refButton) {
            this.ref();
        } else if (ae.getSource() == this.consoleMenuItem) {
            this.consoleFrame.setVisible(true);
        } else if (ae.getSource() == this.clearConsoleButton) {
            this.consoleTextArea.setText("");
        } else if (ae.getSource() == this.resetViewMenuItem) {
            this.controller.reset(this.a3);
        } else if (ae.getSource() == this.snapshotMenuItem) {
            try {
                File f = new File("snapshot.png");
                this.a3canvas.saveImage(f);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (ae.getSource() == this.backgroundMenuItem) {
            this.setBackground();
        } else if (ae.getSource() == this.headLightMenuItem) {
            this.headLight = !this.headLight;
            this.a3canvas.setHeadLightEnable(this.headLight);
        } else if (ae.getSource() == this.balloonRightMenuItem) {
            if (this.a3 == null) {
                return;
            }
            this.a3.setBalloonDir(A3Object.BalloonDir.RIGHT);
            this.a3.setBalloon("\u3075\u304d\u3060\u3057");
        } else if (ae.getSource() == this.balloonLeftMenuItem) {
            if (this.a3 == null) {
                return;
            }
            this.a3.setBalloonDir(A3Object.BalloonDir.LEFT);
            this.a3.setBalloon("\u3075\u304d\u3060\u3057");
        } else if (ae.getSource() == this.balloonTopMenuItem) {
            if (this.a3 == null) {
                return;
            }
            this.a3.setBalloonDir(A3Object.BalloonDir.TOP);
            this.a3.setBalloon("\u3075\u304d\u3060\u3057");
        } else if (ae.getSource() == this.balloonBottomMenuItem) {
            if (this.a3 == null) {
                return;
            }
            this.a3.setBalloonDir(A3Object.BalloonDir.BOTTOM);
            this.a3.setBalloon("\u3075\u304d\u3060\u3057");
        } else if (ae.getSource() == this.balloonDelMenuItem) {
            if (this.a3 == null) {
                return;
            }
            this.a3.setBalloon(null);
        } else if (ae.getSource() == this.labelMenuItem) {
            if (this.a3 == null) {
                return;
            }
            this.a3.setLabel("\u30e9\u30d9\u30eb");
        } else if (ae.getSource() == this.labelDelMenuItem) {
            if (this.a3 == null) {
                return;
            }
            this.a3.setLabel(null);
        } else if (ae.getSource() == this.htmlMenuItem) {
            this.openHtml();
        } else if (ae.getSource() == this.metadataMenuItem) {
            this.openMetadata();
        } else if (ae.getSource() == this.helpMenuItem) {
            this.openHelp();
        } else if (ae.getSource() == this.aboutMenuItem) {
            this.openAbout();
        } else if (ae.getSource() == this.pauseCheckBox) {
            if (this.a3 == null) {
                return;
            }
            if (this.pauseCheckBox.isSelected()) {
                this.a3.changeImmediately((Serializable)((Object)this.actionName));
                this.a3.setMode(Motion.Mode.PAUSE);
                double t = this.motionLength * ((double)this.slider.getValue() / (double)this.sliderLength);
                this.a3.setPauseTime(t);
            } else {
                this.a3.changeImmediately((Serializable)((Object)this.actionName));
                this.a3.setMode(Motion.Mode.PLAY);
                double t = this.motionLength * ((double)this.slider.getValue() / (double)this.sliderLength);
                this.a3.setPauseTime(t);
            }
        } else {
            System.out.append("gaha???");
        }
    }

    void openHtml() {
        if (this.a3 == null) {
            return;
        }
        URL url = this.a3.getHTML();
        if (url == null) {
            JOptionPane.showMessageDialog(this, "No html file.", "ERROR", 0);
            return;
        }
        this.htmlViewer.open(url);
    }

    void openMetadata() {
        if (this.a3 == null) {
            return;
        }
        String s = "";
        s = s + "<html><body><h1>Not implemented yet!</h1><p><a href=\"http://www.google.co.jp/\">test</a></p>";
        s = s + "<pre>" + this.a3.getComment() + "</pre>";
        s = s + "</body></html>";
        this.htmlViewer.open(s);
    }

    void openHelp() {
        URL url = null;
        try {
            url = new URL("x-res:///jp/sourceforge/acerola3d/a3viewer/resources/ja/help.html");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.helpViewer.open(url);
    }

    void openAbout() {
        URL url = null;
        try {
            url = new URL("x-res:///jp/sourceforge/acerola3d/a3viewer/resources/ja/about.html");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.htmlViewer.open(url);
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (ce.getSource() == this.volumeSlider) {
            double g = 2.0 * ((double)this.volumeSlider.getValue() / (double)this.sliderLength);
            this.a3canvas.setSoundGain(g);
        } else if (ce.getSource() == this.slider) {
            if (this.a3 == null) {
                return;
            }
            double t = this.motionLength * ((double)this.slider.getValue() / (double)this.sliderLength);
            this.a3.setPauseTime(t);
        }
    }

    void loadAction3D() {
        Action3D.clearCash();
        this.statusBarLabel.setText("Status: Loading ... ");
        this.statusBarLabel.repaint();
        if (this.a3 != null) {
            this.a3canvas.del((A3Object)this.a3);
        }
        String urlString = this.urlTextField.getText();
        try {
            A23.initA23();
            this.a3 = Action3D.load((String)urlString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.actionNameCB.removeAllItems();
        String[] sss = this.a3.getActionNames();
        for (int i = 0; i < sss.length; ++i) {
            this.actionNameCB.addItem(sss[i]);
        }
        this.a3canvas.add((A3Object)this.a3);
        this.commentTextArea.setText(this.a3.getComment());
        if (this.pauseCheckBox.isSelected()) {
            this.a3.setMode(Motion.Mode.PAUSE);
        } else {
            this.a3.setMode(Motion.Mode.PLAY);
        }
        this.motionLength = this.a3.getMotionLength(this.actionName);
        this.slider.setValue(0);
        this.a3.setLocImmediately(0.0, 0.0, 0.0);
        this.a3.setQuatImmediately(0.0, 0.0, 0.0, 1.0);
        this.a3.setScaleImmediately(1.0);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                A3Panel.this.controller.reset(A3Panel.this.a3);
            }
        };
        this.executor.schedule(r, 100L, TimeUnit.MILLISECONDS);
        this.statusBarLabel.setText("Status: Loading ... done.");
    }

    @Override
    public void repaint() {
        if (this.a3 == null) {
            return;
        }
        if (this.immediatelyCheckBox.isSelected()) {
            this.a3.changeImmediately((Serializable)((Object)this.actionName));
        } else {
            this.a3.change((Serializable)((Object)this.actionName));
        }
        this.motionLength = this.a3.getMotionLength(this.actionName);
        this.slider.setValue(0);
    }

    void ref() {
        int returnVal;
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(".");
            this.fileChooser.setFileSelectionMode(2);
        }
        if ((returnVal = this.fileChooser.showOpenDialog(this)) != 0) {
            return;
        }
        File f = this.fileChooser.getSelectedFile();
        URL url = null;
        try {
            url = new URL(f.toURI().toString());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (url == null) {
            return;
        }
        this.urlTextField.setText(url.toExternalForm());
        Runnable r = new Runnable(){

            @Override
            public void run() {
                A3Panel.this.loadAction3D();
            }
        };
        this.executor.schedule(r, 100L, TimeUnit.MILLISECONDS);
    }

    void setBackground() {
        int returnVal;
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(".");
        }
        if ((returnVal = this.fileChooser.showOpenDialog(this)) != 0) {
            return;
        }
        File f = this.fileChooser.getSelectedFile();
        URL url = null;
        try {
            url = new URL(f.toURI().toString());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (url == null) {
            return;
        }
        Action3D a = null;
        try {
            a = Action3D.load((URL)url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (a != null) {
            this.a3canvas.setBackground((A3Object)a);
        }
        Box.createVerticalBox();
    }

    class MyVerticalBox
    extends JPanel {
        private static final long serialVersionUID = 1L;
        GridBagConstraints c;
        int index;

        MyVerticalBox() {
            this.setLayout(new GridBagLayout());
            this.c = new GridBagConstraints();
            this.c.fill = 1;
            this.c.weightx = 1.0;
        }

        public void myAdd(Component component, double weight) {
            this.c.gridy = this.index++;
            this.c.weighty = weight;
            this.add(component, this.c);
        }
    }

    class MyHorizontalBox
    extends JPanel {
        private static final long serialVersionUID = 1L;
        GridBagConstraints c;
        int index;

        MyHorizontalBox() {
            this.setLayout(new GridBagLayout());
            this.c = new GridBagConstraints();
            this.c.fill = 1;
            this.c.weighty = 1.0;
        }

        void myAdd(Component component, double weight) {
            this.c.gridx = this.index++;
            this.c.weightx = weight;
            this.add(component, this.c);
        }
    }
}

