#ifndef _SYS_SIGNAL_H
#define _SYS_SIGNAL_H
#ifdef __STDC__
#pragma comment(exestr, "@(#) signal.h 23.15 91/12/05 ")
#else
#if !_STRICT_NAMES && defined(ASM)
.ident "@(#) signal.h 23.15 91/12/05 "
#else
#ident "@(#) signal.h 23.15 91/12/05 "
#endif
#endif
/*
 *	Copyright (C) 1988-1991 The Santa Cruz Operation, Inc.
 *		All Rights Reserved.
 *	The information in this file is provided for the exclusive use of
 *	the licensees of The Santa Cruz Operation, Inc.  Such users have the
 *	right to use, modify, and incorporate this code into other products
 *	for purposes authorized by the license agreement provided they include
 *	this notice and the associated copyright notice with any such product.
 *	The information in this file is provided "AS IS" without warranty.
 */
/*	Copyright (c) 1984, 1986, 1987, 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#if !_STRICT_NAMES && defined(M_XOUT) && !defined(_M_XOUT)
#define _M_XOUT M_XOUT
#endif /* Eliminate name space pollution */

#if !_STRICT_NAMES && defined(M_UNIX) && !defined(_M_UNIX)
#define _M_UNIX M_UNIX
#endif /* Eliminate name space pollution */

#if !_STRICT_NAMES && defined(i386) && !defined(__i386)
#define __i386 i386
#endif /* Eliminate name space pollution */

#if defined(__i386) && !defined(_M_UNIX)
#define _M_UNIX __i386
#endif

#if !_STRICT_NAMES && defined(M_I386) && !defined(_M_I386)
#define _M_I386 M_I386
#endif /* Eliminate name space pollution */

#if !_STRICT_NAMES && defined(lint) && !defined(__lint)
#define __lint lint
#endif /* Eliminate name space pollution */

#if defined(_XOPEN_SOURCE) || defined(_POSIX_SOURCE) || !defined (__STRICT_ANSI__)
#define	SIGHUP	1	/* hangup */
#endif /* defined(_XOPEN_SOURCE) || defined(_POSIX_SOURCE) || !defined (__STRICT_ANSI__) */

#define	SIGINT	2	/* interrupt (rubout) */

#if defined(_XOPEN_SOURCE) || defined(_POSIX_SOURCE) || !defined (__STRICT_ANSI__)
#define	SIGQUIT	3	/* quit (ASCII FS) */
#endif /* defined(_XOPEN_SOURCE) || defined(_POSIX_SOURCE) || !defined (__STRICT_ANSI__) */

#define	SIGILL	4	/* illegal instruction (not reset when caught)*/

#if !defined (__STRICT_ANSI__)
#define	SIGTRAP	5	/* trace trap (not reset when caught) */
#define	SIGIOT	6	/* IOT instruction */
#endif /* !defined (__STRICT_ANSI__) */

#define SIGABRT 6	/* used by abort, replace SIGIOT in the  future */

#if !defined (__STRICT_ANSI__)
#define	SIGEMT	7	/* EMT instruction */
#endif /* !defined (__STRICT_ANSI__) */

#define	SIGFPE	8	/* floating point exception */

#if defined(_XOPEN_SOURCE) || defined(_POSIX_SOURCE) || !defined (__STRICT_ANSI__)
#define	SIGKILL	9	/* kill (cannot be caught or ignored) */
#endif /* defined(_XOPEN_SOURCE) || defined(_POSIX_SOURCE) || !defined (__STRICT_ANSI__) */

#if !defined (__STRICT_ANSI__)
#define	SIGBUS	10	/* bus error */
#endif /* !defined (__STRICT_ANSI__) */

#define	SIGSEGV	11	/* segmentation violation */

#if !defined (__STRICT_ANSI__)
#define	SIGSYS	12	/* bad argument to system call */
#endif /* !defined (__STRICT_ANSI__) */

#if defined(_XOPEN_SOURCE) || defined(_POSIX_SOURCE) || !defined (__STRICT_ANSI__)
#define	SIGPIPE	13	/* write on a pipe with no one to read it */
#define	SIGALRM	14	/* alarm clock */
#endif /* defined(_XOPEN_SOURCE) || defined(_POSIX_SOURCE) || !defined (__STRICT_ANSI__) */

#define	SIGTERM	15	/* software termination signal from kill */

#if defined(_XOPEN_SOURCE) || defined(_POSIX_SOURCE) || !defined (__STRICT_ANSI__)
#define	SIGUSR1	16	/* user defined signal 1 */
#define	SIGUSR2	17	/* user defined signal 2 */

#if !defined (__STRICT_ANSI__)
#define	SIGCLD	18	/* death of a child */
#define	SIGPWR	19	/* power-fail restart */
#define SIGWINCH 20	/* window change */
			/* SIGPHONE only used in UNIX/PC */
/*#define SIGPHONE 21*/	/* handset, line status change */

#define SIGCHLD SIGCLD  /* compatibility */

#if	!defined( _M_XOUT )	/* Normal UNIX case */
#	define	SIGPOLL	22	/* pollable event occurred */
#else				/* XENIX cross development */
#	define	SIGPOLL 20	/* pollable event occurred */
#endif /* _M_XOUT */

#else
#define SIGCHLD 18
#endif /* !defined (__STRICT_ANSI__) */

#if	defined( _M_UNIX )	/* Normal UNIX case */
#	define SIGSTOP 23	/* sendable stop signal not from tty */
#	define SIGTSTP 24	/* stop signal from tty */
#	define SIGCONT 25	/* continue a stopped process */
#	define SIGTTIN 26	/* to readers pgrp upon background tty read */
#	define SIGTTOU 27	/* like TTIN for output if tp->t_local&TOSTOP */

#if !defined (__STRICT_ANSI__)
#	define SIGVTALRM 28	/* virtual timer alarm */
#	define SIGPROF	 29	/* profile alarm */

#	define SIGALL	(~(sigset_t)0L)		/* new for POSIX */
#	define __SIGALL	(~(sigset_t)0L)		/* new for POSIX */

#	define NSIG	30	/* The valid signal number is from 1 to NSIG-1*/
#	define MAXSIG	32	/* size of u_signal[], NSIG-1 <= MAXSIG*/
			/* MAXSIG is larger than we need now. */
			/* In the future, we can add more signal */
			/* number without changing user.h */
#else
#	define __SIGALL	(~(sigset_t)0L)		/* new for POSIX */
#endif /* !defined (__STRICT_ANSI__) */

#	define	SIG_SETMASK	0	/* set mask in sigprocmask. new for POSIX */
#	define	SIG_BLOCK	1	/* union mask in sigprocmask. new for POSIX */
#	define	SIG_UNBLOCK	2	/* intrsct mask in sigprocmask. new for POSIX */

#else /* !_M_UNIX */			/* XENIX cross development */

#	define	NSIG	21
#ifdef _M_I386
#	define	MAXSIG	32
#else
#	define	MAXSIG	20
#endif

#endif	/* _M_UNIX */

typedef	long	sigset_t;

#if !defined (__STRICT_ANSI__)
#define         sigbit(n)       (1L << ((n) - 1))
#define         sigemptyset(s)  (*(s) = ~SIGALL)
#endif /* !defined (__STRICT_ANSI__) */

#ifdef _INKERNEL
#define         sigfillset(s)   (*(s) = SIGALL)
#define         sigaddset(s,n)  (qorl((s), sigbit(n)))
#define         sigdelset(s,n)  (qandl((s), ~sigbit(n)))
#define         sigismember(set,n) ((*(set) & sigbit(n)) == sigbit(n))
#endif /* _INKERNEL */

/*
 * Signal vector "template" used in sigaction call.
 */
struct  sigaction {
#if defined(__STDC__) && !defined(_NO_PROTOTYPE)
	void	(*sa_handler)(int);        /* signal handler */
#else
	void	(*sa_handler)();        /* signal handler */
#endif /* defined(__STDC__) && !defined(_NO_PROTOTYPE) */
        sigset_t sa_mask;               /* signal mask to apply */
        int     sa_flags;               /* see signal options below */
};

#define         SA_NOCLDSTOP    0x01    /* ignore SIGCHLD */

#if !defined (__STRICT_ANSI__)
/***				0x80	** do not use - 3.2v2 compatibility */
#define		SA_SIGNAL	0x100	/* handler established by signal(S),
					 *  rather than sigaction(S).
					 */
#endif /* !defined (__STRICT_ANSI__) */
#endif /* defined(_XOPEN_SOURCE) || defined(_POSIX_SOURCE) || !defined (__STRICT_ANSI__) */

#if (defined(__STDC__) || !defined(__STRICT_ANSI__)) && !defined(_NO_PROTOTYPE)
#define __SIG_FTN (void(*)(int))
#else
#define __SIG_FTN (void(*)())
#endif /* defined(__STDC__) && !defined(_NO_PROTOTYPE) */

#if __cplusplus

typedef void SIG_FUNC_TYP(int);
typedef SIG_FUNC_TYP *SIG_TYP;
#define SIG_PF SIG_TYP

extern "C" {
	SIG_TYP signal(int, SIG_TYP);	/* These 4 are declared in signal.h */
#ifdef _SYS_TYPES_H
	int kill(pid_t, int);
#else
	int kill(short, int);
#endif
#ifdef I_WANT_TO_GET_AN_CONFLICT /* conflicts with signal.h */
	int (*ssignal(int, int(*)(int)))();
	void (*sigset(int, SIG_TYP))();
#endif

	int sigpause(int);	/* These 4 are SVID functions as well */
	int sighold(int);
	int sigrelse(int);
	int sigignore(int);

	int gsignal(int);	/* No clue where this comes from, in libc */
}
#endif /* __cplusplus */

#define SIG_DFL (__SIG_FTN 0)

#if __lint
#define SIG_ERR (__SIG_FTN 0)
#define SIG_IGN (__SIG_FTN 0)
#define SIG_HOLD (__SIG_FTN 0)
#else
#define SIG_ERR (__SIG_FTN -1)
#define SIG_IGN (__SIG_FTN 1)
#if !defined (__STRICT_ANSI__)
#define SIG_HOLD (__SIG_FTN 2)
#endif /* !defined (__STRICT_ANSI__) */
#endif /* __lint */

/* The following definitions are only used by kernel */
#ifdef _INKERNEL
#define SIGNO_MASK	0xff
#define SIGDEFER	0x100
#define SIGHOLD		0x200
#define SIGRELSE	0x400
#define SIGIGNORE	0x800
#define SIGPAUSE	0x1000
#endif /* _INKERNEL */

#endif	/* _SYS_SIGNAL_H */
