/*
 * Copyright (c) 2007, 2018, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2.0,
 * as published by the Free Software Foundation.
 *
 * This program is also distributed with certain software (including
 * but not limited to OpenSSL) that is licensed under separate terms, as
 * designated in a particular file or component or in included license
 * documentation.  The authors of MySQL hereby grant you an additional
 * permission to link the program and your derivative works with the
 * separately licensed software that they have included with MySQL.
 * This program is distributed in the hope that it will be useful,  but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 * the GNU General Public License, version 2.0, for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA 
 */

#pragma once

#include "mforms/scrollpanel.h"
#include "mforms/checkbox.h"
#include "mforms/box.h"

#include "grt.h"

#include "wbpublic_public_interface.h"

class WBPUBLICBACKEND_PUBLIC_FUNC StringCheckBoxList : public mforms::ScrollPanel {
  std::vector<mforms::CheckBox *> _items;
  mforms::Box _box;
  boost::signals2::signal<void()> _signal_changed;

  void toggled();

public:
  StringCheckBoxList();

  void set_strings(const std::vector<std::string> &strings);
  void set_strings(const grt::StringListRef &strings);

  std::vector<std::string> get_selection();
  bool has_selection();

  void set_selected(const std::string &name, bool flag);

  boost::signals2::signal<void()> *signal_changed() {
    return &_signal_changed;
  }
};
