#!/bin/sh
# @(#$Id: tablescreen.tcl,v 1.13 1999/06/08 11:59:51 dockes Exp $  
# Generate a standard access screen from all a table's columns

# The following nonsense is required because mysqlwish dumps core when 
# SQLDBTYPE is ODBC, reason unknown.
# The following lines are executed by sh, not by wish because of the
# backslashes... Puke loudly
#\
case "A$SQLDBTYPE" in 
#\
  A|AMYSQL) exec /usr/local/bin/mysqlwish "$0" "$@";;
#\
*) exec wish "$0" "$@";; 
#\
esac

package require sqlsc

# Things that you may want to change
set username "";set hostname "";set password ""
catch {set username $env(SQLSCUSER)}
catch {set hostname $env(SQLSCHOST)}
catch {set password $env(SQLSCPASSWORD)}

# There is some special handling when CDKITDB is set, you don't want it
catch {unset env(CDKITDB)}

# Done with initialization. Process args:
if {$argc != 2} {
    puts "Usage: tablescreen.tcl <dbname> <table-name>"
    exit 1
}
set dbname [lindex $argv 0] 
set table [lindex $argv 1]

# Create Quit button
button .quit -text quit -command exit
pack .quit -side top -expand yes -fill x

# Create screen
set windowname [string tolower .$table]
set ${table}(window)   $windowname
set ${table}(database) $dbname
set ${table}(table)    $table
set ${table}(allowdelete) ""
# No need to set the next 3 if you're connecting to the local host and
# don't need user name or passwd
set ${table}(sqlschost) $hostname
set ${table}(sqlscuser) $username
set ${table}(sqlscpasswd) $password

puts "Connecting to $hostname, db $dbname, table $table as $username"

sqlscreen ${table}

pack $windowname -side top -expand 1 -fill x
