#!/bin/sh

# Create and load the sample "wines" database:
fatal()
{
    echo $1;exit 1
}

host=${SQLSCHOST:-localhost}
mysqladmin -h $host create wines || fatal \
    "Could not create database 'wines'. See diagnostic above"

mysql -h $host wines <<\EOF
# MySQL dump 4.0
#
# Host: ausone    Database: wines
#--------------------------------------------------------

#
# Table structure for table 'origins'
#
CREATE TABLE origins (
  origid int(11) DEFAULT '0' NOT NULL auto_increment,
  origin varchar(100),
  PRIMARY KEY (origid)
);

#
# Dumping data for table 'origins'
#

INSERT INTO origins VALUES (1,'alsace gewurtztraminer');
INSERT INTO origins VALUES (2,'alsace muscat');
INSERT INTO origins VALUES (3,'alsace riesling');
INSERT INTO origins VALUES (4,'bordeaux blanc');
INSERT INTO origins VALUES (5,'bordeaux entre deux mers');
INSERT INTO origins VALUES (62,'bourgogne morey saint denis 1er cru');
INSERT INTO origins VALUES (7,'bourgogne meursault');
INSERT INTO origins VALUES (8,'bourgogne nuits saint georges premier cru');
INSERT INTO origins VALUES (9,'bourgogne pernand vergelesses');
INSERT INTO origins VALUES (10,'bourgogne puligny montrachet');
INSERT INTO origins VALUES (11,'bourgogne puligny montrachet premier cru');
INSERT INTO origins VALUES (12,'cotes de plaimont primeur');
INSERT INTO origins VALUES (13,'jura cotes du jura');
INSERT INTO origins VALUES (14,'cotes du rhone lirac');
INSERT INTO origins VALUES (15,'sancerre');
INSERT INTO origins VALUES (16,'bordeaux premieres cotes de bordeaux');
INSERT INTO origins VALUES (17,'bordeaux');
INSERT INTO origins VALUES (18,'bordeaux graves');
INSERT INTO origins VALUES (19,'bordeaux haut medoc');
INSERT INTO origins VALUES (20,'bordeaux lalande de pomerol');
INSERT INTO origins VALUES (21,'bordeaux moulis');
INSERT INTO origins VALUES (22,'bordeaux pauillac');
INSERT INTO origins VALUES (23,'bordeaux saint estephe');
INSERT INTO origins VALUES (24,'bordeaux pomerol');
INSERT INTO origins VALUES (25,'bordeaux saint julien');
INSERT INTO origins VALUES (26,'bourgueuil');
INSERT INTO origins VALUES (27,'collioure');
INSERT INTO origins VALUES (28,'bourgogne cotes de nuits village');
INSERT INTO origins VALUES (29,'sancerre rouge');
INSERT INTO origins VALUES (30,'saumur champigny');
INSERT INTO origins VALUES (31,'bourgogne batard montrachet grand cru');
INSERT INTO origins VALUES (32,'bourgogne chablis premier cru');
INSERT INTO origins VALUES (33,'jura cotes du jura vin jaune');
INSERT INTO origins VALUES (34,'bordeaux barsac');
INSERT INTO origins VALUES (35,'bordeaux sauternes');
INSERT INTO origins VALUES (36,'bordeaux sainte croix du mont');
INSERT INTO origins VALUES (37,'coteaux du Layon SGN');
INSERT INTO origins VALUES (38,'bourgogne beaune');
INSERT INTO origins VALUES (39,'bourgogne chambolle musigny grand cru');
INSERT INTO origins VALUES (40,'bourgogne chambolle musigny premier cru');
INSERT INTO origins VALUES (41,'bordeaux saint emilion');
INSERT INTO origins VALUES (42,'bordeaux margaux');
INSERT INTO origins VALUES (43,'bourgogne clos de la roche grand cru');
INSERT INTO origins VALUES (44,'bourgogne vougeot');
INSERT INTO origins VALUES (45,'bourgogne morey saint denis');
INSERT INTO origins VALUES (46,'bourgogne cote de beaune corton grand cru');
INSERT INTO origins VALUES (47,'cotes du rhone cote rotie');
INSERT INTO origins VALUES (48,'bourgogne echezaux');
INSERT INTO origins VALUES (49,'bourgogne gevrey chambertin');
INSERT INTO origins VALUES (50,'cotes du rhone gigondas');
INSERT INTO origins VALUES (51,'bourgogne mazis chambertin grand cru');
INSERT INTO origins VALUES (52,'bourgogne santenay premier cru');
INSERT INTO origins VALUES (53,'bourgogne volnay premier cru');
INSERT INTO origins VALUES (54,'bourgogne vosnes romanee');
INSERT INTO origins VALUES (55,'cotes du rhone');
INSERT INTO origins VALUES (56,'bourgogne macon village');
INSERT INTO origins VALUES (57,'bourgogne blanc');
INSERT INTO origins VALUES (58,'coteaux du Layon');
INSERT INTO origins VALUES (60,'bourgogne savigny premier cru');
INSERT INTO origins VALUES (61,'bourgogne chorey les beaune');
INSERT INTO origins VALUES (63,'corbieres');
INSERT INTO origins VALUES (64,'brunello di montalcino');
INSERT INTO origins VALUES (65,'saint nicolas de bourgueuil');
INSERT INTO origins VALUES (66,'coteaux du Layon chaume');
INSERT INTO origins VALUES (67,'bourgogne clos de vougeot');
INSERT INTO origins VALUES (68,'bourgogne vougeot 1er cru');
INSERT INTO origins VALUES (69,'pouilly fume');
INSERT INTO origins VALUES (70,'bordeaux medoc');
INSERT INTO origins VALUES (71,'bourgogne beaune 1er cru');
INSERT INTO origins VALUES (72,'bourgogne chambertin grand cru');
INSERT INTO origins VALUES (73,'bourgogne corton charlemagne grand cru');
INSERT INTO origins VALUES (74,'bourgogne meursault 1er cru');
INSERT INTO origins VALUES (75,'bordeaux cotes de francs');
INSERT INTO origins VALUES (76,'madiran');
INSERT INTO origins VALUES (77,'jurancon');
INSERT INTO origins VALUES (78,'bordeaux saint emilion grand cru classe');
INSERT INTO origins VALUES (79,'bordeaux saint emilion premier grand cru classe');
INSERT INTO origins VALUES (80,'bordeaux premieres cotes de blaye');
INSERT INTO origins VALUES (81,'pacherenc du vic bilh');
INSERT INTO origins VALUES (82,'cotes du rhone chateauneuf du pape');
INSERT INTO origins VALUES (83,'coteaux du tricastin');
INSERT INTO origins VALUES (84,'cotes du rhone cornas');
INSERT INTO origins VALUES (85,'alsace');
INSERT INTO origins VALUES (86,'cotes du rhone cairanne');
INSERT INTO origins VALUES (87,'jura chateau chalon');
INSERT INTO origins VALUES (88,'alsace tokay pinot gris SGN');
INSERT INTO origins VALUES (89,'alsace tokay pinot gris');
INSERT INTO origins VALUES (90,'quarts de chaume');
INSERT INTO origins VALUES (91,'jura arbois vin jaune');
INSERT INTO origins VALUES (92,'maury');
INSERT INTO origins VALUES (93,'muscat de rivesaltes');
INSERT INTO origins VALUES (94,'Brunello de Montalcino');
INSERT INTO origins VALUES (95,'coteaux du languedoc');
INSERT INTO origins VALUES (96,'cahors');
INSERT INTO origins VALUES (97,'vin de pays des cotes de thongues');
INSERT INTO origins VALUES (98,'vin de pays des coteaux de Murviel');
INSERT INTO origins VALUES (99,'bourgogne chablis grand cru');
INSERT INTO origins VALUES (100,'saint chinian');
INSERT INTO origins VALUES (101,'bourgogne');
INSERT INTO origins VALUES (102,'bourgogne marsannay');
INSERT INTO origins VALUES (103,'bourgogne charmes chambertin grand cru');
INSERT INTO origins VALUES (104,'cotes du rhone Hermitage');
INSERT INTO origins VALUES (105,'minervois');
INSERT INTO origins VALUES (106,'alsace riesling SGN');
INSERT INTO origins VALUES (107,'bourgogne mercurey');
INSERT INTO origins VALUES (108,'bourgogne aloxe-corton');
INSERT INTO origins VALUES (109,'coteaux du Layon saint Aubin');
INSERT INTO origins VALUES (110,'coteaux du Layon saint Lambert');
INSERT INTO origins VALUES (111,'bourgogne Chassagne Montrachet');

#
# Table structure for table 'producers'
#
CREATE TABLE producers (
  id int(11) DEFAULT '0' NOT NULL auto_increment,
  name varchar(100) DEFAULT '' NOT NULL,
  address1 varchar(100) DEFAULT '' NOT NULL,
  address2 varchar(100),
  city varchar(50) DEFAULT '' NOT NULL,
  zip varchar(20),
  comments varchar(200),
  tel varchar(30),
  fax varchar(15),
  PRIMARY KEY (id)
);

#
# Dumping data for table 'producers'
#

INSERT INTO producers VALUES (1,'Domaine Zind Humbrecht','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (2,'Domaine Barmes Buecher','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (3,'Domaine Kientzler','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (4,'Bouchard pere et fils','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (5,'Domaine Leflaive','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (6,'Domaine Bonnardot','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (7,'Domaine Mellot','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (8,'Domaine Laurent Tribut','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (9,'Domaine Jacques Prieur','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (10,'Domaine Henri Clerc','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (11,'Domaine de la pierre saint morille','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (12,'Maison Dominique Laurent','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (13,'Domaine Drouhin Laroze','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (14,'SCE chateau de Santenay','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (15,'Domaine Francois Lamarche','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (16,'Domaine Bertagna','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (17,'Guigal','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (18,'Domaine des Pallieres','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (19,'Domaine de la pousse d''or','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (20,'Domaine Michel Clair','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (21,'Maison Verget','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (22,'Domaine Jo Pithon','3 ch. du moulin',NULL,'SAINT LAMBERT DU LATTAY','','','',NULL);
INSERT INTO producers VALUES (23,'rene et laurent dauvissat','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (24,'pernin rossin','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (25,'tollot-beau','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (26,'Chateau de Plaisance. scea rochais','',NULL,'ROCHEFORT SUR LOIRE','49190','','02 41 78 33 01','02 41 78 67 52');
INSERT INTO producers VALUES (27,'Domaine Capdevielle','',NULL,'64360 MONEIN','',NULL,NULL,NULL);
INSERT INTO producers VALUES (28,'domaine raffaitin','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (29,'lucien legrand','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (30,'alain hudelot-noellat','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (31,'Domaine Joseph Roty','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (32,'Serge Dagueneau et fils','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (33,'domaine jacques prieur','6 rue des santenots',NULL,'21190 meursault','',NULL,NULL,NULL);
INSERT INTO producers VALUES (34,'fontaine-gagnard','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (35,'SCEA domaine Capdevielle','',NULL,'MONEIN','64360',NULL,NULL,NULL);
INSERT INTO producers VALUES (36,'marcel deiss','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (37,'domaine Marc Kreydenweiss','','Andlau','','67140',NULL,NULL,NULL);
INSERT INTO producers VALUES (38,'domaine richaud','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (39,'domaine berthet-bondet','',NULL,'chateau-chalon','39210','','03 84 44 60 48',NULL);
INSERT INTO producers VALUES (40,'domaine mittnacht-klack','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (41,'domaine de la bergerie','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (42,'Domaine Jacques Tissot','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (43,'maurydore domaine de la coume du roy','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (44,'Domaine de la pierre saint maurille','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (45,'Domaine Cauhape','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (46,'Seppi Landmann','20 rue de la Vallee',NULL,'SOULTZMATT','68750',NULL,NULL,NULL);
INSERT INTO producers VALUES (47,'Chateau la Voulte Gasparets','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (48,'Chateau de Lastours','',NULL,'PORTEL DES CORBIERES','11490','','04 68 48 29 17','04 68 48 29 14');
INSERT INTO producers VALUES (49,'Mas de Daumas Gassac','',NULL,'','',NULL,NULL,NULL);
INSERT INTO producers VALUES (50,'Domaine le Nouveau Monde','A. et J. Gauch',NULL,'VENDRES','34350','','04 67 37 33 68','04 67 37 58 15');
INSERT INTO producers VALUES (51,'domaine brunel','',NULL,'',NULL,NULL,NULL,NULL);
INSERT INTO producers VALUES (52,'Domaine Henri Gouges','',NULL,'',NULL,NULL,NULL,NULL);
INSERT INTO producers VALUES (53,'domaine M.Perron','',NULL,'',NULL,NULL,NULL,NULL);
INSERT INTO producers VALUES (54,'Domaine Trimbach','',NULL,'',NULL,NULL,NULL,NULL);
INSERT INTO producers VALUES (55,'Richard Leroy','',NULL,'',NULL,NULL,NULL,NULL);
INSERT INTO producers VALUES (56,'Maison Tardieu-Laurent','',NULL,'',NULL,NULL,NULL,NULL);
INSERT INTO producers VALUES (57,'Chateau Genot Boulanger','',NULL,'',NULL,NULL,NULL,NULL);
INSERT INTO producers VALUES (58,'Domaine Capmartin','',NULL,'',NULL,NULL,NULL,NULL);

#
# Table structure for table 'providers'
#
CREATE TABLE providers (
  id int(11) DEFAULT '0' NOT NULL auto_increment,
  name varchar(100) DEFAULT '' NOT NULL,
  address1 varchar(100) DEFAULT '' NOT NULL,
  address2 varchar(100),
  city varchar(50) DEFAULT '' NOT NULL,
  zip varchar(20),
  comments varchar(200),
  fax varchar(30),
  tel varchar(30),
  PRIMARY KEY (id)
);

#
# Dumping data for table 'providers'
#

INSERT INTO providers VALUES (1,'Thien','',NULL,'','',NULL,NULL,NULL);
INSERT INTO providers VALUES (2,'Le chemin des vignes','',NULL,'','',NULL,NULL,NULL);
INSERT INTO providers VALUES (3,'jean lemetais','',NULL,'','',NULL,NULL,NULL);
INSERT INTO providers VALUES (4,'Bouchard pere et fils','',NULL,'','',NULL,NULL,NULL);
INSERT INTO providers VALUES (5,'auchan maurepas','',NULL,'','',NULL,NULL,NULL);
INSERT INTO providers VALUES (6,'Domaine Leflaive','',NULL,'','',NULL,NULL,NULL);
INSERT INTO providers VALUES (7,'dubecq','',NULL,'','',NULL,NULL,NULL);
INSERT INTO providers VALUES (8,'Les vins des grands vignobles','',NULL,'','',NULL,NULL,NULL);
INSERT INTO providers VALUES (9,'pierrot','',NULL,'','',NULL,NULL,NULL);
INSERT INTO providers VALUES (10,'leclerc bois d''arcy','',NULL,'','',NULL,NULL,NULL);
INSERT INTO providers VALUES (11,'Intermarche','',NULL,'','',NULL,NULL,NULL);
INSERT INTO providers VALUES (12,'grands crus diffusion','',NULL,'','',NULL,NULL,NULL);
INSERT INTO providers VALUES (13,'sodis ville avray','',NULL,'','',NULL,NULL,NULL);
INSERT INTO providers VALUES (14,'publix','',NULL,'','',NULL,NULL,NULL);
INSERT INTO providers VALUES (15,'Domaine de la pousse d''or','',NULL,'','',NULL,NULL,NULL);
INSERT INTO providers VALUES (16,'Salon des caves particulieres','',NULL,'',NULL,NULL,NULL,NULL);
INSERT INTO providers VALUES (17,'grains nobles','',NULL,'',NULL,NULL,NULL,NULL);

#
# Table structure for table 'tastings'
#
CREATE TABLE tastings (
  tastid int(11) DEFAULT '0' NOT NULL auto_increment,
  tdate date,
  stockid int(11),
  text text,
  PRIMARY KEY (tastid)
);

#
# Dumping data for table 'tastings'
#

INSERT INTO tastings VALUES (24,'1997-11-05',133,'Aromes classiques s''eventant assez vite, agreable en bouche. Evolution\nrapide apres ouverture. A boire. Super pour le prix \n');
INSERT INTO tastings VALUES (25,'1997-12-01',223,'Note **+ RVF dec/jan 97 vin simple  mais j''ai trouve bon au salon\nPas tres type jura\n\n');
INSERT INTO tastings VALUES (31,'1998-01-03',238,'Impression moins sucre qu''un Sauternes. Alcool tres present en bouche\nmais pas desagreable (15%) Notes de Cognac ou Pineau.\n');
INSERT INTO tastings VALUES (38,'1997-12-01',212,'Bon, belle  structure serree, pas a point du tout->attendre 1999 pour\nregouter.\n\n');
INSERT INTO tastings VALUES (41,'1998-05-02',NULL,'Impression beaucoup plus de corps et de jeunesse que degustation\nprecedente. Bouteilles ? Ou du au fait qu''il avait ete bu avant le \nGevrey Champs Chenys la fois d''avant ?\n');
INSERT INTO tastings VALUES (42,'1998-05-03',49,'Joli ne, bouche pas mal mais (tres legerement) plate et courte.\nA boire\nRegoute 26 mai, Pas du tout plat et court, tres beayu vin. Difference \npeut etre due a servi plus chaud la deuxieme fois , vers 15 degres.\n\n');
INSERT INTO tastings VALUES (43,'1998-05-13',221,'Joli vin tres type alsace. Relativement corse, parait moins leger que\nles 11 degres annonces sur l''etiquette.\nBeaucoup de Riesling ?\n\n');

#
# Table structure for table 'wines'
#
CREATE TABLE wines (
  stockid int(11) DEFAULT '0' NOT NULL auto_increment,
  name varchar(100) DEFAULT '' NOT NULL,
  origin varchar(100),
  color enum('red','sweet white','white'),
  year int(11),
  minyear int(11),
  maxyear int(11),
  purchdate date,
  producer int(11),
  provider int(11),
  unitprice float(10,2),
  bottype enum('50','75','half','magnum'),
  botcnt int(11),
  comments varchar(200),
  curuprice float(10,2),
  purchcnt int(11),
  PRIMARY KEY (stockid)
);

#
# Dumping data for table 'wines'
#

INSERT INTO wines VALUES (1,'gewurtztraminer clos winsbuhl hunawihr','alsace gewurtztraminer','white',1992,1995,2000,'0000-00-00',1,1,0.00,'75',6,'',0.00,6);
INSERT INTO wines VALUES (2,'gewurtztraminer grand cru cru hengst','alsace gewurtztraminer','white',1992,1995,2000,'0000-00-00',2,2,0.00,'75',1,'',0.00,1);
INSERT INTO wines VALUES (3,'gewurtztraminer heimburg turkheim','alsace gewurtztraminer','white',1993,1995,2000,'0000-00-00',1,1,0.00,'75',4,'',0.00,4);
INSERT INTO wines VALUES (4,'gewurtztraminer rosenberg','alsace gewurtztraminer','white',1993,1995,2000,'0000-00-00',2,2,0.00,'75',4,'',0.00,4);
INSERT INTO wines VALUES (5,'muscat kirchberg de ribeauville','alsace muscat','white',1992,1994,1998,'0000-00-00',3,1,0.00,'75',2,'',0.00,3);
INSERT INTO wines VALUES (6,'riesling herrenweg','alsace riesling','white',1992,1994,1998,'0000-00-00',2,2,0.00,'75',0,'',0.00,0);
INSERT INTO wines VALUES (12,'nuits saint georges la perriere','bourgogne nuits saint georges premier cru','white',1991,1996,2000,'1996-10-01',NULL,2,0.00,'75',0,'',0.00,1);
INSERT INTO wines VALUES (13,'pernand vergelesses','bourgogne pernand vergelesses','white',1991,1993,1996,'1993-01-01',NULL,5,60.00,'75',0,'',60.00,1);
INSERT INTO wines VALUES (16,'colombelle plaimont','cotes de ? primeur','white',1995,1995,1996,'0000-00-00',NULL,NULL,0.00,'75',3,'',0.00,3);
INSERT INTO wines VALUES (19,'lirac blanc','cotes du rhone lirac','white',1992,1993,1995,'0000-00-00',NULL,2,0.00,'75',0,'',0.00,0);
INSERT INTO wines VALUES (181,'saint nicolas de bourgueil','saint nicolas de bourgueil','red',1995,1998,2002,'1997-02-01',NULL,2,40.00,'75',5,NULL,40.00,11);
INSERT INTO wines VALUES (180,'brunello la bellarina','brunello di montalcino','red',1989,1996,1998,'1997-01-01',NULL,NULL,0.00,'75',1,'Cadeau ',0.00,1);
INSERT INTO wines VALUES (202,'chateau anniche','bordeaux premieres cotes de bordeaux','red',1994,1995,1998,'1995-01-01',NULL,3,25.00,'75',0,NULL,25.00,6);
INSERT INTO wines VALUES (24,'chateau belle-garde','bordeaux','red',1995,1997,1999,'1997-02-01',NULL,1,25.00,'75',0,'pas paye a thien ? ou echange avec je ne sais quoi?',25.00,0);
INSERT INTO wines VALUES (28,'chateau pontoise cabarrus','bordeaux haut medoc','red',1989,1994,1999,'1992-01-01',NULL,1,39.00,'75',5,'',39.00,5);
INSERT INTO wines VALUES (29,'chateau tour du haut moulin','bordeaux haut medoc','red',1986,1993,2002,'1993-01-01',NULL,7,60.00,'75',3,'',60.00,3);
INSERT INTO wines VALUES (30,'chateau bertineau saint vincent','bordeaux lalande de pomerol','red',1989,1994,1999,'1992-01-01',NULL,1,55.00,'75',0,'Tres bon, tres ouvert beaucoup de gout tout en restant relativement leger fini en 1997',55.00,0);
INSERT INTO wines VALUES (40,'cotes de nuits villages','bourgogne cotes de nuits village','red',1990,1994,2000,'0000-00-00',6,9,0.00,'75',0,'',0.00,0);
INSERT INTO wines VALUES (42,'saumur champigny','saumur champigny','red',1990,1994,1998,'1992-01-01',29,1,35.00,'75',2,'',35.00,5);
INSERT INTO wines VALUES (43,'batard montrachet','bourgogne batard montrachet grand cru','white',1986,1996,2005,'0000-00-00',NULL,2,0.00,'75',3,'',0.00,3);
INSERT INTO wines VALUES (49,'meursault clos de mazeray','bourgogne meursault','white',1992,1998,2010,'0000-00-00',9,2,0.00,'75',0,'',0.00,3);
INSERT INTO wines VALUES (67,'chateau anniche','bordeaux premieres cotes de bordeaux','red',1995,1998,2001,'1996-01-01',NULL,3,25.00,'75',10,'',25.00,11);
INSERT INTO wines VALUES (94,'chateau la tour carnet','bordeaux haut medoc','red',1990,1999,2005,'1994-01-01',NULL,5,50.00,'75',6,'***',50.00,6);
INSERT INTO wines VALUES (97,'chateau lafon rochet','bordeaux saint estephe','red',1990,2000,2015,'1993-03-01',NULL,5,60.00,'75',11,'****tb grande garde d''apres rvf',60.00,11);
INSERT INTO wines VALUES (133,'chateau tour de mons','bordeaux margaux','red',1990,1997,2002,'1993-03-01',NULL,5,50.00,'75',0,'',50.00,6);
INSERT INTO wines VALUES (148,'musigny','bourgogne chambolle musigny grand cru','red',1991,2001,2011,'0000-00-00',9,2,0.00,'75',4,'',0.00,4);
INSERT INTO wines VALUES (153,'volnay premier cru clos des santenots','bourgogne volnay premier cru','red',1991,2001,2011,'0000-00-00',NULL,2,0.00,'75',1,'',0.00,1);
INSERT INTO wines VALUES (156,'macon village Verget','bourgogne macon village','white',1996,1998,2003,'1997-03-01',21,1,42.00,'75',12,'',42.00,12);
INSERT INTO wines VALUES (158,'bourgogne blanc Verget','bourgogne blanc','white',1996,1998,2000,'1997-03-01',21,1,48.00,'75',12,'',48.00,12);
INSERT INTO wines VALUES (160,'coteaux du layon st Lambert jo pithon','coteaux du Layon saint Lambert','sweet white',1996,1998,2005,'1997-03-01',22,1,60.00,'75',6,'',60.00,6);
INSERT INTO wines VALUES (162,'Domaine de Granoupiac','coteaux du languedoc','white',1996,1997,1999,'1997-04-20',NULL,NULL,35.00,'75',3,'Achete au domaine avec thien/christian',35.00,6);
INSERT INTO wines VALUES (163,'Domaine de Granoupiac','coteaux du languedoc','red',1995,1998,2000,'1997-04-20',NULL,NULL,35.00,'75',0,'Achete au domaine avec thien/christian',35.00,5);
INSERT INTO wines VALUES (166,'Chateau la Voulte-Gasparets Cuvee Romain Pauc','corbieres','red',1994,1998,2002,'1997-04-20',47,NULL,NULL,'magnum',1,'Cadeau du producteur',NULL,1);
INSERT INTO wines VALUES (168,'Chateau la Voulte-Gasparets Cuvee Reservee','corbieres','red',1995,1998,2002,'1997-04-20',47,NULL,35.00,'75',4,NULL,35.00,12);
INSERT INTO wines VALUES (184,'riesling herrenweg','alsace riesling','white',1995,1997,2005,'1997-03-01',2,2,60.00,'75',5,NULL,60.00,6);
INSERT INTO wines VALUES (201,'chateau de l''hospital','bordeaux graves','white',1995,1997,2000,'1997-06-26',NULL,NULL,55.00,'75',3,NULL,55.00,6);
INSERT INTO wines VALUES (204,'Chateau les Charmes Godard','bordeaux cotes de francs','red',1995,2000,2005,'1997-09-25',NULL,1,48.00,'75',23,NULL,48.00,23);
INSERT INTO wines VALUES (207,'domaine du crampihl','madiran','red',1990,1997,2000,'1997-09-25',NULL,1,36.00,'75',5,NULL,36.00,7);
INSERT INTO wines VALUES (208,'domaine capdevielle petit manseing','jurancon','white',1995,1998,2005,'1997-06-01',35,1,55.00,'75',12,NULL,55.00,12);
INSERT INTO wines VALUES (257,'Chateau de Lastours. Cuvee Simone Descamps','coteaux du languedoc','red',1994,2000,2005,'1997-04-27',48,NULL,39.00,'75',6,'Achete Salon C.P.',39.00,6);
INSERT INTO wines VALUES (212,'moulin de citran','bordeaux haut medoc','red',1995,1999,2000,'1997-11-10',NULL,1,40.00,'75',20,NULL,40.00,23);
INSERT INTO wines VALUES (213,'chateau lacaussade saint martin "trois moulins"','bordeaux premieres cotes de blaye','white',1995,1997,1999,'1997-11-10',NULL,1,35.00,'75',12,NULL,35.00,12);
INSERT INTO wines VALUES (214,'chateau la tuilerie','bordeaux graves','white',1995,1997,1999,'1997-11-10',NULL,NULL,30.00,'75',4,NULL,30.00,6);
INSERT INTO wines VALUES (216,'Domaine de la Janasse - cuvee Chaupin','cotes du rhone chateauneuf du pape','red',1994,1999,2004,'1997-11-28',NULL,NULL,116.00,'75',3,NULL,NULL,3);
INSERT INTO wines VALUES (218,'domaine de saint luc - syrah','coteaux du tricastin','red',1992,1997,2000,'1997-11-28',NULL,2,60.00,'75',2,NULL,60.00,2);
INSERT INTO wines VALUES (221,'clos du val d''eleon','alsace','white',1992,1997,2000,'1997-11-28',37,2,0.00,'75',0,'Pour gouter. C''est assemblage multicepages. cadeau legrand',0.00,1);
INSERT INTO wines VALUES (222,'cairanne blanc domaine richaud','cotes du rhone cairanne','white',1995,1997,2000,'1997-11-28',38,2,0.00,'75',1,'pour gouter. cadeau legrand',0.00,1);
INSERT INTO wines VALUES (223,'cotes du jura tradition berthet-bondet','jura cotes du jura','white',1994,2000,2004,'1997-12-01',39,NULL,47.00,'75',3,'salon des caves particulieres chardonnay+savagnin',47.00,4);
INSERT INTO wines VALUES (233,'muscat de rivesaltes','muscat de rivesaltes','white',1996,1997,1997,'1997-12-01',43,NULL,45.00,'75',2,'salon caves particulieres',45.00,3);
INSERT INTO wines VALUES (238,'Jurancon quintessence du petit manseng','jurancon','sweet white',1991,1998,2003,NULL,45,NULL,0.00,'half',0,'Cadeau pepe',0.00,0);
INSERT INTO wines VALUES (241,'Riesling Zinnkoepfle','alsace riesling','white',1997,1999,2005,'1998-03-01',46,NULL,49.50,'75',24,'12 pour Thien. Primeurs pas livre.',49.50,24);
INSERT INTO wines VALUES (251,'La Pieve',NULL,'red',1996,1998,2000,'1998-04-15',NULL,NULL,0.00,'75',1,'Le vin du copain de Suzy',0.00,1);
INSERT INTO wines VALUES (252,'Brunello Tenuta la Poderina','Brunello de Montalcino','red',1993,2000,2005,'1998-04-15',NULL,NULL,0.00,'75',1,'Cadeau du producteur, ami de suzi',0.00,1);
INSERT INTO wines VALUES (259,'Chateau de Lastours. Cuvee futs de chene','coteaux du languedoc','red',1993,1998,2003,'1997-04-27',48,NULL,44.00,'75',6,'Achete Salon C.P.',44.00,6);
INSERT INTO wines VALUES (262,'Chateau la Gineste','cahors','red',1995,2000,2005,'1997-04-27',NULL,NULL,40.00,'75',2,'Salon C.P.',40.00,2);
INSERT INTO wines VALUES (263,'Vin de pays d''Oc - Chardonnay',NULL,'white',1997,1998,2000,'1997-04-27',50,NULL,30.00,'75',3,'Salon C.P. un peu vulgaire mais patronne gentille',30.00,3);
INSERT INTO wines VALUES (264,'Vin de pays d''Oc - Vinifie en futs de chene',NULL,'white',1994,1998,2000,'1997-04-27',50,NULL,45.00,'75',3,'Salon C.P. assez fin',45.00,3);
INSERT INTO wines VALUES (265,'Les douves de francs','bordeaux cotes de francs','red',1995,1998,2000,'1998-05-12',NULL,1,20.00,'75',9,'',20.00,12);
INSERT INTO wines VALUES (310,'coteaux du Layon chateau des Rochettes selec. V.V.','coteaux du layon','sweet white',1997,1998,2010,'1998-12-15',NULL,1,NULL,'75',6,NULL,NULL,6);
INSERT INTO wines VALUES (267,'chateau Puygueraud','bordeaux cotes de francs','red',1995,1998,2008,'1998-05-01',NULL,7,60.00,'75',12,NULL,60.00,12);
INSERT INTO wines VALUES (270,'Domaine de Limbardie','vin de pays des coteaux de Murviel','red',1997,1998,2000,'1998-05-15',NULL,1,20.00,'75',12,'Merlot et Cabernet',20.00,12);
INSERT INTO wines VALUES (271,'Domaine les chemins de Bassac cuvee Pierre Elie','vin de pays des cotes de thongues','red',1995,2000,2003,'1998-05-20',NULL,1,40.00,'75',12,'50% grenache 50% Syrah',40.00,6);
INSERT INTO wines VALUES (272,'Domaine les chemins de Bassac cuvee Cap de l''homme','vin de pays des cotes de thongues','red',1995,2000,2003,'1998-05-20',NULL,1,50.00,'75',6,'100% grenache eleve futs et foudres recents',50.00,6);
INSERT INTO wines VALUES (273,'Domaine les chemins de Bassac','vin de pays des cotes de thongues','red',1996,1998,2000,'1998-05-20',NULL,1,31.00,'75',6,NULL,31.00,6);
INSERT INTO wines VALUES (277,'nuits saint georges les vaucrains','bourgogne nuits saint georges premier cru','red',1989,2001,2008,'1993-01-01',52,1,0.00,'75',6,'',NULL,6);
INSERT INTO wines VALUES (278,'Chateau de Ruth','cotes du rhone','red',1993,1998,2002,'1998-06-15',NULL,NULL,0.00,'magnum',1,'residu fete fontenelles',0.00,1);
INSERT INTO wines VALUES (280,'Chateau Quartironi de Sars','saint chinian','red',1995,1998,2002,'1998-08-10',NULL,1,28.00,'75',5,NULL,28.00,6);
INSERT INTO wines VALUES (281,'Chateau Quartironi de Sars - Cuvee Campanil','saint chinian','red',1995,1998,2002,'1998-08-10',NULL,1,42.00,'75',11,NULL,42.00,12);
INSERT INTO wines VALUES (287,'Bourgogne "cuvee Pressonniers"','bourgogne','red',1995,1998,1999,'1998-11-03',31,NULL,51.00,'75',12,NULL,51.00,12);
INSERT INTO wines VALUES (292,'chateau belle-garde','bordeaux','red',1996,1998,2000,'1998-11-24',NULL,NULL,22.00,'75',24,NULL,22.00,24);
INSERT INTO wines VALUES (293,'chateau belle-garde "Eleve en fut"','bordeaux','red',1996,2000,2005,'1998-11-24',NULL,NULL,30.00,'75',12,NULL,30.00,12);
INSERT INTO wines VALUES (298,'Domaine Lignon','minervois','red',1996,1998,2000,'1998-12-15',NULL,1,NULL,'75',12,'Thien. Prix ?',NULL,12);
INSERT INTO wines VALUES (299,'Domaine Lignon','minervois','red',1997,1999,2001,'1998-12-15',NULL,1,NULL,'75',6,'Thien. Prix ?',NULL,6);
INSERT INTO wines VALUES (300,'chateau de Ruth','cotes du rhone','red',1995,1998,2002,'1998-12-15',NULL,1,NULL,'75',12,NULL,NULL,12);
INSERT INTO wines VALUES (305,'gigondas chateau Redortier','cotes du rhone gigondas','red',1995,2003,2005,'1998-12-15',NULL,1,NULL,'75',6,NULL,NULL,6);
INSERT INTO wines VALUES (306,'pacherenc du vic bilh chateau Barrejat','pacherenc du vic bilh','sweet white',1996,1998,2004,'1998-12-15',NULL,1,NULL,'50',6,NULL,NULL,6);
INSERT INTO wines VALUES (307,'madiran vieilles vignes Dom. Capmartin','madiran','red',1995,1998,2003,'1998-12-15',58,1,NULL,'75',NULL,NULL,NULL,6);
INSERT INTO wines VALUES (308,'madiran Dom. Capmartin cuvee du couvent chene neuf','madiran','red',1996,2000,2005,'1998-12-15',58,1,NULL,'75',6,NULL,NULL,6);
INSERT INTO wines VALUES (309,'madiran Chateau Barrejat','madiran','red',1996,2000,2005,'1998-12-15',58,1,NULL,'75',12,'tvv 80-200 ans...',NULL,12);
INSERT INTO wines VALUES (311,'coteaux du Layon chateau des Rochettes cuvee Sophie','coteaux du layon','sweet white',1997,1998,2010,'1998-12-15',NULL,1,NULL,'75',6,NULL,NULL,6);
INSERT INTO wines VALUES (312,'coteaux du Layon saint Aubin Domaine Cady','coteaux du Layon saint Aubin','sweet white',1997,1998,2010,'1998-12-15',NULL,1,NULL,'75',12,NULL,NULL,12);


EOF
