/******************************************************************************
	  CCCC	    A	  BBBBB	  L	EEEEE  N     N	EEEEE	TTTTTTT
	 C    C    A A	  B    B  L	E      NN    N	E	   T
	C	  A   A	  B    B  L	E      N N   N	E	   T
	C	 AAAAAAA  BBBBB	  L	EEEEE  N  N  N	EEEEE	   T
	C        A     A  B    B  L	E      N   N N	E	   T
	 C    C  A     A  B    B  L	E      N    NN  E 	   T
	  CCCC	 A     A  BBBBB	  LLLL	EEEEE  N     N	EEEEE	   T
*******************************************************************************

CableNet Source Module:
	Copyright 1994-1995 (C) CableNet Limited. All Rights Reserved.

    Module Name:		$RCSfile: TagValue.c,v $
    Module Description:	Brief description of source module

Command Line Args: (for main program modules only)
    Arg      Param      Description

Description: 

Linked with: <file.c> .. <file.c>

Created on   20 Mar 1995    By V

Edit History:

	$Log: TagValue.c,v $
 * Revision 1.2  1997/07/04  16:26:28  damian
 * initialise tagvalue list scan
 *
 * Revision 1.1  1995/08/29  10:31:08  damian
 * Initial revision
 *


*/

/* RCS identification string (for "what" program) */
static char moduleRCSid[] = "@(#) $Id: TagValue.c,v 1.2 1997/07/04 16:26:28 damian Exp $";

/* must come first header files */
#include "V.h"			/* virtual header file */
#include "Vport.h"		/* port header file */

/*
 * system header files 
*/
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>

/*
 * project header files 
*/
#include "Vlib.h"

/*
 * local header files 
*/

/*
 * non static functions 
*/



#ifdef VANSI_1
TagDef *
CreateTagDef (char *tag, char *val)
#else
TagDef *
CreateTagDef (tag, val)
     char *tag;
     char *val;
#endif
{
  TagDef *tdef;

  tdef = (TagDef *) Malloc (sizeof (TagDef));

  Memset (tdef, 0, sizeof (TagDef));

  tdef->tag = CopyString (tag);
  tdef->val = CopyString (val);

  return tdef;
}

void 
DestroyTagDef( TagDef *tg )
{
    if ( tg ) {
	Free(tg->tag); 
	Free(tg->val); 
	Free(tg);
    }
}

int
CompareTagDefs( TagDef *tg1, TagDef *tg2 )
{

    if ( !tg1 )
	return 1;

    if ( !tg2 )
	return -1;

    return strcmp(tg1->tag, tg2->tag);

}

LLlist  *
CreateTagValueLLlist()
{
    return LLcreate(NULL, CompareTagDefs, DestroyTagDef, 0);
}

int
AddTagValueToLLlist( LLlist *list, char *tag, char *val)
{
    TagDef  *tdef;

    if ( !list || !tag || !val )
	return -1;

    tdef = CreateTagDef (tag, val);

    LLappend (list, (void *) tdef);

    return 0;
}

void
InitTagValueScan(LLlist *list)
{
    LLinitScan(list, 0);
}

int
GetNextTagValuePair( LLlist *list, char **tag, char **val)
{
    TagDef  *td;

    if ((td = (TagDef *)LLscan(list)) == NULL)
	return -1;

    *tag = td->tag;
    *val = td->val;

    return 0;

}

char    *
FindTagValue( LLlist *list, char *tag )
{
    TagDef  *tdef, *tres;

    if ( !list || !tag )
	return NULL;

    tdef = CreateTagDef (tag, "");

    InitTagValueScan(list);

    tres = LLfind(list, tdef, 0);

    DestroyTagDef(tdef);

    if (tres != NULL)
	return tres->val;
    else
	return NULL;

}

/*++ ****************  function SeperateTagAndValue *********************/
/*
    Purpose:     seperate a string into a tag and a value

    Parameters:
    char     *str    == string to seperate
    char     **tag   == pointer to char * to set as tag
    char     **val   == pointer to char * to set as val

    Return Values: int
    0       success
    < 0     error    (str not in 'tag = val' format )

*/
/*********************************************************************** ++*/

#ifdef VANSI_1
int 
SeperateTagAndValue (char *str, char **tag, char **val)
#else
int 
SeperateTagAndValue (str, tag, val)
     char *str;
     char **tag;
     char **val;
#endif
{
  char *nl, *sep;

  if (!str || !tag || !val)
    return -1;

  /*-- determine location of seperator '=' and end of line '\n' */
  sep = strchr (str, '=');
  nl = strchr (str, '\n');

  /*-- initialise pointers in the event of error return */
  *tag = NULL;
  *val = NULL;

  /*-- if no seperator or seperator is first char in line return error */
  if (!sep || (sep == str))
    return -1;

  /*-- null terminate tag and value fields */
  *sep++ = '\0';

  if (nl)
    *nl = '\0';

  *tag = str;
  *val = sep;

  /*-- if seperator is last char in line return error */
  if ((!*tag) || (!*val))
    return -1;

  /*-- return success */
  return 0;
}

