/******************************************************************************
	  CCCC	    A	  BBBBB	  L	EEEEE  N     N	EEEEE	TTTTTTT
	 C    C    A A	  B    B  L	E      NN    N	E	   T
	C	  A   A	  B    B  L	E      N N   N	E	   T
	C	 AAAAAAA  BBBBB	  L	EEEEE  N  N  N	EEEEE	   T
	C        A     A  B    B  L	E      N   N N	E	   T
	 C    C  A     A  B    B  L	E      N    NN  E 	   T
	  CCCC	 A     A  BBBBB	  LLLL	EEEEE  N     N	EEEEE	   T
*******************************************************************************

CableNet Source Module:
	Copyright 1994-1995 (C) CableNet Limited. All Rights Reserved.

    Module Name:		$RCSfile: Vdb.c,v $
    Module Description:	Virtual interface to any database engine

Description: 

Created on   21/1/97    By damian

Edit History:

	$Log: Vdb.c,v $
 * Revision 1.6  1998/04/15  17:05:15  damian
 * connect to localhost if host == NULL
 *
 * Revision 1.5  1998/03/06  14:22:30  damian
 * hold hostname in handles and set handle to -1 on close
 *
 * Revision 1.4  1997/09/19  15:49:58  damian
 * don't log notice of which engine is being used
 *
 * Revision 1.3  1997/09/08  17:55:51  damian
 * log_notice use of default database engine
 *
 * Revision 1.2  1997/09/02  12:06:45  damian
 * use Vdbmsg error message pointer
 *
	Revision 1.1  1997/08/21 18:08:59  damian
	Initial revision

*/

/* RCS identification string (for "what" program) */
static char moduleRCSid[] = "@(#) $Id: Vdb.c,v 1.6 1998/04/15 17:05:15 damian Exp damian $";

/* must come first header files  */
#include "V.h"
#include "Vport.h"


/*
 * system header files 
*/
#include <sys/types.h>
#include <sys/param.h>
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <syslog.h>
#include <memory.h>

/*
 * third party headers ie, X, informix, ctree 
*/

/*
 * project header files 
*/

#include "Vlib.h"
#include "dflts.h"

#include "Vdb.h"

/*
 * local header files 
*/

#ifdef VDB_MSQL
#include "msqlacc.h"
#endif

#ifdef VDB_MYSQL
#include "mysqlacc.h"
#endif

/*
 * local defines 
*/

#ifdef Vsunos40
#include "Vansi.h"
#endif


/*
 * local typedefs 
*/

/*
 * static function declarations 
*/

/*
 * static local variables 
*/

/*
 * exported objects/variables (non-static) 
*/

/*
 * static functions 
*/

/*
 * non static functions 
*/

#define MSQL_TYPE   1
#define MYSQL_TYPE  2

static int default_engine = 0;
static int initialised = 0;

static struct _dbhandles {
    char    host[64];
    char    dbase[32];
    int type;
    int handle;
} dbhandles[NOFILE];

char	*Vdbmsg;

/* cache a possibly free handle */
static int cache = 0;

#ifdef __STDC__
int
VdbInit(char *user, char*passwd)
#else
int
VdbInit(user,passwd)
char    *user;
char    *passwd;
#endif
{
  memset(dbhandles,0,sizeof(dbhandles));

#ifdef VDB_MSQL
/*	MsqlInit(user,passwd); */
#endif

#ifdef VDB_MYSQL
	MysqlInit(user,passwd);
#endif

    return 0;
}

#ifdef __STDC__
int
VdbNumRows(VdbHandle handle)
#else
int
VdbNumRows(handle)
VdbHandle handle;
#endif
{
    switch(dbhandles[handle].type){
#ifdef VDB_MSQL
    case MSQL_TYPE:
	return MsqlaccNumrows(dbhandles[handle].handle);
	break;
#endif

#ifdef VDB_MYSQL
    case MYSQL_TYPE:
	return MysqlaccNumrows(dbhandles[handle].handle);
	break;
#endif

    }
    return 0;
}

#ifdef __STDC__
int
VdbNumFields(VdbHandle handle)
#else
int
VdbNumFields(handle)
VdbHandle handle;
#endif
{
    switch(dbhandles[handle].type){
#ifdef VDB_MSQL
    case MSQL_TYPE:
	return MsqlaccNumfields(dbhandles[handle].handle);
	break;
#endif

#ifdef VDB_MYSQL
    case MYSQL_TYPE:
	return MysqlaccNumfields(dbhandles[handle].handle);
	break;
#endif

    }
    return 0;
}

/* 
 * connect to database on specified host
 * this first checks the array of db handles to see if we are already
 * connected to this host and database
 */

VdbHandle
VdbConnectDB(char *host, char *dbase)
{
    register int     i;
    DfltsInfo   di;
    char    *val;

    if (host == NULL)
	host = "localhost";

#if defined(VDB_MYSQL) && defined(VDB_MSQL)

    if (default_engine == 0) {

	memset(&di, 0, sizeof(di));
	di.group = "Vdb";
	di.tag = "default_engine";
	di.base = ANY_DFLT_SET;

	if ((val = DfltGetString(&di)) == NULL)
	    default_engine = 1;
	else {
	    if ( strncasecmp(val, "msql", 4) == 0)
		default_engine = 1;
	    else if ( strncasecmp(val, "mysql", 5) == 0)
		default_engine = 2;
	    else
		default_engine = 2;
	}

    }
#else

    if (default_engine == 0) {

  #ifdef VDB_MSQL
    default_engine = MSQL_TYPE
  #else
    default_engine = MYSQL_TYPE
  #endif

    }

#endif

    for(i = 0; i < NOFILE; i++) {
	if(dbhandles[i].type == 0)
	    continue;

	if (strcmp(dbhandles[i].host,host) == 0 &&
	    strcmp(dbhandles[i].dbase,dbase) == 0 )
	    break;
    }

    if( i == NOFILE) {
	/* not found */
	if ((i = VdbConnect(host)) < 0)
	    return -1;

	sprintf(dbhandles[i].host, "%.63s", host);

	if (VdbSelect(i,dbase) < 0)
	    return -1;
    }

    return (VdbHandle) i;
}


/* 
 * connect to database engine on specified host
 */

#ifdef __STDC__
VdbHandle
VdbConnect(char *host)
#else
VdbHandle
VdbConnect(host)
char    *host;
#endif
{
    register int     handle, i;
    DfltsInfo   di;
    char    *val;

    if (host == NULL)
	host = "localhost";

#if defined(VDB_MYSQL) && defined(VDB_MSQL)

    if (default_engine == 0) {

	memset(&di, 0, sizeof(di));
	di.group = "Vdb";
	di.tag = "default_engine";
	di.base = ANY_DFLT_SET;

	if ((val = DfltGetString(&di)) == NULL)
	    default_engine = 1;
	else {
	    if ( strncasecmp(val, "msql", 4) == 0)
		default_engine = 1;
	    else if ( strncasecmp(val, "mysql", 5) == 0)
		default_engine = 2;
	    else
		default_engine = 2;
	}

    }
#else

    if (default_engine == 0) {

  #ifdef VDB_MSQL
    default_engine = MSQL_TYPE
  #else
    default_engine = MYSQL_TYPE
  #endif

    }

#endif

    i = cache;
    if ( i >= NOFILE || dbhandles[i].handle > 0)
	for(i = 0; i < NOFILE; i++)
	    if(dbhandles[i].type == 0)
		break;

    if ( i == NOFILE) {
	/* no handles left */
	Vdbmsg = "Couldn't connect to engine! - No handles left\n"; 
	return -1;
    }
    cache = i + 1;
    handle = -1;
    switch(default_engine) {

#ifdef VDB_MSQL
    case MSQL_TYPE:
	dbhandles[i].type = MSQL_TYPE;
	if ( (handle = MsqlaccConnect(host)) < 0 ) {
	    cache = i;
	    return -1;
	}
	break;
#endif

#ifdef VDB_MYSQL
    case MYSQL_TYPE:
	dbhandles[i].type = MYSQL_TYPE;
	if ( (handle = MysqlaccConnect(host)) < 0 ) {
	    cache = i;
	    return -1;
	}
	break;
#endif

    }

    dbhandles[i].handle = handle;
    sprintf(dbhandles[i].host, "%.63s", host);

    return (VdbHandle) i;
}


/*
 * select a database
*/
#ifdef __STDC__
int
VdbSelect(VdbHandle handle, char *db)
#else
int
VdbSelect(handle, db)
VdbHandle     handle;
char    *db;
#endif
{
    int     err = -1;
    
    switch(dbhandles[handle].type) {

#ifdef VDB_MSQL
    case MSQL_TYPE:
	err = MsqlaccSelect(dbhandles[handle].handle,db);
	break;
#endif

#ifdef VDB_MYSQL
    case MYSQL_TYPE:
	err = MysqlaccSelect(dbhandles[handle].handle,db);
	break;
#endif

    }

    if (err != 0) {
	dbhandles[handle].dbase[0] = '\0';

    } else {
	sprintf(dbhandles[handle].dbase, "%.31s", db);
    }

    return err;

}

/*
 * perform a database query
*/
#ifdef __STDC__
int
VdbQuery(VdbHandle handle, char *query)
#else
int
VdbQuery(handle, query)
VdbHandle     handle;
char    *query;
#endif
{
    
    int     err = -1;

    switch(dbhandles[handle].type) {
#ifdef VDB_MSQL
    case MSQL_TYPE:
	err = MsqlaccQuery(dbhandles[handle].handle,
			   dbhandles[handle].dbase,
			   query);
	break;
#endif

#ifdef VDB_MYSQL
    case MYSQL_TYPE:
	err = MysqlaccQuery(dbhandles[handle].handle,
			    dbhandles[handle].dbase,
			    query);
	break;
#endif

    }

    return err;

}

/*
 * close the connection to the database engine
*/
#ifdef __STDC__
int
VdbClose(VdbHandle handle)
#else
int
VdbClose(handle)
VdbHandle    handle;
#endif
{
    int     err = -1;

    switch(dbhandles[handle].type) {
#ifdef VDB_MSQL
    case MSQL_TYPE:
	err = MsqlaccClose(dbhandles[handle].handle);
	break;
#endif

#ifdef VDB_MYSQL
    case MYSQL_TYPE:
	err = MysqlaccClose(dbhandles[handle].handle);
	break;
#endif

    }

    dbhandles[handle].handle = -1;

    return 0;
}

/*
 * 
*/
int
VdbFetchRow(VdbHandle handle, char *fldv[], int *num)
{
    int     err = -1;

    switch(dbhandles[handle].type) {
#ifdef VDB_MSQL
    case MSQL_TYPE:
	err = MsqlaccFetchRow(dbhandles[handle].handle, fldv, num);
	break;
#endif

#ifdef VDB_MYSQL
    case MYSQL_TYPE:
	err = MysqlaccFetchRow(dbhandles[handle].handle, fldv, num);
	break;
#endif

    }
    return err;
}

/*
 * get pointers to the first record's data values
*/
int
VdbFirstRec(VdbHandle handle, char *fldv[], int *num)
{
    int     err = -1;

    switch(dbhandles[handle].type) {
#ifdef VDB_MSQL
    case MSQL_TYPE:
	err = MsqlaccFirstRec(dbhandles[handle].handle, fldv, num);
	break;
#endif

#ifdef VDB_MYSQL
    case MYSQL_TYPE:
	err = MysqlaccFirstRec(dbhandles[handle].handle, fldv, num);
	break;
#endif

    }
    return err;
}

/*
 * move the result record pointer to the next result
 * and get the values therein
*/
int
VdbNextRec(VdbHandle handle, char *fldv[], int *num)
{
    int     err = -1;

    switch(dbhandles[handle].type) {
#ifdef VDB_MSQL
    case MSQL_TYPE:
	err = MsqlaccNextRec(dbhandles[handle].handle, fldv, num);
	break;
#endif

#ifdef VDB_MYSQL
    case MYSQL_TYPE:
	err = MysqlaccNextRec(dbhandles[handle].handle, fldv, num);
	break;
#endif

    }
    return err;
}

/*
 * move the result record pointer to the previous result
 * and get the values therein
*/
int
VdbPrevRec(VdbHandle handle, char *fldv[], int *num)
{
    int     err = -1;

    switch(dbhandles[handle].type) {
#ifdef VDB_MSQL
    case MSQL_TYPE:
	err = MsqlaccPrevRec(dbhandles[handle].handle, fldv, num);
	break;
#endif

#ifdef VDB_MYSQL
    case MYSQL_TYPE:
	err = MysqlaccPrevRec(dbhandles[handle].handle, fldv, num);
	break;
#endif

    }
    return err;
}

/*
 * format the result of a query into a list of strings
 * each field is delimited by the 'sep' character
*/
#ifdef __STDC__
StringList  
VdbResultSL(VdbHandle handle, int sep)
#else
StringList  
VdbResultSL(handle, sep)
VdbHandle handle;
int     sep;
#endif
{
    switch(dbhandles[handle].type) {
#ifdef VDB_MSQL
    case MSQL_TYPE:
	return MsqlaccResultSL(dbhandles[handle].handle, sep);
	break;
#endif

#ifdef VDB_MYSQL
    case MYSQL_TYPE:
	return MysqlaccResultSL(dbhandles[handle].handle, sep);
	break;
#endif

    }
    return NULL;
}


/*
 * format the result of a query into a list of strings
 * each field is delimited by specified seperator character
*/
#ifdef __STDC__
LLlist  *
VdbResultLL(VdbHandle handle, int sep)
#else
LLlist  *
VdbResultLL(handle, sep)
VdbHandle handle;
int     sep;
#endif
{

    switch(dbhandles[handle].type) {
#ifdef VDB_MSQL
    case MSQL_TYPE:
	return MsqlaccResultLL(dbhandles[handle].handle, sep);
	break;
#endif

#ifdef VDB_MYSQL
    case MYSQL_TYPE:
	return MysqlaccResultLL(dbhandles[handle].handle, sep);
	break;
#endif

    }

    return NULL;
}


