/******************************************************************************
	  CCCC	    A	  BBBBB	  L	EEEEE  N     N	EEEEE	TTTTTTT
	 C    C    A A	  B    B  L	E      NN    N	E	   T
	C	  A   A	  B    B  L	E      N N   N	E	   T
	C	 AAAAAAA  BBBBB	  L	EEEEE  N  N  N	EEEEE	   T
	C        A     A  B    B  L	E      N   N N	E	   T
	 C    C  A     A  B    B  L	E      N    NN  E 	   T
	  CCCC	 A     A  BBBBB	  LLLL	EEEEE  N     N	EEEEE	   T
*******************************************************************************

CableNet Source Module:
	Copyright 1994-1995 (C) CableNet Limited. All Rights Reserved.

    Module Name:		$RCSfile: DfltsIntface.c,v $
    Module Description:	Defaults library interface functions

Description:

Edit History:

	$Log: DfltsIntface.c,v $
 * Revision 1.4  1997/09/12  17:34:00  damian
 * change level of message about not being able to load a set to NOTICE
 *
 * Revision 1.3  1997/09/08  17:57:05  damian
 * print error message stating which default set couldn't be loaded
 *
 * Revision 1.2  1997/08/19  15:38:50  damian
 * include Vlib.h
 *
 * Revision 1.1  1997/08/19  15:27:32  damian
 * Initial revision
 *


*/

/* RCS identification string (for "what" program) */
static char moduleRCSid[] = "@(#) $Id: DfltsIntface.c,v 1.4 1997/09/12 17:34:00 damian Exp $";

/* must come first header files */
#include "V.h"			/* virtual header file */
#include "Vport.h"		/* port header file */


/*
 *   system header files
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <dirent.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <memory.h>
#include <time.h>
#include <syslog.h>

#include "Vlib.h"

#include "dflts.h"

/*
 *  local application/library header files
 */

#include "dfltsP.h"

LLITEMPTR user_l = NULL;
LLITEMPTR local_l = NULL;
LLITEMPTR global_l = NULL;

/*++ ***************  function DfltSetString *************** */
/*
   Purpose:        set a string in the current or specified group
   to a value

   can handle tag & value strings of up to 4095
   combined total

   Globals changed: none

   Parameters:
   char     *set    == set to use or NULL for current set
   char     *group  == group to use or NULL for current group
   char     *tag    == tag identifier
   char     *val    == string value for tag

   Return Values:  int
   0       success
   < 0     error

   Dependencies:
   StripLTBlanks(), CopyString(), DfltMakeSet(), DfltDeleteGroup()
   DfltSetCurrentGroup(), DfltSetCurrentSet(), TerminateAtNextChar()

 */
/************************************************************************ ++**/

#ifdef __STDC__
int
DfltSetString(DfltsInfo * di)
#else
int
DfltSetString(di)
DfltsInfo *di;

#endif
{
    char buf[4096];
    char namebuf[MAXPATHLEN];
    char *str;
    char *ftag, *t, *p;
    FILE *fp, *tempfp;
    int found = FALSE;
    TagDef *td;

    if (di->base == ANY_DFLT_SET)
	return -1;

/*-- if a set was specified then set the current set to this set */
    DfltSetCurrentPath(di);

  /*-- if the tag wasn't specified but the group was then delete the entire
      group */
    if (!di->tag && di->group) {	/* delete the entire group */
	DfltDeleteGroup(DfltGetCurrentPath(di));
	return 0;
    }
    sprintf(namebuf, "%s.tmp", DfltGetCurrentPath(di));

    if ((p = strrchr(namebuf, '/')) != NULL) {
	*p = '\0';
	DfltMakeSet(namebuf);	/* ensure directory exists */
	*p = '/';
    }
    if ((tempfp = fopen(namebuf, "w")) == NULL) {
	syslog(LOG_ERR, "couldn't open temporary file %s\n",
	    namebuf);
	return -1;
    }
/*-- copy all but the tag line from group file to temp file */
    if ((fp = fopen(DfltGetCurrentPath(di), "r")) != NULL) {
	if (remove(DfltGetCurrentPath(di)) != 0)
	    /* disable access by other processes */
	    syslog(LOG_ERR, "remove %s failed\n",
		DfltGetCurrentPath(di));
/*-- while there are more lines in the group file */
	while ((str = fgets(buf, 4095, fp)) != NULL) {
	    t = CopyString(str);
	    ftag = t;

/*-- determine if this is a 'tag = value' line */
	    if (buf[0] != '#' && TerminateAtNextChar(t, "=") != NULL) {
		StripLTBlanks(ftag);

/*--if the tag matches and a value was specified */
		if (strcmp(di->tag, ftag) == 0) {
		    found = TRUE;
		    if (di->val)
/*-- replace the value */
			fprintf(tempfp, "%s = %s\n", di->tag, di->val);
		} else
/*-- else copy the line to the temp file */
		    fputs(str, tempfp);
	    } else
/*-- if there was no tag then copy the line to the temp file */
		fputs(str, tempfp);
	    Free(t);
	}
    }
/*-- if the tag didn't exist in the group file then add it to the end */
    if ((fp == NULL) || (found == FALSE))
	if (di->val)
	    fprintf(tempfp, "%s = %s\n", di->tag, di->val);

/*-- close both files */
    if (fp)
	fclose(fp);

    fclose(tempfp);

/*-- and move the temp file to the group file */
    if (rename(namebuf, DfltGetCurrentPath(di)) != 0) {
	syslog(LOG_ERR, "couldn't rename tempfile %s to groupfile %s",
	    namebuf, DfltGetCurrentPath(di));
	return -1;
    }
    /* update the incore version */

    if (di->set && di->group)
	sprintf(buf, "%s/%s/%s", di->set, di->group, di->tag);
    else if (di->set)
	sprintf(buf, "%s/%s", di->set, di->tag);
    else if (di->group)
	sprintf(buf, "%s/%s", di->group, di->tag);
    else
	sprintf(buf, "%s", di->tag);

    if (user_l && (td = DfltFindTagDef(user_l, buf)) != NULL);
    else if (local_l && (td = DfltFindTagDef(local_l, buf)) != NULL);
    else if (global_l && (td = DfltFindTagDef(global_l, buf)) != NULL);
    else
	return -1;

    Free(td->val);

    td->val = CopyString(di->val);

    return 0;
}



static char *value = NULL;

/*++ **********************  function  DfltGetStringInSet ***************

   Purpose:  get a string value from a particular set

   Return Values: char *

   ******************************************************************* ++ */
#ifdef __STDC__
static char *
DfltGetStringInSet(DfltsInfo * di)
#else
static char *
DfltGetStringInSet(di)
DfltsInfo *di;

#endif
{
    char tagbuf[1024];
    LLITEMPTR   tlist= NULL;

    if (!di || !di->tag)
	return NULL;

    value = NULL;

    if (di->set && di->group)
	sprintf(tagbuf, "%s/%s/%s", di->set, di->group, di->tag);
    else if (di->set)
	sprintf(tagbuf, "%s/%s", di->set, di->tag);
    else if (di->group)
	sprintf(tagbuf, "%s/%s", di->group, di->tag);
    else
	sprintf(tagbuf, "%s", di->tag);

    switch (di->base) {
    case USER_DFLT_SET:
	if (user_l == NULL) 
	{
	    user_l = LLCreate();
	    if (DfltAddSetDefs(user_l, DfltGetBaseSet(di->base)) < 0)
		syslog(LOG_NOTICE,"couldn't load user defaults set");
	}
	tlist = user_l;
	break;
    case LOCAL_DFLT_SET:
	if (local_l == NULL) 
	{
	    local_l = LLCreate();
	    if (DfltAddSetDefs(local_l, DfltGetBaseSet(di->base)) < 0)
		syslog(LOG_NOTICE,"couldn't load local defaults set");
	}
	tlist = local_l;
	break;
    case GLOBAL_DFLT_SET:
	if (global_l == NULL) 
	{
	    global_l = LLCreate();
	    if (DfltAddSetDefs(global_l, DfltGetBaseSet(di->base)) <0)
		syslog(LOG_NOTICE,"couldn't load global defaults set");

	}
	tlist = global_l;
	break;
    default:
	return NULL;

    }

    value = DfltFindSetDef(tlist, tagbuf);

    return value;

}


/*++ ***************  function DfltGetString *************** */
/*
   Purpose:        get a string value for a tag from a set/group

   Globals changed: none

   Parameters:
   DfltInfo *info structure which contains
   char     *set    == set to use or NULL for current set
   char     *group  == group to use or NULL for current group
   char     *tag    == tag identifier
   char     *default    == string to return if tag-value not found
   int      base     == which set to use global/local/user

   Return Values:
   char     *val     ==   string value corresponding to tag        or
   char     *default ==   string user passed as a default

   Dependencies:
   StripLTBlanks(), DfltSetCurrentGroup(), Free(), DfltSetCurrentSet()

 */
/************************************************************************ ++**/
#ifdef __STDC__
char *
DfltGetString(DfltsInfo * di)
#else
char *
DfltGetString(di)
DfltsInfo di;

#endif
{
    char *val = NULL;

    /* if base is any base set then search all sets */
    if (di->base == ANY_DFLT_SET) {

	di->base = USER_DFLT_SET;
	do {
	    if ((val = DfltGetStringInSet(di)) != NULL)
		break;
	    di->base--;
	}
	while (val == NULL && di->base > ANY_DFLT_SET);

	return val;
    } else
	/* otherwise search a particular base set */
	val = DfltGetStringInSet(di);

    return val;
}


/*++ ***************  function DfltSetInt *************** */
/*
   Purpose:         set a tag value to an number

   Globals changed: none

   Parameters:
   char     *set    == set to use or NULL for current set
   char     *group  == group to use or NULL for current group
   char     *tag    == tag identifier
   int      val     == integer value for the tag

   Return Values: int
   0       success
   < 0     error

   Dependencies:
   DfltSetString()

 */
/************************************************************************ ++**/

#ifdef __STDC__
int
DfltSetInt(DfltsInfo * di)
#else
int
DfltSetInt(di)
DfltsInfo *di;

#endif
{
    char buf[32];

    sprintf(buf, "%d", di->num);

    di->val = buf;

    return DfltSetString(di);

}



/*++ ***************  function DfltGetInt *************** */
/*
   Purpose:     get an integer value for a tag from a set/group

   Globals changed: none

   Parameters:
   char     *set    == set to use or NULL for current set
   char     *group  == group to use or NULL for current group
   char     *tag    == tag identifier
   int      default == integer to return if tag-value not found

   Return Values:
   int      val    ==   integer value corresponding to tag        or
   int      default ==  integer value user passed as a default

   Dependencies:
   StripLTBlanks(), DfltSetCurrentGroup(), DfltSetCurrentSet()

 */
/************************************************************************ ++**/

#ifdef __STDC__
int
DfltGetInt(DfltsInfo * di)
#else
int
DfltGetInt(di)
DfltsInfo *di;

#endif
{
    char *val = NULL;
    int fint;

    fint = di->num;

    /* if base is any base set then search all sets */
    if (di->base == ANY_DFLT_SET) {

	di->base = USER_DFLT_SET;
	while (val == NULL && di->base > ANY_DFLT_SET) {
	    if ((val = DfltGetStringInSet(di)) != NULL)
		break;
	    di->base--;
	}


	if (val == NULL)
	    return di->num;
	else
	    return atoi(val);
    } else
	/* otherwise search a particular base set */
	val = DfltGetStringInSet(di);

    if (val != NULL)
	return atoi(val);
    else
	return di->num;

}


/*++ ***************  function DfltGetBool *************** */
/*
   Purpose:     get an boolean value for a tag from a set/group

   Globals changed: none

   Parameters:
   DfltsInfo *di;

   Return Values:
   0   == FALSE  (value not defined as TRUE or YES)
   1   == TRUE  (value defined as TRUE or YES)

   Dependencies:
   StripLTBlanks(), DfltSetCurrentGroup(), DfltSetCurrentSet()

 */
/************************************************************************ ++**/

#ifdef __STDC__
int
DfltGetBool(DfltsInfo * di)
#else
int
DfltGetBool(di)
DfltsInfo *di;

#endif
{
    char *val;

/*-- if set &/or group specified then set them up */
    if (di->set)
	DfltSetCurrentSet(di);

    if (di->group)
	DfltSetCurrentGroup(di);

    /* if base is any base set then search all sets */
    if (di->base == ANY_DFLT_SET) {

	di->base = USER_DFLT_SET;
	do {
	    if ((val = DfltGetStringInSet(di)) != NULL)
		break;
	    di->base--;
	}
	while (val == NULL && di->base > ANY_DFLT_SET);

	if (val == NULL)
	    return FALSE;
	else {
	    if (strncasecmp(val, "TRUE", 4) == 0 ||
		strncasecmp(val, "YES", 3) == 0 ||
		strncasecmp(val, "1", 1) == 0)
		return TRUE;
	    else
		return FALSE;
	}
    } else
	/* otherwise search a particular base set */
	val = DfltGetStringInSet(di);


    if (val == NULL)
	return FALSE;
    else {
	if (strncasecmp(val, "TRUE", 4) == 0 ||
	    strncasecmp(val, "YES", 3) == 0 ||
	    strncasecmp(val, "1", 1) == 0)
	    return TRUE;
    }

    return FALSE;

}


/*++ ***************  function DfltGetSet *************** */
/*
   Purpose:        get a comma seperated list of all entries in a set

   Globals changed: none

   Parameters:
   char        *set        == set to list

   Return Values:
   char     *list   == allocated buffer of list of set entries

   Dependencies:
   Malloc(), DfltSetCurrentSet()

 */
/************************************************************************ ++**/

#ifdef __STDC__
char *
DfltGetSet(DfltsInfo * di)
#else
char *
DfltGetSet(di)
DfltsInfo *di;

#endif
{
    char *t, buf[MAXPATHLEN];
    DIR *dir;
    struct dirent *dent;
    int tsize = 0;

    DfltSetCurrentPath(di);

/*-- allocate some space for the list */
    t = (char *) Malloc(1024);
    tsize = 1024;
    memset(t, 0, 1024);

    sprintf(buf, "%s/%s", DfltGetBaseSet(di->base),
	DfltGetCurrentSet(di->base));

/*-- open the set */
    if ((dir = opendir(buf)) == NULL) {
	return NULL;
    } else {
/*-- read successive entries in the set */
	while ((dent = readdir(dir)) != NULL) {
	    int newsize = 0;

/*-- if this entry is not "." or ".." directories */
	    if (strcmp(dent->d_name, ".") == 0)
		continue;
	    if (strcmp(dent->d_name, "..") == 0)
		continue;

/*-- calculate the new list length */
	    if (*t)
		newsize = strlen(t) + strlen(dent->d_name) + 2;
	    else
		newsize = strlen(dent->d_name) + 2;

	  /*-- and if it's longer than current space length
	      realloc the space to add another 1024 bytes */
	    if (newsize > tsize) {
		t = (char *) Realloc(t, (uint) tsize + 1024);
		tsize += 1024;
	    }
/*-- add the name to the list */
	    if (*t) {
		strcat(t, ",");
		strcat(t, dent->d_name);
	    } else
		strcpy(t, dent->d_name);
	}
    }
/*-- return the list */
    return t;
}


/*++ ***************  function  DfltGetGroup *************** */
/*
   Purpose:     determine a list of tags in a group

   Globals changed: none

   Parameters:
   char        *set        == set name for group
   char        *group      == group name to list

   Return Values:
   char        *list       == allocated buffer of list of group entries

   Dependencies:

 */
/************************************************************************ ++**/

#ifdef __STDC__
char *
DfltGetGroup(DfltsInfo * di)
#else
char *
DfltGetGroup(di)
DfltsInfo *di;

#endif
{
    char buf[4096];
    char *str, *t;
    char *ftag, *fval;
    FILE *fp;
    int tsize;

    DfltSetCurrentPath(di);

/*-- open the current/new path group file */
    if ((fp = fopen(DfltGetCurrentPath(di), "r")) == NULL) {
	syslog(LOG_ERR, "invalid group %s\n",
	    DfltGetCurrentPath(di));
	return NULL;
    }
/*-- allocate some space */
    t = (char *) Malloc(1024);
    tsize = 1024;
    memset(t, 0, 1024);

/*-- read successive lines from the group file */
    while ((str = fgets(buf, 4095, fp)) != NULL) {
	int newsize = 0;

/*-- seperate into tag and value fields */
	if (SeperateTagAndValue(str, &ftag, &fval) < 0)
	    continue;

/*-- remove leading & trailing blanks from tag */
	StripLTBlanks(ftag);

/*-- and add it to the list */
	if (ftag) {
	    if (*t)
		newsize = strlen(t) + strlen(ftag) + 2;
	    else
		newsize = strlen(ftag) + 2;

	  /*-- reallocate the list buffer space if addition goes past the end
	      of the buffer space */
	    if (newsize > tsize) {
		t = (char *) Realloc(t, (uint) tsize + 1024);
		tsize += 1024;
	    }
	    if (*t) {
		strcat(t, ",");
		strcat(t, ftag);
	    } else
		strcpy(t, ftag);
	}
    }
/*-- return tag list */
    return t;
}
