/*
 Copyright (C) 2002-2004 MySQL AB

 This program is free software; you can redistribute it and/or modify
 it under the terms of version 2 of the GNU General Public License as
 published by the Free Software Foundation.
 

 There are special exceptions to the terms and conditions of the GPL 
 as it is applied to this software. View the full text of the 
 exception exception in file EXCEPTIONS-CONNECTOR-J in the directory of this 
 software distribution.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */
package com.mysql.jdbc;

import java.sql.SQLException;


/**
 * Thrown when a result sate is not updatable
 *
 * @author Mark Matthews
 */
public class NotUpdatable extends SQLException {
    /**
     * The message to use when result set is not updatable.
     *
     * The same message is used in the warnings generated by
     * Updatabale result set.
     */
    public static final String NOT_UPDATEABLE_MESSAGE =
        "Result Set not updatable."
        + "This result set must come from a statement "
        + "that was created with a result set type of ResultSet.CONCUR_UPDATABLE, "
        + "the query must select only one table, and must "
        + "select all primary keys from that table. See the JDBC 2.1 API Specification, "
        + "section 5.6 for more details.";

    /**
     * Creates a new NotUpdatable exception.
     */
    public NotUpdatable() {
        super(NOT_UPDATEABLE_MESSAGE, SQLError.SQL_STATE_GENERAL_ERROR);
    }
}
