/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar.tokenattrs;

import org.eclipse.jdt.annotation.Nullable;

public final class EncodedTokenAttributes {
    public static String toBinaryStr(int encodedTokenAttributes) {
        return new StringBuilder(Integer.toBinaryString(encodedTokenAttributes)).insert(0, "0".repeat(Integer.numberOfLeadingZeros(encodedTokenAttributes))).toString();
    }

    public static String toString(int encodedTokenAttributes) {
        int languageId = EncodedTokenAttributes.getLanguageId(encodedTokenAttributes);
        int tokenType = EncodedTokenAttributes.getTokenType(encodedTokenAttributes);
        int fontStyle = EncodedTokenAttributes.getFontStyle(encodedTokenAttributes);
        int foreground = EncodedTokenAttributes.getForeground(encodedTokenAttributes);
        int background = EncodedTokenAttributes.getBackground(encodedTokenAttributes);
        boolean containsBalancedBrackets = EncodedTokenAttributes.containsBalancedBrackets(encodedTokenAttributes);
        return "{\n  languageId: " + languageId + ",\n  tokenType: " + tokenType + ",\n  fontStyle: " + fontStyle + ",\n  foreground: " + foreground + ",\n  background: " + background + "\n,  containsBalancedBrackets: " + containsBalancedBrackets + "\n}";
    }

    public static int getLanguageId(int metadata) {
        return (metadata & 0xFF) >>> 0;
    }

    public static int getTokenType(int metadata) {
        return (metadata & 0x300) >>> 8;
    }

    public static boolean containsBalancedBrackets(int metadata) {
        return (metadata & 0x400) != 0;
    }

    public static int getFontStyle(int metadata) {
        return (metadata & 0x7800) >>> 11;
    }

    public static int getForeground(int metadata) {
        return (metadata & 0xFF8000) >>> 15;
    }

    public static int getBackground(int metadata) {
        return (metadata & 0xFF000000) >>> 24;
    }

    public static int set(int metadata, int languageId, int tokenType, @Nullable Boolean containsBalancedBrackets, int fontStyle, int foreground, int background) {
        int _tokenType;
        int _languageId = languageId == 0 ? EncodedTokenAttributes.getLanguageId(metadata) : languageId;
        int n = _tokenType = tokenType == 8 ? EncodedTokenAttributes.getTokenType(metadata) : tokenType;
        int _containsBalancedBracketsBit = (containsBalancedBrackets == null ? EncodedTokenAttributes.containsBalancedBrackets(metadata) : containsBalancedBrackets != false) ? 1 : 0;
        int _fontStyle = fontStyle == -1 ? EncodedTokenAttributes.getFontStyle(metadata) : fontStyle;
        int _foreground = foreground == 0 ? EncodedTokenAttributes.getForeground(metadata) : foreground;
        int _background = background == 0 ? EncodedTokenAttributes.getBackground(metadata) : background;
        return (_languageId << 0 | _tokenType << 8 | _containsBalancedBracketsBit << 10 | _fontStyle << 11 | _foreground << 15 | _background << 24) >>> 0;
    }

    private EncodedTokenAttributes() {
    }
}

