/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.lsp4e.internal.NullSafetyHelper;
import org.eclipse.lsp4e.server.StreamConnectionProvider;

public abstract class ProcessStreamConnectionProvider
implements StreamConnectionProvider,
IAdaptable {
    private @Nullable Process process;
    private @Nullable List<String> commands;
    private @Nullable String workingDir;

    protected ProcessStreamConnectionProvider() {
    }

    protected ProcessStreamConnectionProvider(List<String> commands) {
        this.commands = commands;
    }

    protected ProcessStreamConnectionProvider(List<String> commands, String workingDir) {
        this.commands = commands;
        this.workingDir = workingDir;
    }

    @Override
    public void start() throws IOException {
        Process p;
        List<String> commands = this.commands;
        if (commands == null || commands.isEmpty() || commands.stream().anyMatch(Objects::isNull)) {
            throw new IOException("Unable to start language server: " + String.valueOf(this));
        }
        ProcessBuilder builder = this.createProcessBuilder();
        this.process = p = builder.start();
        if (!p.isAlive()) {
            throw new IOException("Unable to start language server: " + String.valueOf(this));
        }
    }

    protected ProcessBuilder createProcessBuilder() {
        ProcessBuilder builder = new ProcessBuilder(NullSafetyHelper.castNonNull(this.getCommands()));
        String workDir = this.getWorkingDirectory();
        if (workDir != null) {
            builder.directory(new File(workDir));
        }
        builder.redirectError(ProcessBuilder.Redirect.INHERIT);
        return builder;
    }

    @Override
    public @Nullable InputStream getInputStream() {
        Process p = this.process;
        return p == null ? null : p.getInputStream();
    }

    @Override
    public @Nullable InputStream getErrorStream() {
        Process p = this.process;
        return p == null ? null : p.getErrorStream();
    }

    @Override
    public @Nullable OutputStream getOutputStream() {
        Process p = this.process;
        return p == null ? null : p.getOutputStream();
    }

    @Override
    public void stop() {
        Process p = this.process;
        if (p != null) {
            p.destroy();
        }
    }

    public <T> @Nullable T getAdapter(@Nullable Class<T> adapter) {
        Process process = this.process;
        if (adapter == ProcessHandle.class) {
            try {
                return (T)(process == null ? null : process.toHandle());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return null;
    }

    protected @Nullable Process getProcess() {
        return this.process;
    }

    protected @Nullable List<String> getCommands() {
        return this.commands;
    }

    public void setCommands(List<String> commands) {
        this.commands = commands;
    }

    protected @Nullable String getWorkingDirectory() {
        return this.workingDir;
    }

    public void setWorkingDirectory(String workingDir) {
        this.workingDir = workingDir;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof ProcessStreamConnectionProvider) {
            ProcessStreamConnectionProvider other = (ProcessStreamConnectionProvider)obj;
            if (Objects.equals(this.getCommands(), other.getCommands()) && Objects.equals(this.getWorkingDirectory(), other.getWorkingDirectory())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getCommands(), this.getWorkingDirectory());
    }

    public String toString() {
        return "ProcessStreamConnectionProvider [commands=" + String.valueOf(this.getCommands()) + ", workingDir=" + this.getWorkingDirectory() + "]";
    }
}

