/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.debugmodel;

import java.util.ArrayList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.lsp4e.debug.debugmodel.DSPDebugElement;
import org.eclipse.lsp4e.debug.debugmodel.DSPDebugTarget;
import org.eclipse.lsp4e.debug.debugmodel.DSPVariable;
import org.eclipse.lsp4j.debug.Variable;
import org.eclipse.lsp4j.debug.VariablesArguments;
import org.eclipse.lsp4j.debug.VariablesResponse;

public final class DSPValue
extends DSPDebugElement
implements IValue {
    private static final IVariable[] NO_VARIABLES = new IVariable[0];
    private final @Nullable DSPVariable modelVariable;
    private final Integer variablesReference;
    private final String value;
    private IVariable @Nullable [] cachedVariables;

    public DSPValue(DSPVariable variable, Integer variablesReference, String value) {
        super(variable.getDebugTarget());
        this.modelVariable = variable;
        this.variablesReference = variablesReference;
        this.value = value;
    }

    public DSPValue(DSPDebugTarget debugger, Integer variablesReference, String value) {
        super(debugger);
        this.modelVariable = null;
        this.variablesReference = variablesReference;
        this.value = value;
    }

    public IVariable @Nullable [] getVariables() throws DebugException {
        if (!this.hasVariables()) {
            return NO_VARIABLES;
        }
        if (this.cachedVariables == null) {
            VariablesArguments arguments = new VariablesArguments();
            arguments.setVariablesReference(this.variablesReference.intValue());
            Variable[] targetVariables = ((VariablesResponse)DSPValue.complete(this.getDebugTarget().getDebugProtocolServer().variables(arguments))).getVariables();
            ArrayList<DSPVariable> variables = new ArrayList<DSPVariable>();
            Variable[] variableArray = targetVariables;
            int n = targetVariables.length;
            int n2 = 0;
            while (n2 < n) {
                Variable variable = variableArray[n2];
                variables.add(new DSPVariable(this.getDebugTarget(), this.variablesReference, variable.getName(), variable.getValue(), variable.getVariablesReference()));
                ++n2;
            }
            this.cachedVariables = (IVariable[])variables.toArray(DSPVariable[]::new);
        }
        return this.cachedVariables;
    }

    public @Nullable String getReferenceTypeName() throws DebugException {
        if (this.modelVariable != null) {
            return this.modelVariable.getName();
        }
        return null;
    }

    public String getValueString() throws DebugException {
        return this.value;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public boolean hasVariables() throws DebugException {
        return this.variablesReference != null && this.variablesReference > 0;
    }
}

