/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.DeleteServerDialogExtension;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;

public class DeleteServerDialog
extends MessageDialog {
    protected IServer[] servers;
    protected IFolder[] configs;
    protected List<IServer> runningServersList;
    protected boolean runningServerCanStop;
    protected Button checkDeleteConfigs;
    protected Button checkDeleteRunning;
    protected Button checkDeleteRunningStop;
    List<DeleteServerDialogExtension> dialogExtensionLst = new ArrayList<DeleteServerDialogExtension>();

    public DeleteServerDialog(Shell parentShell, IServer[] servers, IFolder[] configs) {
        super(parentShell, Messages.deleteServerDialogTitle, null, null, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        if (servers == null || configs == null) {
            throw new IllegalArgumentException();
        }
        this.servers = servers;
        this.configs = configs;
        this.runningServersList = new ArrayList<IServer>();
        int i = 0;
        while (i < servers.length) {
            if (servers[i].getServerState() != 4) {
                this.runningServersList.add(servers[i]);
            }
            if (servers[i].canStop().isOK()) {
                this.runningServerCanStop = true;
            }
            ++i;
        }
        this.message = servers.length == 1 ? NLS.bind((String)Messages.deleteServerDialogMessage, (Object)servers[0].getName()) : NLS.bind((String)Messages.deleteServerDialogMessageMany, (Object)String.valueOf(servers.length));
    }

    protected Control createCustomArea(Composite parent) {
        int size;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.wst.server.ui.svcp0002");
        if (this.configs.length > 0) {
            this.checkDeleteConfigs = new Button(composite, 32);
            this.checkDeleteConfigs.setText(NLS.bind((String)Messages.deleteServerDialogLooseConfigurations, (Object)this.configs[0].getName()));
            this.checkDeleteConfigs.setSelection(true);
        }
        if ((size = this.runningServersList.size()) > 0) {
            if (this.servers.length > 1) {
                this.checkDeleteRunning = new Button(composite, 32);
                this.checkDeleteRunning.setText(Messages.deleteServerDialogRunningServer);
                this.checkDeleteRunning.setSelection(true);
            }
            if (this.runningServerCanStop) {
                this.checkDeleteRunningStop = new Button(composite, 32);
                this.checkDeleteRunningStop.setText(Messages.deleteServerDialogRunningServerStop);
                this.checkDeleteRunningStop.setSelection(true);
                GridData data = new GridData();
                if (this.checkDeleteRunning != null) {
                    data.horizontalIndent = 15;
                    this.checkDeleteRunning.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            DeleteServerDialog.this.checkDeleteRunningStop.setEnabled(DeleteServerDialog.this.checkDeleteRunning.getSelection());
                        }
                    });
                }
                this.checkDeleteRunningStop.setLayoutData((Object)data);
            }
        }
        List<DeleteServerDialogExtension> fullDialogExtensionLst = ServerUIPlugin.getDeleteServerDialogExtensions();
        for (DeleteServerDialogExtension curDialogExtension : fullDialogExtensionLst) {
            curDialogExtension.setServers(this.servers);
            if (!curDialogExtension.isEnabled()) continue;
            this.dialogExtensionLst.add(curDialogExtension);
            curDialogExtension.createControl(composite);
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            final boolean checked = this.checkDeleteConfigs != null && this.checkDeleteConfigs.getSelection();
            final boolean deleteRunning = this.checkDeleteRunning == null || this.checkDeleteRunning.getSelection();
            final boolean deleteRunningStop = this.checkDeleteRunningStop != null && this.checkDeleteRunningStop.getSelection();
            Thread t = new Thread("Delete servers"){

                @Override
                public void run() {
                    if (DeleteServerDialog.this.runningServersList.size() > 0) {
                        DeleteServerDialog.this.prepareForDeletion(deleteRunning, deleteRunningStop);
                    }
                    Job job = new Job(Messages.deleteServerTask){

                        protected IStatus run(IProgressMonitor monitor) {
                            if ((this).DeleteServerDialog.this.servers.length == 0) {
                                return Status.OK_STATUS;
                            }
                            try {
                                if (monitor.isCanceled()) {
                                    return Status.CANCEL_STATUS;
                                }
                                for (DeleteServerDialogExtension curDialogExtension : (this).DeleteServerDialog.this.dialogExtensionLst) {
                                    curDialogExtension.performPreDeleteAction(monitor);
                                }
                                int size = (this).DeleteServerDialog.this.servers.length;
                                int i = 0;
                                while (i < size) {
                                    (this).DeleteServerDialog.this.servers[i].delete();
                                    ++i;
                                }
                                if (monitor.isCanceled()) {
                                    return Status.CANCEL_STATUS;
                                }
                                if (checked) {
                                    size = (this).DeleteServerDialog.this.configs.length;
                                    i = 0;
                                    while (i < size) {
                                        (this).DeleteServerDialog.this.configs[i].refreshLocal(2, monitor);
                                        (this).DeleteServerDialog.this.configs[i].delete(true, true, monitor);
                                        ++i;
                                    }
                                }
                                for (DeleteServerDialogExtension curDialogExtension : (this).DeleteServerDialog.this.dialogExtensionLst) {
                                    curDialogExtension.performPostDeleteAction(monitor);
                                }
                            }
                            catch (Exception e) {
                                if (Trace.SEVERE) {
                                    Trace.trace("/severe", "Error while deleting resources", e);
                                }
                                return new Status(4, "org.eclipse.wst.server.ui", 0, e.getMessage(), (Throwable)e);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    int size = DeleteServerDialog.this.servers.length;
                    ISchedulingRule[] rules = new ISchedulingRule[size + 1];
                    int i = 0;
                    while (i < size) {
                        rules[i] = DeleteServerDialog.this.servers[i];
                        ++i;
                    }
                    IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
                    rules[size] = ruleFactory.createRule((IResource)ResourcesPlugin.getWorkspace().getRoot());
                    job.setRule(MultiRule.combine((ISchedulingRule[])rules));
                    job.setPriority(40);
                    job.schedule();
                }
            };
            t.setDaemon(true);
            t.start();
        }
        super.buttonPressed(buttonId);
    }

    /*
     * Unable to fully structure code
     */
    protected void prepareForDeletion(boolean deleteRunning, boolean stopRunning) {
        serversList = new LinkedList<IServer>(Arrays.asList(this.servers));
        configsList = new LinkedList<IFolder>(Arrays.asList(this.configs));
        if (!deleteRunning) {
            size = this.runningServersList.size();
            i = 0;
            while (i < size) {
                server = this.runningServersList.get(i);
                serversList.remove(server);
                if (server.getServerConfiguration() != null) {
                    configsList.remove(server.getServerConfiguration());
                }
                ++i;
            }
        } else if (stopRunning) {
            listener = new MultiServerStopListener();
            expected = 0;
            for (IServer s : this.runningServersList) {
                if (s.canStop().isOK()) {
                    ++expected;
                    s.stop(false, (IServer.IOperationListener)listener);
                    continue;
                }
                serversList.remove(s);
                configsList.remove(s.getServerConfiguration());
            }
            try {
                while (expected != listener.getNumberStopped()) {
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException v0) {
                if (!Trace.WARNING) ** GOTO lbl37
                Trace.trace("/warning", "Interrupted while waiting for servers stop");
            }
        }
lbl37:
        // 6 sources

        this.servers = new IServer[serversList.size()];
        serversList.toArray(this.servers);
        this.configs = new IFolder[configsList.size()];
        configsList.toArray(this.configs);
    }

    class MultiServerStopListener
    implements IServer.IOperationListener {
        protected int num;

        MultiServerStopListener() {
        }

        public void done(IStatus result) {
            ++this.num;
        }

        public int getNumberStopped() {
            return this.num;
        }
    }
}

