/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.dstore.core.java.IRemoteClassInstance;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.Handler;

public abstract class UpdateHandler
extends Handler {
    protected ArrayList _dataObjects;
    protected ArrayList _classesToSend;

    public UpdateHandler() {
        this.setName("DStore UpdateHandler" + this.getName());
        this._dataObjects = new ArrayList();
        this._classesToSend = new ArrayList();
    }

    public void handle() {
        if (!this._dataObjects.isEmpty() || !this._classesToSend.isEmpty()) {
            this.sendUpdates();
        }
    }

    protected void clean(DataElement object) {
        this.clean(object, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unmap(DataElement element) {
        if (element.isDeleted() || element.isSpirit()) {
            HashMap map;
            HashMap hashMap = map = this._dataStore.getHashMap();
            synchronized (hashMap) {
                String id = element.getId();
                map.remove(id);
                this._dataStore.addToRecycled(element);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clean(DataElement object, int depth) {
        DataElement tmpRoot;
        boolean isServer;
        boolean bl = isServer = !this._dataStore.isVirtual();
        if (depth > 0 && object != null) {
            if (object.isSpirit() || object.isDeleted()) {
                DataElement parent = object.getParent();
                this.cleanChildren(object);
                this.unmap(object);
                if (object.isSpirit() && isServer) {
                    object.delete();
                }
                if (isServer) {
                    object.clear();
                }
                if (parent != null) {
                    DataElement dataElement = parent;
                    synchronized (dataElement) {
                        parent.removeNestedData(object);
                    }
                }
            } else if (object.getNestedSize() > 0) {
                this.cleanChildren(object);
            }
        }
        if ((tmpRoot = this._dataStore.getTempRoot()) != null) {
            tmpRoot.removeNestedData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanChildren(DataElement parent) {
        boolean isServer = !this._dataStore.isVirtual();
        List nestedData = parent.getNestedData();
        if (nestedData != null) {
            List list = nestedData;
            synchronized (list) {
                int i = nestedData.size() - 1;
                while (i >= 0) {
                    DataElement child = (DataElement)nestedData.get(i);
                    if (child.isSpirit() || child.isDeleted()) {
                        this.cleanChildren(child);
                        this.unmap(child);
                        if (isServer) {
                            child.delete();
                            child.clear();
                        }
                        nestedData.remove(child);
                    }
                    --i;
                }
            }
        }
    }

    public void update(ArrayList objects) {
        int i = 0;
        while (i < objects.size()) {
            this.update((DataElement)objects.get(i));
            ++i;
        }
    }

    public void update(DataElement object) {
        this.update(object, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(DataElement object, boolean immediate) {
        if (object != null) {
            String type = object.getType();
            boolean statusDone = false;
            boolean isStatus = "status".equals(type);
            if (isStatus) {
                statusDone = "done".equals(object.getName()) || "done".equals(object.getValue());
            }
            ArrayList arrayList = this._dataObjects;
            synchronized (arrayList) {
                if (immediate) {
                    this._dataObjects.add(0, object);
                } else if (!this._dataObjects.contains(object)) {
                    this._dataObjects.add(object);
                } else if (this._dataStore != null && object != null && !object.isDeleted() && isStatus && statusDone) {
                    this._dataObjects.remove(object);
                    this._dataObjects.add(object);
                }
            }
            if (this._dataStore != null && !this._dataStore.isVirtual() && isStatus && statusDone) {
                this._dataStore.disconnectObject(object.getParent());
            }
        }
        this.notifyInput();
    }

    public synchronized void waitForInput() {
        if (this._dataObjects.size() == 0 && this._classesToSend.size() == 0) {
            super.waitForInput();
        }
    }

    public abstract void sendUpdates();

    public abstract void updateFile(String var1, byte[] var2, int var3, boolean var4);

    public abstract void updateAppendFile(String var1, byte[] var2, int var3, boolean var4);

    public abstract void updateFile(String var1, byte[] var2, int var3, boolean var4, String var5);

    public abstract void updateAppendFile(String var1, byte[] var2, int var3, boolean var4, String var5);

    public abstract void requestClass(String var1);

    public abstract void sendKeepAliveRequest();

    public abstract void updateClassInstance(IRemoteClassInstance var1, String var2);

    public abstract void sendClass(String var1);

    public abstract void sendClass(String var1, String var2);

    public abstract void sendKeepAliveConfirmation();
}

