/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import java.util.Collections;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.NavigatorSaveablesService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.services.IEvaluationService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;

public class NavigatorPlugin
extends AbstractUIPlugin {
    private static NavigatorPlugin plugin;
    private static final int LOG_DELAY = 100;
    public static final int ACTION_BAR_DELAY = 100;
    public static final int LINK_HELPER_DELAY = 120;
    private static final LogJob logJob;
    public static String PLUGIN_ID;
    private BundleListener bundleListener = NavigatorSaveablesService::bundleChanged;
    public static final String RESOURCE_REGEXP_FILTER_DATA = "resourceRegexpFilters";
    public static final String RESOURCE_REGEXP_FILTER_FILTER_ID = "org.eclipse.ui.navigator.resources.filters.userDefined";

    static {
        logJob = new LogJob();
        PLUGIN_ID = "org.eclipse.ui.navigator";
    }

    public NavigatorPlugin() {
        plugin = this;
    }

    public static NavigatorPlugin getDefault() {
        return plugin;
    }

    public Image getImage(String path) {
        ImageRegistry registry = this.getImageRegistry();
        Image image = registry.get(path);
        if (image == null) {
            ResourceLocator.imageDescriptorFromBundle((String)PLUGIN_ID, (String)path).ifPresent(d -> registry.put(path, d.createImage()));
            image = registry.get(path);
        }
        return image;
    }

    public static void logError(int aCode, String aMessage, Throwable anException) {
        NavigatorPlugin.getDefault().getLog().log(NavigatorPlugin.createErrorStatus(aCode, aMessage, anException));
    }

    public static void log(int severity, int aCode, String aMessage, Throwable exception) {
        NavigatorPlugin.log(NavigatorPlugin.createStatus(severity, aCode, aMessage, exception));
    }

    public static void log(IStatus aStatus) {
        logJob.log(aStatus);
        logJob.schedule(100L);
    }

    public static IEvaluationContext getApplicationContext() {
        IEvaluationService es = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
        return es == null ? null : es.getCurrentState();
    }

    public static IEvaluationContext getEmptyEvalContext() {
        EvaluationContext c = new EvaluationContext(NavigatorPlugin.getApplicationContext(), (Object)Collections.EMPTY_LIST);
        c.setAllowPluginActivation(true);
        return c;
    }

    public static IEvaluationContext getEvalContext(Object selection) {
        EvaluationContext c = new EvaluationContext(NavigatorPlugin.getApplicationContext(), selection);
        c.setAllowPluginActivation(true);
        return c;
    }

    public static EvaluationResult safeEvaluate(Expression expression, IEvaluationContext scope) {
        Evaluator evaluator = new Evaluator();
        evaluator.expression = expression;
        evaluator.scope = scope;
        SafeRunner.run((ISafeRunnable)evaluator);
        return evaluator.result;
    }

    public static IStatus createStatus(int severity, int aCode, String aMessage, Throwable exception) {
        return new Status(severity, PLUGIN_ID, aCode, aMessage != null ? aMessage : "No message.", exception);
    }

    public static IStatus createErrorStatus(int aCode, String aMessage, Throwable exception) {
        return NavigatorPlugin.createStatus(4, aCode, aMessage, exception);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        context.addBundleListener(this.bundleListener);
    }

    public void stop(BundleContext context) throws Exception {
        context.removeBundleListener(this.bundleListener);
        super.stop(context);
    }

    public static class Evaluator
    implements ISafeRunnable {
        EvaluationResult result;
        Expression expression;
        IEvaluationContext scope;

        public void handleException(Throwable exception) {
            this.result = EvaluationResult.FALSE;
        }

        public void run() throws Exception {
            this.result = this.expression.evaluate(this.scope);
        }
    }

    private static class LogJob
    extends Job {
        private ListenerList messages = new ListenerList(){

            public synchronized Object[] getListeners() {
                Object[] mesgs = super.getListeners();
                this.clear();
                return mesgs;
            }
        };

        public LogJob() {
            super(CommonNavigatorMessages.LoggingJob);
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            Object[] mesgs = this.messages.getListeners();
            ILog pluginLog = NavigatorPlugin.getDefault().getLog();
            Object[] objectArray = mesgs;
            int n = mesgs.length;
            int n2 = 0;
            while (n2 < n) {
                Object mesg = objectArray[n2];
                pluginLog.log((IStatus)mesg);
                ++n2;
            }
            return Status.OK_STATUS;
        }

        public void log(IStatus mesg) {
            this.messages.add((Object)mesg);
        }
    }
}

