/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.resource;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.internal.core.refactoring.BasicElementLabels;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.resource.MoveRenameResourceProcessor;

public final class MoveRenameResourceDescriptor
extends RefactoringDescriptor {
    public static final String ID = "org.eclipse.ltk.core.refactoring.moverename.resource";
    private String fNewName = null;
    private IPath fDestinationPath = null;
    private IPath fResourcePath = null;
    private boolean fUpdateReferences;

    public MoveRenameResourceDescriptor() {
        super(ID, null, RefactoringCoreMessages.RenameResourceDescriptor_unnamed_descriptor, null, 6);
    }

    public void setNewName(String name) {
        Assert.isNotNull((Object)name);
        Assert.isLegal((!"".equals(name) ? 1 : 0) != 0, (String)"Name must not be empty");
        this.fNewName = name;
    }

    public String getNewName() {
        return this.fNewName;
    }

    public void setDestination(IContainer container) {
        Assert.isNotNull((Object)container);
        this.fDestinationPath = container.getFullPath();
    }

    public void setDestinationPath(IPath path) {
        Assert.isNotNull((Object)path);
        this.fDestinationPath = path;
    }

    public IPath getDestinationPath() {
        return this.fDestinationPath;
    }

    @Override
    public void setProject(String project) {
        super.setProject(project);
    }

    public void setResourcePath(IPath resourcePath) {
        Assert.isNotNull((Object)resourcePath);
        this.fResourcePath = resourcePath;
    }

    public IPath getResourcePath() {
        return this.fResourcePath;
    }

    public void setUpdateReferences(boolean updateReferences) {
        this.fUpdateReferences = updateReferences;
    }

    public boolean isUpdateReferences() {
        return this.fUpdateReferences;
    }

    @Override
    public Refactoring createRefactoring(RefactoringStatus status) throws CoreException {
        IPath resourcePath = this.getResourcePath();
        if (resourcePath == null) {
            status.addFatalError(RefactoringCoreMessages.MoveRenameResourceDescriptor_error_path_not_set);
            return null;
        }
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(resourcePath);
        if (resource == null || !resource.exists()) {
            status.addFatalError(Messages.format(RefactoringCoreMessages.MoveRenameResourceDescriptor_error_resource_not_existing, BasicElementLabels.getPathLabel(resourcePath, false)));
            return null;
        }
        IPath destinationPath = this.getDestinationPath();
        if (destinationPath == null) {
            status.addFatalError(RefactoringCoreMessages.MoveResourcesDescriptor_error_destination_not_set);
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource destination = root.findMember(destinationPath);
        if (!(destination instanceof IFolder) && !(destination instanceof IProject) || !destination.exists()) {
            status.addFatalError(Messages.format(RefactoringCoreMessages.MoveResourcesDescriptor_error_destination_not_exists, BasicElementLabels.getPathLabel(destinationPath, false)));
            return null;
        }
        String newName = this.getNewName();
        if (newName == null || newName.length() == 0) {
            status.addFatalError(RefactoringCoreMessages.MoveRenameResourceDescriptor_error_name_not_defined);
            return null;
        }
        MoveRenameResourceProcessor processor = new MoveRenameResourceProcessor(resource);
        processor.setNewResourceName(newName);
        processor.setDestination((IContainer)destination);
        processor.setUpdateReferences(this.isUpdateReferences());
        return new RenameRefactoring(processor);
    }
}

