/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.signing;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.signing.ExternalGpgSigner;
import org.eclipse.jgit.gpg.bc.BouncyCastleGpgSignerFactory;
import org.eclipse.jgit.lib.GpgSigner;

public final class GpgSetup {
    private static final Object LOCK = new Object();
    private static Signer current;

    private GpgSetup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GpgSigner getDefault() {
        Signer signer = GpgSetup.getSigner();
        Object object = LOCK;
        synchronized (object) {
            if (signer != current) {
                current = signer;
                switch (signer) {
                    case BC: {
                        GpgSigner.setDefault((GpgSigner)BouncyCastleGpgSignerFactory.create());
                        break;
                    }
                    case GPG: {
                        GpgSigner.setDefault((GpgSigner)new ExternalGpgSigner());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown signer " + (Object)((Object)signer));
                    }
                }
            }
            return GpgSigner.getDefault();
        }
    }

    private static Signer getSigner() {
        String pref = Platform.getPreferencesService().getString("org.eclipse.egit.core", "core_gpg_signer", null, null);
        if (pref != null) {
            Signer[] signerArray = Signer.values();
            int n = signerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Signer s = signerArray[n2];
                if (pref.equalsIgnoreCase(s.name())) {
                    return s;
                }
                ++n2;
            }
        }
        Activator.logWarning(MessageFormat.format(CoreText.GpgSetup_signerUnknown, pref), null);
        return Signer.BC;
    }

    private static enum Signer {
        BC,
        GPG;

    }
}

