/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.set.SimpleSetProperty;
import org.eclipse.core.internal.databinding.beans.BeanPropertyHelper;

public class PojoSetProperty<S, E>
extends SimpleSetProperty<S, E> {
    private final PropertyDescriptor propertyDescriptor;
    private final Class<E> elementType;

    public PojoSetProperty(PropertyDescriptor propertyDescriptor, Class<E> elementType) {
        this.propertyDescriptor = propertyDescriptor;
        this.elementType = elementType == null ? BeanPropertyHelper.getCollectionPropertyElementType(propertyDescriptor) : elementType;
    }

    public Object getElementType() {
        return this.elementType;
    }

    protected Set<E> doGetSet(S source) {
        return this.asSet(BeanPropertyHelper.readProperty(source, this.propertyDescriptor));
    }

    private Set<E> asSet(Object propertyValue) {
        if (propertyValue == null) {
            return Collections.emptySet();
        }
        if (this.propertyDescriptor.getPropertyType().isArray()) {
            return new HashSet<Object>(Arrays.asList((Object[])propertyValue));
        }
        return (Set)propertyValue;
    }

    protected void doSetSet(S source, Set<E> set, SetDiff<E> diff) {
        this.doSetSet(source, set);
    }

    protected void doSetSet(S source, Set<E> set) {
        BeanPropertyHelper.writeProperty(source, this.propertyDescriptor, this.convertSetToBeanPropertyType(set));
    }

    private Object convertSetToBeanPropertyType(Set<E> set) {
        Object[] propertyValue = set;
        if (this.propertyDescriptor.getPropertyType().isArray()) {
            Class<?> componentType = this.propertyDescriptor.getPropertyType().getComponentType();
            Object[] array = (Object[])Array.newInstance(componentType, set.size());
            propertyValue = set.toArray(array);
        }
        return propertyValue;
    }

    public INativePropertyListener<S> adaptListener(ISimplePropertyListener<S, SetDiff<E>> listener) {
        return null;
    }

    public String toString() {
        String s = String.valueOf(BeanPropertyHelper.propertyName(this.propertyDescriptor)) + "{}";
        if (this.elementType != null) {
            s = String.valueOf(s) + "<" + BeanPropertyHelper.shortClassName(this.elementType) + ">";
        }
        return s;
    }
}

