/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.embedder.node;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wildwebdeveloper.embedder.node.Activator;
import org.eclipse.wildwebdeveloper.embedder.node.CompressUtils;
import org.osgi.framework.Bundle;

public class NodeJSManager {
    private static final String MACOS_DSCL_SHELL_PREFIX = "UserShell: ";
    private static boolean alreadyWarned;
    private static Properties cachedNodeJsInfoProperties;
    private static final Object EXPAND_LOCK;

    static {
        EXPAND_LOCK = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getNodeJsLocation() {
        File res;
        block11: {
            File nodejs;
            String nodeJsLocation = System.getProperty("org.eclipse.wildwebdeveloper.nodeJSLocation");
            if (nodeJsLocation != null && (nodejs = new File(nodeJsLocation)).exists()) {
                NodeJSManager.validateNodeVersion(nodejs);
                return new File(nodeJsLocation);
            }
            Properties properties = NodeJSManager.getNodeJsInfoProperties();
            if (properties != null) {
                try {
                    IPath stateLocationPath = Platform.getStateLocation((Bundle)Activator.getDefault().getBundle());
                    if (stateLocationPath == null) break block11;
                    File installationPath = stateLocationPath.toFile();
                    File nodePath = new File(installationPath, properties.getProperty("nodePath"));
                    Object object = EXPAND_LOCK;
                    synchronized (object) {
                        if (!(nodePath.exists() && nodePath.canRead() && nodePath.canExecute())) {
                            CompressUtils.unarchive(FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path(properties.getProperty("archiveFile"))), installationPath);
                        }
                    }
                    return nodePath;
                }
                catch (IOException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wildwebdeveloper.embedder.node", e.getMessage(), (Throwable)e));
                }
            }
        }
        if ((res = NodeJSManager.which("node")) == null && NodeJSManager.getDefaultNodePath().exists()) {
            res = NodeJSManager.getDefaultNodePath();
        }
        if (res != null) {
            NodeJSManager.validateNodeVersion(res);
            return res;
        }
        if (!alreadyWarned) {
            NodeJSManager.warnNodeJSMissing();
            alreadyWarned = true;
        }
        return null;
    }

    public static File getNpmLocation() {
        File res;
        String npmFileName = Platform.getOS().equals("win32") ? "npm.cmd" : "npm";
        File nodeJsLocation = NodeJSManager.getNodeJsLocation();
        if (nodeJsLocation != null && (res = new File(nodeJsLocation.getParentFile(), npmFileName)).canExecute()) {
            return res;
        }
        return NodeJSManager.which(npmFileName);
    }

    public static File which(String program) {
        String[] paths;
        File installationPath;
        File nodePath2;
        IPath stateLocationPath;
        Properties properties = NodeJSManager.getNodeJsInfoProperties();
        if (properties != null && (stateLocationPath = InternalPlatform.getDefault().getStateLocation(Platform.getBundle((String)"org.eclipse.wildwebdeveloper.embedder.node"))) != null && (nodePath2 = new File(installationPath = stateLocationPath.toFile(), properties.getProperty("nodePath"))).exists() && nodePath2.canRead() && nodePath2.canExecute()) {
            File exe3 = new File(nodePath2.getParent(), program);
            if (exe3.canExecute()) {
                return exe3;
            }
            if ("win32".equals(Platform.getOS()) && (exe3 = new File(nodePath2.getParent(), String.valueOf(program) + ".exe")).canExecute()) {
                return exe3;
            }
        }
        String[] stringArray = paths = System.getenv("PATH").split(System.getProperty("path.separator"));
        int exe3 = paths.length;
        int nodePath2 = 0;
        while (nodePath2 < exe3) {
            String path = stringArray[nodePath2];
            File exe2 = new File(path, program);
            if (exe2.canExecute()) {
                return exe2;
            }
            ++nodePath2;
        }
        String res = null;
        String[] command = new String[]{"/bin/bash", "-c", "-l", "which " + program};
        if (Platform.getOS().equals("win32")) {
            command = new String[]{"cmd", "/c", "where " + program};
        } else if (Platform.getOS().equals("macosx")) {
            command = new String[]{NodeJSManager.getDefaultShellMacOS(), "-c", "-li", "which " + program};
        }
        try {
            Throwable exe3 = null;
            stringArray = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(command).getInputStream()));){
                res = reader.readLine();
            }
            catch (Throwable throwable) {
                if (exe3 == null) {
                    exe3 = throwable;
                } else if (exe3 != throwable) {
                    exe3.addSuppressed(throwable);
                }
                throw exe3;
            }
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e));
        }
        return res != null ? new File(res) : null;
    }

    private static Properties getNodeJsInfoProperties() {
        URL nodeJsInfo;
        if (cachedNodeJsInfoProperties == null && (nodeJsInfo = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("nodejs-info.properties"))) != null) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (InputStream infoStream = nodeJsInfo.openStream();){
                    Properties properties = new Properties();
                    properties.load(infoStream);
                    cachedNodeJsInfoProperties = properties;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wildwebdeveloper.embedder.node", e.getMessage(), (Throwable)e));
            }
        }
        return cachedNodeJsInfoProperties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getDefaultShellMacOS() {
        String res = null;
        String[] command = new String[]{"/bin/bash", "-c", "-l", "dscl . -read ~/ UserShell"};
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(command).getInputStream()));){
                res = reader.readLine();
                if (!res.startsWith(MACOS_DSCL_SHELL_PREFIX)) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Cannot find default shell. Use '/bin/zsh' instead."));
                    return "/bin/zsh";
                }
                res = res.substring(MACOS_DSCL_SHELL_PREFIX.length());
                return res;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e));
        }
        return res;
    }

    private static File getDefaultNodePath() {
        return new File(switch (Platform.getOS()) {
            case "macosx" -> "/usr/local/bin/node";
            case "win32" -> "C:\\Program Files\\nodejs\\node.exe";
            default -> "/usr/bin/node";
        });
    }

    private static void validateNodeVersion(File nodeJsLocation) {
        String nodeVersion = null;
        String[] nodeVersionCommand = new String[]{nodeJsLocation.getAbsolutePath(), "-v"};
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(nodeVersionCommand).getInputStream()));){
                nodeVersion = reader.readLine();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e));
        }
        if (nodeVersion == null) {
            NodeJSManager.warnNodeJSVersionCouldNotBeDetermined();
        }
    }

    private static void warnNodeJSMissing() {
        if (!alreadyWarned) {
            Display.getDefault().asyncExec(() -> MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Missing node.js", (String)"Could not find node.js. This will result in editors missing key features.\nPlease make sure node.js is installed and that your PATH environment variable contains the location to the `node` executable."));
        }
        alreadyWarned = true;
    }

    private static void warnNodeJSVersionCouldNotBeDetermined() {
        if (!alreadyWarned) {
            Display.getDefault().asyncExec(() -> MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Node.js version could not be determined", (String)"Node.js version could not be determined. Please make sure a recent version of node.js is installed, editors may be missing key features otherwise.\n"));
        }
        alreadyWarned = true;
    }
}

