/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage;

import org.eclipse.userstorage.IStorage;
import org.eclipse.userstorage.internal.Storage;
import org.eclipse.userstorage.spi.ISettings;
import org.eclipse.userstorage.spi.StorageCache;
import org.eclipse.userstorage.util.BadApplicationTokenException;
import org.eclipse.userstorage.util.Settings;

public final class StorageFactory {
    public static final StorageFactory DEFAULT = new StorageFactory(Settings.DEFAULT);
    private final ISettings settings;

    public StorageFactory(ISettings settings) {
        this.settings = settings != null ? settings : Settings.NONE;
    }

    public StorageFactory() {
        this(new Settings.MemorySettings());
    }

    public ISettings getSettings() {
        return this.settings;
    }

    public IStorage create(String applicationToken) throws BadApplicationTokenException {
        return this.create(applicationToken, null);
    }

    public IStorage create(String applicationToken, StorageCache cache) throws BadApplicationTokenException {
        return new Storage(this, applicationToken, cache);
    }
}

