/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.api.violation;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.wtp.releng.tools.component.CommandOptionParser;
import org.eclipse.wtp.releng.tools.component.IClazz;
import org.eclipse.wtp.releng.tools.component.ILibrary;
import org.eclipse.wtp.releng.tools.component.IPluginXML;
import org.eclipse.wtp.releng.tools.component.api.ClassUse;
import org.eclipse.wtp.releng.tools.component.api.ComponentUse;
import org.eclipse.wtp.releng.tools.component.api.ComponentUseEmitter;
import org.eclipse.wtp.releng.tools.component.api.Source;
import org.eclipse.wtp.releng.tools.component.api.violation.ComponentViolationSummary;
import org.eclipse.wtp.releng.tools.component.internal.AbstractEmitter;
import org.eclipse.wtp.releng.tools.component.internal.ComponentDepends;
import org.eclipse.wtp.releng.tools.component.internal.ComponentRef;
import org.eclipse.wtp.releng.tools.component.internal.ComponentXML;
import org.eclipse.wtp.releng.tools.component.internal.FileLocation;
import org.eclipse.wtp.releng.tools.component.internal.Package;
import org.eclipse.wtp.releng.tools.component.internal.Plugin;
import org.eclipse.wtp.releng.tools.component.internal.Type;

public class ComponentViolationEmitter
extends AbstractEmitter {
    public static final String CONST_COMPONENT_VIOLATION_XML = "component-violation.xml";
    public static final String CONST_COMPONENT_VIOLATION_HTML = "component-violation.html";
    public static final String OPTION_ECLIPSE_DIR = "eclipseDir";
    public static final String OPTION_COMPONENT_XML_DIR = "compXMLDir";
    public static final String OPTION_COMPONENT_REF_DIR = "compRefDir";
    public static final String OPTION_COMPONENT_VIOLATION_DIR = "compVioDir";
    public static final String OPTION_INCLUDE = "include";
    public static final String OPTION_EXCLUDE = "exclude";
    public static final String OPTION_GEN_HTML = "genHTML";
    public static final String OPTION_GEN_USAGE = "genUsage";
    public static final String OPTION_DEBUG = "debug";
    private String compViolationDir;
    private Map pluginId2Plugin;
    private Map fragmentId2Fragment;
    private Map compLoc2CompXML;
    private Map compLoc2CompRef;
    private List classUseIncludes;
    private List classUseIncludesMatch;
    private List classUseExcludes;
    private List classUseExcludesMatch;
    private boolean genHTML;
    private boolean genUsage;
    private boolean classRefOnly;
    private boolean debug;
    private ComponentUseEmitter compUseEmitter;

    public ComponentViolationEmitter(String compViolationDir) {
        this.compViolationDir = this.addTrailingSeperator(compViolationDir);
        this.genUsage = false;
        this.classRefOnly = false;
        this.debug = false;
    }

    public void init(List eclipseDirs, List compXMLDirs, List compRefDirs) {
        this.compLoc2CompXML = new HashMap();
        this.compLoc2CompRef = new HashMap();
        this.pluginId2Plugin = new HashMap();
        this.fragmentId2Fragment = new HashMap();
        Iterator it = eclipseDirs.iterator();
        while (it.hasNext()) {
            File eclipseFile = new File(this.addTrailingSeperator((String)it.next()));
            if (!eclipseFile.exists()) continue;
            this.harvestPlugins(eclipseFile, this.pluginId2Plugin, this.fragmentId2Fragment);
        }
        this.linkPluginsAndFragments(this.pluginId2Plugin, this.fragmentId2Fragment);
        it = compXMLDirs.iterator();
        while (it.hasNext()) {
            File compXMLFile = new File(this.addTrailingSeperator((String)it.next()));
            if (!compXMLFile.exists()) continue;
            this.harvestComponents(compXMLFile, this.compLoc2CompXML);
        }
        if (compRefDirs != null) {
            it = compRefDirs.iterator();
            while (it.hasNext()) {
                File compRefFile = new File(this.addTrailingSeperator((String)it.next()));
                if (!compRefFile.exists()) continue;
                this.harvestComponents(compRefFile, this.compLoc2CompRef);
            }
        }
        this.init();
    }

    public void init(Map compLoc2CompXML, Map compLoc2CompRef, Map pluginId2Plugin, Map fragmentId2Fragment) {
        this.compLoc2CompXML = compLoc2CompXML;
        this.compLoc2CompRef = compLoc2CompRef;
        this.pluginId2Plugin = pluginId2Plugin;
        this.fragmentId2Fragment = fragmentId2Fragment;
        this.init();
    }

    private void init() {
        this.compUseEmitter = new ComponentUseEmitter(this.genUsage ? this.compViolationDir : null);
        this.compUseEmitter.setClassUseIncludes(this.classUseIncludes);
        this.compUseEmitter.setClassUseIncludesMatch(this.classUseIncludesMatch);
        this.compUseEmitter.setClassUseExcludes(this.classUseExcludes);
        this.compUseEmitter.setClassUseExcludesMatch(this.classUseExcludesMatch);
        this.compUseEmitter.setClassRefOnly(this.classRefOnly);
        this.compUseEmitter.setDebug(this.debug);
        this.compUseEmitter.init(this.compLoc2CompXML, this.pluginId2Plugin, this.fragmentId2Fragment);
    }

    public Map getCompRefs() {
        return new HashMap(this.compLoc2CompRef);
    }

    public void setCompRefs(Map compLoc2CompRef) {
        this.compLoc2CompRef = compLoc2CompRef;
    }

    public List getClassUseIncludes() {
        return this.classUseIncludes;
    }

    public void setClassUseIncludes(List includes) {
        this.classUseIncludes = includes;
    }

    public List getClassUseIncludesMatch() {
        return this.classUseIncludesMatch;
    }

    public void setClassUseIncludesMatch(List includesMatch) {
        this.classUseIncludesMatch = includesMatch;
    }

    public List getClassUseExcludes() {
        return this.classUseExcludes;
    }

    public void setClassUseExcludes(List excludes) {
        this.classUseExcludes = excludes;
    }

    public List getClassUseExcludesMatch() {
        return this.classUseExcludesMatch;
    }

    public void setClassUseExcludesMatch(List excludesMatch) {
        this.classUseExcludesMatch = excludesMatch;
    }

    public boolean isGenHTML() {
        return this.genHTML;
    }

    public void setGenHTML(boolean genHTML) {
        this.genHTML = genHTML;
    }

    public boolean getGenUsage() {
        return this.genUsage;
    }

    public void setGenUsage(boolean genUsage) {
        this.genUsage = genUsage;
    }

    public boolean isClassRefOnly() {
        return this.classRefOnly;
    }

    public void setClassRefOnly(boolean classRefOnly) {
        this.classRefOnly = classRefOnly;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void genComponentViolationXML() throws IOException {
        ComponentViolationSummary summary = new ComponentViolationSummary();
        Iterator it = this.compLoc2CompXML.keySet().iterator();
        while (it.hasNext()) {
            summary.add(this.genComponentViolationXML((String)it.next()));
        }
        if (this.compViolationDir != null) {
            summary.save(new FileLocation(new File(String.valueOf(this.compViolationDir) + "index.xml")));
            if (this.genHTML) {
                try {
                    summary.saveAsHTML(new FileLocation(new File(String.valueOf(this.compViolationDir) + "index.html")));
                }
                catch (TransformerConfigurationException e) {
                    e.printStackTrace();
                }
                catch (TransformerException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public ComponentUse genComponentViolationXML(String compLoc) throws IOException {
        ComponentUse compUse = null;
        ComponentXML componentXML = (ComponentXML)this.compLoc2CompXML.get(compLoc);
        if (componentXML != null) {
            ComponentXML compXML;
            componentXML.load();
            compUse = this.compUseEmitter.genComponentUseXML(compLoc);
            compUse.save();
            Iterator pluginsIt = componentXML.getPlugins().iterator();
            while (pluginsIt.hasNext()) {
                IPluginXML pluginXML = (IPluginXML)this.pluginId2Plugin.get(((Plugin)pluginsIt.next()).getId());
                if (pluginXML == null) continue;
                this.validateComponentUse(pluginXML, compUse);
            }
            ComponentDepends depends = componentXML.getComponentDepends();
            boolean unrestricted = depends.isUnrestricted();
            ArrayList<String> dependNames = null;
            if (!unrestricted) {
                dependNames = new ArrayList<String>();
                Collection compRefs = depends.getComponentRefs();
                Iterator it = compRefs.iterator();
                while (it.hasNext()) {
                    dependNames.add(((ComponentRef)it.next()).getName());
                }
            }
            Iterator it = this.compLoc2CompXML.values().iterator();
            while (it.hasNext() && compUse.getSources().size() > 0) {
                compXML = (ComponentXML)it.next();
                if (!unrestricted && !dependNames.contains(compXML.getName())) continue;
                compXML.load();
                this.validateComponentUse(compXML, compUse);
            }
            it = this.compLoc2CompRef.values().iterator();
            while (it.hasNext() && compUse.getSources().size() > 0) {
                compXML = (ComponentXML)it.next();
                if (!unrestricted && !dependNames.contains(compXML.getName())) continue;
                compXML.load();
                this.validateComponentUse(compXML, compUse);
            }
            if (this.compViolationDir != null) {
                String compName = compUse.getName();
                System.out.println("Writing component-violation.xml for " + compName);
                StringBuffer sb = new StringBuffer(this.compViolationDir);
                sb.append(compName);
                sb.append('/');
                compUse.setLocation(new FileLocation(new File(String.valueOf(sb.toString()) + CONST_COMPONENT_VIOLATION_XML)));
                compUse.save();
                if (this.genHTML) {
                    try {
                        FileLocation html = new FileLocation(new File(String.valueOf(sb.toString()) + CONST_COMPONENT_VIOLATION_HTML));
                        compUse.setLocation(html);
                        compUse.saveAsHTML(html);
                    }
                    catch (TransformerConfigurationException e) {
                        e.printStackTrace();
                    }
                    catch (TransformerException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return compUse;
    }

    public Source genViolation(String compLoc, IClazz clazz) {
        Source source = null;
        ComponentXML componentXML = (ComponentXML)this.compLoc2CompXML.get(compLoc);
        if (componentXML != null) {
            ComponentXML comp;
            Iterator it;
            boolean valid = false;
            source = this.compUseEmitter.genUse(clazz);
            Iterator pluginsIt = componentXML.getPlugins().iterator();
            while (pluginsIt.hasNext()) {
                IPluginXML pluginXML = (IPluginXML)this.pluginId2Plugin.get(((Plugin)pluginsIt.next()).getId());
                if (pluginXML == null || !this.validateComponentUse(pluginXML, source)) continue;
                valid = true;
                break;
            }
            ComponentDepends depends = componentXML.getComponentDepends();
            boolean unrestricted = depends.isUnrestricted();
            ArrayList<String> dependNames = null;
            if (!unrestricted) {
                dependNames = new ArrayList<String>();
                Collection compRefs = depends.getComponentRefs();
                Iterator it2 = compRefs.iterator();
                while (it2.hasNext()) {
                    dependNames.add(((ComponentRef)it2.next()).getName());
                }
            }
            if (!valid) {
                it = this.compLoc2CompXML.values().iterator();
                while (it.hasNext()) {
                    comp = (ComponentXML)it.next();
                    if ((unrestricted || dependNames.contains(comp.getName())) && (valid = this.validateComponentUse(comp, source))) break;
                }
            }
            if (!valid) {
                it = this.compLoc2CompRef.values().iterator();
                while (it.hasNext()) {
                    comp = (ComponentXML)it.next();
                    if ((unrestricted || dependNames.contains(comp.getName())) && (valid = this.validateComponentUse(comp, source))) break;
                }
            }
        }
        return source;
    }

    private void validateComponentUse(IPluginXML pluginXML, ComponentUse compUse) {
        List sources = compUse.getSources();
        int i = 0;
        while (i < sources.size()) {
            if (this.validateComponentUse(pluginXML, (Source)sources.get(i))) {
                sources.remove(i);
                --i;
            }
            ++i;
        }
    }

    private boolean validateComponentUse(IPluginXML pluginXML, Source source) {
        ArrayList classUses = new ArrayList(source.getClassUses());
        int j = 0;
        while (j < classUses.size()) {
            ClassUse classUse = (ClassUse)classUses.get(j);
            if (this.validateComponentUse(pluginXML, classUse)) {
                classUses.remove(j);
                --j;
            }
            ++j;
        }
        return classUses.size() == 0;
    }

    private boolean validateComponentUse(IPluginXML pluginXML, ClassUse classUse) {
        String classUseName = classUse.getName();
        int dollarSign = classUseName.indexOf(36);
        if (dollarSign != -1) {
            classUseName = classUseName.substring(0, dollarSign);
        }
        List libs = pluginXML.getLibraries();
        Iterator libsIt = libs.iterator();
        while (libsIt.hasNext()) {
            ILibrary lib = (ILibrary)libsIt.next();
            Map types = lib.getTypes();
            if (!types.containsKey(classUseName)) continue;
            return true;
        }
        return false;
    }

    private void validateComponentUse(ComponentXML compXML, ComponentUse compUse) {
        List sources = compUse.getSources();
        int i = 0;
        while (i < sources.size()) {
            if (this.validateComponentUse(compXML, (Source)sources.get(i))) {
                sources.remove(i);
                --i;
            }
            ++i;
        }
    }

    private boolean validateComponentUse(ComponentXML compXML, Source source) {
        ArrayList classUses = new ArrayList(source.getClassUses());
        int j = 0;
        while (j < classUses.size()) {
            ClassUse classUse = (ClassUse)classUses.get(j);
            if (this.validateComponentUse(compXML, classUse)) {
                classUses.remove(j);
                --j;
            }
            ++j;
        }
        return classUses.size() == 0;
    }

    private boolean validateComponentUse(ComponentXML compXML, ClassUse classUse) {
        String classUseName = classUse.getName();
        Collection pkgs = compXML.getPackages();
        Iterator pkgsIt = pkgs.iterator();
        while (pkgsIt.hasNext()) {
            Package pkg = (Package)pkgsIt.next();
            String pkgName = pkg.getName();
            if (!classUseName.startsWith(pkgName) || classUseName.substring(pkgName.length() + 1).indexOf(46) != -1) continue;
            Collection types = pkg.getTypes();
            Iterator typesIt = types.iterator();
            while (typesIt.hasNext()) {
                Type type = (Type)typesIt.next();
                if (!classUseName.equals(type.getName())) continue;
                return !(classUse.isReference() && !type.isReference() || classUse.isSubclass() && !type.isSubclass() || classUse.isImplement() && !type.isImplement() || classUse.isInstantiate() && !type.isInstantiate());
            }
            return pkg.isApi();
        }
        return false;
    }

    public static void main(String[] args) {
        CommandOptionParser optionParser = new CommandOptionParser(args);
        Map options = optionParser.getOptions();
        List eclipseDir = (List)options.get(OPTION_ECLIPSE_DIR);
        List compXMLDir = (List)options.get(OPTION_COMPONENT_XML_DIR);
        List compRefDir = (List)options.get(OPTION_COMPONENT_REF_DIR);
        List compViolationDir = (List)options.get(OPTION_COMPONENT_VIOLATION_DIR);
        List includes = (List)options.get(OPTION_INCLUDE);
        List excludes = (List)options.get(OPTION_EXCLUDE);
        List genHTML = (List)options.get(OPTION_GEN_HTML);
        List genUsage = (List)options.get(OPTION_GEN_USAGE);
        List classRefOnly = (List)options.get("classRefOnly");
        List debug = (List)options.get(OPTION_DEBUG);
        if (eclipseDir == null || compXMLDir == null || compViolationDir == null || eclipseDir.size() < 1 || compXMLDir.size() < 1 || compViolationDir.size() < 1) {
            ComponentViolationEmitter.printUsage();
            System.exit(-1);
        }
        ArrayList<String> includesStart = null;
        ArrayList<String> includesMatch = null;
        if (includes != null) {
            Iterator it = includes.iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                if (s.charAt(0) == '*' && s.charAt(s.length() - 1) == '*') {
                    if (includesMatch == null) {
                        includesMatch = new ArrayList<String>(1);
                    }
                    includesMatch.add(s.substring(1, s.length() - 1));
                    continue;
                }
                if (includesStart == null) {
                    includesStart = new ArrayList<String>(1);
                }
                includesStart.add(s);
            }
        }
        ArrayList<String> excludesStart = null;
        ArrayList<String> excludesMatch = null;
        if (excludes != null) {
            Iterator it = excludes.iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                if (s.charAt(0) == '*' && s.charAt(s.length() - 1) == '*') {
                    if (excludesMatch == null) {
                        excludesMatch = new ArrayList<String>(1);
                    }
                    excludesMatch.add(s.substring(1, s.length() - 1));
                    continue;
                }
                if (excludesStart == null) {
                    excludesStart = new ArrayList<String>(1);
                }
                excludesStart.add(s);
            }
        }
        ComponentViolationEmitter compViolationEmitter = new ComponentViolationEmitter((String)compViolationDir.get(0));
        compViolationEmitter.setClassUseIncludes(includesStart);
        compViolationEmitter.setClassUseExcludesMatch(includesMatch);
        compViolationEmitter.setClassUseExcludes(excludesStart);
        compViolationEmitter.setClassUseExcludesMatch(excludesMatch);
        compViolationEmitter.setGenHTML(genHTML != null);
        compViolationEmitter.setGenUsage(genUsage != null);
        compViolationEmitter.setClassRefOnly(classRefOnly != null);
        compViolationEmitter.setDebug(debug != null);
        compViolationEmitter.init(eclipseDir, compXMLDir, compRefDir);
        try {
            compViolationEmitter.genComponentViolationXML();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static void printUsage() {
        System.out.println("Usage: java org.eclipse.wtp.releng.tools.component.violaion.ComponentViolationEmitter -eclipseDir <eclipseDir> -compXMLDir <compXMLDir> -compVioDir <compVioDir> [-options]");
        System.out.println("");
        System.out.println("\t-eclipseDir\t<eclipseDir>\tspace seperated list of directories containing Eclipse plugins");
        System.out.println("\t-compXMLDir\t<compXMLDir>\tdirectories containing component.xml that will be checked for API violations");
        System.out.println("\t-compVioDir\t<compVioDir>\toutput directory of component-violation.xml");
        System.out.println("");
        System.out.println("where options include:");
        System.out.println("");
        System.out.println("\t-compRefDir\t<compRefDir>\tdirectories containing component.xml being referenced");
        System.out.println("\t-include\t<include>\tspace seperated packages to include");
        System.out.println("\t-exclude\t<exclude>\tspace seperated packages to exclude");
        System.out.println("\t-genHTML\t\t\tgenerate violation report in HTML");
        System.out.println("\t-genUsage\t\t\tgenerate component-use.xml");
        System.out.println("\t-classRefOnly\t\t\ttreat all violations as class reference");
        System.out.println("\t-debug\t\t\t\tgenerate debug information (ex. line numbers)");
    }
}

