/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.api.violation;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.wtp.releng.tools.component.CommandOptionParser;
import org.eclipse.wtp.releng.tools.component.IClassVisitor;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.ILocationVisitor;
import org.eclipse.wtp.releng.tools.component.api.ClassUse;
import org.eclipse.wtp.releng.tools.component.api.ComponentUse;
import org.eclipse.wtp.releng.tools.component.api.ComponentXMLVisitor;
import org.eclipse.wtp.releng.tools.component.api.Source;
import org.eclipse.wtp.releng.tools.component.api.violation.Class2Reference;
import org.eclipse.wtp.releng.tools.component.api.violation.LibVisitor;
import org.eclipse.wtp.releng.tools.component.images.ImagesUtil;
import org.eclipse.wtp.releng.tools.component.internal.ComponentDepends;
import org.eclipse.wtp.releng.tools.component.internal.ComponentXML;
import org.eclipse.wtp.releng.tools.component.internal.FileLocation;
import org.eclipse.wtp.releng.tools.component.internal.Location;
import org.eclipse.wtp.releng.tools.component.internal.Package;
import org.eclipse.wtp.releng.tools.component.internal.Plugin;
import org.eclipse.wtp.releng.tools.component.internal.Type;
import org.eclipse.wtp.releng.tools.component.xsl.XSLUtil;

public class APIViolationScanner
implements IClassVisitor {
    private Collection src;
    private Collection api;
    private String outputDir;
    private Collection includes;
    private Collection excludes;
    private boolean classRefOnly;
    private boolean debug;
    private boolean html;
    private String xsl;
    private Map pluginId2CompXML = new HashMap();
    private boolean visit1 = true;
    private Map pluginId2Pkgs = new HashMap();
    private Class2Reference class2Ref = new Class2Reference();
    private ComponentUse cachedCompUse;

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = this.addTrailingSeperator(outputDir);
    }

    public Collection getSrc() {
        return this.src;
    }

    public void setSrc(Collection src) {
        this.src = src;
    }

    public Collection getApi() {
        return this.api;
    }

    public void setApi(Collection api) {
        this.api = api;
    }

    public Collection getIncludes() {
        return this.includes;
    }

    public void setIncludes(Collection includes) {
        this.includes = includes;
    }

    public Collection getExcludes() {
        return this.excludes;
    }

    public void setExcludes(Collection excludes) {
        this.excludes = excludes;
    }

    public boolean isClassRefOnly() {
        return this.classRefOnly;
    }

    public void setClassRefOnly(boolean classRefOnly) {
        this.classRefOnly = classRefOnly;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isHtml() {
        return this.html;
    }

    public void setHtml(boolean html) {
        this.html = html;
    }

    public String getXsl() {
        return this.xsl;
    }

    public void setXsl(String xsl) {
        this.xsl = xsl;
    }

    public void execute() {
        Iterator i = this.api.iterator();
        while (i.hasNext()) {
            String locationString = (String)i.next();
            ILocation apiLocation = Location.createLocation(new File(locationString));
            ComponentXMLVisitor compXMLVisitor = new ComponentXMLVisitor();
            if (apiLocation == null) {
                System.out.println("ERROR - Can't find location at: " + locationString);
                continue;
            }
            apiLocation.accept(compXMLVisitor);
            Iterator it = compXMLVisitor.getCompXMLs().iterator();
            while (it.hasNext()) {
                ComponentXML compXML = (ComponentXML)it.next();
                Iterator it2 = compXML.getPlugins().iterator();
                while (it2.hasNext()) {
                    this.pluginId2CompXML.put(((Plugin)it2.next()).getId(), compXML);
                }
            }
        }
        Iterator it = this.src.iterator();
        while (it.hasNext()) {
            this.visit1 = true;
            ILocation srcLocation = Location.createLocation(new File((String)it.next()));
            LibVisitor libVisitor = new LibVisitor();
            srcLocation.accept(libVisitor);
            libVisitor.setClassVisitor(this);
            srcLocation.accept(libVisitor);
            this.visit1 = false;
            srcLocation.accept(libVisitor);
        }
        try {
            if (this.cachedCompUse != null) {
                this.cachedCompUse.save();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.isHtml()) {
            ImagesUtil.copyAll(this.outputDir);
            this.genHTML();
        }
    }

    private void genHTML() {
        final StringBuffer summary = new StringBuffer();
        summary.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        summary.append("<root>");
        ILocation outputLoc = Location.createLocation(new File(this.outputDir));
        outputLoc.accept(new ILocationVisitor(){

            public boolean accept(ILocation location) {
                if (location.getName().endsWith("api-violation.xml")) {
                    try {
                        XSLUtil.transform(APIViolationScanner.this.xsl != null && APIViolationScanner.this.xsl.length() > 0 ? Location.createLocation(new File(APIViolationScanner.this.xsl)).getInputStream() : ClassLoader.getSystemResourceAsStream("org/eclipse/wtp/releng/tools/component/xsl/api-violation.xsl"), location.getInputStream(), (OutputStream)new FileOutputStream(((FileLocation)location.createSibling("api-violation.html")).getFile()));
                    }
                    catch (Throwable throwable) {
                        try {
                            XSLUtil.transform(Platform.getBundle((String)"org.eclipse.wtp.releng.tools.component.core").getResource("org/eclipse/wtp/releng/tools/component/xsl/api-violation.xsl").openStream(), location.getInputStream(), (OutputStream)new FileOutputStream(((FileLocation)location.createSibling("api-violation.html")).getFile()));
                        }
                        catch (Throwable e2) {
                            e2.printStackTrace();
                        }
                    }
                    summary.append("<violation file=\"");
                    summary.append(location.getAbsolutePath().substring(APIViolationScanner.this.outputDir.length()));
                    summary.append("\"/>");
                }
                return true;
            }
        });
        summary.append("</root>");
        try {
            XSLUtil.transform(ClassLoader.getSystemResourceAsStream("org/eclipse/wtp/releng/tools/component/xsl/api-violation-summary.xsl"), new ByteArrayInputStream(summary.toString().getBytes()), (OutputStream)new FileOutputStream(new File(String.valueOf(this.outputDir) + "/api-violation-summary.html")), this.outputDir);
        }
        catch (Throwable throwable) {
            try {
                XSLUtil.transform(Platform.getBundle((String)"org.eclipse.wtp.releng.tools.component.core").getResource("org/eclipse/wtp/releng/tools/component/xsl/api-violation-summary.xsl").openStream(), new ByteArrayInputStream(summary.toString().getBytes()), (OutputStream)new FileOutputStream(new File(String.valueOf(this.outputDir) + "/api-violation-summary.html")), this.outputDir);
            }
            catch (Throwable e2) {
                e2.printStackTrace();
            }
        }
    }

    public boolean visit(String pluginId, ILocation classLoc) {
        if (this.visit1) {
            return this.visit1(pluginId, classLoc);
        }
        return this.visit2(pluginId, classLoc);
    }

    private boolean visit1(String pluginId, ILocation classLoc) {
        String className = classLoc.getName();
        className = className.substring(0, className.length() - ".class".length());
        className = className.replace('/', '.');
        int i = (className = className.replace('\\', '.')).lastIndexOf(46);
        String packageName = i != -1 ? className.substring(0, i) : "";
        ArrayList<String> pkgs = (ArrayList<String>)this.pluginId2Pkgs.get(pluginId);
        if (pkgs == null) {
            pkgs = new ArrayList<String>();
            this.pluginId2Pkgs.put(pluginId, pkgs);
        }
        if (!pkgs.contains(packageName)) {
            pkgs.add(packageName);
        }
        return true;
    }

    private boolean visit2(String pluginId, ILocation classLoc) {
        try {
            ComponentUse compUse = this.getComponentUse(pluginId);
            this.class2Ref.setIncludes(this.getIncludes());
            this.class2Ref.setExcludes(this.getExcludes());
            this.class2Ref.setClassRefOnly(this.isClassRefOnly());
            this.class2Ref.setDebug(this.isDebug());
            Source uses = this.class2Ref.visit(classLoc);
            this.removeSelfRefs(pluginId, uses);
            Iterator it = this.getDependCompXML(pluginId).iterator();
            while (it.hasNext()) {
                this.removeAPIUses((ComponentXML)it.next(), uses);
            }
            if (!uses.getClassUses().isEmpty()) {
                compUse.addSource(uses);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassFormatException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private void removeSelfRefs(String pluginId, Source source) {
        this.removeSelfRefs2(pluginId, source);
        ComponentXML compXML = (ComponentXML)this.pluginId2CompXML.get(pluginId);
        if (compXML != null) {
            Iterator it = compXML.getPlugins().iterator();
            while (it.hasNext()) {
                String id = ((Plugin)it.next()).getId();
                if (id.equals(pluginId)) continue;
                this.removeSelfRefs2(id, source);
            }
        }
    }

    private void removeSelfRefs2(String pluginId, Source source) {
        List pkgs = (List)this.pluginId2Pkgs.get(pluginId);
        if (pkgs != null) {
            Iterator it = new ArrayList(source.getClassUses()).iterator();
            while (it.hasNext()) {
                String packageName;
                ClassUse classUse = (ClassUse)it.next();
                String className = classUse.getName();
                int i = className.lastIndexOf(46);
                String string = packageName = i != -1 ? className.substring(0, i) : "";
                if (!pkgs.contains(packageName)) continue;
                source.removeClassUse(classUse);
            }
        }
    }

    private Collection getDependCompXML(String pluginId) {
        ArrayList<ComponentXML> compXMLs = new ArrayList<ComponentXML>();
        ComponentXML thisCompXML = (ComponentXML)this.pluginId2CompXML.get(pluginId);
        if (thisCompXML != null) {
            ComponentDepends depends = thisCompXML.getComponentDepends();
            boolean unrestricted = depends != null ? depends.isUnrestricted() : false;
            Collection compRefs = depends != null ? depends.getComponentRefs() : new ArrayList(0);
            Iterator it = this.pluginId2CompXML.values().iterator();
            while (it.hasNext()) {
                ComponentXML compXML = (ComponentXML)it.next();
                if (compXML == thisCompXML || !unrestricted && !compRefs.contains(compXML.getName())) continue;
                compXMLs.add(compXML);
            }
        } else {
            compXMLs.addAll(this.pluginId2CompXML.values());
        }
        return compXMLs;
    }

    private void removeAPIUses(ComponentXML compXML, Source source) {
        Iterator it = new ArrayList(source.getClassUses()).iterator();
        while (it.hasNext()) {
            ClassUse classUse = (ClassUse)it.next();
            if (!this.validateUse(compXML, classUse)) continue;
            source.removeClassUse(classUse);
        }
    }

    private boolean validateUse(ComponentXML compXML, ClassUse classUse) {
        String className = classUse.getName();
        int i = className.lastIndexOf(46);
        String packageName = i != -1 ? className.substring(0, i) : "";
        String localName = i != -1 ? className.substring(i + 1) : className;
        Package pkg = compXML.getPackage(packageName);
        if (pkg != null) {
            Type type = pkg.getType(localName);
            if (type != null) {
                return !(classUse.isReference() && !type.isReference() || classUse.isSubclass() && !type.isSubclass() || classUse.isImplement() && !type.isImplement() || classUse.isInstantiate() && !type.isInstantiate());
            }
            return pkg.isApi();
        }
        return false;
    }

    private ComponentUse getComponentUse(String pluginId) throws IOException {
        String compId;
        ComponentXML compXML = (ComponentXML)this.pluginId2CompXML.get(pluginId);
        String string = compId = compXML != null ? compXML.getName() : pluginId;
        if (this.cachedCompUse != null) {
            if (this.cachedCompUse.getName().equals(compId)) {
                return this.cachedCompUse;
            }
            this.cachedCompUse.save();
        }
        StringBuffer sb = new StringBuffer(this.outputDir);
        sb.append(compId);
        sb.append("/api-violation.xml");
        File file = new File(sb.toString());
        this.cachedCompUse = new ComponentUse();
        this.cachedCompUse.setName(compId);
        this.cachedCompUse.setLocation(new FileLocation(file));
        if (file.exists()) {
            this.cachedCompUse.load();
        }
        return this.cachedCompUse;
    }

    protected String addTrailingSeperator(String s) {
        if (s != null && !s.endsWith("/") && !s.endsWith("\\")) {
            StringBuffer sb = new StringBuffer(s);
            sb.append('/');
            return sb.toString();
        }
        return s;
    }

    public static void main(String[] args) {
        CommandOptionParser optionParser = new CommandOptionParser(args);
        Map options = optionParser.getOptions();
        Collection src = (Collection)options.get("src");
        Collection api = (Collection)options.get("api");
        Collection outputDir = (Collection)options.get("outputDir");
        Collection includes = (Collection)options.get("includes");
        Collection excludes = (Collection)options.get("excludes");
        Collection classRefOnly = (Collection)options.get("classRefOnly");
        Collection debug = (Collection)options.get("debug");
        Collection html = (Collection)options.get("html");
        Collection xsl = (Collection)options.get("xsl");
        if (src == null || api == null || outputDir == null || src.isEmpty() || api.isEmpty() || outputDir.isEmpty()) {
            APIViolationScanner.printUsage();
            System.exit(-1);
        }
        APIViolationScanner vioScanner = new APIViolationScanner();
        vioScanner.setSrc(src);
        vioScanner.setApi(api);
        vioScanner.setOutputDir((String)outputDir.iterator().next());
        vioScanner.setIncludes(includes);
        vioScanner.setExcludes(excludes);
        vioScanner.setClassRefOnly(classRefOnly != null);
        vioScanner.setDebug(debug != null);
        vioScanner.setHtml(html != null);
        vioScanner.setXsl(xsl != null && !xsl.isEmpty() ? (String)xsl.iterator().next() : null);
        vioScanner.execute();
    }

    private static void printUsage() {
        System.out.println("Usage: java org.eclipse.wtp.releng.tools.component.violation.APIViolationScanner -src <src> -api <api> -outputDir <outputDir> [-options]");
        System.out.println("");
        System.out.println("\t-src\t\t<src>\t\tlocation of a Eclipse-based product");
        System.out.println("\t-api\t\t<api>\t\tlocation of your component.xml");
        System.out.println("\t-outputDir\t<outputDir>\toutput directory of component.xml files");
        System.out.println("");
        System.out.println("where options include:");
        System.out.println("");
        System.out.println("\t-includes\t<includes>\tspace seperated packages to include");
        System.out.println("\t-excludes\t<excludes>\tspace seperated packages to exclude");
        System.out.println("\t-classRefOnly\t\t\ttreat all violations as class reference");
        System.out.println("\t-debug\t\t\t\tgenerate debug information (ex. line numbers)");
        System.out.println("\t-html\t\t\tgenerate HTML results");
        System.out.println("\t-xsl\t<xsl>\tuse your own stylesheet. You must specify the -html option");
    }
}

