/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.wst.xml.xpath2.processor.DOMLoader;
import org.eclipse.wst.xml.xpath2.processor.DOMLoaderException;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XercesLoader
implements DOMLoader {
    public static final String NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    public static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    public static final String SCHEMA_VALIDATION_FEATURE = "http://apache.org/xml/features/validation/schema";
    public static final String SCHEMA_FULL_CHECKING_FEATURE = "http://apache.org/xml/features/validation/schema-full-checking";
    public static final String DYNAMIC_VALIDATION_FEATURE = "http://apache.org/xml/features/validation/dynamic";
    public static final String LOAD_EXTERNAL_DTD_FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String DOCUMENT_IMPLEMENTATION_PROPERTY = "http://apache.org/xml/properties/dom/document-class-name";
    public static final String DOCUMENT_PSVI_IMPLEMENTATION = "org.apache.xerces.dom.PSVIDocumentImpl";
    boolean _validating = false;

    public Document load(InputStream in) throws DOMLoaderException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(this._validating);
        factory.setAttribute(SCHEMA_VALIDATION_FEATURE, new Boolean(this._validating));
        factory.setAttribute(DOCUMENT_IMPLEMENTATION_PROPERTY, DOCUMENT_PSVI_IMPLEMENTATION);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (this._validating) {
                builder.setErrorHandler(new ErrorHandler(){

                    public void fatalError(SAXParseException e) throws SAXException {
                        throw e;
                    }

                    public void error(SAXParseException e) throws SAXParseException {
                        throw e;
                    }

                    public void warning(SAXParseException e) throws SAXParseException {
                        throw e;
                    }
                });
            }
            return builder.parse(in);
        }
        catch (SAXException e) {
            throw new DOMLoaderException("SAX exception: " + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new DOMLoaderException("Parser configuration exception: " + e.getMessage());
        }
        catch (IOException e) {
            throw new DOMLoaderException("IO exception: " + e.getMessage());
        }
    }

    public void set_validating(boolean x) {
        this._validating = x;
    }
}

