/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - Initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.server.preview.internal;

import java.io.IOException;
import java.io.Writer;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.handler.ErrorHandler;
import org.mortbay.util.StringUtil;

public class WTPErrorHandler extends ErrorHandler {
	private static final long serialVersionUID = 1L;

	public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException {
		super.handle(target, request, response, dispatch);
		Request base_request = request instanceof Request?(Request)request:HttpConnection.getCurrentConnection().getRequest();
		base_request.setHandled(true);
	}

	protected void writeErrorPageBody(HttpServletRequest request, Writer writer, int code, String message, boolean showStacks)
   	throws IOException {
		String uri = request.getRequestURI();
		if (uri != null) {
			uri = StringUtil.replace(uri, "&", "&amp;");
			uri = StringUtil.replace(uri, "<", "&lt;");
			uri = StringUtil.replace(uri, ">", "&gt;");
		}
		
		writeErrorPageMessage(request, writer, code, message, uri);
		if (showStacks)
			writeErrorPageStacks(request, writer);
		
		for (int i = 0; i < 20; i++)
			writer.write("<br/>                                                \n");
	}
}
