/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.search.HierarchyScope;
import org.eclipse.wst.jsdt.internal.core.search.IRestrictedAccessBindingRequestor;
import org.eclipse.wst.jsdt.internal.core.search.IRestrictedAccessTypeRequestor;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchDocument;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchParticipant;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchScope;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchTypeNameMatch;
import org.eclipse.wst.jsdt.internal.core.search.PathCollector;
import org.eclipse.wst.jsdt.internal.core.search.PatternSearchJob;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexManager;
import org.eclipse.wst.jsdt.internal.core.search.matching.DeclarationOfAccessedFieldsPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.DeclarationOfReferencedMethodsPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.DeclarationOfReferencedTypesPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchLocator;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class BasicSearchEngine {
    private Parser parser;
    private CompilerOptions compilerOptions;
    private IJavaScriptUnit[] workingCopies;
    private WorkingCopyOwner workingCopyOwner;
    public static boolean VERBOSE = false;

    public BasicSearchEngine() {
    }

    public BasicSearchEngine(IJavaScriptUnit[] workingCopies) {
        this.workingCopies = workingCopies;
    }

    char convertTypeKind(int typeDeclarationKind) {
        switch (typeDeclarationKind) {
            case 1: {
                return 'C';
            }
            case 2: {
                return 'I';
            }
            case 3: {
                return 'E';
            }
            case 4: {
                return 'A';
            }
        }
        return '\u0000';
    }

    public BasicSearchEngine(WorkingCopyOwner workingCopyOwner) {
        this.workingCopyOwner = workingCopyOwner;
    }

    public static IJavaScriptSearchScope createHierarchyScope(IType type) throws JavaScriptModelException {
        return BasicSearchEngine.createHierarchyScope(type, DefaultWorkingCopyOwner.PRIMARY);
    }

    public static IJavaScriptSearchScope createHierarchyScope(IType type, WorkingCopyOwner owner) throws JavaScriptModelException {
        return new HierarchyScope(type, owner);
    }

    public static IJavaScriptSearchScope createJavaSearchScope(IJavaScriptElement[] elements) {
        return BasicSearchEngine.createJavaSearchScope(elements, true);
    }

    public static IJavaScriptSearchScope createJavaSearchScope(IJavaScriptElement[] elements, boolean includeReferencedProjects) {
        int includeMask = 7;
        if (includeReferencedProjects) {
            includeMask |= 8;
        }
        return BasicSearchEngine.createJavaSearchScope(elements, includeMask);
    }

    public static IJavaScriptSearchScope createJavaSearchScope(IJavaScriptElement[] elements, int includeMask) {
        JavaSearchScope scope = new JavaSearchScope();
        HashSet visitedProjects = new HashSet(2);
        int i = 0;
        int length = elements.length;
        while (i < length) {
            IJavaScriptElement element = elements[i];
            if (element != null) {
                try {
                    if (element instanceof JavaProject) {
                        scope.add((JavaProject)element, includeMask, visitedProjects);
                    } else {
                        scope.add(element);
                    }
                }
                catch (JavaScriptModelException javaScriptModelException) {}
            }
            ++i;
        }
        return scope;
    }

    public static TypeNameMatch createTypeNameMatch(IType type, int modifiers) {
        return new JavaSearchTypeNameMatch(type, modifiers);
    }

    public static IJavaScriptSearchScope createWorkspaceScope() {
        return JavaModelManager.getJavaModelManager().getWorkspaceScope();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void findMatches(SearchPattern pattern, SearchParticipant[] participants, IJavaScriptSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        block20: {
            block19: {
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    if (VERBOSE) {
                        Util.verbose("Searching for pattern: " + pattern.toString());
                        Util.verbose(scope.toString());
                    }
                    if (participants == null) {
                        if (VERBOSE) {
                            Util.verbose("No participants => do nothing!");
                        }
                        Object var17_6 = null;
                        requestor.endReporting();
                        if (monitor == null) return;
                        break block19;
                    }
                    int length = participants.length;
                    if (monitor != null) {
                        monitor.beginTask(Messages.engine_searching, 100 * length);
                    }
                    IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
                    requestor.beginReporting();
                    int i = 0;
                    while (i < length) {
                        Object var15_19;
                        if (monitor != null && monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        SearchParticipant participant = participants[i];
                        try {
                            String[] indexMatchPaths;
                            if (monitor != null) {
                                monitor.subTask(Messages.bind(Messages.engine_searching_indexing, new String[]{participant.getDescription()}));
                            }
                            participant.beginSearching();
                            requestor.enterParticipant(participant);
                            PathCollector pathCollector = new PathCollector();
                            indexManager.performConcurrentJob(new PatternSearchJob(pattern, participant, scope, pathCollector), 3, (IProgressMonitor)(monitor == null ? null : new SubProgressMonitor(monitor, 50)));
                            if (monitor != null && monitor.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            if (monitor != null) {
                                monitor.subTask(Messages.bind(Messages.engine_searching_matching, new String[]{participant.getDescription()}));
                            }
                            if ((indexMatchPaths = pathCollector.getPaths()) != null) {
                                SearchDocument[] matches;
                                pathCollector = null;
                                int indexMatchLength = indexMatchPaths.length;
                                SearchDocument[] indexMatches = new SearchDocument[indexMatchLength];
                                int j = 0;
                                while (true) {
                                    if (j >= indexMatchLength) {
                                        matches = MatchLocator.addWorkingCopies(pattern, indexMatches, this.getWorkingCopies(), participant);
                                    }
                                    indexMatches[j] = participant.getDocument(indexMatchPaths[j]);
                                    ++j;
                                }
                                participant.locateMatches(matches, pattern, scope, requestor, (IProgressMonitor)(monitor == null ? null : new SubProgressMonitor(monitor, 50)));
                            }
                        }
                        catch (Throwable throwable) {
                            var15_19 = null;
                            requestor.exitParticipant(participant);
                            participant.doneSearching();
                            throw throwable;
                        }
                        {
                            var15_19 = null;
                            requestor.exitParticipant(participant);
                            participant.doneSearching();
                            ++i;
                        }
                    }
                    break block20;
                }
                catch (Throwable throwable) {
                    Object var17_7 = null;
                    requestor.endReporting();
                    if (monitor == null) throw throwable;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return;
        }
        Object var17_8 = null;
        requestor.endReporting();
        if (monitor == null) return;
        monitor.done();
    }

    public static SearchParticipant getDefaultSearchParticipant() {
        return new JavaSearchParticipant();
    }

    public static String getMatchRuleString(int matchRule) {
        if (matchRule == 0) {
            return "R_EXACT_MATCH";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 1;
        while (i <= 8) {
            int bit = matchRule & 1 << i - 1;
            if (bit != 0 && buffer.length() > 0) {
                buffer.append(" | ");
            }
            switch (bit) {
                case 1: {
                    buffer.append("R_PREFIX_MATCH");
                    break;
                }
                case 8: {
                    buffer.append("R_CASE_SENSITIVE");
                    break;
                }
                case 32: {
                    buffer.append("R_EQUIVALENT_MATCH");
                    break;
                }
                case 16: {
                    buffer.append("R_ERASURE_MATCH");
                    break;
                }
                case 64: {
                    buffer.append("R_FULL_MATCH");
                    break;
                }
                case 2: {
                    buffer.append("R_PATTERN_MATCH");
                    break;
                }
                case 4: {
                    buffer.append("R_REGEXP_MATCH");
                    break;
                }
                case 128: {
                    buffer.append("R_CAMELCASE_MATCH");
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String getSearchForString(int searchFor) {
        switch (searchFor) {
            case 0: {
                return "TYPE";
            }
            case 1: {
                return "METHOD";
            }
            case 2: {
                return "PACKAGE";
            }
            case 3: {
                return "CONSTRUCTOR";
            }
            case 4: {
                return "FIELD";
            }
            case 5: {
                return "CLASS";
            }
            case 6: {
                return "INTERFACE";
            }
            case 7: {
                return "ENUM";
            }
            case 8: {
                return "ANNOTATION_TYPE";
            }
            case 9: {
                return "CLASS_AND_ENUM";
            }
            case 10: {
                return "CLASS_AND_INTERFACE";
            }
            case 11: {
                return "INTERFACE_AND_ANNOTATION";
            }
            case 12: {
                return "VAR";
            }
            case 13: {
                return "FUNCTION";
            }
        }
        return "UNKNOWN";
    }

    private Parser getParser() {
        if (this.parser == null) {
            this.compilerOptions = new CompilerOptions(JavaScriptCore.getOptions());
            ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.compilerOptions, new DefaultProblemFactory());
            this.parser = new Parser(problemReporter, true);
        }
        return this.parser;
    }

    private IJavaScriptUnit[] getWorkingCopies() {
        int length;
        IJavaScriptUnit[] copies;
        if (this.workingCopies != null) {
            if (this.workingCopyOwner == null) {
                copies = JavaModelManager.getJavaModelManager().getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, false);
                if (copies == null) {
                    copies = this.workingCopies;
                } else {
                    IJavaScriptUnit unit;
                    HashMap<IPath, IJavaScriptUnit> pathToCUs = new HashMap<IPath, IJavaScriptUnit>();
                    int i = 0;
                    int length2 = copies.length;
                    while (i < length2) {
                        unit = copies[i];
                        pathToCUs.put(unit.getPath(), unit);
                        ++i;
                    }
                    i = 0;
                    length2 = this.workingCopies.length;
                    while (i < length2) {
                        unit = this.workingCopies[i];
                        pathToCUs.put(unit.getPath(), unit);
                        ++i;
                    }
                    length = pathToCUs.size();
                    copies = new IJavaScriptUnit[length];
                    pathToCUs.values().toArray(copies);
                }
            } else {
                copies = this.workingCopies;
            }
        } else {
            copies = this.workingCopyOwner != null ? JavaModelManager.getJavaModelManager().getWorkingCopies(this.workingCopyOwner, true) : JavaModelManager.getJavaModelManager().getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, false);
        }
        if (copies == null) {
            return null;
        }
        IJavaScriptUnit[] result = null;
        length = copies.length;
        int index = 0;
        int i = 0;
        while (i < length) {
            CompilationUnit copy = (CompilationUnit)copies[i];
            try {
                if (!copy.isPrimary() || copy.hasUnsavedChanges() || copy.hasResourceChanged()) {
                    if (result == null) {
                        result = new IJavaScriptUnit[length];
                    }
                    result[index++] = copy;
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {}
            ++i;
        }
        if (index != length && result != null) {
            IJavaScriptUnit[] iJavaScriptUnitArray = result;
            result = new IJavaScriptUnit[index];
            System.arraycopy(iJavaScriptUnitArray, 0, result, 0, index);
        }
        return result;
    }

    private IJavaScriptUnit[] getWorkingCopies(IJavaScriptElement element) {
        IJavaScriptUnit cu;
        if (element instanceof IMember && (cu = ((IMember)element).getJavaScriptUnit()) != null && cu.isWorkingCopy()) {
            int length;
            IJavaScriptUnit[] copies = this.getWorkingCopies();
            int n = length = copies == null ? 0 : copies.length;
            if (length > 0) {
                IJavaScriptUnit[] newWorkingCopies = new IJavaScriptUnit[length + 1];
                System.arraycopy(copies, 0, newWorkingCopies, 0, length);
                newWorkingCopies[length] = cu;
                return newWorkingCopies;
            }
            return new IJavaScriptUnit[]{cu};
        }
        return this.getWorkingCopies();
    }

    boolean match(char patternTypeSuffix, int modifiers) {
        switch (patternTypeSuffix) {
            case 'C': {
                return (modifiers & 0x6200) == 0;
            }
            case '\n': {
                return (modifiers & 0x6000) == 0;
            }
            case '\t': {
                return (modifiers & 0x2200) == 0;
            }
            case 'I': {
                return (modifiers & 0x200) != 0;
            }
            case '\u000b': {
                return (modifiers & 0x2200) != 0;
            }
            case 'E': {
                return (modifiers & 0x4000) != 0;
            }
            case 'A': {
                return (modifiers & 0x2000) != 0;
            }
        }
        return true;
    }

    boolean match(char patternTypeSuffix, char[] patternPkg, char[] patternTypeName, int matchRule, int typeKind, char[] pkg, char[] typeName) {
        boolean isCaseSensitive;
        if (typeName == null) {
            typeName = CharOperation.NO_CHAR;
        }
        switch (patternTypeSuffix) {
            case 'C': {
                if (typeKind == 1) break;
                return false;
            }
            case '\n': {
                if (typeKind == 1 || typeKind == 2) break;
                return false;
            }
            case '\t': {
                if (typeKind == 1 || typeKind == 3) break;
                return false;
            }
            case 'I': {
                if (typeKind == 2) break;
                return false;
            }
            case '\u000b': {
                if (typeKind == 2 || typeKind == 4) break;
                return false;
            }
            case 'E': {
                if (typeKind == 3) break;
                return false;
            }
            case 'A': {
                if (typeKind == 4) break;
                return false;
            }
        }
        boolean bl = isCaseSensitive = (matchRule & 8) != 0;
        if (patternPkg != null && !CharOperation.equals(patternPkg, pkg, isCaseSensitive)) {
            return false;
        }
        if (patternTypeName != null) {
            boolean matchFirstChar;
            boolean isCamelCase = (matchRule & 0x80) != 0;
            int matchMode = matchRule & 7;
            if (!isCaseSensitive && !isCamelCase) {
                patternTypeName = CharOperation.toLowerCase(patternTypeName);
            }
            boolean bl2 = matchFirstChar = !isCaseSensitive || patternTypeName[0] == typeName[0];
            if (isCamelCase && matchFirstChar && CharOperation.camelCaseMatch(patternTypeName, typeName)) {
                return true;
            }
            switch (matchMode) {
                case 0: {
                    if (!isCamelCase) {
                        return matchFirstChar && CharOperation.equals(patternTypeName, typeName, isCaseSensitive);
                    }
                }
                case 1: {
                    return matchFirstChar && CharOperation.prefixEquals(patternTypeName, typeName, isCaseSensitive);
                }
                case 2: {
                    return CharOperation.match(patternTypeName, typeName, isCaseSensitive);
                }
            }
        }
        return true;
    }

    public void search(SearchPattern pattern, SearchParticipant[] participants, IJavaScriptSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        if (VERBOSE) {
            Util.verbose("BasicSearchEngine.search(SearchPattern, SearchParticipant[], IJavaScriptSearchScope, SearchRequestor, IProgressMonitor)");
        }
        this.findMatches(pattern, participants, scope, requestor, monitor);
    }

    /*
     * Exception decompiling
     */
    public void searchAllBindingNames(char[] packageName, char[] bindingName, int bindingType, int matchRule, IJavaScriptSearchScope scope, IRestrictedAccessBindingRequestor nameRequestor, int waitingPolicy, boolean doParse, IProgressMonitor progressMonitor) throws JavaScriptModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 1331->1335)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void searchAllSecondaryTypeNames(IPackageFragmentRoot[] sourceFolders, IRestrictedAccessTypeRequestor nameRequestor, boolean waitForIndexes, IProgressMonitor progressMonitor) throws JavaScriptModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 349->353)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void searchAllTypeNames(char[] packageName, int packageMatchRule, char[] typeName, int typeMatchRule, int searchFor, IJavaScriptSearchScope scope, IRestrictedAccessTypeRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws JavaScriptModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 976->980)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void searchAllTypeNames(char[][] qualifications, char[][] typeNames, int matchRule, int searchFor, IJavaScriptSearchScope scope, IRestrictedAccessTypeRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws JavaScriptModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 917->921)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void searchDeclarations(IJavaScriptElement enclosingElement, SearchRequestor requestor, SearchPattern pattern, IProgressMonitor monitor) throws JavaScriptModelException {
        if (VERBOSE) {
            Util.verbose("\t- java element: " + enclosingElement);
        }
        IJavaScriptSearchScope scope = BasicSearchEngine.createJavaSearchScope(new IJavaScriptElement[]{enclosingElement});
        IResource resource = enclosingElement.getResource();
        if (enclosingElement instanceof IMember) {
            IMember member = (IMember)enclosingElement;
            IJavaScriptUnit cu = member.getJavaScriptUnit();
            if (cu != null) {
                resource = cu.getResource();
            } else if (member.isBinary()) {
                resource = null;
            }
        }
        try {
            if (!(resource instanceof IFile)) {
                this.search(pattern, new SearchParticipant[]{BasicSearchEngine.getDefaultSearchParticipant()}, scope, requestor, monitor);
                return;
            }
            try {
                requestor.beginReporting();
                if (VERBOSE) {
                    Util.verbose("Searching for " + pattern + " in " + resource.getFullPath());
                }
                SearchParticipant participant = BasicSearchEngine.getDefaultSearchParticipant();
                SearchDocument[] documents = MatchLocator.addWorkingCopies(pattern, new SearchDocument[]{new JavaSearchDocument(enclosingElement.getPath().toString(), participant)}, this.getWorkingCopies(enclosingElement), participant);
                participant.locateMatches(documents, pattern, scope, requestor, monitor);
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                requestor.endReporting();
                throw throwable;
            }
            {
                Object var9_12 = null;
                requestor.endReporting();
                return;
            }
        }
        catch (CoreException e) {
            if (!(e instanceof JavaScriptModelException)) throw new JavaScriptModelException(e);
            throw (JavaScriptModelException)e;
        }
    }

    public void searchDeclarationsOfAccessedFields(IJavaScriptElement enclosingElement, SearchRequestor requestor, IProgressMonitor monitor) throws JavaScriptModelException {
        if (VERBOSE) {
            Util.verbose("BasicSearchEngine.searchDeclarationsOfAccessedFields(IJavaScriptElement, SearchRequestor, SearchPattern, IProgressMonitor)");
        }
        DeclarationOfAccessedFieldsPattern pattern = new DeclarationOfAccessedFieldsPattern(enclosingElement);
        this.searchDeclarations(enclosingElement, requestor, pattern, monitor);
    }

    public void searchDeclarationsOfReferencedTypes(IJavaScriptElement enclosingElement, SearchRequestor requestor, IProgressMonitor monitor) throws JavaScriptModelException {
        if (VERBOSE) {
            Util.verbose("BasicSearchEngine.searchDeclarationsOfReferencedTypes(IJavaScriptElement, SearchRequestor, SearchPattern, IProgressMonitor)");
        }
        DeclarationOfReferencedTypesPattern pattern = new DeclarationOfReferencedTypesPattern(enclosingElement);
        this.searchDeclarations(enclosingElement, requestor, pattern, monitor);
    }

    public void searchDeclarationsOfSentMessages(IJavaScriptElement enclosingElement, SearchRequestor requestor, IProgressMonitor monitor) throws JavaScriptModelException {
        if (VERBOSE) {
            Util.verbose("BasicSearchEngine.searchDeclarationsOfSentMessages(IJavaScriptElement, SearchRequestor, SearchPattern, IProgressMonitor)");
        }
        DeclarationOfReferencedMethodsPattern pattern = new DeclarationOfReferencedMethodsPattern(enclosingElement);
        this.searchDeclarations(enclosingElement, requestor, pattern, monitor);
    }
}

