/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.rewrite.describing;

import java.util.List;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionRef;
import org.eclipse.wst.jsdt.core.dom.FunctionRefParameter;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.MemberRef;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.core.tests.model.SuiteOfTestCases;
import org.eclipse.wst.jsdt.core.tests.rewrite.describing.ASTRewritingTest;

public class ASTRewritingJavadocTest
extends ASTRewritingTest {
    private static final Class THIS;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.rewrite.describing.ASTRewritingJavadocTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        THIS = clazz;
    }

    public ASTRewritingJavadocTest(String name) {
        super(name);
    }

    public static Test allTests() {
        return new SuiteOfTestCases.Suite(THIS);
    }

    public static Test setUpTest(Test someTest) {
        SuiteOfTestCases.Suite suite = new SuiteOfTestCases.Suite("one test");
        suite.addTest(someTest);
        return suite;
    }

    public static Test suite() {
        return ASTRewritingJavadocTest.allTests();
    }

    public void testParamName() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * @param name Hello World.\n");
        buf.append("     */\n");
        buf.append("    public void gee(String name) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingJavadocTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingJavadocTest.findMethodDeclaration(type, "gee");
        JSdoc javadoc = methodDecl.getJavadoc();
        List tags = javadoc.tags();
        ASTRewritingJavadocTest.assertTrue((String)"Has one tag", (tags.size() == 1 ? 1 : 0) != 0);
        TagElement tagElement = (TagElement)tags.get(0);
        List fragments = tagElement.fragments();
        ASTRewritingJavadocTest.assertTrue((String)"Has fragments", (!fragments.isEmpty() ? 1 : 0) != 0);
        SimpleName name = (SimpleName)fragments.get(0);
        rewrite.replace((ASTNode)name, (ASTNode)ast.newSimpleName("newName"), null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * @param newName Hello World.\n");
        buf.append("     */\n");
        buf.append("    public void gee(String name) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingJavadocTest.assertEqualString(preview, buf.toString());
    }

    public void testSeeTag1() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * @see String A String\n");
        buf.append("     */\n");
        buf.append("    public void gee(String name) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingJavadocTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingJavadocTest.findMethodDeclaration(type, "gee");
        JSdoc javadoc = methodDecl.getJavadoc();
        List tags = javadoc.tags();
        ASTRewritingJavadocTest.assertTrue((String)"Has one tag", (tags.size() == 1 ? 1 : 0) != 0);
        TagElement tagElement = (TagElement)tags.get(0);
        List fragments = tagElement.fragments();
        ASTRewritingJavadocTest.assertTrue((String)"Has fragments", (!fragments.isEmpty() ? 1 : 0) != 0);
        SimpleName name = (SimpleName)fragments.get(0);
        rewrite.replace((ASTNode)name, (ASTNode)ast.newSimpleName("Vector"), null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * @see Vector A String\n");
        buf.append("     */\n");
        buf.append("    public void gee(String name) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingJavadocTest.assertEqualString(preview, buf.toString());
    }

    public void testSeeTag2() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * @see #toString A String\n");
        buf.append("     */\n");
        buf.append("    public void gee(String name) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingJavadocTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingJavadocTest.findMethodDeclaration(type, "gee");
        JSdoc javadoc = methodDecl.getJavadoc();
        List tags = javadoc.tags();
        ASTRewritingJavadocTest.assertTrue((String)"Has one tag", (tags.size() == 1 ? 1 : 0) != 0);
        TagElement tagElement = (TagElement)tags.get(0);
        List fragments = tagElement.fragments();
        ASTRewritingJavadocTest.assertTrue((String)"Has fragments", (!fragments.isEmpty() ? 1 : 0) != 0);
        MemberRef ref = (MemberRef)fragments.get(0);
        rewrite.replace((ASTNode)ref.getName(), (ASTNode)ast.newSimpleName("hashCode"), null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * @see #hashCode A String\n");
        buf.append("     */\n");
        buf.append("    public void gee(String name) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingJavadocTest.assertEqualString(preview, buf.toString());
    }

    public void testSeeTag3() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * @see #toString A String\n");
        buf.append("     */\n");
        buf.append("    public void gee(String name) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingJavadocTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingJavadocTest.findMethodDeclaration(type, "gee");
        JSdoc javadoc = methodDecl.getJavadoc();
        List tags = javadoc.tags();
        ASTRewritingJavadocTest.assertTrue((String)"Has one tag", (tags.size() == 1 ? 1 : 0) != 0);
        TagElement tagElement = (TagElement)tags.get(0);
        List fragments = tagElement.fragments();
        ASTRewritingJavadocTest.assertTrue((String)"Has fragments", (!fragments.isEmpty() ? 1 : 0) != 0);
        MemberRef ref = (MemberRef)fragments.get(0);
        rewrite.set((ASTNode)ref, (StructuralPropertyDescriptor)MemberRef.QUALIFIER_PROPERTY, (Object)ast.newSimpleName("E"), null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * @see E#toString A String\n");
        buf.append("     */\n");
        buf.append("    public void gee(String name) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingJavadocTest.assertEqualString(preview, buf.toString());
    }

    public void testSeeTagParamInsert1() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * @see #toString() A String\n");
        buf.append("     */\n");
        buf.append("    public void gee(String name) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingJavadocTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingJavadocTest.findMethodDeclaration(type, "gee");
        JSdoc javadoc = methodDecl.getJavadoc();
        List tags = javadoc.tags();
        ASTRewritingJavadocTest.assertTrue((String)"Has one tag", (tags.size() == 1 ? 1 : 0) != 0);
        TagElement tagElement = (TagElement)tags.get(0);
        List fragments = tagElement.fragments();
        ASTRewritingJavadocTest.assertTrue((String)"Has fragments", (!fragments.isEmpty() ? 1 : 0) != 0);
        FunctionRef ref = (FunctionRef)fragments.get(0);
        FunctionRefParameter param = ast.newFunctionRefParameter();
        param.setName(ast.newSimpleName("arg"));
        param.setType((Type)ast.newPrimitiveType(PrimitiveType.INT));
        rewrite.getListRewrite((ASTNode)ref, FunctionRef.PARAMETERS_PROPERTY).insertLast((ASTNode)param, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * @see #toString(int arg) A String\n");
        buf.append("     */\n");
        buf.append("    public void gee(String name) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingJavadocTest.assertEqualString(preview, buf.toString());
    }

    public void testSeeTagParamInsert2() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * {@link #toString(int x) A String}\n");
        buf.append("     */\n");
        buf.append("    public void gee(String name) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingJavadocTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingJavadocTest.findMethodDeclaration(type, "gee");
        JSdoc javadoc = methodDecl.getJavadoc();
        List tags = javadoc.tags();
        ASTRewritingJavadocTest.assertTrue((String)"Has one tag", (tags.size() == 1 ? 1 : 0) != 0);
        TagElement topElement = (TagElement)tags.get(0);
        List fragments = topElement.fragments();
        ASTRewritingJavadocTest.assertTrue((String)"Has fragments", (!fragments.isEmpty() ? 1 : 0) != 0);
        TagElement tagElement = (TagElement)fragments.get(0);
        fragments = tagElement.fragments();
        ASTRewritingJavadocTest.assertTrue((String)"Has fragments", (!fragments.isEmpty() ? 1 : 0) != 0);
        FunctionRef ref = (FunctionRef)fragments.get(0);
        FunctionRefParameter param = ast.newFunctionRefParameter();
        param.setName(ast.newSimpleName("arg"));
        param.setType((Type)ast.newPrimitiveType(PrimitiveType.INT));
        rewrite.getListRewrite((ASTNode)ref, FunctionRef.PARAMETERS_PROPERTY).insertLast((ASTNode)param, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * {@link #toString(int x, int arg) A String}\n");
        buf.append("     */\n");
        buf.append("    public void gee(String name) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingJavadocTest.assertEqualString(preview, buf.toString());
    }

    public void testTagInsert1() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * @param name\n");
        buf.append("     */\n");
        buf.append("    public void gee(String name) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingJavadocTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingJavadocTest.findMethodDeclaration(type, "gee");
        JSdoc javadoc = methodDecl.getJavadoc();
        List tags = javadoc.tags();
        ASTRewritingJavadocTest.assertTrue((String)"Has one tag", (tags.size() == 1 ? 1 : 0) != 0);
        TagElement newTag = ast.newTagElement();
        newTag.setTagName("@throws");
        newTag.fragments().add(ast.newSimpleName("Exception"));
        TextElement text = ast.newTextElement();
        text.setText("Thrown for no reason.");
        newTag.fragments().add(text);
        rewrite.getListRewrite((ASTNode)javadoc, JSdoc.TAGS_PROPERTY).insertLast((ASTNode)newTag, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * @param name\n");
        buf.append("     * @throws Exception Thrown for no reason.\n");
        buf.append("     */\n");
        buf.append("    public void gee(String name) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingJavadocTest.assertEqualString(preview, buf.toString());
    }

    public void testTagInsert2() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * @param name\n");
        buf.append("     */\n");
        buf.append("    public void gee(String name) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingJavadocTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingJavadocTest.findMethodDeclaration(type, "gee");
        JSdoc javadoc = methodDecl.getJavadoc();
        List tags = javadoc.tags();
        ASTRewritingJavadocTest.assertTrue((String)"Has one tag", (tags.size() == 1 ? 1 : 0) != 0);
        TagElement newTag = ast.newTagElement();
        newTag.setTagName("@see");
        MemberRef ref = ast.newMemberRef();
        ref.setQualifier((Name)ast.newSimpleName("Vector"));
        ref.setName(ast.newSimpleName("size"));
        newTag.fragments().add(ref);
        rewrite.getListRewrite((ASTNode)javadoc, JSdoc.TAGS_PROPERTY).insertFirst((ASTNode)newTag, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * @see Vector#size\n");
        buf.append("     * @param name\n");
        buf.append("     */\n");
        buf.append("    public void gee(String name) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingJavadocTest.assertEqualString(preview, buf.toString());
    }

    public void testTagInsert3() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     */\n");
        buf.append("    public void gee(String name) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingJavadocTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingJavadocTest.findMethodDeclaration(type, "gee");
        JSdoc javadoc = methodDecl.getJavadoc();
        List tags = javadoc.tags();
        ASTRewritingJavadocTest.assertTrue((String)"Has one tag", (tags.size() == 0 ? 1 : 0) != 0);
        TagElement newTag = ast.newTagElement();
        newTag.setTagName(null);
        TextElement text = ast.newTextElement();
        text.setText("Comment");
        newTag.fragments().add(text);
        TagElement nested = ast.newTagElement();
        nested.setTagName("@link");
        newTag.fragments().add(nested);
        FunctionRef ref = ast.newFunctionRef();
        ref.setQualifier((Name)ast.newSimpleName("Vector"));
        ref.setName(ast.newSimpleName("size"));
        nested.fragments().add(ref);
        TextElement textNested = ast.newTextElement();
        textNested.setText("Link");
        nested.fragments().add(textNested);
        rewrite.getListRewrite((ASTNode)javadoc, JSdoc.TAGS_PROPERTY).insertFirst((ASTNode)newTag, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * Comment {@link Vector#size() Link}\n");
        buf.append("     */\n");
        buf.append("    public void gee(String name) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingJavadocTest.assertEqualString(preview, buf.toString());
    }

    public void testTagInsert4() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * @param name\n");
        buf.append("     */\n");
        buf.append("    public void gee(String name) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingJavadocTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingJavadocTest.findMethodDeclaration(type, "gee");
        JSdoc javadoc = methodDecl.getJavadoc();
        List tags = javadoc.tags();
        ASTRewritingJavadocTest.assertTrue((String)"Has one tag", (tags.size() == 1 ? 1 : 0) != 0);
        TagElement newTag = ast.newTagElement();
        newTag.setTagName("@throws");
        List fragments = newTag.fragments();
        fragments.add(ast.newSimpleName("Exception"));
        TextElement element1 = ast.newTextElement();
        element1.setText("Description line 1\n * Description line 2");
        fragments.add(element1);
        rewrite.getListRewrite((ASTNode)javadoc, JSdoc.TAGS_PROPERTY).insertLast((ASTNode)newTag, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * @param name\n");
        buf.append("     * @throws Exception Description line 1\n");
        buf.append("     * Description line 2\n");
        buf.append("     */\n");
        buf.append("    public void gee(String name) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingJavadocTest.assertEqualString(preview, buf.toString());
    }

    public void testTagRemove1() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * @param name\n");
        buf.append("     */\n");
        buf.append("    public void gee(String name) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = ASTRewritingJavadocTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingJavadocTest.findMethodDeclaration(type, "gee");
        JSdoc javadoc = methodDecl.getJavadoc();
        List tags = javadoc.tags();
        ASTRewritingJavadocTest.assertTrue((String)"Has one tag", (tags.size() == 1 ? 1 : 0) != 0);
        rewrite.remove((ASTNode)tags.get(0), null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     */\n");
        buf.append("    public void gee(String name) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingJavadocTest.assertEqualString(preview, buf.toString());
    }

    public void testTagRemove2() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * @param name1 The first name.\n");
        buf.append("     * @param name2 The second name.\n");
        buf.append("     */\n");
        buf.append("    public void gee(String name) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = ASTRewritingJavadocTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingJavadocTest.findMethodDeclaration(type, "gee");
        JSdoc javadoc = methodDecl.getJavadoc();
        List tags = javadoc.tags();
        ASTRewritingJavadocTest.assertTrue((String)"Has one tag", (tags.size() == 2 ? 1 : 0) != 0);
        rewrite.remove((ASTNode)tags.get(0), null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * @param name2 The second name.\n");
        buf.append("     */\n");
        buf.append("    public void gee(String name) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingJavadocTest.assertEqualString(preview, buf.toString());
    }

    public void testTagRemove3() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * @param name1 The first name.\n");
        buf.append("     * @param name2 The second name.\n");
        buf.append("     */\n");
        buf.append("    public void gee(String name) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = ASTRewritingJavadocTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingJavadocTest.findMethodDeclaration(type, "gee");
        JSdoc javadoc = methodDecl.getJavadoc();
        List tags = javadoc.tags();
        ASTRewritingJavadocTest.assertTrue((String)"Has one tag", (tags.size() == 2 ? 1 : 0) != 0);
        rewrite.remove((ASTNode)tags.get(1), null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * @param name1 The first name.\n");
        buf.append("     */\n");
        buf.append("    public void gee(String name) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingJavadocTest.assertEqualString(preview, buf.toString());
    }

    public void testTagRemove4() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("/**\n");
        buf.append(" * @author xy\n");
        buf.append(" */\n");
        buf.append("package test1;\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("package-info.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST3(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        rewrite.remove((ASTNode)astRoot.getPackage().getJavadoc(), null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        ASTRewritingJavadocTest.assertEqualString(preview, buf.toString());
    }

    public void testTagRemoveInsert() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * @param name1 The first name.\n");
        buf.append("     * @param name2 The second name.\n");
        buf.append("     */\n");
        buf.append("    public void gee(String name) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = ASTRewritingJavadocTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingJavadocTest.findMethodDeclaration(type, "gee");
        JSdoc javadoc = methodDecl.getJavadoc();
        List tags = javadoc.tags();
        ASTRewritingJavadocTest.assertTrue((String)"Has one tag", (tags.size() == 2 ? 1 : 0) != 0);
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)javadoc, JSdoc.TAGS_PROPERTY);
        listRewrite.remove((ASTNode)tags.get(1), null);
        AST ast = astRoot.getAST();
        TagElement element = ast.newTagElement();
        element.setTagName("@since");
        TextElement textElement = ast.newTextElement();
        textElement.setText("1.1");
        element.fragments().add(textElement);
        listRewrite.insertLast((ASTNode)element, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * @param name1 The first name.\n");
        buf.append("     * @since 1.1\n");
        buf.append("     */\n");
        buf.append("    public void gee(String name) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingJavadocTest.assertEqualString(preview, buf.toString());
    }

    public void testAddJavadoc() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    public void gee(String name) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = ASTRewritingJavadocTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingJavadocTest.findMethodDeclaration(type, "gee");
        JSdoc javadoc = ast.newJSdoc();
        TagElement element = ast.newTagElement();
        element.setTagName("@since");
        TextElement textElement = ast.newTextElement();
        textElement.setText("1.1");
        element.fragments().add(textElement);
        javadoc.tags().add(element);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.JAVADOC_PROPERTY, (Object)javadoc, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * @since 1.1\n");
        buf.append("     */\n");
        buf.append("    public void gee(String name) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingJavadocTest.assertEqualString(preview, buf.toString());
    }

    public void testAddJavadoc2() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    public int count;\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = ASTRewritingJavadocTest.findTypeDeclaration(astRoot, "E");
        FieldDeclaration fieldDecl = type.getFields()[0];
        JSdoc javadoc = ast.newJSdoc();
        TagElement element = ast.newTagElement();
        element.setTagName("@since");
        TextElement textElement = ast.newTextElement();
        textElement.setText("1.1");
        element.fragments().add(textElement);
        javadoc.tags().add(element);
        rewrite.set((ASTNode)fieldDecl, (StructuralPropertyDescriptor)FieldDeclaration.JAVADOC_PROPERTY, (Object)javadoc, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * @since 1.1\n");
        buf.append("     */\n");
        buf.append("    public int count;\n");
        buf.append("}\n");
        ASTRewritingJavadocTest.assertEqualString(preview, buf.toString());
    }

    public void testRemoveJavadoc() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * @since 1.1\n");
        buf.append("     */\n");
        buf.append("    static {\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = ASTRewritingJavadocTest.findTypeDeclaration(astRoot, "E");
        Initializer initializer = (Initializer)type.bodyDeclarations().get(0);
        rewrite.remove((ASTNode)initializer.getJavadoc(), null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    static {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingJavadocTest.assertEqualString(preview, buf.toString());
    }

    public void testRemoveJavadoc2() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("/**\n");
        buf.append(" * @since 1.1\n");
        buf.append(" */\n");
        buf.append("public class E {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = ASTRewritingJavadocTest.findTypeDeclaration(astRoot, "E");
        rewrite.remove((ASTNode)type.getJavadoc(), null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("}\n");
        ASTRewritingJavadocTest.assertEqualString(preview, buf.toString());
    }

    public void testMoveTags() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * @author Mr X\n");
        buf.append("     *         and friends\n");
        buf.append("     * @since 1.1\n");
        buf.append("     *         maybe less\n");
        buf.append("     */\n");
        buf.append("    static {\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = ASTRewritingJavadocTest.findTypeDeclaration(astRoot, "E");
        Initializer initializer = (Initializer)type.bodyDeclarations().get(0);
        JSdoc javadoc = initializer.getJavadoc();
        List tags = javadoc.tags();
        ASTNode node1 = (ASTNode)tags.get(0);
        ASTNode placeholder1 = rewrite.createMoveTarget(node1);
        ASTNode node2 = (ASTNode)tags.get(1);
        ASTNode placeholder2 = rewrite.createMoveTarget(node2);
        rewrite.replace(node1, placeholder2, null);
        rewrite.replace(node2, placeholder1, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * @since 1.1\n");
        buf.append("     *         maybe less\n");
        buf.append("     * @author Mr X\n");
        buf.append("     *         and friends\n");
        buf.append("     */\n");
        buf.append("    static {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingJavadocTest.assertEqualString(preview, buf.toString());
    }

    public void testChangeTagElement() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * Mr X\n");
        buf.append("     * @author Mr X\n");
        buf.append("     * @author Mr X\n");
        buf.append("     */\n");
        buf.append("    static {\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = ASTRewritingJavadocTest.findTypeDeclaration(astRoot, "E");
        Initializer initializer = (Initializer)type.bodyDeclarations().get(0);
        JSdoc javadoc = initializer.getJavadoc();
        List tags = javadoc.tags();
        TagElement elem1 = (TagElement)tags.get(0);
        rewrite.set((ASTNode)elem1, (StructuralPropertyDescriptor)TagElement.TAG_NAME_PROPERTY, (Object)"@param", null);
        TagElement elem2 = (TagElement)tags.get(1);
        rewrite.set((ASTNode)elem2, (StructuralPropertyDescriptor)TagElement.TAG_NAME_PROPERTY, (Object)"@param", null);
        TagElement elem3 = (TagElement)tags.get(2);
        rewrite.set((ASTNode)elem3, (StructuralPropertyDescriptor)TagElement.TAG_NAME_PROPERTY, null, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     * @paramMr X\n");
        buf.append("     * @param Mr X\n");
        buf.append("     *  Mr X\n");
        buf.append("     */\n");
        buf.append("    static {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingJavadocTest.assertEqualString(preview, buf.toString());
    }
}

