/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaModelTests;

public class SelectionJavadocModelTests
extends AbstractJavaModelTests {
    IJavaScriptElement element;
    static /* synthetic */ Class class$0;

    public SelectionJavadocModelTests(String name) {
        super(name, 3);
        this.displayName = true;
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.SelectionJavadocModelTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return SelectionJavadocModelTests.buildModelTestSuite(clazz);
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.setUpJavaProject("Tests", "1.5");
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject("Tests");
        super.tearDownSuite();
    }

    void setUnit(String name, String source) throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/Tests/" + name, source);
    }

    void assertElementEquals(String message, String expected) {
        this.assertElementEquals(message, expected, this.element);
    }

    void assertSelectionIsEmpty(IJavaScriptUnit unit, String selection) throws JavaScriptModelException {
        this.assertSelectionIsEmpty(unit, selection, 1);
    }

    void assertSelectionIsEmpty(IJavaScriptUnit unit, String selection, int occurences) throws JavaScriptModelException {
        int[] selectionPositions = this.selectionInfo(unit, selection, occurences);
        IJavaScriptElement[] elements = unit.codeSelect(selectionPositions[0], selectionPositions[1]);
        SelectionJavadocModelTests.assertTrue((String)"Selection should be empty", (elements == null || elements.length == 0 ? 1 : 0) != 0);
    }

    public void test00() throws JavaScriptModelException {
        this.setUnit("Test.js", "function bar() {\n\t\tfoo();\n}\nfunction foo() {}\n}\n");
        this.element = this.selectMethod(this.workingCopies[0], "foo");
        this.assertElementEquals("Invalid selected method", "foo() [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]");
    }

    public void test01() throws JavaScriptModelException {
        this.setUnit("Test.js", "function foo() {}\n}\nfunction bar() {\n\t\tfoo();\n}\n");
        this.element = this.selectMethod(this.workingCopies[0], "foo");
        this.assertElementEquals("Invalid selected method", "foo() [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]");
    }

    public void test01a() throws JavaScriptModelException {
        this.setUnit("Test.js", "function bar() {\n\t\tfoo();\n}\nfunction foo() {}\n}\n");
        this.element = this.selectMethod(this.workingCopies[0], "foo");
        this.assertElementEquals("Invalid selected method", "foo() [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]");
    }

    public void test02() throws JavaScriptModelException {
        this.setUnit("Test.js", "public class Test {\n\t/** {@link #foo() foo} */\n\tvoid bar() {\n\t\tfoo();\n\t}\n\tvoid foo() {}\n}\n");
        this.element = this.selectMethod(this.workingCopies[0], "foo");
        this.assertElementEquals("Invalid selected method", "foo() [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]");
    }

    public void test03() throws JavaScriptModelException {
        this.setUnit("Test.js", "public class Test {\n\t/** @see Test */\n\tvoid foo() {}\n}\n");
        this.element = this.selectType(this.workingCopies[0], "Test", 2);
        this.assertElementEquals("Invalid selected type", "Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]");
    }

    public void test04() throws JavaScriptModelException {
        this.setUnit("Test.js", "public class Test {\n\t/** Javadoc {@link Test} */\n\tvoid foo() {}\n}\n");
        this.element = this.selectType(this.workingCopies[0], "Test", 2);
        this.assertElementEquals("Invalid selected type", "Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]");
    }

    public void test05() throws JavaScriptModelException {
        this.setUnit("Test.js", "public class Test {\n\tint field;\n\t/** @see #field */\n\tvoid foo() {}\n}\n");
        this.element = this.selectField(this.workingCopies[0], "field", 2);
        this.assertElementEquals("Invalid selected field", "field [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]");
    }

    public void test06() throws JavaScriptModelException {
        this.setUnit("Test.js", "public class Test {\n\tint field;\n\t/**{@link #field}*/\n\tvoid foo() {}\n}\n");
        this.element = this.selectField(this.workingCopies[0], "field", 2);
        this.assertElementEquals("Invalid selected field", "field [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]");
    }

    public void test07() throws JavaScriptModelException {
        this.setUnit("Test.js", "public class Test {\n\t/**\n\t * @see Test#field\n\t * @see #foo(int, String)\n\t * @see Test#foo(int, String)\n\t */\n\tvoid bar() {\n\t\tfoo(0, \"\");\n\t}\n\tint field;\n\tvoid foo(int x, String s) {}\n}\n");
        IJavaScriptElement[] elements = new IJavaScriptElement[]{this.selectType(this.workingCopies[0], "Test", 2), this.selectField(this.workingCopies[0], "field"), this.selectMethod(this.workingCopies[0], "foo"), this.selectType(this.workingCopies[0], "String"), this.selectType(this.workingCopies[0], "Test", 3), this.selectMethod(this.workingCopies[0], "foo", 2), this.selectType(this.workingCopies[0], "String", 2)};
        this.assertElementsEqual("Invalid selection(s)", "Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]\nfield [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]\nfoo(int, String) [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]\nString [in String.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + " [in Tests]]]]\n" + "Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]\n" + "foo(int, String) [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]\n" + "String [in String.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + " [in Tests]]]]", elements);
    }

    public void test08() throws JavaScriptModelException {
        this.setUnit("Test.js", "public class Test {\n\t/**\n\t * First {@link #foo(int, String)}\n\t * Second {@link Test#foo(int, String) method foo}\n\t * Third {@link Test#field field}\n\t */\n\tvoid bar() {\n\t\tfoo(0, \"\");\n\t}\n\tint field;\n\tvoid foo(int x, String s) {}\n}\n");
        IJavaScriptElement[] elements = new IJavaScriptElement[]{this.selectType(this.workingCopies[0], "Test", 2), this.selectField(this.workingCopies[0], "field"), this.selectMethod(this.workingCopies[0], "foo"), this.selectType(this.workingCopies[0], "String"), this.selectType(this.workingCopies[0], "Test", 3), this.selectMethod(this.workingCopies[0], "foo", 2), this.selectType(this.workingCopies[0], "String", 2)};
        this.assertElementsEqual("Invalid selection(s)", "Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]\nfield [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]\nfoo(int, String) [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]\nString [in String.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + " [in Tests]]]]\n" + "Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]\n" + "foo(int, String) [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]\n" + "String [in String.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + " [in Tests]]]]", elements);
    }

    public void test09() throws JavaScriptModelException {
        this.setUnit("test/junit/Test.js", "package test.junit;\npublic class Test {\n\t/**\n\t * @see test.junit.Test\n\t * @see test.junit.Test#field\n\t * @see test.junit.Test#foo(Object[] array)\n\t */\n\tvoid bar() {\n\t\tfoo(null);\n\t}\n\tint field;\n\tvoid foo(Object[] array) {}\n}\n");
        IJavaScriptElement[] elements = new IJavaScriptElement[6];
        this.assertSelectionIsEmpty(this.workingCopies[0], "test", 2);
        this.assertSelectionIsEmpty(this.workingCopies[0], "junit", 2);
        elements[0] = this.selectType(this.workingCopies[0], "Test", 2);
        this.assertSelectionIsEmpty(this.workingCopies[0], "test", 3);
        this.assertSelectionIsEmpty(this.workingCopies[0], "junit", 3);
        elements[1] = this.selectType(this.workingCopies[0], "Test", 3);
        elements[2] = this.selectField(this.workingCopies[0], "field");
        this.assertSelectionIsEmpty(this.workingCopies[0], "test", 4);
        this.assertSelectionIsEmpty(this.workingCopies[0], "junit", 4);
        elements[3] = this.selectType(this.workingCopies[0], "Test", 4);
        elements[4] = this.selectMethod(this.workingCopies[0], "foo");
        elements[5] = this.selectType(this.workingCopies[0], "Object");
        this.assertSelectionIsEmpty(this.workingCopies[0], "array");
        this.assertElementsEqual("Invalid selection(s)", "Test [in [Working copy] Test.js [in test.junit [in <project root> [in Tests]]]]\nTest [in [Working copy] Test.js [in test.junit [in <project root> [in Tests]]]]\nfield [in Test [in [Working copy] Test.js [in test.junit [in <project root> [in Tests]]]]]\nTest [in [Working copy] Test.js [in test.junit [in <project root> [in Tests]]]]\nfoo(Object[]) [in Test [in [Working copy] Test.js [in test.junit [in <project root> [in Tests]]]]]\nObject [in Object.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + " [in Tests]]]]", elements);
    }

    public void test10() throws JavaScriptModelException {
        this.setUnit("test/junit/Test.js", "package test.junit;\npublic class Test {\n\t/** Javadoc {@linkplain test.junit.Test}\n\t * {@linkplain test.junit.Test#field field}\n\t * last line {@linkplain test.junit.Test#foo(Object[] array) foo(Object[])}\n\t */\n\tvoid bar() {\n\t\tfoo(null);\n\t}\n\tint field;\n\tvoid foo(Object[] array) {}\n}\n");
        IJavaScriptElement[] elements = new IJavaScriptElement[6];
        this.assertSelectionIsEmpty(this.workingCopies[0], "test", 2);
        this.assertSelectionIsEmpty(this.workingCopies[0], "junit", 2);
        elements[0] = this.selectType(this.workingCopies[0], "Test", 2);
        this.assertSelectionIsEmpty(this.workingCopies[0], "test", 3);
        this.assertSelectionIsEmpty(this.workingCopies[0], "junit", 3);
        elements[1] = this.selectType(this.workingCopies[0], "Test", 3);
        elements[2] = this.selectField(this.workingCopies[0], "field");
        this.assertSelectionIsEmpty(this.workingCopies[0], "test", 4);
        this.assertSelectionIsEmpty(this.workingCopies[0], "junit", 4);
        elements[3] = this.selectType(this.workingCopies[0], "Test", 4);
        elements[4] = this.selectMethod(this.workingCopies[0], "foo");
        elements[5] = this.selectType(this.workingCopies[0], "Object");
        this.assertSelectionIsEmpty(this.workingCopies[0], "array");
        this.assertElementsEqual("Invalid selection(s)", "Test [in [Working copy] Test.js [in test.junit [in <project root> [in Tests]]]]\nTest [in [Working copy] Test.js [in test.junit [in <project root> [in Tests]]]]\nfield [in Test [in [Working copy] Test.js [in test.junit [in <project root> [in Tests]]]]]\nTest [in [Working copy] Test.js [in test.junit [in <project root> [in Tests]]]]\nfoo(Object[]) [in Test [in [Working copy] Test.js [in test.junit [in <project root> [in Tests]]]]]\nObject [in Object.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + " [in Tests]]]]", elements);
    }

    public void test11() throws JavaScriptModelException {
        this.setUnit("Test.js", "public class Test {\n\t/**\n\t * @throws RuntimeException runtime exception\n\t * @throws InterruptedException interrupted exception\n\t */\n\tvoid foo() {}\n}\n");
        IJavaScriptElement[] elements = new IJavaScriptElement[]{this.selectType(this.workingCopies[0], "RuntimeException"), this.selectType(this.workingCopies[0], "InterruptedException")};
        this.assertElementsEqual("Invalid selection(s)", "RuntimeException [in RuntimeException.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + " [in Tests]]]]\n" + "InterruptedException [in InterruptedException.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + " [in Tests]]]]", elements);
    }

    public void test12() throws JavaScriptModelException {
        this.setUnit("Test.js", "public class Test {\n\t/**\n\t * @exception RuntimeException runtime exception\n\t * @exception InterruptedException interrupted exception\n\t */\n\tvoid foo() {}\n}\n");
        IJavaScriptElement[] elements = new IJavaScriptElement[]{this.selectType(this.workingCopies[0], "RuntimeException"), this.selectType(this.workingCopies[0], "InterruptedException")};
        this.assertElementsEqual("Invalid selection(s)", "RuntimeException [in RuntimeException.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + " [in Tests]]]]\n" + "InterruptedException [in InterruptedException.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + " [in Tests]]]]", elements);
    }

    public void test13() throws JavaScriptModelException {
        this.setUnit("Test.js", "public class Test {\n\t/**\n\t * @param xxx integer param\n\t * @param str string param\n\t */\n\tvoid foo(int xxx, String str) {}\n}\n");
        IJavaScriptElement[] elements = new IJavaScriptElement[]{this.selectLocalVariable(this.workingCopies[0], "xxx"), this.selectLocalVariable(this.workingCopies[0], "str")};
        this.assertElementsEqual("Invalid selection(s)", "xxx [in foo(int, String) [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]\nstr [in foo(int, String) [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]", elements);
    }

    public void test14() throws JavaScriptModelException {
        this.setUnit("Test.js", "/**\n * Javadoc of {@link Test}\n * @see Field#foo\n */\npublic class Test {}\n/**\n * Javadoc on {@link Field} to test selection in javadoc field references\n * @see #foo\n */\nclass Field {\n\t/**\n\t * Javadoc on {@link #foo} to test selection in javadoc field references\n\t * @see #foo\n\t * @see Field#foo\n\t */\n\tint foo;\n}\n");
        IJavaScriptElement[] elements = new IJavaScriptElement[]{this.selectType(this.workingCopies[0], "Test", 2), this.selectType(this.workingCopies[0], "Field"), this.selectField(this.workingCopies[0], "foo"), this.selectType(this.workingCopies[0], "Field", 2), this.selectField(this.workingCopies[0], "foo", 2), this.selectField(this.workingCopies[0], "foo", 3), this.selectField(this.workingCopies[0], "foo", 4), this.selectType(this.workingCopies[0], "Field", 4), this.selectField(this.workingCopies[0], "foo", 5)};
        this.assertElementsEqual("Invalid selection(s)", "Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]\nField [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]\nfoo [in Field [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]\nField [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]\nfoo [in Field [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]\nfoo [in Field [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]\nfoo [in Field [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]\nField [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]\nfoo [in Field [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]", elements);
    }

    public void test15() throws JavaScriptModelException {
        this.setUnit("Test.js", "/**\n * Javadoc of {@link Test}\n * @see Method#foo\n */\npublic class Test {}\n/**\n * Javadoc on {@link Method} to test selection in javadoc method references\n * @see #foo\n */\nclass Method {\n\t/**\n\t * Javadoc on {@link #foo} to test selection in javadoc method references\n\t * @see #foo\n\t * @see Method#foo\n\t */\n\tvoid bar() {}\n\t/**\n\t * Method with parameter and throws clause to test selection in javadoc\n\t * @param xxx TODO\n\t * @param str TODO\n\t * @throws RuntimeException blabla\n\t * @throws InterruptedException bloblo\n\t */\n\tvoid foo(int xxx, String str) throws RuntimeException, InterruptedException {}\n}\n");
        IJavaScriptElement[] elements = new IJavaScriptElement[]{this.selectType(this.workingCopies[0], "Test", 2), this.selectType(this.workingCopies[0], "Method"), this.selectMethod(this.workingCopies[0], "foo"), this.selectType(this.workingCopies[0], "Method", 2), this.selectMethod(this.workingCopies[0], "foo", 2), this.selectMethod(this.workingCopies[0], "foo", 3), this.selectMethod(this.workingCopies[0], "foo", 4), this.selectType(this.workingCopies[0], "Method", 4), this.selectMethod(this.workingCopies[0], "foo", 5), this.selectLocalVariable(this.workingCopies[0], "xxx"), this.selectLocalVariable(this.workingCopies[0], "str"), this.selectType(this.workingCopies[0], "RuntimeException"), this.selectType(this.workingCopies[0], "InterruptedException")};
        this.assertElementsEqual("Invalid selection(s)", "Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]\nMethod [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]\nfoo(int, String) [in Method [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]\nMethod [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]\nfoo(int, String) [in Method [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]\nfoo(int, String) [in Method [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]\nfoo(int, String) [in Method [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]\nMethod [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]\nfoo(int, String) [in Method [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]\nxxx [in foo(int, String) [in Method [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]\nstr [in foo(int, String) [in Method [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]\nRuntimeException [in RuntimeException.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + " [in Tests]]]]\n" + "InterruptedException [in InterruptedException.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + " [in Tests]]]]", elements);
    }

    public void test16() throws JavaScriptModelException {
        this.setUnit("Test.js", "/**\n * Javadoc of {@link Test}\n * @see Other\n */\npublic class Test {}\n/**\n * Javadoc of {@link Other}\n * @see Test\n */\nclass Other {}\n");
        IJavaScriptElement[] elements = new IJavaScriptElement[]{this.selectType(this.workingCopies[0], "Test"), this.selectType(this.workingCopies[0], "Other"), this.selectType(this.workingCopies[0], "Test", 3), this.selectType(this.workingCopies[0], "Other", 2)};
        this.assertElementsEqual("Invalid selection(s)", "Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]\nOther [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]\nTest [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]\nOther [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]", elements);
    }

    public void test17() throws JavaScriptModelException {
        this.setUnit("Test.js", "/**\n * @see Test.Field#foo\n */\npublic class Test {\n\t/**\n\t * @see Field#foo\n\t */\n\tclass Field {\n\t\t/**\n\t\t * @see #foo\n\t\t * @see Field#foo\n\t\t * @see Test.Field#foo\n\t\t */\n\t\tint foo;\n\t}\n}\n");
        IJavaScriptElement[] elements = new IJavaScriptElement[]{this.selectType(this.workingCopies[0], "Test", 2), this.selectType(this.workingCopies[0], "Field"), this.selectField(this.workingCopies[0], "foo"), this.selectType(this.workingCopies[0], "Field", 2), this.selectField(this.workingCopies[0], "foo", 2), this.selectField(this.workingCopies[0], "foo", 3), this.selectType(this.workingCopies[0], "Field", 4), this.selectField(this.workingCopies[0], "foo", 4), this.selectType(this.workingCopies[0], "Test", 3), this.selectType(this.workingCopies[0], "Field", 5), this.selectField(this.workingCopies[0], "foo", 5)};
        this.assertElementsEqual("Invalid selection(s)", "Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]\nField [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]\nfoo [in Field [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]\nField [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]\nfoo [in Field [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]\nfoo [in Field [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]\nField [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]\nfoo [in Field [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]\nTest [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]\nField [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]\nfoo [in Field [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]", elements);
    }

    public void test18() throws JavaScriptModelException {
        this.setUnit("Test.js", "/**\n * @see Test.Method#foo()\n */\npublic class Test {\n\t/**\n\t * @see Method#foo()\n\t */\n\tclass Method {\n\t\t/**\n\t\t * @see #foo()\n\t\t * @see Method#foo()\n\t\t * @see Test.Method#foo()\n\t\t */\n\t\tvoid foo() {}\n\t}\n}");
        IJavaScriptElement[] elements = new IJavaScriptElement[]{this.selectType(this.workingCopies[0], "Test", 2), this.selectType(this.workingCopies[0], "Method"), this.selectMethod(this.workingCopies[0], "foo"), this.selectType(this.workingCopies[0], "Method", 2), this.selectMethod(this.workingCopies[0], "foo", 2), this.selectMethod(this.workingCopies[0], "foo", 3), this.selectType(this.workingCopies[0], "Method", 4), this.selectMethod(this.workingCopies[0], "foo", 4), this.selectType(this.workingCopies[0], "Test", 3), this.selectType(this.workingCopies[0], "Method", 5), this.selectMethod(this.workingCopies[0], "foo", 5)};
        this.assertElementsEqual("Invalid selection(s)", "Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]\nMethod [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]\nfoo() [in Method [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]\nMethod [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]\nfoo() [in Method [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]\nfoo() [in Method [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]\nMethod [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]\nfoo() [in Method [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]\nTest [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]\nMethod [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]\nfoo() [in Method [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]", elements);
    }

    public void test19() throws JavaScriptModelException {
        this.setUnit("Test.js", "/**\n * @see Test.Other\n */\npublic class Test {\n\t/**\n\t * @see Test\n\t * @see Other\n\t * @see Test.Other\n\t */\n\tclass Other {}\n}");
        IJavaScriptElement[] elements = new IJavaScriptElement[]{this.selectType(this.workingCopies[0], "Test"), this.selectType(this.workingCopies[0], "Other"), this.selectType(this.workingCopies[0], "Test", 3), this.selectType(this.workingCopies[0], "Other", 2), this.selectType(this.workingCopies[0], "Test", 4), this.selectType(this.workingCopies[0], "Other", 3)};
        this.assertElementsEqual("Invalid selection(s)", "Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]\nOther [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]\nTest [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]\nOther [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]\nTest [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]\nOther [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]", elements);
    }

    public void test20() throws JavaScriptModelException {
        this.setUnit("Test.js", "public class Test {\n\tvoid bar() {\n\t\t/**\n\t\t * @see Field#foo\n\t\t */\n\t\tclass Field {\n\t\t\t/**\n\t\t\t * @see #foo\n\t\t\t * @see Field#foo\n\t\t\t */\n\t\t\tint foo;\n\t\t}\n\t}\n}\n");
        IJavaScriptElement[] elements = new IJavaScriptElement[]{this.selectType(this.workingCopies[0], "Field"), this.selectField(this.workingCopies[0], "foo"), this.selectField(this.workingCopies[0], "foo", 2), this.selectType(this.workingCopies[0], "Field", 3), this.selectField(this.workingCopies[0], "foo", 3)};
        this.assertElementsEqual("Invalid selection(s)", "Field [in bar() [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]\nfoo [in Field [in bar() [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]]\nfoo [in Field [in bar() [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]]\nField [in bar() [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]\nfoo [in Field [in bar() [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]]", elements);
    }

    public void test21() throws JavaScriptModelException {
        this.setUnit("Test.js", "public class Test {\n\tvoid bar() {\n\t\t/**\n\t\t * @see Method#foo()\n\t\t */\n\t\tclass Method {\n\t\t\t/**\n\t\t\t * @see #foo()\n\t\t\t * @see Method#foo()\n\t\t\t */\n\t\t\tvoid foo() {}\n\t\t}\n\t}\n}");
        IJavaScriptElement[] elements = new IJavaScriptElement[]{this.selectType(this.workingCopies[0], "Method"), this.selectMethod(this.workingCopies[0], "foo"), this.selectMethod(this.workingCopies[0], "foo", 2), this.selectType(this.workingCopies[0], "Method", 3), this.selectMethod(this.workingCopies[0], "foo", 3)};
        this.assertElementsEqual("Invalid selection(s)", "Method [in bar() [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]\nfoo() [in Method [in bar() [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]]\nfoo() [in Method [in bar() [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]]\nMethod [in bar() [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]\nfoo() [in Method [in bar() [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]]", elements);
    }

    public void test22() throws JavaScriptModelException {
        this.setUnit("Test.js", "public class Test {\n\tvoid bar() {\n\t\t/**\n\t\t * @see Test\n\t\t * @see Other\n\t\t */\n\t\tclass Other {}\n\t}\n}");
        IJavaScriptElement[] elements = new IJavaScriptElement[]{this.selectType(this.workingCopies[0], "Test", 2), this.selectType(this.workingCopies[0], "Other")};
        this.assertElementsEqual("Invalid selection(s)", "Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]\nOther [in bar() [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]", elements);
    }

    public void test23() throws JavaScriptModelException {
        this.setUnit("Test.js", "public class Test {\n\tvoid bar() {\n\t\tnew Object() {\n\t\t\t/**\n\t\t\t * @see Field#foo\n\t\t\t */\n\t\t\tclass Field {\n\t\t\t\t/**\n\t\t\t\t * @see #foo\n\t\t\t\t * @see Field#foo\n\t\t\t\t */\n\t\t\t\tint foo;\n\t\t\t}\n\t\t};\n\t}\n}\n");
        IJavaScriptElement[] elements = new IJavaScriptElement[]{this.selectType(this.workingCopies[0], "Field"), this.selectField(this.workingCopies[0], "foo"), this.selectField(this.workingCopies[0], "foo", 2), this.selectType(this.workingCopies[0], "Field", 3), this.selectField(this.workingCopies[0], "foo", 3)};
        this.assertElementsEqual("Invalid selection(s)", "Field [in <anonymous #1> [in bar() [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]]\nfoo [in Field [in <anonymous #1> [in bar() [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]]]\nfoo [in Field [in <anonymous #1> [in bar() [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]]]\nField [in <anonymous #1> [in bar() [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]]\nfoo [in Field [in <anonymous #1> [in bar() [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]]]", elements);
    }

    public void test24() throws JavaScriptModelException {
        this.setUnit("Test.js", "public class Test {\n\tvoid bar() {\n\t\tnew Object() {\n\t\t\t/**\n\t\t\t * @see Method#foo()\n\t\t\t */\n\t\t\tclass Method {\n\t\t\t\t/**\n\t\t\t\t * @see #foo()\n\t\t\t\t * @see Method#foo()\n\t\t\t\t */\n\t\t\t\tvoid foo() {}\n\t\t\t}\n\t\t};\n\t}\n}");
        IJavaScriptElement[] elements = new IJavaScriptElement[]{this.selectType(this.workingCopies[0], "Method"), this.selectMethod(this.workingCopies[0], "foo"), this.selectMethod(this.workingCopies[0], "foo", 2), this.selectType(this.workingCopies[0], "Method", 3), this.selectMethod(this.workingCopies[0], "foo", 3)};
        this.assertElementsEqual("Invalid selection(s)", "Method [in <anonymous #1> [in bar() [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]]\nfoo() [in Method [in <anonymous #1> [in bar() [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]]]\nfoo() [in Method [in <anonymous #1> [in bar() [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]]]\nMethod [in <anonymous #1> [in bar() [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]]\nfoo() [in Method [in <anonymous #1> [in bar() [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]]]", elements);
    }

    public void test25() throws JavaScriptModelException {
        this.setUnit("Test.js", "public class Test {\n\tvoid bar() {\n\t\tnew Object() {\n\t\t\t/**\n\t\t\t * @see Test\n\t\t\t * @see Other\n\t\t\t */\n\t\t\tclass Other {}\n\t\t};\n\t}\n}");
        IJavaScriptElement[] elements = new IJavaScriptElement[]{this.selectType(this.workingCopies[0], "Test", 2), this.selectType(this.workingCopies[0], "Other")};
        this.assertElementsEqual("Invalid selection(s)", "Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]\nOther [in <anonymous #1> [in bar() [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]]]", elements);
    }

    public void test26() throws JavaScriptModelException {
        this.setUnit("Test.js", "public class Test {\n\tstatic int field;\n\t/** \n\t * First {@value #field}\t * Second {@value Test#field}\t */\n\tvoid foo() {}\n}\n");
        IJavaScriptElement[] elements = new IJavaScriptElement[]{this.selectField(this.workingCopies[0], "field"), this.selectType(this.workingCopies[0], "Test"), this.selectField(this.workingCopies[0], "field")};
        this.assertElementsEqual("Invalid selection(s)", "field [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]\nTest [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]\nfield [in Test [in [Working copy] Test.js [in <default> [in <project root> [in Tests]]]]]", elements);
    }

    public void testBug86380() throws CoreException {
        this.wcOwner = new WorkingCopyOwner(){};
        this.workingCopies = new IJavaScriptUnit[2];
        this.workingCopies[0] = this.getWorkingCopy("/Tests/b86380/package-info.js", "/**\n * Valid javadoc.\n * @see Test\n * @see Unknown\n * @see Test#foo()\n * @see Test#unknown()\n * @see Test#field\n * @see Test#unknown\n * @param unexpected\n * @throws unexpected\n * @return unexpected \n */\npackage b86380;\n", this.wcOwner, null);
        this.workingCopies[1] = this.getWorkingCopy("/Tests/b86380/Test.js", "/**\n * Invalid javadoc\n */\npackage b86380;\npublic class Test {\n\tpublic int field;\n\tpublic void foo() {}\n}\n", this.wcOwner, null);
        IJavaScriptElement[] elements = new IJavaScriptElement[]{this.selectType(this.workingCopies[0], "Test"), this.selectMethod(this.workingCopies[0], "foo"), this.selectField(this.workingCopies[0], "field")};
        this.assertElementsEqual("Invalid selection(s)", "Test [in [Working copy] Test.js [in b86380 [in <project root> [in Tests]]]]\nfoo() [in Test [in [Working copy] Test.js [in b86380 [in <project root> [in Tests]]]]]\nfield [in Test [in [Working copy] Test.js [in b86380 [in <project root> [in Tests]]]]]", elements);
    }

    public void testBug90266_String() throws JavaScriptModelException {
        this.setUnit("b90266/Test.js", "package b90266;\npublic class Test {\n\tpublic int field;\n\tpublic void foo(String str, int i) {}\n\tpublic void bar() {\n\t\tfoo(\"String including / (slash)\", this.field)\n\t}\n}\n");
        int[] selectionPositions = this.selectionInfo(this.workingCopies[0], "field", 2);
        IJavaScriptElement[] elements = this.workingCopies[0].codeSelect(selectionPositions[0], 0);
        this.assertElementsEqual("Invalid selection(s)", "field [in Test [in [Working copy] Test.js [in b90266 [in <project root> [in Tests]]]]]", elements);
    }

    public void testBug90266_Char() throws JavaScriptModelException {
        this.setUnit("b90266/Test.js", "package b90266;\npublic class Test {\n\tpublic int field;\n\tpublic void foo(Char c, int i) {}\n\tpublic void bar() {\n\t\tfoo('/', this.field)\n\t}\n}\n");
        int[] selectionPositions = this.selectionInfo(this.workingCopies[0], "field", 2);
        IJavaScriptElement[] elements = this.workingCopies[0].codeSelect(selectionPositions[0], 0);
        this.assertElementsEqual("Invalid selection(s)", "field [in Test [in [Working copy] Test.js [in b90266 [in <project root> [in Tests]]]]]", elements);
    }

    public void testBug165701() throws JavaScriptModelException {
        this.setUnit("b165701/Test.js", "package b165701;\n/**\n * @see #fooo(int)\n */\npublic class Test {\n\tpublic void foo() {}\n}\n");
        int[] selectionPositions = this.selectionInfo(this.workingCopies[0], "fooo", 1);
        IJavaScriptElement[] elements = this.workingCopies[0].codeSelect(selectionPositions[0], 0);
        this.assertElementsEqual("Invalid selection(s)", "Test [in [Working copy] Test.js [in b165701 [in <project root> [in Tests]]]]", elements);
    }

    public void testBug165794() throws JavaScriptModelException {
        this.setUnit("b165794/Test.js", "package b165794;\n/**\n * No reasonable hint for resolving the {@link #getMax(A)}.\n */\npublic class X {\n    /**\n     * Extends Number method.\n     * @see #getMax(A ipZ)\n     */\n    public <T extends Y> T getMax(final A<T> ipY) {\n        return ipY.t();\n    }\n    \n    /**\n     * Extends Exception method.\n     * @see #getMax(A ipY)\n     */\n    public <T extends Z> T getMax(final A<T> ipZ) {\n        return ipZ.t();\n    }\n}\nclass A<T> {\n\tT t() { return null; }\n}\nclass Y {}\nclass Z {}");
        int[] selectionPositions = this.selectionInfo(this.workingCopies[0], "getMax", 1);
        IJavaScriptElement[] elements = this.workingCopies[0].codeSelect(selectionPositions[0], 0);
        this.assertElementsEqual("Invalid selection(s)", "getMax(A<T>) [in X [in [Working copy] Test.js [in b165794 [in <project root> [in Tests]]]]]", elements);
    }
}

