/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.util.ArrayList;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.ElementChangedEvent;
import org.eclipse.wst.jsdt.core.IElementChangedListener;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptElementDelta;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;
import org.eclipse.wst.jsdt.internal.core.DeltaProcessingState;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;

public class JavaElementDeltaTests
extends ModifyingResourceTests {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.JavaElementDeltaTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return JavaElementDeltaTests.buildModelTestSuite(clazz);
    }

    public JavaElementDeltaTests(String name) {
        super(name);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddCommentAndCommit() throws CoreException {
        DeltaListener listener = new DeltaListener(1);
        IJavaScriptUnit copy = null;
        try {
            this.createJavaProject("P", new String[]{""}, "");
            this.createFile("P/X.js", "function X() {\n}");
            IJavaScriptUnit unit = this.getCompilationUnit("P", "", "", "X.js");
            copy = unit.getWorkingCopy(null);
            copy.getBuffer().setContents("function X(){\n  // some comment\n}");
            JavaScriptCore.addElementChangedListener((IElementChangedListener)listener, (int)1);
            copy.commitWorkingCopy(true, null);
            JavaElementDeltaTests.assertEquals((String)"Unexpected delta after committing working copy", (String)"P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.js[*]: {CONTENT | FINE GRAINED | PRIMARY RESOURCE}", (String)listener.toString());
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            JavaScriptCore.removeElementChangedListener((IElementChangedListener)listener);
            if (copy != null) {
                copy.discardWorkingCopy();
            }
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        JavaScriptCore.removeElementChangedListener((IElementChangedListener)listener);
        if (copy != null) {
            copy.discardWorkingCopy();
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddCuInDefaultPkg1() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{""}, "");
            this.startDeltas();
            this.createFile("P/X.js", "function X() {\n}");
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.js[+]: {}");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddCuInDefaultPkg2() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"}, "bin");
            this.startDeltas();
            this.createFile("P/src/X.js", "function X() {\n}");
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.js[+]: {}");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddCuAfterProjectOpen() throws CoreException {
        try {
            IJavaScriptProject p1 = this.createJavaProject("P1", new String[]{"src"}, "bin");
            IJavaScriptProject p2 = this.createJavaProject("P2", new String[]{"src"}, "bin");
            this.createFile("P2/src/X.js", "function X() {\n}");
            IProject project = p2.getProject();
            project.close(null);
            p1.setRawIncludepath(new IIncludePathEntry[0], null);
            project.open(null);
            this.startDeltas();
            this.createFile("P2/src/Y.js", "function Y() {\n}");
            this.assertDeltas("Unexpected delta", "P2[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tY.js[+]: {}");
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.stopDeltas();
            this.deleteProject("P1");
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.stopDeltas();
        this.deleteProject("P1");
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddDotClasspathFile() throws CoreException {
        try {
            this.createProject("P");
            this.createFolder("/P/src");
            this.editFile("/P/.project", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>Test</name>\n\t<comment></comment>\n\t<projects>\n\t</projects>\n\t<buildSpec>\n\t\t<buildCommand>\n\t\t\t<name>org.eclipse.wst.jsdt.core.jsbuilder</name>\n\t\t\t<arguments>\n\t\t\t</arguments>\n\t\t</buildCommand>\n\t</buildSpec>\n\t<natures>\n\t\t<nature>org.eclipse.wst.jsdt.core.jsnature</nature>\n\t</natures>\n</projectDescription>");
            this.startDeltas();
            this.createFile("P/.classpath", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n    <classpathentry kind=\"src\" path=\"src\"/>\n    <classpathentry kind=\"output\" path=\"bin\"/>\n</classpath>");
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {REMOVED FROM CLASSPATH}\n\tsrc[*]: {ADDED TO CLASSPATH}\n\tResourceDelta(/P/.classpath)[+]");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddFileToNonJavaProject() throws CoreException {
        try {
            this.createProject("P");
            this.startDeltas();
            this.createFile("/P/toto.txt", "");
            this.assertDeltas("Unexpected delta", "ResourceDelta(/P)");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddFolderInNonJavaFolder() throws CoreException {
        try {
            this.createJavaProject("P");
            this.createFolder("/P/META-INF");
            this.startDeltas();
            this.createFolder("/P/META-INF/folder");
            this.assertDeltas("Unexpected delta", "P[*]: {CONTENT}\n\tResourceDelta(/P/META-INF)[*]");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddInvalidSubfolder() throws CoreException {
        try {
            this.createJavaProject("P");
            this.startDeltas();
            this.createFolder("/P/p/.folder");
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\tp[+]: {}");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddJavaNature() throws CoreException {
        try {
            this.createProject("P");
            this.startDeltas();
            this.addJavaNature("P");
            this.assertDeltas("Unexpected delta", "P[+]: {}\nResourceDelta(/P)");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddJavaNatureAndClasspath() throws CoreException {
        try {
            this.createProject("P");
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    JavaElementDeltaTests.this.addJavaNature("P");
                    JavaElementDeltaTests.this.createFolder("/P/src");
                    JavaElementDeltaTests.this.getJavaProject("P").setRawIncludepath(new IIncludePathEntry[]{JavaScriptCore.newSourceEntry((IPath)new Path("/P/src"))}, (IPath)new Path("/P/bin"), null);
                }
            }, null);
            this.startDeltas();
            this.createFile("/P/src/file.txt", "");
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\tsrc[*]: {CONTENT}\n\t\tResourceDelta(/P/src/file.txt)[+]");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddJavaProject() throws CoreException {
        try {
            this.startDeltas();
            this.createJavaProject("P", new String[]{""}, "");
            this.assertDeltas("Unexpected delta", "P[+]: {}");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddNonJavaProject() throws CoreException {
        try {
            this.startDeltas();
            this.createProject("P");
            this.assertDeltas("Should get a non-Java resource delta", "ResourceDelta(/P)");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddPackageSourceIsBin() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"}, "src");
            this.startDeltas();
            this.createFolder("P/src/x");
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\tx[+]: {}");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddTwoJavaProjects() throws CoreException {
        try {
            this.startDeltas();
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    JavaElementDeltaTests.this.createJavaProject("P1", new String[]{""}, "");
                    JavaElementDeltaTests.this.createJavaProject("P2", new String[]{"src"}, "bin");
                }
            }, null);
            JavaElementDeltaTests.assertEquals((String)"Unexpected delta", (String)"P1[+]: {}\nP2[+]: {}", (String)this.getSortedByProjectDeltas());
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteProject("P1");
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteProject("P1");
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddTwoJavaProjectsWithExtraSetClasspath() throws CoreException {
        try {
            this.startDeltas();
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IJavaScriptProject p1 = JavaElementDeltaTests.this.createJavaProject("P1", new String[]{""}, "");
                    p1.setRawIncludepath(p1.getRawIncludepath(), p1.getOutputLocation(), null);
                    JavaElementDeltaTests.this.createJavaProject("P2", new String[]{"src"}, "bin");
                }
            }, null);
            JavaElementDeltaTests.assertEquals((String)"Unexpected delta", (String)"P1[+]: {}\nP2[+]: {}", (String)this.getSortedByProjectDeltas());
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteProject("P1");
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteProject("P1");
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBatchOperation() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"}, "bin");
            this.createFolder("P/src/x");
            this.createFile("P/src/x/A.js", "function A() {\n}");
            this.startDeltas();
            JavaScriptCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IJavaScriptUnit unit = JavaElementDeltaTests.this.getCompilationUnit("P/src/x/A.js");
                    unit.createField("var i;", null, false, monitor);
                }
            }, null);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\tx[*]: {CHILDREN}\n\t\t\tA.js[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\ti[+]: {}");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBuildProjectUsedAsLib() throws CoreException {
        try {
            IJavaScriptProject p1 = this.createJavaProject("P1", new String[]{"src1"}, new String[]{"JCL_LIB"}, "bin1");
            this.createJavaProject("P2", new String[]{"src2"}, new String[]{"/P1/bin1"}, "bin2");
            this.createFile("/P1/src1/X.js", "function X() {\n}");
            p1.open(null);
            this.startDeltas();
            p1.getProject().build(6, null);
            JavaElementDeltaTests.waitForAutoBuild();
            this.assertDeltas("Unexpected delta (1)", "P2[*]: {CHILDREN}\n\t/P1/bin1[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.class[+]: {}");
            this.editFile("/P1/src1/X.js", "function X() {\n}\nfunction Y() {\n}");
            this.clearDeltas();
            p1.getProject().build(10, null);
            JavaElementDeltaTests.waitForAutoBuild();
            this.assertDeltas("Unexpected delta (2)", "P2[*]: {CHILDREN}\n\t/P1/bin1[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.class[*]: {CONTENT}\n\t\t\tY.class[+]: {}");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.stopDeltas();
            this.deleteProject("P1");
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.stopDeltas();
        this.deleteProject("P1");
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testChangeCustomOutput() throws CoreException {
        try {
            IJavaScriptProject proj = this.createJavaProject("P", new String[]{"src"}, "bin", new String[]{"bin1"});
            this.startDeltas();
            this.setClasspath(proj, new IIncludePathEntry[]{JavaScriptCore.newSourceEntry((IPath)new Path("/P/src"), (IPath[])new IPath[0], (IPath)new Path("/P/bin2"))});
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN | CLASSPATH CHANGED}\n\tsrc[*]: {ADDED TO CLASSPATH | REMOVED FROM CLASSPATH}\n\tResourceDelta(/P/.classpath)[*]");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testChangeRootKind() throws CoreException {
        try {
            IJavaScriptProject proj = this.createJavaProject("P", new String[]{"src"}, "bin");
            this.startDeltas();
            this.setClasspath(proj, new IIncludePathEntry[]{JavaScriptCore.newLibraryEntry((IPath)new Path("/P/src"), null, null, (boolean)false)});
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN | CLASSPATH CHANGED}\n\tsrc[*]: {ADDED TO CLASSPATH | REMOVED FROM CLASSPATH}\n\tResourceDelta(/P/.classpath)[*]");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCloseJavaProject() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{""}, "");
            IProject project = this.getProject("P");
            this.startDeltas();
            project.close(null);
            this.assertDeltas("Unexpected delta", "P[*]: {CLOSED}\nResourceDelta(/P)");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCloseNonJavaProject() throws CoreException {
        try {
            this.createProject("P");
            IProject project = this.getProject("P");
            this.startDeltas();
            project.close(null);
            this.assertDeltas("Unexpected delta", "ResourceDelta(/P)");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCompilationUnitRemoveAndAdd() throws CoreException {
        try {
            this.createJavaProject("P");
            IFile file = this.createFile("/P/X.js", "function X() {\n}");
            this.startDeltas();
            this.deleteResource((IResource)file);
            this.assertDeltas("Unexpected delta after deleting /P/X.js", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.js[-]: {}");
            this.clearDeltas();
            this.createFile("/P/X.js", "function X() {\n}");
            this.assertDeltas("Unexpected delta after adding /P/p/X.js", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\tp[*]: {CHILDREN}\n\t\t\tX.js[+]: {}");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCreateSharedWorkingCopy() throws CoreException {
        IJavaScriptUnit copy = null;
        try {
            this.createJavaProject("P", new String[]{""}, "");
            this.createFile("P/X.js", "function X() {\n}");
            IJavaScriptUnit unit = this.getCompilationUnit("P", "", "", "X.js");
            this.startDeltas();
            copy = unit.getWorkingCopy(new WorkingCopyOwner(){}, null, null);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\t[Working copy] X.js[+]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            if (copy != null) {
                copy.discardWorkingCopy();
            }
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        if (copy != null) {
            copy.discardWorkingCopy();
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCreateWorkingCopy() throws CoreException {
        IJavaScriptUnit copy = null;
        try {
            this.createJavaProject("P", new String[]{""}, "");
            this.createFile("P/X.js", "function X() {\n}");
            IJavaScriptUnit unit = this.getCompilationUnit("P", "", "", "X.js");
            this.startDeltas();
            copy = unit.getWorkingCopy(null);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\t[Working copy] X.js[+]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            if (copy != null) {
                copy.discardWorkingCopy();
            }
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        if (copy != null) {
            copy.discardWorkingCopy();
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCopyAndOverwritePackage() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src1", "src2"}, "bin");
            this.createFile("P/src1/X.js", "function X() {\n}");
            this.createFolder("/P/src2");
            this.startDeltas();
            this.getPackage("/P/src1").copy((IJavaScriptElement)this.getPackageFragmentRoot("/P/src2"), null, null, true, null);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\tsrc2[*]: {CHILDREN}\n\t\tp[*]: {CHILDREN}\n\t\t\tX.js[+]: {}");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCUNotOnClasspath() throws CoreException {
        try {
            this.createJavaProject("P", new String[0], "bin");
            IFile file = this.createFile("/P/src/p/X.js", "function X() {\n}");
            this.startDeltas();
            this.deleteResource((IResource)file);
            this.assertDeltas("Unexpected delta after deletion of /P/src/X.js", "P[*]: {CONTENT}\n\tResourceDelta(/P/src)[*]");
            this.clearDeltas();
            this.createFile("/P/src/X.js", "function X() {\n}");
            this.assertDeltas("Unexpected delta after addition of /P/src/X.js", "P[*]: {CONTENT}\n\tResourceDelta(/P/src)[*]");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteNonJavaFolder() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"foo/bar"}, "bin");
            IFolder folder = this.getFolder("/P/foo");
            this.startDeltas();
            this.deleteResource((IResource)folder);
            this.assertDeltas("Unexpected deltas", "P[*]: {CHILDREN | CONTENT}\n\tfoo/bar[-]: {}\n\tResourceDelta(/P/foo)[-]");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteProjectAfterChangingClasspath() throws CoreException {
        try {
            final IJavaScriptProject project = this.createJavaProject("P");
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    project.setRawIncludepath(JavaElementDeltaTests.this.createClasspath("P", new String[]{"/P/src", ""}), (IPath)new Path("/P/bin"), monitor);
                    JavaElementDeltaTests.this.deleteProject("P");
                }
            };
            this.startDeltas();
            this.getWorkspace().run(runnable, null);
            this.assertDeltas("Unexpected delta", "P[-]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteProjectSetCPAnotherProject() throws CoreException {
        final IJavaScriptProject project = this.createJavaProject("P1", new String[]{"src"}, "bin");
        this.createJavaProject("P2", new String[0], "");
        try {
            this.startDeltas();
            JavaScriptCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    JavaElementDeltaTests.this.deleteProject("P2");
                    project.setRawIncludepath(new IIncludePathEntry[]{JavaScriptCore.newSourceEntry((IPath)project.getPath())}, null);
                }
            }, null);
            this.assertDeltas("Unexpected deltas", "P1[*]: {CHILDREN | CLASSPATH CHANGED}\n\t<project root>[*]: {ADDED TO CLASSPATH}\n\tsrc[*]: {REMOVED FROM CLASSPATH}\n\tResourceDelta(/P1/.classpath)[*]\nP2[-]: {}");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.stopDeltas();
            this.deleteProject("P1");
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.stopDeltas();
        this.deleteProject("P1");
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDiscardWorkingCopy1() throws CoreException {
        IJavaScriptUnit copy = null;
        try {
            this.createJavaProject("P", new String[]{""}, "");
            this.createFile("P/X.js", "public class X {\n}");
            IJavaScriptUnit unit = this.getCompilationUnit("P", "", "", "X.js");
            copy = unit.getWorkingCopy(null);
            this.startDeltas();
            copy.discardWorkingCopy();
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\t[Working copy] X.js[-]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            if (copy != null) {
                copy.discardWorkingCopy();
            }
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        if (copy != null) {
            copy.discardWorkingCopy();
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDiscardWorkingCopy2() throws CoreException {
        IJavaScriptUnit copy = null;
        try {
            this.createJavaProject("P", new String[]{""}, "");
            this.createFile("P/X.js", "public class X {\n}");
            IJavaScriptUnit unit = this.getCompilationUnit("P", "", "", "X.js");
            copy = unit.getWorkingCopy(new WorkingCopyOwner(){}, null, null);
            this.startDeltas();
            copy.discardWorkingCopy();
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\t[Working copy] X.js[-]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            if (copy != null) {
                copy.discardWorkingCopy();
            }
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        if (copy != null) {
            copy.discardWorkingCopy();
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testListenerPostChange() throws CoreException {
        DeltaListener listener;
        block4: {
            listener = new DeltaListener(1);
            IJavaScriptUnit wc = null;
            try {
                this.createJavaProject("P", new String[]{""}, "");
                JavaScriptCore.addElementChangedListener((IElementChangedListener)listener, (int)1);
                IPackageFragment pkg = this.getPackage("P");
                IJavaScriptUnit cu = pkg.createCompilationUnit("X.js", "public class X {\n}", false, null);
                JavaElementDeltaTests.assertEquals((String)"Unexpected delta after creating CU", (String)"P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.js[+]: {}", (String)listener.toString());
                listener.flush();
                cu.createType("class A {\n}", (IJavaScriptElement)cu.getType("X"), false, null);
                JavaElementDeltaTests.assertEquals((String)"Unexpected delta after creating type", (String)"P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.js[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tA[+]: {}", (String)listener.toString());
                listener.flush();
                this.createFile("P/readme.txt", "");
                JavaElementDeltaTests.assertEquals((String)"Unexpected delta after creating non-java resource", (String)"P[*]: {CONTENT}\n\tResourceDelta(/P/readme.txt)[+]", (String)listener.toString());
                listener.flush();
                wc = cu.getWorkingCopy(new WorkingCopyOwner(){}, null, null);
                JavaElementDeltaTests.assertEquals((String)"Unexpected delta after creating shared working copy", (String)"P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\t[Working copy] X.js[+]: {}", (String)listener.toString());
                listener.flush();
                wc.getBuffer().setContents("public class X {\n  public void foo() {\n  }\n}");
                wc.reconcile(0, false, null, null);
                JavaElementDeltaTests.assertEquals((String)"Unexpected delta after reconciling working copy", (String)"", (String)listener.toString());
                listener.flush();
                wc.commitWorkingCopy(false, null);
                JavaElementDeltaTests.assertEquals((String)"Unexpected delta after committing working copy", (String)"P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.js[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tX[*]: {CHILDREN | FINE GRAINED}\n\t\t\t\t\tfoo()[+]: {}\n\t\t\t\tA[-]: {}", (String)listener.toString());
                listener.flush();
                wc.discardWorkingCopy();
                JavaElementDeltaTests.assertEquals((String)"Unexpected delta after destroying shared working copy", (String)"P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\t[Working copy] X.js[-]: {}", (String)listener.toString());
                listener.flush();
                wc = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (wc != null) {
                    wc.discardWorkingCopy();
                }
                JavaScriptCore.removeElementChangedListener((IElementChangedListener)listener);
                this.deleteProject("P");
                throw throwable;
            }
            {
                Object var5_7 = null;
                if (wc == null) break block4;
            }
            wc.discardWorkingCopy();
        }
        JavaScriptCore.removeElementChangedListener((IElementChangedListener)listener);
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testListenerReconcile() throws CoreException {
        DeltaListener listener;
        block4: {
            listener = new DeltaListener(4);
            IJavaScriptUnit wc = null;
            try {
                this.createJavaProject("P", new String[]{""}, "");
                JavaScriptCore.addElementChangedListener((IElementChangedListener)listener, (int)4);
                IPackageFragment pkg = this.getPackage("P");
                IJavaScriptUnit cu = pkg.createCompilationUnit("X.js", "public class X {\n}", false, null);
                JavaElementDeltaTests.assertEquals((String)"Unexpected delta after creating CU", (String)"", (String)listener.toString());
                listener.flush();
                cu.createType("class A {\n}", (IJavaScriptElement)cu.getType("X"), false, null);
                JavaElementDeltaTests.assertEquals((String)"Unexpected delta after creating type", (String)"", (String)listener.toString());
                listener.flush();
                this.createFile("P/readme.txt", "");
                JavaElementDeltaTests.assertEquals((String)"Unexpected delta after creating non-java resource", (String)"", (String)listener.toString());
                listener.flush();
                wc = cu.getWorkingCopy(new WorkingCopyOwner(){}, null, null);
                JavaElementDeltaTests.assertEquals((String)"Unexpected delta after creating shared working copy", (String)"", (String)listener.toString());
                listener.flush();
                wc.getBuffer().setContents("public class X {\n  public void foo() {\n  }\n}");
                wc.reconcile(0, false, null, null);
                JavaElementDeltaTests.assertEquals((String)"Unexpected delta after reconciling working copy", (String)"X[*]: {CHILDREN | FINE GRAINED}\n\tfoo()[+]: {}\nA[-]: {}", (String)listener.toString());
                listener.flush();
                wc.commitWorkingCopy(false, null);
                JavaElementDeltaTests.assertEquals((String)"Unexpected delta after committing working copy", (String)"", (String)listener.toString());
                listener.flush();
                wc.discardWorkingCopy();
                JavaElementDeltaTests.assertEquals((String)"Unexpected delta after destroying shared working copy", (String)"", (String)listener.toString());
                listener.flush();
                wc = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (wc != null) {
                    wc.discardWorkingCopy();
                }
                JavaScriptCore.removeElementChangedListener((IElementChangedListener)listener);
                this.deleteProject("P");
                throw throwable;
            }
            {
                Object var5_7 = null;
                if (wc == null) break block4;
            }
            wc.discardWorkingCopy();
        }
        JavaScriptCore.removeElementChangedListener((IElementChangedListener)listener);
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMergeResourceDeltas() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{""}, "");
            this.startDeltas();
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IPackageFragment pkg = JavaElementDeltaTests.this.getPackageFragment("P", "", "");
                    pkg.createCompilationUnit("X.js", "public class X {\n}", true, null);
                    JavaElementDeltaTests.this.createFile("P/Y.txt", "");
                }
            }, null);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.js[+]: {}\n\tResourceDelta(/P/Y.txt)[+]");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testModifyMethodBodyAndSave() throws CoreException {
        IJavaScriptUnit workingCopy = null;
        try {
            this.createJavaProject("P", new String[]{""}, "");
            this.createFolder("P/x/y");
            this.createFile("P/x/y/A.js", "package x.y;\npublic class A {\n  public void foo() {\n  }\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("P/x/y/A.js");
            workingCopy = cu.getWorkingCopy(null);
            workingCopy.getBuffer().setContents("package x.y;\npublic class A {\n  public void foo() {\n    // method body change \n  }\n}");
            this.startDeltas();
            workingCopy.commitWorkingCopy(true, null);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\tx.y[*]: {CHILDREN}\n\t\t\tA.js[*]: {CONTENT | FINE GRAINED | PRIMARY RESOURCE}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            if (workingCopy != null) {
                workingCopy.discardWorkingCopy();
            }
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        if (workingCopy != null) {
            workingCopy.discardWorkingCopy();
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testModifyOutputLocation1() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"}, "bin");
            this.startDeltas();
            this.createFile("/P/bin/X.class", "");
            this.assertDeltas("Unexpected delta", "");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testModifyOutputLocation2() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"}, "bin1", new String[]{"bin2"});
            this.startDeltas();
            this.createFile("/P/bin2/X.class", "");
            this.assertDeltas("Unexpected delta", "");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testModifyOutputLocation3() throws CoreException {
        try {
            String[] stringArray = new String[2];
            stringArray[0] = "src1";
            this.createJavaProject("P", new String[]{"src1", "src2"}, "bin", stringArray);
            this.startDeltas();
            this.createFile("/P/bin/X.class", "");
            this.assertDeltas("Unexpected delta", "");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testModifyOutputLocation4() throws CoreException {
        try {
            this.createJavaProject("P");
            this.editFile("/P/.classpath", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n    <classpathentry excluding=\"src/\" kind=\"src\" output=\"bin1\" path=\"\"/>\n    <classpathentry kind=\"src\" output=\"bin2\" path=\"src\"/>\n    <classpathentry kind=\"output\" path=\"bin\"/>\n</classpath>");
            this.createFolder("/P/bin2");
            this.startDeltas();
            this.createFile("/P/bin2/X.class", "");
            this.assertDeltas("Unexpected delta", "");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testModifyProjectDescriptionAndRemoveFolder() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P");
            final IProject projectFolder = project.getProject();
            final IFolder folder = this.createFolder("/P/folder");
            this.startDeltas();
            this.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IProjectDescription desc = projectFolder.getDescription();
                    desc.setComment("A comment");
                    projectFolder.setDescription(desc, null);
                    JavaElementDeltaTests.this.deleteResource((IResource)folder);
                }
            }, null);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN | CONTENT}\n\t<project root>[*]: {CHILDREN}\n\t\tfolder[-]: {}\n\tResourceDelta(/P/.project)[*]");
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveCuInEnclosingPkg() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{""}, "");
            this.createFolder("P/x/y");
            this.createFile("P/x/y/A.js", "package x.y;\npublic class A {\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("P/x/y/A.js");
            IPackageFragment pkg = this.getPackage("P/x");
            this.startDeltas();
            cu.move((IJavaScriptElement)pkg, null, null, true, null);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\tx[*]: {CHILDREN}\n\t\t\tA.js[+]: {MOVED_FROM(A.js [in x.y [in <project root> [in P]]])}\t\tx.y[*]: {CHILDREN}\n\t\t\tA.js[-]: {MOVED_TO(A.js [in x [in <project root> [in P]]])}\n");
            this.assertElementDescendants("Unexpected children for package x", "x\n  A.js\n    package x\n    class A", (IJavaScriptElement)pkg);
            this.assertElementDescendants("Unexpected children for package x.y", "x.y", (IJavaScriptElement)this.getPackage("P/x/y"));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveResInDotNamedFolder() throws CoreException {
        try {
            this.createJavaProject("P", new String[0], "");
            IProject project = this.getProject("P");
            this.createFolder("P/x.y");
            IFile file = this.createFile("P/x.y/test.txt", "");
            this.startDeltas();
            file.move(project.getFullPath().append("test.txt"), true, null);
            this.assertDeltas("Unexpected delta", "P[*]: {CONTENT}\n\tResourceDelta(/P/test.txt)[+]\n\tResourceDelta(/P/x.y)[*]");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveTwoResInRoot() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"}, "bin");
            final IFile f1 = this.createFile("P/X.js", "public class X {}");
            final IFile f2 = this.createFile("P/Y.js", "public class Y {}");
            this.startDeltas();
            JavaScriptCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    f1.move((IPath)new Path("/P/src/X.js"), true, null);
                    f2.move((IPath)new Path("/P/src/Y.js"), true, null);
                }
            }, null);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN | CONTENT}\n\tsrc[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.js[+]: {}\n\t\t\tY.js[+]: {}\n\tResourceDelta(/P/X.js)[-]\n\tResourceDelta(/P/Y.js)[-]");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testNestedRootParentMove() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"nested2/src", "nested/src"}, "bin");
            this.deleteFolder("/P/nested2/src");
            this.startDeltas();
            IFolder folder = this.getFolder("/P/nested/src");
            folder.move((IPath)new Path("/P/nested2/src"), false, null);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN | CONTENT}\n\tnested2/src[+]: {MOVED_FROM(nested/src [in P])}\n\tnested/src[-]: {MOVED_TO(nested2/src [in P])}\n\tResourceDelta(/P/nested)[*]\n\tResourceDelta(/P/nested2)[*]");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testNonJavaResourceRemoveAndAdd() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"}, "bin");
            IFile file = this.createFile("/P/src/read.txt", "");
            this.startDeltas();
            this.deleteResource((IResource)file);
            this.assertDeltas("Unexpected delta after deleting /P/src/read.txt", "P[*]: {CHILDREN}\n\tsrc[*]: {CONTENT}\n\t\tResourceDelta(/P/src/read.txt)[-]");
            this.clearDeltas();
            this.createFile("/P/src/read.txt", "");
            this.assertDeltas("Unexpected delta after creating /P/src/read.txt", "P[*]: {CHILDREN}\n\tsrc[*]: {CONTENT}\n\t\tResourceDelta(/P/src/read.txt)[+]");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testOpenJavaProject() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{""}, "");
            IProject project = this.getProject("P");
            project.close(null);
            this.startDeltas();
            project.open(null);
            this.assertDeltas("Unexpected delta", "P[*]: {OPENED}\nResourceDelta(/P)");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testOpenNonJavaProject() throws CoreException {
        try {
            this.createProject("P");
            IProject project = this.getProject("P");
            project.close(null);
            this.startDeltas();
            project.open(null);
            this.assertDeltas("Unexpected delta", "ResourceDelta(/P)");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testOverwriteClasspath() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{""}, "");
            this.createFolder("P/src");
            this.createFolder("P/bin");
            final IFile newCP = this.createFile("P/.classpath2", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n    <classpathentry kind=\"src\" path=\"src\"/>\n    <classpathentry kind=\"output\" path=\"bin\"/>\n</classpath>");
            this.startDeltas();
            IWorkspaceRunnable run = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IFile oldCP = newCP.getParent().getFile((IPath)new Path(".classpath"));
                    JavaElementDeltaTests.this.deleteResource((IResource)oldCP);
                    newCP.move((IPath)new Path("/P/.classpath"), true, null);
                }
            };
            this.getWorkspace().run(run, null);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {REMOVED FROM CLASSPATH}\n\tsrc[*]: {ADDED TO CLASSPATH}\n\tResourceDelta(/P/.classpath)[*]\n\tResourceDelta(/P/.classpath2)[-]");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testPackageFragmentAddAndRemove() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"}, "bin");
            this.startDeltas();
            IFolder folder = this.createFolder("/P/src/p");
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\tp[+]: {}");
            this.clearDeltas();
            this.deleteResource((IResource)folder);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\tp[-]: {}");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testPackageFragmentMove() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"}, "bin");
            IFolder folder = this.createFolder("/P/src/p");
            this.startDeltas();
            folder.move((IPath)new Path("/P/src/p2"), false, null);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\tp[-]: {MOVED_TO(p2 [in src [in P]])}\n\t\tp2[+]: {MOVED_FROM(p [in src [in P]])}");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testPackageFragmentRootRemoveAndAdd() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"}, "bin");
            this.startDeltas();
            this.deleteFolder("/P/src");
            this.assertDeltas("Unexpected delta after deleting /P/src", "P[*]: {CHILDREN}\n\tsrc[-]: {}");
            this.clearDeltas();
            this.createFolder("/P/src");
            this.assertDeltas("Unexpected delta after creating /P/src", "P[*]: {CHILDREN}\n\tsrc[+]: {}");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRemoveAddBinaryProject() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{""}, "");
            this.createFile("P/lib.jar", "");
            project.setRawIncludepath(new IIncludePathEntry[]{JavaScriptCore.newLibraryEntry((IPath)new Path("/P/lib.jar"), null, null)}, null);
            this.startDeltas();
            this.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    JavaElementDeltaTests.this.deleteProject("P");
                    JavaElementDeltaTests.this.createJavaProject("P", new String[]{""}, "");
                }
            }, null);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN | CLASSPATH CHANGED}\n\t<project root>[*]: {ADDED TO CLASSPATH}\n\tlib.jar[-]: {}\n\tResourceDelta(/P/.classpath)[*]\n\tResourceDelta(/P/.project)[*]");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRemoveAddJavaProject() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{""}, "");
            this.startDeltas();
            this.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    JavaElementDeltaTests.this.deleteProject("P");
                    JavaElementDeltaTests.this.createJavaProject("P", new String[]{""}, "");
                }
            }, null);
            this.assertDeltas("Unexpected delta", "P[*]: {CONTENT | CLASSPATH CHANGED}\n\tResourceDelta(/P/.classpath)[*]\n\tResourceDelta(/P/.project)[*]");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRemoveCPEntryAndRoot1() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"}, "bin");
            project.open(null);
            this.startDeltas();
            JavaScriptCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    JavaElementDeltaTests.this.editFile("/P/.classpath", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n    <classpathentry kind=\"output\" path=\"bin\"/>\n</classpath>");
                    JavaElementDeltaTests.this.deleteFolder("/P/src");
                }
            }, null);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\tsrc[-]: {}\n\tResourceDelta(/P/.classpath)[*]");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRemoveCPEntryAndRoot2() throws CoreException {
        try {
            final IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"}, "bin");
            project.open(null);
            this.startDeltas();
            JavaScriptCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    project.setRawIncludepath(new IIncludePathEntry[0], null);
                    JavaElementDeltaTests.this.deleteFolder("/P/src");
                }
            }, null);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN | CLASSPATH CHANGED}\n\tsrc[-]: {}\n\tResourceDelta(/P/.classpath)[*]");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRemoveCPEntryAndRoot3() throws CoreException {
        try {
            final IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"}, "bin");
            project.open(null);
            this.startDeltas();
            JavaScriptCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    JavaElementDeltaTests.this.deleteFolder("/P/src");
                    project.setRawIncludepath(new IIncludePathEntry[0], null);
                }
            }, null);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN | CLASSPATH CHANGED}\n\tsrc[-]: {}\n\tResourceDelta(/P/.classpath)[*]");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRemoveJavaNature() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{""}, "");
            this.startDeltas();
            this.removeJavaNature("P");
            this.assertDeltas("Unexpected delta", "P[-]: {}\nResourceDelta(/P)");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRemoveJavaProject() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{""}, "");
            this.startDeltas();
            this.deleteProject("P");
            this.assertDeltas("Unexpected delta", "P[-]: {}");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRemoveNonJavaProject() throws CoreException {
        try {
            this.createProject("P");
            this.startDeltas();
            this.deleteProject("P");
            this.assertDeltas("Should get a non-Java resource delta", "ResourceDelta(/P)");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRemoveNonJavaProjectUpdateDependent1() throws CoreException {
        try {
            this.createProject("SP");
            this.createFile("/SP/x.jar", "");
            this.createJavaProject("JP", new String[]{""}, new String[]{"/SP/x.jar"}, "");
            this.startDeltas();
            this.deleteProject("SP");
            this.assertDeltas("Unexpected delta", "JP[*]: {CHILDREN}\n\t/SP/x.jar[-]: {}\nResourceDelta(/SP)");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteProject("SP");
            this.deleteProject("JP");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteProject("SP");
        this.deleteProject("JP");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRemoveNonJavaProjectUpdateDependent2() throws CoreException {
        try {
            this.createProject("SP");
            this.createJavaProject("JP", new String[]{""}, new String[]{"/SP/missing"}, "");
            this.startDeltas();
            this.deleteProject("SP");
            this.assertDeltas("Unexpected delta", "ResourceDelta(/SP)");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteProject("SP");
            this.deleteProject("JP");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteProject("SP");
        this.deleteProject("JP");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRemoveNonJavaProjectUpdateDependent3() throws CoreException {
        try {
            this.createProject("SP");
            this.createFile("/SP/x.jar", "");
            this.createJavaProject("JP", new String[]{""}, new String[]{"/SP/x.jar"}, "");
            DeltaProcessingState deltaState = JavaModelManager.getJavaModelManager().deltaState;
            deltaState.oldRoots = null;
            deltaState.roots = null;
            deltaState.rootsAreStale = true;
            this.startDeltas();
            JavaScriptCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    JavaElementDeltaTests.this.deleteProject("SP");
                }
            }, null);
            this.assertDeltas("Unexpected delta", "JP[*]: {CHILDREN}\n\t/SP/x.jar[-]: {}\nResourceDelta(/SP)");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.stopDeltas();
            this.deleteProject("SP");
            this.deleteProject("JP");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.stopDeltas();
        this.deleteProject("SP");
        this.deleteProject("JP");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRenameJavaProject() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{""}, "");
            this.startDeltas();
            this.renameProject("P", "P1");
            this.assertDeltas("Unexpected delta", "P[-]: {MOVED_TO(P1)}\nP1[+]: {MOVED_FROM(P)}");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteProject("P");
            this.deleteProject("P1");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
        this.deleteProject("P1");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRenameMethodAndSave() throws CoreException {
        IJavaScriptUnit workingCopy = null;
        try {
            this.createJavaProject("P", new String[]{""}, "");
            this.createFolder("P/x/y");
            this.createFile("P/x/y/A.js", "package x.y;\npublic class A {\n  public void foo1() {\n  }\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("P/x/y/A.js");
            workingCopy = cu.getWorkingCopy(null);
            workingCopy.getBuffer().setContents("package x.y;\npublic class A {\n  public void foo2() {\n  }\n}");
            this.startDeltas();
            workingCopy.commitWorkingCopy(true, null);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\tx.y[*]: {CHILDREN}\n\t\t\tA.js[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tA[*]: {CHILDREN | FINE GRAINED}\n\t\t\t\t\tfoo1()[-]: {}\n\t\t\t\t\tfoo2()[+]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            if (workingCopy != null) {
                workingCopy.discardWorkingCopy();
            }
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        if (workingCopy != null) {
            workingCopy.discardWorkingCopy();
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRenameNonJavaProject() throws CoreException {
        try {
            this.createProject("P");
            this.startDeltas();
            this.renameProject("P", "P1");
            this.assertDeltas("Unexpected delta", "ResourceDelta(/P)\nResourceDelta(/P1)");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteProject("P");
            this.deleteProject("P1");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
        this.deleteProject("P1");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRenameOuterPkgFragment() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{""}, "");
            this.createFolder("P/x/y");
            this.createFile("P/x/y/X.js", "package x.y;\npublic class X {\n}");
            this.startDeltas();
            IPackageFragment pkg = this.getPackageFragment("P", "", "x");
            pkg.rename("z", false, null);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\tz[+]: {}");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSaveWorkingCopy() throws CoreException {
        IJavaScriptUnit copy = null;
        try {
            this.createJavaProject("P", new String[]{""}, "");
            this.createFile("P/X.js", "public class X {\n}");
            IJavaScriptUnit unit = this.getCompilationUnit("P", "", "", "X.js");
            copy = unit.getWorkingCopy(null);
            copy.getType("X").createMethod("void foo() {}", null, true, null);
            this.startDeltas();
            copy.save(null, true);
            this.assertDeltas("Unexpected delta after saving working copy", "");
            copy.commitWorkingCopy(true, null);
            this.assertDeltas("Unexpected delta after committing working copy", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.js[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tX[*]: {CHILDREN | FINE GRAINED}\n\t\t\t\t\tfoo()[+]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            if (copy != null) {
                copy.discardWorkingCopy();
            }
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        if (copy != null) {
            copy.discardWorkingCopy();
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSetClasspathOnFreshProject() throws CoreException {
        try {
            this.createProject("LibProj");
            this.createFile("LibProj/mylib.jar", "");
            JavaProject p1 = (JavaProject)this.createJavaProject("P1", new String[]{""}, "bin");
            this.createFolder("P1/src2");
            p1.getProject().close(null);
            p1.getProject().open(null);
            this.startDeltas();
            IIncludePathEntry[] classpath = new IIncludePathEntry[]{JavaScriptCore.newSourceEntry((IPath)new Path("/P1/src2")), JavaScriptCore.newLibraryEntry((IPath)new Path("/LibProj/mylib.jar"), null, null)};
            p1.setRawIncludepath(classpath, null);
            this.assertDeltas("Should notice src2 and myLib additions to the classpath", "P1[*]: {CHILDREN | CLASSPATH CHANGED}\n\t<project root>[*]: {REMOVED FROM CLASSPATH}\n\t/LibProj/mylib.jar[*]: {ADDED TO CLASSPATH}\n\tsrc2[*]: {ADDED TO CLASSPATH}\n\tResourceDelta(/P1/.classpath)[*]");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteProject("P1");
            this.deleteProject("LibProj");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteProject("P1");
        this.deleteProject("LibProj");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSetClasspathVariable1() throws CoreException {
        try {
            this.createProject("LibProj");
            this.createFile("LibProj/mylib.jar", "");
            this.createFile("LibProj/otherlib.jar", "");
            JavaScriptCore.setIncludepathVariables((String[])new String[]{"LIB"}, (IPath[])new IPath[]{new Path("/LibProj/mylib.jar")}, null);
            this.createJavaProject("P", new String[]{""}, new String[]{"LIB"}, "");
            this.startDeltas();
            JavaScriptCore.setIncludepathVariables((String[])new String[]{"LIB"}, (IPath[])new IPath[]{new Path("/LibProj/otherlib.jar")}, null);
            this.assertDeltas("Unexpected delta after setting classpath variable", "P[*]: {CHILDREN}\n\t/LibProj/mylib.jar[*]: {REMOVED FROM CLASSPATH}\n\t/LibProj/otherlib.jar[*]: {ADDED TO CLASSPATH}");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteProject("P");
            this.deleteProject("LibProj");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
        this.deleteProject("LibProj");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSetClasspathVariable2() throws CoreException {
        try {
            this.createProject("LibProj");
            this.createFile("LibProj/mylib.jar", "");
            this.createFile("LibProj/otherlib.jar", "");
            JavaScriptCore.setIncludepathVariables((String[])new String[]{"LIB"}, (IPath[])new IPath[]{new Path("/LibProj/mylib.jar")}, null);
            this.createJavaProject("P1", new String[]{""}, new String[]{"LIB"}, "");
            this.createJavaProject("P2", new String[]{""}, new String[]{"LIB"}, "");
            this.startDeltas();
            JavaScriptCore.setIncludepathVariables((String[])new String[]{"LIB"}, (IPath[])new IPath[]{new Path("/LibProj/otherlib.jar")}, null);
            JavaElementDeltaTests.assertEquals((String)"Unexpected delta after setting classpath variable", (String)"P1[*]: {CHILDREN}\n\t/LibProj/mylib.jar[*]: {REMOVED FROM CLASSPATH}\n\t/LibProj/otherlib.jar[*]: {ADDED TO CLASSPATH}\nP2[*]: {CHILDREN}\n\t/LibProj/mylib.jar[*]: {REMOVED FROM CLASSPATH}\n\t/LibProj/otherlib.jar[*]: {ADDED TO CLASSPATH}", (String)this.getSortedByProjectDeltas());
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopDeltas();
            this.deleteProject("P1");
            this.deleteProject("P2");
            this.deleteProject("LibProj");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.stopDeltas();
        this.deleteProject("P1");
        this.deleteProject("P2");
        this.deleteProject("LibProj");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testWorkingCopyCommit() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{""}, "");
            this.createFolder("P/x/y");
            this.createFile("P/x/y/A.js", "package x.y;\npublic class A {\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("P/x/y/A.js");
            IJavaScriptUnit copy = cu.getWorkingCopy(null);
            copy.getBuffer().setContents("package x.y;\npublic class A {\n  public void foo() {\n  }\n}");
            copy.save(null, false);
            this.startDeltas();
            copy.commitWorkingCopy(true, null);
            this.assertDeltas("Unexpected delta after commit", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\tx.y[*]: {CHILDREN}\n\t\t\tA.js[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tA[*]: {CHILDREN | FINE GRAINED}\n\t\t\t\t\tfoo()[+]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteProject("P");
    }

    public class DeltaListener
    implements IElementChangedListener {
        ArrayList deltas = new ArrayList();
        int eventType;

        public DeltaListener() {
            this.eventType = -1;
        }

        public DeltaListener(int eventType) {
            this.eventType = eventType;
        }

        public void elementChanged(ElementChangedEvent event) {
            if (this.eventType == -1 || event.getType() == this.eventType) {
                this.deltas.add(event.getDelta());
            }
        }

        public void flush() {
            this.deltas = new ArrayList();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            int length = this.deltas.size();
            while (i < length) {
                IJavaScriptElementDelta delta = (IJavaScriptElementDelta)this.deltas.get(i);
                IJavaScriptElementDelta[] children = delta.getAffectedChildren();
                if (children.length > 0) {
                    int j = 0;
                    int childrenLength = children.length;
                    while (j < childrenLength) {
                        buffer.append(children[j]);
                        if (j != childrenLength - 1) {
                            buffer.append("\n");
                        }
                        ++j;
                    }
                } else {
                    buffer.append(delta);
                }
                if (i != length - 1) {
                    buffer.append("\n\n");
                }
                ++i;
            }
            return buffer.toString();
        }
    }
}

