/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageDeclaration;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;
import org.eclipse.wst.jsdt.core.tests.model.TestProgressMonitor;
import org.eclipse.wst.jsdt.core.tests.util.Util;

public class DeleteTests
extends ModifyingResourceTests {
    static /* synthetic */ Class class$0;

    public DeleteTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        DeleteTests.waitUntilIndexesReady();
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.createJavaProject("P");
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.DeleteTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return DeleteTests.buildModelTestSuite(clazz);
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject("P");
        super.tearDownSuite();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteAllImports() throws CoreException {
        try {
            this.createFile("P/X.js", "import java.util.*;\nimport q.Y;\npublic class X {\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("P/X.js");
            IImportDeclaration[] children = cu.getImports();
            this.startDeltas();
            this.assertDeletion((IJavaScriptElement[])children);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.java[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\t<import container>[-]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteFile("P/X.js");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/X.js");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteBinaryMethod() throws CoreException {
        try {
            this.createJavaProject("P1", new String[0], new String[]{"lib"}, "");
            byte[] byArray = new byte[221];
            byArray[0] = -54;
            byArray[1] = -2;
            byArray[2] = -70;
            byArray[3] = -66;
            byArray[5] = 3;
            byArray[7] = 45;
            byArray[9] = 14;
            byArray[10] = 1;
            byArray[12] = 1;
            byArray[13] = 88;
            byArray[14] = 7;
            byArray[16] = 1;
            byArray[17] = 1;
            byArray[19] = 16;
            byArray[20] = 106;
            byArray[21] = 97;
            byArray[22] = 118;
            byArray[23] = 97;
            byArray[24] = 47;
            byArray[25] = 108;
            byArray[26] = 97;
            byArray[27] = 110;
            byArray[28] = 103;
            byArray[29] = 47;
            byArray[30] = 79;
            byArray[31] = 98;
            byArray[32] = 106;
            byArray[33] = 101;
            byArray[34] = 99;
            byArray[35] = 116;
            byArray[36] = 7;
            byArray[38] = 3;
            byArray[39] = 1;
            byArray[41] = 6;
            byArray[42] = 60;
            byArray[43] = 105;
            byArray[44] = 110;
            byArray[45] = 105;
            byArray[46] = 116;
            byArray[47] = 62;
            byArray[48] = 1;
            byArray[50] = 3;
            byArray[51] = 40;
            byArray[52] = 41;
            byArray[53] = 86;
            byArray[54] = 1;
            byArray[56] = 4;
            byArray[57] = 67;
            byArray[58] = 111;
            byArray[59] = 100;
            byArray[60] = 101;
            byArray[61] = 12;
            byArray[63] = 5;
            byArray[65] = 6;
            byArray[66] = 10;
            byArray[68] = 4;
            byArray[70] = 8;
            byArray[71] = 1;
            byArray[73] = 15;
            byArray[74] = 76;
            byArray[75] = 105;
            byArray[76] = 110;
            byArray[77] = 101;
            byArray[78] = 78;
            byArray[79] = 117;
            byArray[80] = 109;
            byArray[81] = 98;
            byArray[82] = 101;
            byArray[83] = 114;
            byArray[84] = 84;
            byArray[85] = 97;
            byArray[86] = 98;
            byArray[87] = 108;
            byArray[88] = 101;
            byArray[89] = 1;
            byArray[91] = 3;
            byArray[92] = 102;
            byArray[93] = 111;
            byArray[94] = 111;
            byArray[95] = 1;
            byArray[97] = 10;
            byArray[98] = 83;
            byArray[99] = 111;
            byArray[100] = 117;
            byArray[101] = 114;
            byArray[102] = 99;
            byArray[103] = 101;
            byArray[104] = 70;
            byArray[105] = 105;
            byArray[106] = 108;
            byArray[107] = 101;
            byArray[108] = 1;
            byArray[110] = 6;
            byArray[111] = 88;
            byArray[112] = 46;
            byArray[113] = 106;
            byArray[114] = 97;
            byArray[115] = 118;
            byArray[116] = 97;
            byArray[118] = 33;
            byArray[120] = 2;
            byArray[122] = 4;
            byArray[128] = 2;
            byArray[130] = 1;
            byArray[132] = 5;
            byArray[134] = 6;
            byArray[136] = 1;
            byArray[138] = 7;
            byArray[142] = 29;
            byArray[144] = 1;
            byArray[146] = 1;
            byArray[150] = 5;
            byArray[151] = 42;
            byArray[152] = -73;
            byArray[154] = 9;
            byArray[155] = -79;
            byArray[159] = 1;
            byArray[161] = 10;
            byArray[165] = 6;
            byArray[167] = 1;
            byArray[171] = 1;
            byArray[173] = 1;
            byArray[175] = 11;
            byArray[177] = 6;
            byArray[179] = 1;
            byArray[181] = 7;
            byArray[185] = 25;
            byArray[189] = 1;
            byArray[193] = 1;
            byArray[194] = -79;
            byArray[198] = 1;
            byArray[200] = 10;
            byArray[204] = 6;
            byArray[206] = 1;
            byArray[210] = 3;
            byArray[212] = 1;
            byArray[214] = 12;
            byArray[218] = 2;
            byArray[220] = 13;
            byte[] bytes = byArray;
            this.createFile("P1/lib/X.class", bytes);
            IClassFile cf = this.getClassFile("P1/lib/X.class");
            IFunction method = cf.getType().getFunction("foo", new String[0]);
            try {
                method.delete(false, null);
            }
            catch (JavaScriptModelException e) {
                DeleteTests.assertTrue((String)"Should be read-only", (e.getStatus().getCode() == 976 ? 1 : 0) != 0);
                Object var5_5 = null;
                this.deleteProject("P1");
                return;
            }
            DeleteTests.assertTrue((String)"Should not be able to delete a binary method", (boolean)false);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteProject("P1");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteProject("P1");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteBinaryType() throws CoreException {
        try {
            this.createJavaProject("P1", new String[0], new String[]{"lib"}, "");
            byte[] byArray = new byte[176];
            byArray[0] = -54;
            byArray[1] = -2;
            byArray[2] = -70;
            byArray[3] = -66;
            byArray[5] = 3;
            byArray[7] = 45;
            byArray[9] = 13;
            byArray[10] = 1;
            byArray[12] = 1;
            byArray[13] = 88;
            byArray[14] = 7;
            byArray[16] = 1;
            byArray[17] = 1;
            byArray[19] = 16;
            byArray[20] = 106;
            byArray[21] = 97;
            byArray[22] = 118;
            byArray[23] = 97;
            byArray[24] = 47;
            byArray[25] = 108;
            byArray[26] = 97;
            byArray[27] = 110;
            byArray[28] = 103;
            byArray[29] = 47;
            byArray[30] = 79;
            byArray[31] = 98;
            byArray[32] = 106;
            byArray[33] = 101;
            byArray[34] = 99;
            byArray[35] = 116;
            byArray[36] = 7;
            byArray[38] = 3;
            byArray[39] = 1;
            byArray[41] = 6;
            byArray[42] = 60;
            byArray[43] = 105;
            byArray[44] = 110;
            byArray[45] = 105;
            byArray[46] = 116;
            byArray[47] = 62;
            byArray[48] = 1;
            byArray[50] = 3;
            byArray[51] = 40;
            byArray[52] = 41;
            byArray[53] = 86;
            byArray[54] = 1;
            byArray[56] = 4;
            byArray[57] = 67;
            byArray[58] = 111;
            byArray[59] = 100;
            byArray[60] = 101;
            byArray[61] = 12;
            byArray[63] = 5;
            byArray[65] = 6;
            byArray[66] = 10;
            byArray[68] = 4;
            byArray[70] = 8;
            byArray[71] = 1;
            byArray[73] = 15;
            byArray[74] = 76;
            byArray[75] = 105;
            byArray[76] = 110;
            byArray[77] = 101;
            byArray[78] = 78;
            byArray[79] = 117;
            byArray[80] = 109;
            byArray[81] = 98;
            byArray[82] = 101;
            byArray[83] = 114;
            byArray[84] = 84;
            byArray[85] = 97;
            byArray[86] = 98;
            byArray[87] = 108;
            byArray[88] = 101;
            byArray[89] = 1;
            byArray[91] = 10;
            byArray[92] = 83;
            byArray[93] = 111;
            byArray[94] = 117;
            byArray[95] = 114;
            byArray[96] = 99;
            byArray[97] = 101;
            byArray[98] = 70;
            byArray[99] = 105;
            byArray[100] = 108;
            byArray[101] = 101;
            byArray[102] = 1;
            byArray[104] = 6;
            byArray[105] = 88;
            byArray[106] = 46;
            byArray[107] = 106;
            byArray[108] = 97;
            byArray[109] = 118;
            byArray[110] = 97;
            byArray[112] = 33;
            byArray[114] = 2;
            byArray[116] = 4;
            byArray[122] = 1;
            byArray[124] = 1;
            byArray[126] = 5;
            byArray[128] = 6;
            byArray[130] = 1;
            byArray[132] = 7;
            byArray[136] = 29;
            byArray[138] = 1;
            byArray[140] = 1;
            byArray[144] = 5;
            byArray[145] = 42;
            byArray[146] = -73;
            byArray[148] = 9;
            byArray[149] = -79;
            byArray[153] = 1;
            byArray[155] = 10;
            byArray[159] = 6;
            byArray[161] = 1;
            byArray[165] = 1;
            byArray[167] = 1;
            byArray[169] = 11;
            byArray[173] = 2;
            byArray[175] = 12;
            byte[] bytes = byArray;
            this.createFile("P1/lib/X.class", bytes);
            IClassFile cf = this.getClassFile("P1/lib/X.class");
            IType binaryType = cf.getType();
            try {
                cf.getJavaScriptModel().delete(new IJavaScriptElement[]{binaryType}, false, null);
            }
            catch (JavaScriptModelException e) {
                DeleteTests.assertTrue((String)"Should be read-only", (e.getStatus().getCode() == 976 ? 1 : 0) != 0);
                Object var5_5 = null;
                this.deleteProject("P1");
                return;
            }
            DeleteTests.assertTrue((String)"Should not be able to delete a class file", (boolean)false);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteProject("P1");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteProject("P1");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteCompilationUnit1() throws CoreException {
        try {
            this.createFile("P/X.js", "public class X {\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("P/X.js");
            this.startDeltas();
            cu.delete(false, null);
            DeleteTests.assertTrue((String)"Should be able to delete a CU", (!cu.exists() ? 1 : 0) != 0);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.java[-]: {}");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.stopDeltas();
            this.deleteFile("P/X.js");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/X.js");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteCompilationUnit2() throws CoreException {
        try {
            IFile file = this.createFile("P/X.js", "public class X {\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("P/X.js");
            this.startDeltas();
            Util.delete((IResource)file);
            DeleteTests.assertTrue((String)"Should be able to delete a CU", (!cu.exists() ? 1 : 0) != 0);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.java[-]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteFile("P/X.js");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/X.js");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteCompilationUnit3() throws CoreException {
        try {
            this.createFile("P/X.js", "public class X {\n}");
            final IJavaScriptUnit cu = this.getCompilationUnit("P/X.js");
            cu.open(null);
            this.startDeltas();
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    cu.delete(true, null);
                    DeleteTests.assertTrue((String)"Should be able to delete a CU", (!cu.exists() ? 1 : 0) != 0);
                }
            }, null);
            DeleteTests.assertTrue((String)"Should be able to delete a CU", (!cu.exists() ? 1 : 0) != 0);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.java[-]: {}");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.stopDeltas();
            this.deleteFile("P/X.js");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/X.js");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteCompilationUnit4() throws CoreException {
        try {
            this.createFolder("P/p");
            IFile file = this.createFile("P/p/X.js", "package p;\npublic class X {\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("P/p/X.js");
            this.startDeltas();
            cu.delete(false, null);
            DeleteTests.assertTrue((String)"CU should not exist", (!cu.exists() ? 1 : 0) != 0);
            DeleteTests.assertTrue((String)"Corresponding file should not exist", (!file.exists() ? 1 : 0) != 0);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\tp[*]: {CHILDREN}\n\t\t\tX.java[-]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteFolder("P/p");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteFolder("P/p");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteConstructor() throws CoreException {
        try {
            this.createFile("P/X.js", "public class X {\n  public X(String s) {\n  }\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("P/X.js");
            IFunction constructor = cu.getType("X").getFunction("X", new String[]{"QString;"});
            this.startDeltas();
            this.assertDeletion((IJavaScriptElement)constructor);
            DeleteTests.assertTrue((String)"Should be able to delete a constructor", (!constructor.exists() ? 1 : 0) != 0);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.java[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tX[*]: {CHILDREN | FINE GRAINED}\n\t\t\t\t\tX(String)[-]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteFile("P/X.js");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/X.js");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteEmptyPackageFragment() throws CoreException {
        try {
            this.createFolder("P/p1/p2");
            IPackageFragment pkg = this.getPackage("P/p1");
            IFolder folder = this.getFolder("P/p1");
            this.startDeltas();
            pkg.delete(false, null);
            DeleteTests.assertTrue((String)"Folder should exist", (boolean)folder.exists());
            DeleteTests.assertTrue((String)"Fragment should exist", (boolean)pkg.exists());
            this.assertDeltas("Unexpected delta", "");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteFolder("P/p1");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteFolder("P/p1");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteField1() throws CoreException {
        try {
            this.createFile("P/X.js", "public class X {\n  int field;\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("P/X.js");
            IField field = cu.getType("X").getField("field");
            this.startDeltas();
            this.assertDeletion((IJavaScriptElement)field);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.java[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tX[*]: {CHILDREN | FINE GRAINED}\n\t\t\t\t\tfield[-]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteFile("P/X.js");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/X.js");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteField2() throws CoreException {
        try {
            this.createFile("P/X.js", "public class X {\n  int field;\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("P/X.js");
            IField field = cu.getType("X").getField("field");
            boolean isCanceled = false;
            try {
                TestProgressMonitor monitor = TestProgressMonitor.getInstance();
                monitor.setCancelledCounter(1);
                this.getJavaModel().delete(new IJavaScriptElement[]{field}, false, (IProgressMonitor)monitor);
            }
            catch (OperationCanceledException operationCanceledException) {
                isCanceled = true;
            }
            DeleteTests.assertTrue((String)"Operation should have thrown an operation canceled exception", (boolean)isCanceled);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteFile("P/X.js");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteFile("P/X.js");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteField3() throws CoreException {
        try {
            IFile file = this.createFile("P/X.js", "public class X {\n  int field;\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("P/X.js");
            final IField field = cu.getType("X").getField("field");
            this.startDeltas();
            this.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    DeleteTests.this.assertDeletion((IJavaScriptElement)field);
                }
            }, (ISchedulingRule)file, 1, null);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.java[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tX[*]: {CHILDREN | FINE GRAINED}\n\t\t\t\t\tfield[-]: {}");
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.stopDeltas();
            this.deleteFile("P/X.js");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/X.js");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteField4() throws CoreException {
        try {
            this.createFile("P/X.js", "public class X {\n  private String t = \"sample test\";\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("P/X.js");
            IField field = cu.getType("X").getField("t");
            field.delete(false, null);
            this.assertSourceEquals("Unexpected source", "public class X {\n}", cu.getSource());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteFile("P/X.js");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteFile("P/X.js");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteField5() throws CoreException {
        try {
            this.createJavaProject("P1", new String[]{""}, new String[]{"JCL15_LIB"}, null, "", "1.5");
            this.createFile("P1/X.js", "public enum X {\n  A, B, C\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("P1/X.js");
            IField field = cu.getType("X").getField("A");
            field.delete(false, null);
            this.assertSourceEquals("Unexpected source", "public enum X {\n  B, C\n}", cu.getSource());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P1");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P1");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteImportDeclaration() throws CoreException {
        try {
            this.createFile("P/X.js", "import java.util.*;\nimport q.Y;\npublic class X {\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("P/X.js");
            IImportDeclaration imp = cu.getImport("q.Y");
            this.startDeltas();
            this.assertDeletion((IJavaScriptElement)imp);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.java[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\t<import container>[*]: {CHILDREN | FINE GRAINED}\n\t\t\t\t\timport q.Y[-]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteFile("P/X.js");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/X.js");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteMethod() throws CoreException {
        try {
            this.createFile("P/X.js", "public class X {\n  public void foo() {\n  }\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("P/X.js");
            IFunction method = cu.getType("X").getFunction("foo", new String[0]);
            this.startDeltas();
            this.assertDeletion((IJavaScriptElement)method);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.java[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tX[*]: {CHILDREN | FINE GRAINED}\n\t\t\t\t\tfoo()[-]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteFile("P/X.js");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/X.js");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteMultipleMembersFromVariousCUs() throws CoreException {
        try {
            this.createFolder("P/a/b/c");
            this.createFile("P/a/b/c/X.js", "package a.b.c;\nimport java.util.Vector;\nimport java.util.Enumeration;\npublic class X {\n  public static void main(String[] args) {\n    System.out.println(\"Hello World\");\n  }\n  static class Bar {\n    private final java.lang.String test = \"testminor\";\n    public Bar() {\n      super();\n    }\n    private void test() {\n    }\n  }\n}");
            this.createFile("P/a/b/Y.js", "package a.b;\npublic class Y {\n  int foo;\n  public static void main(String[] args) {\n    System.out.println(\"Hello World\");\n  }\n}");
            IJavaScriptUnit cuX = this.getCompilationUnit("P/a/b/c/X.js");
            IType typeX = cuX.getType("X");
            IType typeBar = typeX.getType("Bar");
            IJavaScriptElement[] toBeDeleted = new IJavaScriptElement[8];
            toBeDeleted[0] = cuX.getImport("java.util.Vector");
            toBeDeleted[1] = typeX.getFunction("main", new String[]{"[QString;"});
            toBeDeleted[2] = typeBar;
            toBeDeleted[3] = typeBar.getFunction("Bar", new String[0]);
            toBeDeleted[4] = typeBar.getFunction("test", new String[0]);
            toBeDeleted[5] = typeBar;
            IJavaScriptUnit cuY = this.getCompilationUnit("P/a/b/Y.js");
            IType typeY = cuY.getType("Y");
            toBeDeleted[6] = typeY.getField("foo");
            toBeDeleted[7] = typeY.getFunction("main", new String[]{"[QString;"});
            this.startDeltas();
            this.assertDeletion(toBeDeleted);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\ta.b[*]: {CHILDREN}\n\t\t\tY.java[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tY[*]: {CHILDREN | FINE GRAINED}\n\t\t\t\t\tfoo[-]: {}\n\t\t\t\t\tmain(String[])[-]: {}\n\t\ta.b.c[*]: {CHILDREN}\n\t\t\tX.java[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\t<import container>[*]: {CHILDREN | FINE GRAINED}\n\t\t\t\t\timport java.util.Vector[-]: {}\n\t\t\t\tX[*]: {CHILDREN | FINE GRAINED}\n\t\t\t\t\tBar[-]: {}\n\t\t\t\t\tmain(String[])[-]: {}");
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.stopDeltas();
            this.deleteFolder("P/a");
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        this.stopDeltas();
        this.deleteFolder("P/a");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeletePackageDeclaration() throws CoreException {
        try {
            this.createFolder("P/a/b/c");
            this.createFile("P/a/b/c/X.js", "package a.b.c;\npublic class X {\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("P/a/b/c/X.js");
            IPackageDeclaration packageDeclaration = cu.getPackageDeclaration("a.b.c");
            this.startDeltas();
            this.assertDeletion((IJavaScriptElement)packageDeclaration);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\ta.b.c[*]: {CHILDREN}\n\t\t\tX.java[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tpackage a.b.c[-]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteFolder("P/a");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteFolder("P/a");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeletePackageFragment1() throws CoreException {
        try {
            this.createFolder("P/a/b/c");
            this.createFile("P/a/b/c/X.js", "package a.b.c;\npublic class X {\n}");
            IPackageFragment pkg = this.getPackage("P/a/b/c");
            IFolder folder = this.getFolder("P/a/b/c");
            this.startDeltas();
            pkg.delete(false, null);
            DeleteTests.assertTrue((String)"Folder should not exist", (!folder.exists() ? 1 : 0) != 0);
            DeleteTests.assertTrue((String)"Fragment should not exist", (!pkg.exists() ? 1 : 0) != 0);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\ta.b.c[-]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteFolder("P/p1");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteFolder("P/p1");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeletePackageFragment2() throws CoreException {
        try {
            this.createJavaProject("P1", new String[]{"src"}, "bin");
            IFile file = this.createFile("P1/src/X.js", "public class X {\n}");
            IPackageFragment pkg = this.getPackage("P1/src");
            IFolder folder = this.getFolder("P1/src");
            IJavaScriptUnit cu = this.getCompilationUnit("P1/src/X.js");
            this.startDeltas();
            pkg.delete(false, null);
            DeleteTests.assertTrue((String)"Folder should still exist", (boolean)folder.exists());
            DeleteTests.assertTrue((String)"Fragment should still exist", (boolean)pkg.exists());
            DeleteTests.assertTrue((String)"File should no longer exist", (!file.exists() ? 1 : 0) != 0);
            DeleteTests.assertTrue((String)"Compilation unit should no longer exist", (!cu.exists() ? 1 : 0) != 0);
            this.assertDeltas("Unexpected delta", "P1[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.java[-]: {}");
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.stopDeltas();
            this.deleteProject("P1");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.stopDeltas();
        this.deleteProject("P1");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeletePackageFragment3() throws CoreException {
        try {
            this.createJavaProject("P1");
            IFile file = this.createFile("P1/X.js", "public class X {\n}");
            IPackageFragment pkg = this.getPackage("P1");
            IProject project = this.getProject("P1");
            IJavaScriptUnit cu = this.getCompilationUnit("P1/X.js");
            this.startDeltas();
            pkg.delete(false, null);
            DeleteTests.assertTrue((String)"Project should still exist", (boolean)project.exists());
            DeleteTests.assertTrue((String)"Fragment should still exist", (boolean)pkg.exists());
            DeleteTests.assertTrue((String)"File should no longer exist", (!file.exists() ? 1 : 0) != 0);
            DeleteTests.assertTrue((String)"Compilation unit should no longer exist", (!cu.exists() ? 1 : 0) != 0);
            this.assertDeltas("Unexpected delta", "P1[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.java[-]: {}");
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.stopDeltas();
            this.deleteProject("P1");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.stopDeltas();
        this.deleteProject("P1");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeletePackageFragment4() throws CoreException {
        try {
            this.createJavaProject("P1");
            IFolder folder = this.createFolder("P1/p");
            IFile file = this.createFile("P1/p/X.class", "");
            IPackageFragment pkg = this.getPackage("P1/p");
            this.startDeltas();
            pkg.delete(false, null);
            DeleteTests.assertTrue((String)"Folder should no longer exist", (!folder.exists() ? 1 : 0) != 0);
            DeleteTests.assertTrue((String)"Fragment should no longer exist", (!pkg.exists() ? 1 : 0) != 0);
            DeleteTests.assertTrue((String)"File should no longer exist", (!file.exists() ? 1 : 0) != 0);
            this.assertDeltas("Unexpected delta", "P1[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\tp[-]: {}");
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.stopDeltas();
            this.deleteProject("P1");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.stopDeltas();
        this.deleteProject("P1");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteSyntaxErrorField() throws CoreException {
        try {
            this.createFile("P/X.js", "public class X {\n  int field\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("P/X.js");
            IField field = cu.getType("X").getField("field");
            this.startDeltas();
            this.assertDeletion((IJavaScriptElement)field);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.java[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tX[*]: {CHILDREN | FINE GRAINED}\n\t\t\t\t\tfield[-]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteFile("P/X.js");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/X.js");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteSyntaxErrorInMethod1() throws CoreException {
        try {
            this.createFile("P/X.js", "public class X {\n  public void foo() {\n    String s = ;\n    System.out.println(s);\n  }\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("P/X.js");
            IFunction method = cu.getType("X").getFunction("foo", new String[0]);
            this.startDeltas();
            this.assertDeletion((IJavaScriptElement)method);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.java[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tX[*]: {CHILDREN | FINE GRAINED}\n\t\t\t\t\tfoo()[-]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteFile("P/X.js");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/X.js");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteSyntaxErrorInMethod2() throws CoreException {
        try {
            this.createFile("P/X.js", "public class X {\n  public void foo() \n}");
            IJavaScriptUnit cu = this.getCompilationUnit("P/X.js");
            IFunction method = cu.getType("X").getFunction("foo", new String[0]);
            this.startDeltas();
            this.assertDeletion((IJavaScriptElement)method);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.java[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tX[*]: {CHILDREN | FINE GRAINED}\n\t\t\t\t\tfoo()[-]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteFile("P/X.js");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/X.js");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteSyntaxErrorInMethod3() throws CoreException {
        try {
            this.createFile("P/X.js", "public class X {\n  public void foo( \n  }\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("P/X.js");
            IFunction method = cu.getType("X").getFunction("foo", new String[0]);
            this.startDeltas();
            this.assertDeletion((IJavaScriptElement)method);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.java[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tX[*]: {CHILDREN | FINE GRAINED}\n\t\t\t\t\tfoo()[-]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteFile("P/X.js");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/X.js");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteSyntaxErrorType() throws CoreException {
        try {
            this.createFile("P/X.js", "public class X {\n  method() {\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("P/X.js");
            IType type = cu.getType("X");
            this.startDeltas();
            this.assertDeletion((IJavaScriptElement)type);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.java[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tX[-]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteFile("P/X.js");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/X.js");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteType1() throws CoreException {
        try {
            this.createFile("P/X.js", "public class X {\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("P/X.js");
            IType type = cu.getType("X");
            this.startDeltas();
            this.assertDeletion((IJavaScriptElement)type);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.java[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tX[-]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteFile("P/X.js");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/X.js");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteType2() throws CoreException {
        try {
            this.createJavaProject("P1", new String[]{"src"}, "bin");
            this.createFile("P1/src/X.js", "public class X {\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("P1/src/X.js");
            IType type = cu.getType("X");
            this.startDeltas();
            this.assertDeletion((IJavaScriptElement)type);
            this.assertDeltas("Unexpected delta", "P1[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.java[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tX[-]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteProject("P1");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteProject("P1");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteWithInvalidInput() throws CoreException {
        IType type = null;
        try {
            try {
                this.createFile("P/X.js", "public class X {\n}");
                IJavaScriptUnit cu = this.getCompilationUnit("P/X.js");
                type = cu.getType("X");
                this.getJavaModel().delete(null, false, null);
            }
            catch (JavaScriptModelException e) {
                DeleteTests.assertTrue((String)"Should be an no elements to process: null supplied", (e.getStatus().getCode() == 968 ? 1 : 0) != 0);
                try {
                    this.getJavaModel().delete(new IJavaScriptElement[]{type}, false, null);
                }
                catch (JavaScriptModelException e2) {
                    DeleteTests.assertTrue((String)"Should be an no elements to process: null in the array supplied", (e2.getStatus().getCode() == 968 ? 1 : 0) != 0);
                }
                Object var4_5 = null;
                this.deleteFile("P/X.js");
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.deleteFile("P/X.js");
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        this.deleteFile("P/X.js");
    }
}

