/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.tests;

import java.util.ArrayList;
import javax.jws.WebService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.jaxws.core.tests.AbstractAnnotationTest;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;

public class AddAnnotationToTypeTest
extends AbstractAnnotationTest {
    public String getPackageName() {
        return "com.example";
    }

    public String getClassName() {
        return "Calculator.java";
    }

    public String getClassContents() {
        StringBuilder classContents = new StringBuilder("package com.example;\n\n");
        classContents.append("public class Calculator {\n\n\tpublic int add(int i, int k) {");
        classContents.append("\n\t\treturn i + k;\n\t}\n}");
        return classContents.toString();
    }

    public Annotation getAnnotation() {
        ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
        MemberValuePair nameValuePair = AnnotationsCore.createStringMemberValuePair((AST)this.ast, (String)"name", (Object)"Calculator");
        MemberValuePair targetNamespaceValuePair = AnnotationsCore.createStringMemberValuePair((AST)this.ast, (String)"targetNamespace", (Object)JDTUtils.getTargetNamespaceFromPackageName((String)this.getPackageName()));
        MemberValuePair portNameValuePair = AnnotationsCore.createStringMemberValuePair((AST)this.ast, (String)"portName", (Object)"CalculatorPort");
        MemberValuePair serviceNameValuePair = AnnotationsCore.createStringMemberValuePair((AST)this.ast, (String)"serviceName", (Object)"CalculatorService");
        memberValuePairs.add(nameValuePair);
        memberValuePairs.add(targetNamespaceValuePair);
        memberValuePairs.add(portNameValuePair);
        memberValuePairs.add(serviceNameValuePair);
        return AnnotationsCore.createAnnotation((AST)this.ast, WebService.class, (String)WebService.class.getSimpleName(), memberValuePairs);
    }

    public void testAddAnnotationToType() {
        try {
            AddAnnotationToTypeTest.assertNotNull((Object)this.annotation);
            AddAnnotationToTypeTest.assertEquals((String)WebService.class.getSimpleName(), (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation));
            AnnotationUtils.addImportEdit((CompilationUnit)this.compilationUnit, WebService.class, (TextFileChange)this.textFileChange, (boolean)true);
            AnnotationUtils.addAnnotationToType((ICompilationUnit)this.source, (CompilationUnit)this.compilationUnit, (ASTRewrite)this.rewriter, (IType)this.source.findPrimaryType(), (Annotation)this.annotation, (TextFileChange)this.textFileChange);
            AddAnnotationToTypeTest.assertTrue((boolean)this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)this.textFileChange));
            AddAnnotationToTypeTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)this.source, (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation)));
        }
        catch (CoreException ce) {
            AddAnnotationToTypeTest.fail((String)ce.getLocalizedMessage());
        }
    }
}

