/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.tests;

import java.util.ArrayList;
import javax.jws.WebMethod;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.jaxws.core.tests.AbstractAnnotationTest;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;

public class AddAnnotationToMethodTest
extends AbstractAnnotationTest {
    public String getPackageName() {
        return "com.example";
    }

    public String getClassName() {
        return "Calculator.java";
    }

    public String getClassContents() {
        StringBuilder classContents = new StringBuilder("package com.example;\n\n");
        classContents.append("public class Calculator {\n\n\tpublic int add(int i, int k) {");
        classContents.append("\n\t\treturn i + k;\n\t}\n}");
        return classContents.toString();
    }

    public Annotation getAnnotation() {
        ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
        MemberValuePair operationValuePair = AnnotationsCore.createStringMemberValuePair((AST)this.ast, (String)"operationName", (Object)"add");
        memberValuePairs.add(operationValuePair);
        return AnnotationsCore.createAnnotation((AST)this.ast, WebMethod.class, (String)WebMethod.class.getSimpleName(), memberValuePairs);
    }

    public void testAddAnnotationToMethod() {
        try {
            AddAnnotationToMethodTest.assertNotNull((Object)this.annotation);
            AddAnnotationToMethodTest.assertEquals((String)WebMethod.class.getSimpleName(), (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation));
            IMethod method = this.source.findPrimaryType().getMethod("add", new String[]{"I", "I"});
            AddAnnotationToMethodTest.assertNotNull((Object)method);
            AnnotationUtils.addImportEdit((CompilationUnit)this.compilationUnit, WebMethod.class, (TextFileChange)this.textFileChange, (boolean)true);
            AnnotationUtils.addAnnotationToMethod((ICompilationUnit)this.source, (CompilationUnit)this.compilationUnit, (ASTRewrite)this.rewriter, (IMethod)method, (Annotation)this.annotation, (TextFileChange)this.textFileChange);
            AddAnnotationToMethodTest.assertTrue((boolean)this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)this.textFileChange));
            AddAnnotationToMethodTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)method, (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation)));
        }
        catch (CoreException ce) {
            AddAnnotationToMethodTest.fail((String)ce.getLocalizedMessage());
        }
    }
}

