/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.creation.core.commands;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jst.ws.internal.cxf.core.CXFCorePlugin;
import org.eclipse.jst.ws.internal.cxf.core.context.Java2WSPersistentContext;
import org.eclipse.jst.ws.internal.cxf.core.model.CXFDataModel;
import org.eclipse.jst.ws.internal.cxf.core.model.Java2WSDataModel;
import org.eclipse.jst.ws.internal.cxf.core.resources.JavaResourceChangeListener;
import org.eclipse.jst.ws.internal.cxf.core.resources.WebContentChangeListener;
import org.eclipse.jst.ws.internal.cxf.core.utils.CommandLineUtils;
import org.eclipse.jst.ws.internal.cxf.core.utils.FileUtils;
import org.eclipse.jst.ws.internal.cxf.core.utils.LaunchUtils;
import org.eclipse.jst.ws.internal.cxf.core.utils.SpringUtils;
import org.eclipse.jst.ws.internal.cxf.creation.core.CXFCreationCorePlugin;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class Java2WSCommand
extends AbstractDataModelOperation {
    private static String JAVA2WSDL_TOOL_CLASS_NAME = "org.apache.cxf.tools.java2wsdl.JavaToWSDL";
    private static String JAVA2WS_TOOL_CLASS_NAME = "org.apache.cxf.tools.java2ws.JavaToWS";
    private String CXF_TOOL_CLASS_NAME;
    private Java2WSDataModel model;
    private String projectName;
    private JavaResourceChangeListener javaResourceChangeListener;
    private WebContentChangeListener webContentChangeListener;

    public Java2WSCommand(Java2WSDataModel model) {
        this.model = model;
        this.projectName = model.getProjectName();
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        this.javaResourceChangeListener = new JavaResourceChangeListener(JDTUtils.getJavaProjectSourceDirectoryPath((String)this.projectName, (String)this.model.getJavaStartingPoint()));
        this.webContentChangeListener = new WebContentChangeListener(this.projectName);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.javaResourceChangeListener, 1);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.webContentChangeListener, 1);
        this.CXF_TOOL_CLASS_NAME = this.model.getCxfRuntimeVersion().compareTo("2.1") >= 0 ? JAVA2WS_TOOL_CLASS_NAME : JAVA2WSDL_TOOL_CLASS_NAME;
        String[] progArgs = CommandLineUtils.getJava2WSProgramArguments((Java2WSDataModel)this.model);
        try {
            try {
                IProject project = FileUtils.getProject((String)this.projectName);
                IJavaProject javaProject = JDTUtils.getJavaProject((IProject)project);
                LaunchUtils.launch((IJavaProject)javaProject, (String)this.CXF_TOOL_CLASS_NAME, (String[])progArgs);
                FileUtils.copyJ2WFilesFromTmp((Java2WSDataModel)this.model);
                if (this.model.isGenerateWSDL()) {
                    SpringUtils.loadSpringConfigInformationFromWSDL((CXFDataModel)this.model);
                }
                if (this.isImplementationSelected() || this.isGenerateServer()) {
                    SpringUtils.createJAXWSEndpoint((CXFDataModel)this.model);
                }
            }
            catch (CoreException ce) {
                status = ce.getStatus();
                CXFCreationCorePlugin.log(status);
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.javaResourceChangeListener);
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.webContentChangeListener);
                FileUtils.refreshProject((String)this.projectName, (IProgressMonitor)monitor);
            }
            catch (IOException ioe) {
                status = new Status(4, "org.eclipse.jst.ws.cxf.creation.core", ioe.getLocalizedMessage());
                CXFCreationCorePlugin.log(status);
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.javaResourceChangeListener);
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.webContentChangeListener);
                FileUtils.refreshProject((String)this.projectName, (IProgressMonitor)monitor);
            }
        }
        finally {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.javaResourceChangeListener);
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.webContentChangeListener);
            FileUtils.refreshProject((String)this.projectName, (IProgressMonitor)monitor);
        }
        return status;
    }

    private boolean isImplementationSelected() {
        return this.model.getFullyQualifiedJavaClassName() != null && this.model.getFullyQualifiedJavaClassName().trim().length() > 0;
    }

    private boolean isGenerateServer() {
        if (this.model.isGenerateServer()) {
            this.model.setFullyQualifiedJavaClassName(String.valueOf(this.model.getFullyQualifiedJavaInterfaceName()) + "Impl");
            return true;
        }
        return false;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        ArrayList changedResources = new ArrayList();
        changedResources.addAll(this.javaResourceChangeListener.getChangedResources());
        changedResources.addAll(this.webContentChangeListener.getChangedResources());
        if (changedResources.size() > 0) {
            for (IResource resource : changedResources) {
                try {
                    resource.delete(true, monitor);
                }
                catch (CoreException ce) {
                    status = ce.getStatus();
                    CXFCreationCorePlugin.log(status);
                }
            }
        }
        Java2WSPersistentContext context = CXFCorePlugin.getDefault().getJava2WSContext();
        this.model.setGenerateClient(context.isGenerateClient());
        this.model.setGenerateServer(context.isGenerateServer());
        this.model.setGenerateWrapperFaultBeans(context.isGenerateWrapperFaultBeans());
        this.model.setGenerateWSDL(context.isGenerateWSDL());
        this.model.setSoap12Binding(context.isSoap12Binding());
        this.model.setGenerateXSDImports(context.isGenerateXSDImports());
        return status;
    }

    public CXFDataModel getCXFDataModel() {
        return this.model;
    }
}

