/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.core.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.cxf.core.model.Java2WSDataModel;
import org.eclipse.jst.ws.internal.cxf.core.model.WSDL2JavaDataModel;
import org.eclipse.jst.ws.internal.cxf.core.utils.CXFModelUtils;
import org.eclipse.jst.ws.internal.cxf.core.utils.FileUtils;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;

public final class CommandLineUtils {
    private static String OUT_FILE = "-o";
    private static String RESOURCE_DIR = "-d";
    private static String SOURCE_DIR = "-s";
    private static String CLASS_DIR = "-classdir";
    private static String J2W_CLASSPATH = "-cp";
    private static String INC_SOAP12 = "-soap12";
    private static String TARGET_NAMESPACE = "-t";
    private static String J2W_SERVICE_NAME = "-servicename";
    private static String PORT_NAME = "-portname";
    private static String GEN_XSD_IMPORTS = "-createxsdimports";
    private static String VERBOSE = "-verbose";
    private static String J2W_FRONTEND = "-frontend";
    private static String J2W_DATABINDING = "-databinding";
    private static String BEAN_PATH = "-beans";
    private static String GEN_WSDL = "-wsdl";
    private static String GEN_CLIENT = "-client";
    private static String GEN_SERVER = "-server";
    private static String GEN_WRAPPER_FAULT = "-wrapperbean";
    private static String W2J_PACKAGE_NAME = "-p";
    private static String W2J_BINDING_NAME = "-b";
    private static String W2J_FRONTEND = "-fe";
    private static String W2J_DATABINDING = "-db";
    private static String W2J_WSDL_VERSION = "-wv";
    private static String W2J_SERVICE_NAME = "-sn";
    private static String W2J_CATALOG = "-catalog";
    private static String W2J_COMPILE = "-compile";
    private static String W2J_GEN_IMPL = "-impl";
    private static String W2J_GEN_ALL = "-all";
    private static String W2J_NO_OVERWRITE = "-keep";
    private static String W2J_DEFAULT_VALUES = "-defaultValues";
    private static String W2J_AUTO_NAME_RESOLUTION = "-autoNameResolution";
    private static String W2J_EXCLUDE_NAMESPACE = "-nexclude";
    private static String W2J_EXT_SOAP_HEADER = "-exsh";
    private static String W2J_DEFAULT_NAMESPACE = "-dns";
    private static String W2J_DEFAULT_EXCLUDE_NS = "-dex";
    private static String W2J_WSDL_LOCATION = "-wsdlLocation";
    private static String W2J_XJC_ARGS = "-xjc";
    private static String W2J_NO_ADDRESS_BINDING = "-noAddressBinding";
    private static String W2J_VALIDATE_WSDL = "-validate";
    private static final String XJC_DV_ARG = "-Xdv";
    private static final String XJC_TS_ARG = "-Xts";
    private static final String XJC_TS_MULTI_ARG = "-Xts:style:multiline";
    private static final String XJC_TS_SIMPLE = "-Xts:style:simple";
    private static final String XJC_LOCATOR_ARG = "-Xlocator";
    private static final String XJC_SYNC_METHODS_ARG = "-Xsync-methods";
    private static final String XJC_MARK_GENERATED_ARG = "-mark-generated";
    private static final String XJC_EPISODE_FILE_ARG = "-episode";

    private CommandLineUtils() {
    }

    public static String[] getJava2WSProgramArguments(Java2WSDataModel model) {
        ArrayList<String> progArgs = new ArrayList<String>();
        IProject project = ResourceUtils.getWorkspaceRoot().getProject(model.getProjectName());
        if (project != null && project.exists() && JDTUtils.isJavaProject((IProject)project)) {
            String className = model.getJavaStartingPoint();
            if (model.isUseServiceEndpointInterface() && model.getFullyQualifiedJavaClassName() != null) {
                className = model.getFullyQualifiedJavaClassName();
            }
            progArgs.addAll(Arrays.asList(CommandLineUtils.getStandardJava2WSDLProgramArguments(model)));
            if (model.getCxfRuntimeVersion().compareTo("2.1") >= 0) {
                progArgs.add(J2W_FRONTEND);
                progArgs.add(model.getFrontend().getLiteral());
                progArgs.add(J2W_DATABINDING);
                progArgs.add(model.getDatabinding().getLiteral());
                if (model.isGenerateWSDL()) {
                    progArgs.add(GEN_WSDL);
                } else {
                    progArgs.remove(OUT_FILE);
                    progArgs.remove(model.getWsdlFileName());
                }
                if (model.isGenerateClient()) {
                    progArgs.add(GEN_CLIENT);
                }
                if (model.isGenerateServer()) {
                    progArgs.add(GEN_SERVER);
                }
                if (model.isGenerateWrapperFaultBeans()) {
                    progArgs.add(GEN_WRAPPER_FAULT);
                }
            }
            progArgs.add(className);
        }
        return progArgs.toArray(new String[progArgs.size()]);
    }

    private static String[] getStandardJava2WSDLProgramArguments(Java2WSDataModel model) {
        String projectName = model.getProjectName();
        ArrayList<String> progArgs = new ArrayList<String>();
        progArgs.add(J2W_CLASSPATH);
        progArgs.add(JDTUtils.getJavaProjectOutputDirectoryPath((String)projectName));
        progArgs.add(SOURCE_DIR);
        progArgs.add(String.valueOf(FileUtils.getTmpFolder(projectName)) + "/src");
        progArgs.add(RESOURCE_DIR);
        progArgs.add(String.valueOf(FileUtils.getTmpFolder(projectName)) + "/wsdl");
        progArgs.add(CLASS_DIR);
        progArgs.add(JDTUtils.getJavaProjectOutputDirectoryPath((String)projectName));
        progArgs.add(OUT_FILE);
        progArgs.add(model.getWsdlFileName());
        if (model.isSoap12Binding()) {
            progArgs.add(INC_SOAP12);
        }
        if (model.isGenerateXSDImports()) {
            progArgs.add(GEN_XSD_IMPORTS);
        }
        if (model.isVerbose()) {
            progArgs.add(VERBOSE);
        }
        return progArgs.toArray(new String[progArgs.size()]);
    }

    public static String[] getWSDL2JavaProgramArguments(WSDL2JavaDataModel model) {
        String projectName = model.getProjectName();
        ArrayList<String> progArgs = new ArrayList<String>();
        IProject project = ResourceUtils.getWorkspaceRoot().getProject(projectName);
        if (project != null && project.exists() && JDTUtils.isJavaProject((IProject)project)) {
            progArgs.addAll(Arrays.asList(CommandLineUtils.getStandardWSDL2JavaProgramArguments(model, projectName)));
            String serviceName = model.getServiceName();
            if (serviceName != null && serviceName.length() > 0) {
                progArgs.add(W2J_SERVICE_NAME);
                progArgs.add(serviceName);
            }
            if (model.isUseDefaultValues()) {
                progArgs.add(W2J_DEFAULT_VALUES);
            }
            if (model.getCxfRuntimeVersion().compareTo("2.1") >= 0) {
                progArgs.add(W2J_FRONTEND);
                progArgs.add(model.getFrontend().getLiteral());
                progArgs.add(W2J_DATABINDING);
                progArgs.add(model.getDatabinding().getLiteral());
                progArgs.add(W2J_WSDL_VERSION);
                progArgs.add(model.getWsdlVersion());
                if (model.isNoAddressBinding()) {
                    progArgs.add(W2J_NO_ADDRESS_BINDING);
                }
            }
            progArgs.add(model.getWsdlURL().toExternalForm());
        }
        return progArgs.toArray(new String[progArgs.size()]);
    }

    public static String[] getWSDL2JavaGenerateClientArguments(WSDL2JavaDataModel model) {
        String projectName = model.getProjectName();
        ArrayList<String> progArgs = new ArrayList<String>();
        IProject project = ResourceUtils.getWorkspaceRoot().getProject(projectName);
        if (project != null && project.exists() && JDTUtils.isJavaProject((IProject)project)) {
            progArgs.add(GEN_CLIENT);
            progArgs.addAll(Arrays.asList(CommandLineUtils.getWSDL2JavaProgramArguments(model)));
        }
        return progArgs.toArray(new String[progArgs.size()]);
    }

    public static String[] getStandardWSDL2JavaProgramArguments(WSDL2JavaDataModel model, String projectName) {
        String string;
        EList<String> bindingFiles;
        ArrayList<String> progArgs = new ArrayList<String>();
        progArgs.add(RESOURCE_DIR);
        progArgs.add(String.valueOf(FileUtils.getTmpFolder(projectName)) + "/src");
        progArgs.add(CLASS_DIR);
        progArgs.add(JDTUtils.getJavaProjectOutputDirectoryPath((String)projectName));
        Map<String, String> includedNamespaces = model.getIncludedNamespaces();
        if (includedNamespaces != null && model.getIncludedNamespaces().size() > 0) {
            Set<Map.Entry<String, String>> includedNamespacesEntrySet = includedNamespaces.entrySet();
            for (Map.Entry entry : includedNamespacesEntrySet) {
                progArgs.add(W2J_PACKAGE_NAME);
                String wsdlNamespace = (String)entry.getKey();
                String packageName = (String)entry.getValue();
                progArgs.add(String.valueOf(wsdlNamespace) + "=" + packageName);
            }
        }
        if (!(bindingFiles = model.getBindingFiles()).isEmpty()) {
            for (String string2 : bindingFiles) {
                progArgs.add(W2J_BINDING_NAME);
                progArgs.add(string2);
            }
        }
        if (model.isGenerateServer()) {
            progArgs.add(GEN_SERVER);
        }
        if (model.isGenerateImplementation()) {
            progArgs.add(W2J_GEN_IMPL);
        }
        if (model.isValidate()) {
            progArgs.add(W2J_VALIDATE_WSDL);
        }
        progArgs.add(W2J_EXT_SOAP_HEADER);
        progArgs.add(Boolean.toString(model.isProcessSOAPHeaders()));
        progArgs.add(W2J_DEFAULT_NAMESPACE);
        progArgs.add(Boolean.toString(model.isLoadDefaultNamespacePackageNameMapping()));
        progArgs.add(W2J_DEFAULT_EXCLUDE_NS);
        progArgs.add(Boolean.toString(model.isLoadDefaultExcludesNamepsaceMapping()));
        if (model.isAutoNameResolution() && CXFModelUtils.isAutoNameResolutionPermitted()) {
            progArgs.add(W2J_AUTO_NAME_RESOLUTION);
        }
        if ((string = CommandLineUtils.getXJCArgs(model)).trim().length() > 0) {
            progArgs.add(String.valueOf(W2J_XJC_ARGS) + string);
        }
        if (model.getWsdlLocation() != null) {
            progArgs.add(W2J_WSDL_LOCATION);
            progArgs.add(model.getWsdlLocation());
        }
        if (model.isVerbose()) {
            progArgs.add(VERBOSE);
        }
        return progArgs.toArray(new String[progArgs.size()]);
    }

    private static String getXJCArgs(WSDL2JavaDataModel model) {
        ArrayList<String> xjcArgs = new ArrayList<String>();
        if (model.isXjcUseDefaultValues()) {
            xjcArgs.add(XJC_DV_ARG);
        }
        if (model.isXjcToString()) {
            xjcArgs.add(XJC_TS_ARG);
        }
        if (model.isXjcToStringMultiLine()) {
            xjcArgs.add(XJC_TS_MULTI_ARG);
        }
        if (model.isXjcToStringSimple()) {
            xjcArgs.add(XJC_TS_SIMPLE);
        }
        if (model.isXjcLocator()) {
            xjcArgs.add(XJC_LOCATOR_ARG);
        }
        if (model.isXjcSyncMethods()) {
            xjcArgs.add(XJC_SYNC_METHODS_ARG);
        }
        if (model.isXjcMarkGenerated()) {
            xjcArgs.add(XJC_MARK_GENERATED_ARG);
        }
        String xjcArg = ((Object)xjcArgs).toString();
        xjcArg = xjcArg.replace('[', ' ');
        xjcArg = xjcArg.replace(']', ' ');
        xjcArg = xjcArg.replaceAll("\\s", "");
        return xjcArg.trim();
    }
}

