/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.core.resources;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.ws.internal.cxf.core.CXFCorePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaResourceChangeListener
implements IResourceChangeListener {
    private List<IResource> changedResources = new ArrayList<IResource>();
    private String sourceDirectoryPath;

    public JavaResourceChangeListener(String sourceDirectoryPath) {
        this.sourceDirectoryPath = sourceDirectoryPath;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta javaResourceDelta;
        if (event.getType() != 1) {
            return;
        }
        IResourceDelta rootDelta = event.getDelta();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFolder srcFolder = workspaceRoot.getFolder((IPath)new Path(this.sourceDirectoryPath));
        IPath srcFolderPath = srcFolder.getFullPath();
        if (!srcFolderPath.hasTrailingSeparator()) {
            srcFolderPath = srcFolderPath.addTrailingSeparator();
        }
        if ((javaResourceDelta = rootDelta.findMember(srcFolderPath)) == null) {
            return;
        }
        IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) {
                if (delta.getKind() != 1) {
                    return true;
                }
                IResource resource = delta.getResource();
                JavaResourceChangeListener.this.changedResources.add(resource);
                return true;
            }
        };
        try {
            javaResourceDelta.accept(visitor);
        }
        catch (CoreException ce) {
            CXFCorePlugin.log(ce.getStatus());
        }
    }

    public List<IResource> getChangedResources() {
        return this.changedResources;
    }
}

