/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.cxf.core.context.Java2WSPersistentContext;
import org.eclipse.jst.ws.internal.cxf.core.context.WSDL2JavaPersistentContext;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class CXFCorePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.jst.ws.cxf.core";
    public static final String CXF_VERSION_2_0 = "2.0";
    public static final String CXF_VERSION_2_1 = "2.1";
    private static CXFCorePlugin plugin;
    private Java2WSPersistentContext java2WSContext;
    private WSDL2JavaPersistentContext wsdl2JavaContext;
    private Version currentRuntimeVersion;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static CXFCorePlugin getDefault() {
        return plugin;
    }

    public Java2WSPersistentContext getJava2WSContext() {
        if (this.java2WSContext == null) {
            this.java2WSContext = new Java2WSPersistentContext();
            this.java2WSContext.load();
        }
        return this.java2WSContext;
    }

    public WSDL2JavaPersistentContext getWSDL2JavaContext() {
        if (this.wsdl2JavaContext == null) {
            this.wsdl2JavaContext = new WSDL2JavaPersistentContext();
            this.wsdl2JavaContext.load();
        }
        return this.wsdl2JavaContext;
    }

    public Version getCurrentRuntimeVersion() {
        if (this.currentRuntimeVersion == null) {
            String cxfRuntimeVersion = CXFCorePlugin.getDefault().getJava2WSContext().getCxfRuntimeVersion();
            if (cxfRuntimeVersion.length() == 0) {
                cxfRuntimeVersion = "0.0.0";
            }
            this.currentRuntimeVersion = new Version(cxfRuntimeVersion);
        }
        return this.currentRuntimeVersion;
    }

    public void setCurrentRuntimeVersion(Version version) {
        this.currentRuntimeVersion = version;
    }

    public static void logMessage(int severity, String message) {
        CXFCorePlugin.log((IStatus)new Status(severity, PLUGIN_ID, message));
    }

    public static void log(IStatus status) {
        CXFCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable exception) {
        CXFCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, exception.toString(), exception));
    }
}

