/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.validation.caret;

import java.util.Arrays;
import org.eclipse.gef.EditPart;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.validation.caret.ActionData;
import org.eclipse.jst.pagedesigner.validation.caret.DefaultPositionRule;
import org.eclipse.jst.pagedesigner.validation.caret.JSFRootContainerPositionRule;
import org.eclipse.jst.pagedesigner.validation.caret.Target;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class RootContainerPositionRule
extends DefaultPositionRule {
    static final String[] HTML_ROOT_CONTAINERS = new String[]{"body"};

    public RootContainerPositionRule(ActionData actionData) {
        super(actionData);
    }

    public boolean hasEditableArea(Target target) {
        EditPart part = target.getPart();
        if (part == null) {
            return false;
        }
        Node node = target.getNode();
        if (RootContainerPositionRule.hasBasicContainers(EditModelQuery.getDocumentNode(node))) {
            return true;
        }
        return super.hasEditableArea(target);
    }

    public boolean isEditable(Target target) {
        Node node = target.getNode();
        if (RootContainerPositionRule.hasBasicContainers(EditModelQuery.getDocumentNode(node))) {
            boolean result = RootContainerPositionRule.isWithinkBasicContainer(node);
            return result;
        }
        return super.isEditable(target);
    }

    public static boolean hasBasicContainers(Document document) {
        return RootContainerPositionRule.getBasicContainer(document) != null;
    }

    private static boolean isWithinkBasicContainer(Node node) {
        return EditModelQuery.isChild(HTML_ROOT_CONTAINERS, node, true, false);
    }

    public static Node getBasicContainer(Document document) {
        Node node = EditModelQuery.getChild(document, HTML_ROOT_CONTAINERS, 2, false);
        if (node == null) {
            node = EditModelQuery.getChild(document, HTML_ROOT_CONTAINERS, 2, true);
        }
        return node;
    }

    public boolean canReference(Target target, boolean atRight) {
        Node node = target.getNode();
        if (node.getLocalName() != null && Arrays.asList(HTML_ROOT_CONTAINERS).contains(node.getLocalName().toLowerCase())) {
            return EditModelQuery.isChild(JSFRootContainerPositionRule.JSF_ROOT_CONTAINERS, node, false, false);
        }
        return true;
    }
}

