/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el.tests.jsp;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.tests.validation.MockValidationReporter;
import org.eclipse.jst.jsf.metadataprocessors.MetaDataEnabledProcessingFactory;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidValues;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.jst.jsf.validation.el.tests.ELValidationTestPlugin;
import org.eclipse.jst.jsf.validation.el.tests.base.ELAssert;
import org.eclipse.jst.jsf.validation.el.tests.base.SingleJSPTestCase;
import org.w3c.dom.Attr;

public class LoadBundleResolutionTestCase
extends SingleJSPTestCase {
    public LoadBundleResolutionTestCase() {
        super("/testdata/jsps/loadBundleResolution.jsp.data", "/loadBundleResolution.jsp", JSFVersion.V1_1, "/testdata/web/faces-config_1_1.xml.data");
    }

    protected void setUp() throws Exception {
        super.setUp();
        TestFileResource resource = new TestFileResource();
        resource.load(ELValidationTestPlugin.getDefault().getBundle(), "/testdata/classes/Bundle.properties.data");
        this._jdtTestEnv.addResourceFile("src", (InputStream)new ByteArrayInputStream(resource.toBytes()), "", "Bundle.properties");
    }

    public void testSanity() {
        LoadBundleResolutionTestCase.assertEquals((String)"bundle.bundleProp2", (String)ELAssert.getELText(this._structuredDocument, 1003));
        LoadBundleResolutionTestCase.assertEquals((String)"noPackageBundle.bundleProp2", (String)ELAssert.getELText(this._structuredDocument, 1051));
        LoadBundleResolutionTestCase.assertEquals((String)"bundle.bundleProp1 && myBean.stringProperty", (String)ELAssert.getELText(this._structuredDocument, 1111));
        LoadBundleResolutionTestCase.assertEquals((String)"empty bundle", (String)ELAssert.getELText(this._structuredDocument, 1187));
        LoadBundleResolutionTestCase.assertEquals((String)"empty bundle.bundleProp2", (String)ELAssert.getELText(this._structuredDocument, 1232));
        LoadBundleResolutionTestCase.assertEquals((String)"bundle.bundleProp2 + 5", (String)ELAssert.getELText(this._structuredDocument, 1289));
        LoadBundleResolutionTestCase.assertEquals((String)"bundleProp2", (String)ELAssert.getELText(this._structuredDocument, 1341));
        LoadBundleResolutionTestCase.assertEquals((String)"bundle.x.y", (String)ELAssert.getELText(this._structuredDocument, 1382));
        LoadBundleResolutionTestCase.assertEquals((String)"noPackageBundle.x.y", (String)ELAssert.getELText(this._structuredDocument, 1422));
        LoadBundleResolutionTestCase.assertEquals((String)"-bundle.bundleProp1", (String)ELAssert.getELText(this._structuredDocument, 1496));
        LoadBundleResolutionTestCase.assertEquals((String)"bundle.bundleProp3", (String)ELAssert.getELText(this._structuredDocument, 1548));
        LoadBundleResolutionTestCase.assertEquals((String)"msg", (String)ELAssert.getELText(this._structuredDocument, 1599));
        LoadBundleResolutionTestCase.assertEquals((String)"bundle.x", (String)ELAssert.getELText(this._structuredDocument, 1635));
        LoadBundleResolutionTestCase.assertEquals((String)"noPackageBundle.notAProperty", (String)ELAssert.getELText(this._structuredDocument, 1673));
    }

    public void testNoErrorExprs() {
        this.assertNoError(1003, "Ljava.lang.String;");
        this.assertNoError(1051, "Ljava.lang.String;");
        this.assertNoError(1111, "Z");
        this.assertNoError(1187, "Z");
        this.assertNoError(1232, "Z");
        this.assertNoError(1289, "J");
        this.assertNoError(1382, "Ljava.lang.String;");
        this.assertNoError(1422, "Ljava.lang.String;");
    }

    public void testWarningExprs() {
        List<MockValidationReporter.ReportedProblem> list = this.assertSemanticWarning(1496, "J", 1);
        ELAssert.assertContainsProblem(list, 17);
        list = this.assertSemanticWarning(1548, null, 1);
        ELAssert.assertContainsProblem(list, 19);
        this.ensureMissingBundleValidation();
        list = this.assertSemanticWarning(1635, null, 1);
        ELAssert.assertContainsProblem(list, 29);
        list = this.assertSemanticWarning(1673, null, 1);
        ELAssert.assertContainsProblem(list, 19);
    }

    public void testErrorExprs() {
    }

    private void ensureMissingBundleValidation() {
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)this._structuredDocument, 839);
        IDOMContextResolver contextResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(context);
        Attr attr = (Attr)contextResolver.getNode();
        String attributeVal = attr.getValue();
        LoadBundleResolutionTestCase.assertEquals((String)"TestMessages", (String)attributeVal);
        LoadBundleResolutionTestCase.assertEquals((String)"basename", (String)attr.getLocalName());
        List vv = MetaDataEnabledProcessingFactory.getInstance().getAttributeValueRuntimeTypeFeatureProcessors(IValidValues.class, context, "http://java.sun.com/jsf/core", "loadBundle", "basename");
        boolean validatesMissingBundle = false;
        for (IValidValues v : vv) {
            if (attributeVal == null) {
                attributeVal = "";
            }
            if (v.isValidValue(attributeVal.trim()) || v.getValidationMessages().size() <= 0) continue;
            validatesMissingBundle = true;
            break;
        }
        LoadBundleResolutionTestCase.assertTrue((boolean)validatesMissingBundle);
    }
}

