/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el.tests.jsp;

import java.util.List;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.tests.validation.MockValidationReporter;
import org.eclipse.jst.jsf.validation.el.tests.base.ELAssert;
import org.eclipse.jst.jsf.validation.el.tests.base.SingleJSPTestCase;

public class BeanVariableResolutionTestCase
extends SingleJSPTestCase {
    public BeanVariableResolutionTestCase() {
        super("/testdata/jsps/beanVariableResolution.jsp.data", "/beanVariableResolution.jsp", JSFVersion.V1_1, "/testdata/web/faces-config_1_1.xml.data");
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testSanity() {
        BeanVariableResolutionTestCase.assertEquals((String)"myBean", (String)ELAssert.getELText(this._structuredDocument, 523));
        BeanVariableResolutionTestCase.assertEquals((String)"myBeanSubClass", (String)ELAssert.getELText(this._structuredDocument, 562));
        BeanVariableResolutionTestCase.assertEquals((String)"mapBean", (String)ELAssert.getELText(this._structuredDocument, 609));
        BeanVariableResolutionTestCase.assertEquals((String)"mapBean1", (String)ELAssert.getELText(this._structuredDocument, 649));
        BeanVariableResolutionTestCase.assertEquals((String)"hiddenBean", (String)ELAssert.getELText(this._structuredDocument, 690));
        BeanVariableResolutionTestCase.assertEquals((String)"myBean_none", (String)ELAssert.getELText(this._structuredDocument, 733));
        BeanVariableResolutionTestCase.assertEquals((String)"myBeanSettable", (String)ELAssert.getELText(this._structuredDocument, 777));
        BeanVariableResolutionTestCase.assertEquals((String)"myBean1", (String)ELAssert.getELText(this._structuredDocument, 851));
        BeanVariableResolutionTestCase.assertEquals((String)"someOtherBeanName", (String)ELAssert.getELText(this._structuredDocument, 891));
    }

    public void testNoErrorExprs() {
        this.assertNoError(523, "Lbeans.MyBean;");
        this.assertNoError(562, "Lbeans.MyBeanSubClass;");
        this.assertNoError(609, "Lbeans.MapBean;");
        this.assertNoError(649, "Lbeans.MapBean;");
        this.assertNoError(690, "Lbeans.MyBean;");
        this.assertNoError(733, "Lbeans.MyBean;");
        this.assertNoError(777, "Lbeans.MyBeanSettable;");
    }

    public void testWarningExprs() {
        List<MockValidationReporter.ReportedProblem> list = this.assertSemanticWarning(851, null, 1);
        ELAssert.assertContainsProblem(list, 20);
        list = this.assertSemanticWarning(891, null, 1);
        ELAssert.assertContainsProblem(list, 20);
    }

    public void testErrorExprs() {
    }
}

