/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.archive.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.jee.archive.ArchiveSaveFailureException;
import org.eclipse.jst.jee.archive.internal.DeleteOnExitUtility;

public class ArchiveUtil {
    protected static String tempDirectoryName;
    protected static File tempDirectory;

    public static String getFileNameTail(String uri) {
        String tempURI = uri.replace('\\', '/');
        while (tempURI.endsWith("/")) {
            tempURI = tempURI.substring(0, tempURI.length() - 1);
        }
        int lastIndex = tempURI.lastIndexOf(47);
        if (lastIndex == -1) {
            return uri;
        }
        return uri.substring(lastIndex + 1, tempURI.length());
    }

    public static File getTempDirectory() {
        return tempDirectory;
    }

    public static File createTempFile(String baseName) throws IOException {
        return ArchiveUtil.createTempFile(baseName, ArchiveUtil.getTempDirectory());
    }

    public static File createTempFile(String baseName, File directory) throws IOException {
        String fileName = ArchiveUtil.getFileNameTail(baseName);
        if (fileName.length() < 3) {
            fileName = "WSTMP" + fileName;
        }
        File tempFile = File.createTempFile(fileName, null, directory);
        DeleteOnExitUtility.markForDeletion(tempFile);
        return tempFile;
    }

    public static List getWriteProtectedFiles(File aFile, List aList) {
        if (aList == null) {
            aList = new ArrayList<File>();
        }
        if (aFile.exists() && !aFile.canWrite()) {
            aList.add(aFile);
        }
        if (aFile.isDirectory()) {
            File[] files = aFile.listFiles();
            int i = 0;
            while (i < files.length) {
                ArchiveUtil.getWriteProtectedFiles(files[i], aList);
                ++i;
            }
        }
        return aList;
    }

    public static void checkWriteable(File aFile) throws ArchiveSaveFailureException {
        List locked = ArchiveUtil.getWriteProtectedFiles(aFile, null);
        if (locked.isEmpty()) {
            return;
        }
        StringBuffer msg = new StringBuffer();
        msg.append("Cannot write to file: ");
        msg.append(aFile.getAbsolutePath());
        msg.append('\n');
        msg.append("One or more files is write protected or locked:");
        msg.append('\n');
        int i = 0;
        while (i < locked.size()) {
            File lockedFile = (File)locked.get(i);
            msg.append(lockedFile.getAbsolutePath());
            msg.append('\n');
            ++i;
        }
        throw new ArchiveSaveFailureException(msg.toString());
    }

    public static boolean delete(File aFile) {
        File[] files;
        if (aFile == null) {
            return true;
        }
        if (aFile.isDirectory() && (files = aFile.listFiles()) != null) {
            int i = 0;
            while (i < files.length) {
                if (!ArchiveUtil.delete(files[i])) {
                    return false;
                }
                ++i;
            }
        }
        return aFile.delete();
    }

    public static boolean isRenameable(File orig) {
        File origCopy1 = null;
        File origCopy2 = null;
        try {
            origCopy1 = orig.getCanonicalFile();
            origCopy2 = orig.getCanonicalFile();
        }
        catch (IOException iOException) {
            return false;
        }
        String name = null;
        String baseName = "save.tmp";
        try {
            if (orig.getParent() != null) {
                baseName = new File(orig.getParent(), baseName).getCanonicalPath();
            }
        }
        catch (IOException iOException) {
            return false;
        }
        File temp = null;
        int index = 0;
        do {
            name = String.valueOf(baseName) + index;
            temp = new File(name);
            ++index;
        } while (temp.exists());
        return origCopy1.renameTo(temp) && temp.renameTo(origCopy2);
    }

    public static void cleanupAfterTempSave(String aUri, File original, File destinationFile) throws ArchiveSaveFailureException {
        ArchiveUtil.checkWriteable(original);
        boolean deleteWorked = false;
        if (original.isDirectory()) {
            ArchiveUtil.isRenameable(original);
        }
        int i = 0;
        while (i < 10) {
            if (ArchiveUtil.delete(original)) {
                deleteWorked = true;
                break;
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
        if (deleteWorked) {
            i = 0;
            while (i < 10) {
                if (destinationFile.renameTo(original)) {
                    DeleteOnExitUtility.fileHasBeenDeleted(destinationFile);
                    return;
                }
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
                ++i;
            }
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        try {
            int n = in.read(buffer);
            while (n > 0) {
                out.write(buffer, 0, n);
                n = in.read(buffer);
            }
        }
        finally {
            if (!(in instanceof ZipInputStream)) {
                in.close();
            }
            if (!(out instanceof ZipOutputStream)) {
                out.close();
            }
        }
    }

    public static void warn(Throwable e) {
        Logger.getLogger().logWarning(e);
    }

    public static void warn(String message) {
        Logger.getLogger().logWarning(message);
    }

    public static ZipFile newZipFile(String fileName) throws ZipException, IOException {
        return ArchiveUtil.newZipFile(new File(fileName), 1);
    }

    public static ZipFile newZipFile(File aFile) throws ZipException, IOException {
        return ArchiveUtil.newZipFile(aFile, 1);
    }

    public static ZipFile newZipFile(File aFile, int mode) throws ZipException, IOException {
        return new ZipFile(aFile, mode){
            Collection<InputStream> openStreams = null;

            public InputStream getInputStream(ZipEntry entry) throws IOException {
                InputStream in = super.getInputStream(entry);
                if (in != null) {
                    if (this.openStreams == null) {
                        this.openStreams = new ArrayList<InputStream>();
                    }
                    this.openStreams.add(in);
                }
                return in;
            }

            public void close() throws IOException {
                this.closeOpenStreams();
                super.close();
            }

            private void closeOpenStreams() {
                if (this.openStreams != null) {
                    for (InputStream in : this.openStreams) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            ArchiveUtil.warn(e);
                        }
                    }
                }
            }
        };
    }
}

