/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value.swing;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionListener;
import org.eclipse.jpt.utility.internal.CollectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectListSelectionModel
extends DefaultListSelectionModel {
    private final ListModel listModel;
    private final ListDataListener listDataListener;

    public ObjectListSelectionModel(ListModel listModel) {
        this.listModel = listModel;
        this.listDataListener = this.buildListDataListener();
    }

    private ListDataListener buildListDataListener() {
        return new ListDataListener(){

            public void intervalAdded(ListDataEvent event) {
            }

            public void intervalRemoved(ListDataEvent event) {
            }

            public void contentsChanged(ListDataEvent event) {
                ObjectListSelectionModel.this.listModelContentsChanged(event);
            }

            public String toString() {
                return "list data listener";
            }
        };
    }

    protected void listModelContentsChanged(ListDataEvent event) {
    }

    @Override
    public void addListSelectionListener(ListSelectionListener l) {
        if (this.hasNoListSelectionListeners()) {
            this.listModel.addListDataListener(this.listDataListener);
        }
        super.addListSelectionListener(l);
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener l) {
        super.removeListSelectionListener(l);
        if (this.hasNoListSelectionListeners()) {
            this.listModel.removeListDataListener(this.listDataListener);
        }
    }

    protected boolean hasNoListSelectionListeners() {
        return this.getListSelectionListeners().length == 0;
    }

    public ListModel getListModel() {
        return this.listModel;
    }

    public int selectedValuesSize() {
        int min = this.getMinSelectionIndex();
        int max = this.getMaxSelectionIndex();
        if (min < 0 || max < 0) {
            return 0;
        }
        int n = 0;
        int count = this.getListModel().getSize();
        int i = min;
        while (i <= max) {
            if (this.isSelectedIndex(i) && i < count) {
                ++n;
            }
            ++i;
        }
        return n;
    }

    public Object selectedValue() {
        int index = this.getMinSelectionIndex();
        if (index == -1) {
            return null;
        }
        if (this.getListModel().getSize() <= index) {
            return null;
        }
        return this.getListModel().getElementAt(index);
    }

    public Object[] selectedValues() {
        int min = this.getMinSelectionIndex();
        int max = this.getMaxSelectionIndex();
        if (min < 0 || max < 0) {
            return new Object[0];
        }
        int maxSize = max - min + 1;
        Object[] temp = new Object[maxSize];
        int n = 0;
        int count = this.getListModel().getSize();
        int i = min;
        while (i <= max) {
            if (this.isSelectedIndex(i) && i < count) {
                temp[n++] = this.getListModel().getElementAt(i);
            }
            ++i;
        }
        if (n == maxSize) {
            return temp;
        }
        Object[] result = new Object[n];
        System.arraycopy(temp, 0, result, 0, n);
        return result;
    }

    public int[] selectedIndices() {
        int min = this.getMinSelectionIndex();
        int max = this.getMaxSelectionIndex();
        if (min < 0 || max < 0) {
            return new int[0];
        }
        int maxSize = max - min + 1;
        int[] temp = new int[maxSize];
        int n = 0;
        int count = this.getListModel().getSize();
        int i = min;
        while (i <= max) {
            if (this.isSelectedIndex(i) && i < count) {
                temp[n++] = i;
            }
            ++i;
        }
        if (n == maxSize) {
            Arrays.sort(temp);
            return temp;
        }
        int[] result = new int[n];
        System.arraycopy(temp, 0, result, 0, n);
        Arrays.sort(result);
        return result;
    }

    public void setSelectedValue(Object object) {
        this.setSelectedValues(CollectionTools.singletonIterator(object));
    }

    public void setSelectedValues(Iterator<?> objects) {
        this.setValueIsAdjusting(true);
        this.clearSelection();
        this.addSelectedValuesInternal(objects);
        this.setValueIsAdjusting(false);
    }

    public void setSelectedValues(Collection<?> objects) {
        this.setSelectedValues(objects.iterator());
    }

    public void setSelectedValues(Object[] objects) {
        this.setSelectedValues(CollectionTools.iterator(objects));
    }

    public void addSelectedValue(Object object) {
        this.addSelectedValues(CollectionTools.singletonIterator(object));
    }

    public void addSelectedValues(Iterator<?> objects) {
        this.setValueIsAdjusting(true);
        this.addSelectedValuesInternal(objects);
        this.setValueIsAdjusting(false);
    }

    public void addSelectedValues(Collection<?> objects) {
        this.addSelectedValues(objects.iterator());
    }

    public void addSelectedValues(Object[] objects) {
        this.addSelectedValues(CollectionTools.iterator(objects));
    }

    public void removeSelectedValue(Object object) {
        this.removeSelectedValues(CollectionTools.singletonIterator(object));
    }

    public void removeSelectedValues(Iterator<?> objects) {
        this.setValueIsAdjusting(true);
        ListModel lm = this.getListModel();
        int lmSize = lm.getSize();
        while (objects.hasNext()) {
            int index = this.indexOf(objects.next(), lm, lmSize);
            this.removeSelectionInterval(index, index);
        }
        this.setValueIsAdjusting(false);
    }

    public void removeSelectedValues(Collection<?> objects) {
        this.removeSelectedValues(objects.iterator());
    }

    public void removeSelectedValues(Object[] objects) {
        this.removeSelectedValues(CollectionTools.iterator(objects));
    }

    public Object getAnchorSelectedValue() {
        int index = this.getAnchorSelectionIndex();
        if (index == -1) {
            return null;
        }
        return this.getListModel().getElementAt(index);
    }

    public void setAnchorSelectedValue(Object object) {
        this.setAnchorSelectionIndex(this.indexOf(object));
    }

    public Object getLeadSelectedValue() {
        int index = this.getLeadSelectionIndex();
        if (index == -1) {
            return null;
        }
        return this.getListModel().getElementAt(index);
    }

    public void setLeadSelectedValue(Object object) {
        this.setLeadSelectionIndex(this.indexOf(object));
    }

    public Object getMaxSelectedValue() {
        int index = this.getMaxSelectionIndex();
        if (index == -1) {
            return null;
        }
        return this.getListModel().getElementAt(index);
    }

    public Object getMinSelectedValue() {
        int index = this.getMinSelectionIndex();
        if (index == -1) {
            return null;
        }
        return this.getListModel().getElementAt(index);
    }

    public boolean valueIsSelected(Object object) {
        return this.isSelectedIndex(this.indexOf(object));
    }

    private void addSelectedValuesInternal(Iterator<?> objects) {
        ListModel lm = this.getListModel();
        int listModelSize = lm.getSize();
        while (objects.hasNext()) {
            int index = this.indexOf(objects.next(), lm, listModelSize);
            this.addSelectionInterval(index, index);
        }
    }

    private int indexOf(Object object) {
        ListModel lm = this.getListModel();
        return this.indexOf(object, lm, lm.getSize());
    }

    private int indexOf(Object object, ListModel lm, int listModelSize) {
        int i = listModelSize;
        while (i-- > 0) {
            if (lm.getElementAt(i) != object) continue;
            return i;
        }
        return -1;
    }
}

