/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.model.value.PropertyValueModelWrapper;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringPropertyValueModel<T>
extends PropertyValueModelWrapper<T>
implements PropertyValueModel<T> {
    protected final Filter<T> filter;
    protected final T defaultValue;

    public FilteringPropertyValueModel(PropertyValueModel<? extends T> valueHolder) {
        this(valueHolder, Filter.Disabled.instance(), null);
    }

    public FilteringPropertyValueModel(PropertyValueModel<? extends T> valueHolder, T defaultValue) {
        this(valueHolder, Filter.Disabled.instance(), (T)defaultValue);
    }

    public FilteringPropertyValueModel(PropertyValueModel<? extends T> valueHolder, Filter<T> filter) {
        this(valueHolder, filter, null);
    }

    public FilteringPropertyValueModel(PropertyValueModel<? extends T> valueHolder, Filter<T> filter, T defaultValue) {
        super(valueHolder);
        this.filter = filter;
        this.defaultValue = defaultValue;
    }

    @Override
    public T getValue() {
        return this.filterValue(this.valueHolder.getValue());
    }

    @Override
    protected void valueChanged(PropertyChangeEvent event) {
        Object oldValue = this.filterValue(event.getOldValue());
        Object newValue = this.filterValue(event.getNewValue());
        this.firePropertyChanged("value", oldValue, newValue);
    }

    protected T filterValue(T value) {
        return this.accept(value) ? value : this.defaultValue();
    }

    protected boolean accept(T value) {
        return this.filter.accept(value);
    }

    protected T defaultValue() {
        return this.defaultValue;
    }
}

