/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.iterables;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.utility.internal.iterators.TreeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeIterable<E>
implements Iterable<E> {
    private final Iterable<? extends E> roots;
    private final TreeIterator.Midwife<E> midwife;

    public TreeIterable(E root) {
        this(new SingleElementIterable<E>(root));
    }

    public TreeIterable(E root, TreeIterator.Midwife<E> midwife) {
        this(new SingleElementIterable<E>(root), midwife);
    }

    public TreeIterable(E ... roots) {
        this(Arrays.asList(roots));
    }

    public TreeIterable(E[] roots, TreeIterator.Midwife<E> midwife) {
        this(Arrays.asList(roots), midwife);
    }

    public TreeIterable(Iterable<? extends E> roots) {
        this.roots = roots;
        this.midwife = new DefaultMidwife();
    }

    public TreeIterable(Iterable<? extends E> roots, TreeIterator.Midwife<E> midwife) {
        this.roots = roots;
        this.midwife = midwife;
    }

    @Override
    public Iterator<E> iterator() {
        return new TreeIterator<E>(this.roots, this.midwife);
    }

    protected Iterator<? extends E> children(E next) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.roots);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DefaultMidwife
    implements TreeIterator.Midwife<E> {
        DefaultMidwife() {
        }

        @Override
        public Iterator<? extends E> children(E node) {
            return TreeIterable.this.children(node);
        }
    }
}

