/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.wizards.gen;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.jpt.db.JptDbPlugin;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.gen.internal2.ORMGenCustomizer;
import org.eclipse.jpt.ui.CommonImages;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.util.SWTUtil;
import org.eclipse.jpt.ui.internal.util.TableLayoutComposite;
import org.eclipse.jpt.ui.internal.wizards.gen.DatabaseGroup;
import org.eclipse.jpt.ui.internal.wizards.gen.GenerateEntitiesFromSchemaWizard;
import org.eclipse.jpt.ui.internal.wizards.gen.JptUiEntityGenMessages;
import org.eclipse.jpt.ui.internal.wizards.gen.PromptJPAProjectWizardPage;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TablesSelectorWizardPage
extends WizardPage {
    private static final int TABLE_COLUMN_INDEX = 0;
    private JpaProject jpaProject;
    private Schema schema = null;
    private ORMGenCustomizer customizer = null;
    private boolean synchronizePersistenceXml = true;
    private DatabaseGroup databaseGroup;
    private CheckboxTableViewer tableTable;

    TablesSelectorWizardPage(JpaProject jpaProject) {
        super("TablesSelectorWizardPage");
        this.jpaProject = jpaProject;
        this.schema = jpaProject.getDefaultDbSchema();
        this.setTitle(JptUiEntityGenMessages.GenerateEntitiesWizard_tableSelectPage_selectTable);
        this.setMessage(JptUiEntityGenMessages.GenerateEntitiesWizard_tableSelectPage_chooseEntityTable);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.doStatusUpdate();
    }

    ConnectionProfile getProjectConnectionProfile() {
        String profileName = this.jpaProject.getDataSource().getConnectionProfileName();
        return this.connectionProfileNamed(profileName);
    }

    ConnectionProfile connectionProfileNamed(String profileName) {
        return JptDbPlugin.instance().getConnectionProfileFactory().buildConnectionProfile(profileName);
    }

    Schema getSchema() {
        return this.schema;
    }

    void setSchema(Schema s) {
        this.schema = s;
    }

    public Collection<org.eclipse.jpt.db.Table> getTables() {
        Schema schema = this.getSchema();
        if (schema != null && schema.getName() != null) {
            return CollectionTools.collection((Iterator)schema.tables());
        }
        return Collections.emptyList();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 3;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.getHelpSystem().setHelp((Control)composite, "org.eclipse.jpt.ui.dialog_selectTablesPage");
        this.databaseGroup = this.createDatabaseGroup(composite, 400);
        this.createTablesSelectionControl(composite, nColumns);
        new Label(composite, 0);
        final Button synchronizeClassesCheckBox = new Button(composite, 32);
        synchronizeClassesCheckBox.setText(JptUiEntityGenMessages.GenerateEntitiesWizard_tableSelectPage_synchronizeClasses);
        synchronizeClassesCheckBox.setSelection(true);
        synchronizeClassesCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TablesSelectorWizardPage.this.setSynchronizePersistenceXml(synchronizeClassesCheckBox.getSelection());
            }
        });
        this.fillColumns((Control)synchronizeClassesCheckBox, 2);
        new Label(composite, 0);
        Button restoreBtn = new Button(composite, 8);
        restoreBtn.setText(JptUiEntityGenMessages.GenerateEntitiesWizard_tableSelectPage_Restore_Defaults);
        restoreBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (TablesSelectorWizardPage.this.customizer != null && TablesSelectorWizardPage.this.customizer.getFile() != null) {
                    if (TablesSelectorWizardPage.this.customizer.getFile().exists()) {
                        TablesSelectorWizardPage.this.customizer.getFile().delete();
                    }
                    TablesSelectorWizardPage.this.updateTablesSelector(TablesSelectorWizardPage.this.databaseGroup.getSelectedSchema());
                    TablesSelectorWizardPage.this.deselectAllTables();
                }
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 0x1000008;
        restoreBtn.setLayoutData((Object)gridData);
        this.getHelpSystem().setHelp(this.tableTable.getControl(), "org.eclipse.jpt.ui.dialog_generateEntities_tables");
        this.setControl((Control)composite);
        this.setPageComplete(true);
    }

    public void dispose() {
        if (this.databaseGroup != null) {
            this.databaseGroup.dispose();
        }
        super.dispose();
    }

    public IWizardPage getPreviousPage() {
        IWizardPage prevPage = super.getPreviousPage();
        if (prevPage instanceof PromptJPAProjectWizardPage) {
            return prevPage.getPreviousPage();
        }
        return prevPage;
    }

    private DatabaseGroup createDatabaseGroup(Composite parent, int widthHint) {
        DatabaseGroup dbGroup = new DatabaseGroup(this.getContainer(), this.jpaProject, parent, widthHint);
        class DatabasePageListener
        implements DatabaseGroup.Listener {
            DatabasePageListener() {
            }

            public void selectedConnectionProfileChanged(ConnectionProfile connectionProfile) {
                TablesSelectorWizardPage.this.jpaProject.getDataSource().setConnectionProfileName(connectionProfile.getName());
                JptCorePlugin.setConnectionProfileName((IProject)TablesSelectorWizardPage.this.jpaProject.getProject(), (String)connectionProfile.getName());
            }

            public void selectedSchemaChanged(Schema schema) {
                if (schema == null) {
                    TablesSelectorWizardPage.this.updateTablesListViewer(Collections.EMPTY_LIST);
                    TablesSelectorWizardPage.this.doStatusUpdate();
                    return;
                }
                TablesSelectorWizardPage.this.jpaProject.setUserOverrideDefaultSchema(schema.getIdentifier());
                TablesSelectorWizardPage.this.setSchema(schema);
                TablesSelectorWizardPage.this.updateTablesSelector(schema);
                TablesSelectorWizardPage.this.doStatusUpdate();
            }
        }
        dbGroup.addListener(new DatabasePageListener());
        dbGroup.init();
        return dbGroup;
    }

    boolean synchronizePersistenceXml() {
        return this.synchronizePersistenceXml;
    }

    private void setSynchronizePersistenceXml(boolean synchronizePersistenceXml) {
        this.synchronizePersistenceXml = synchronizePersistenceXml;
    }

    private void selectAllTables() {
        this.tableTable.setAllChecked(true);
        this.doStatusUpdate();
    }

    private void deselectAllTables() {
        this.tableTable.setAllChecked(false);
        this.doStatusUpdate();
    }

    private void initTablesSelectionControl(Collection<org.eclipse.jpt.db.Table> nonEmptyTables) {
        this.tableTable.setInput(nonEmptyTables);
    }

    private void createTablesSelectionControl(Composite parent, int columns) {
        Label tableLabel = new Label(parent, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        tableLabel.setLayoutData((Object)gd);
        tableLabel.setText(JptUiEntityGenMessages.GenerateEntitiesWizard_tableSelectPage_tables);
        TableLayoutComposite layout = new TableLayoutComposite(parent, 0);
        this.addColumnLayoutData(layout);
        Table table = new Table((Composite)layout, 68388);
        TableColumn tableNameColumn = new TableColumn(table, 0, 0);
        tableNameColumn.setText(JptUiEntityGenMessages.GenerateEntitiesWizard_tableSelectPage_tableColumn);
        tableNameColumn.setResizable(true);
        gd = new GridData(1808);
        gd.heightHint = SWTUtil.getTableHeightHint(table, 20);
        gd.widthHint = 250;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        layout.setLayoutData(gd);
        layout.setBackground(new Color((Device)Display.getDefault(), 255, 0, 0));
        this.tableTable = new CheckboxTableViewer(table);
        this.tableTable.setUseHashlookup(true);
        this.tableTable.setLabelProvider(this.buildTableTableLabelProvider());
        this.tableTable.setContentProvider(this.buildTableTableContentProvider());
        this.tableTable.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((org.eclipse.jpt.db.Table)e1).getName().compareTo(((org.eclipse.jpt.db.Table)e2).getName());
            }
        });
        this.tableTable.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TablesSelectorWizardPage.this.handleTablesListSelectionChanged(event);
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000B && e.stateMask == 0) {
                    TablesSelectorWizardPage.this.editEntityNameIfPossible();
                    e.doit = false;
                }
            }
        });
        this.updateTablesSelector(this.databaseGroup.getSelectedSchema());
        this.createButtonComposite(parent);
        GenerateEntitiesFromSchemaWizard generateEntitiesWizard = (GenerateEntitiesFromSchemaWizard)this.getWizard();
        Collection<org.eclipse.jpt.db.Table> possibleTables = generateEntitiesWizard.getPossibleTables();
        this.initTablesSelectionControl(possibleTables);
    }

    private void createButtonComposite(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout buttonLayout = new GridLayout(1, false);
        buttonComposite.setLayout((Layout)buttonLayout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        buttonComposite.setLayoutData((Object)data);
        Button selectAllButton = new Button(buttonComposite, 8);
        selectAllButton.setToolTipText(JptUiMessages.General_selectAll);
        selectAllButton.setImage(CommonImages.createImage(CommonImages.DESC_BUTTON_SELECT_ALL));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        selectAllButton.setLayoutData((Object)gridData);
        selectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TablesSelectorWizardPage.this.selectAllTables();
            }
        });
        Button deselectAllButton = new Button(buttonComposite, 8);
        deselectAllButton.setToolTipText(JptUiMessages.General_deselectAll);
        deselectAllButton.setImage(CommonImages.createImage(CommonImages.DESC_BUTTON_DESELECT_ALL));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        deselectAllButton.setLayoutData((Object)gridData);
        deselectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TablesSelectorWizardPage.this.deselectAllTables();
            }
        });
    }

    private void addColumnLayoutData(TableLayoutComposite layout) {
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
    }

    void editEntityNameIfPossible() {
        Object[] selected = ((IStructuredSelection)this.tableTable.getSelection()).toArray();
        if (selected.length != 1) {
            return;
        }
    }

    void handleTablesListSelectionChanged(SelectionChangedEvent event) {
        this.doStatusUpdate();
    }

    private IBaseLabelProvider buildTableTableLabelProvider() {
        return new TableTableLabelProvider();
    }

    private IContentProvider buildTableTableContentProvider() {
        return new TableTableContentProvider();
    }

    Collection<org.eclipse.jpt.db.Table> getSelectedTables() {
        ArrayList<org.eclipse.jpt.db.Table> selectedTables = new ArrayList<org.eclipse.jpt.db.Table>();
        Object[] objectArray = this.tableTable.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectedTable = objectArray[n2];
            selectedTables.add((org.eclipse.jpt.db.Table)selectedTable);
            ++n2;
        }
        return selectedTables;
    }

    private boolean hasTablesSelected() {
        return this.tableTable != null ? this.getSelectedTables().size() > 0 : false;
    }

    void updateTablesListViewer(Collection<org.eclipse.jpt.db.Table> possibleTables) {
        if (this.tableTable != null) {
            this.initTablesSelectionControl(possibleTables);
        }
    }

    protected void doStatusUpdate() {
        if (!this.hasTablesSelected()) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
            try {
                this.getContainer().run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("Updating", 10);
                        Collection<org.eclipse.jpt.db.Table> ret = TablesSelectorWizardPage.this.getSelectedTables();
                        ArrayList<String> tableNames = new ArrayList<String>();
                        for (org.eclipse.jpt.db.Table t : ret) {
                            tableNames.add(t.getName());
                        }
                        Schema schema = TablesSelectorWizardPage.this.getSchema();
                        if (schema == null) {
                            return;
                        }
                        TablesSelectorWizardPage.this.customizer.setSchema(schema);
                        TablesSelectorWizardPage.this.customizer.setTableNames(tableNames);
                        monitor.done();
                    }
                });
            }
            catch (Exception e) {
                JptUiPlugin.log(e);
            }
        }
    }

    private void updateTablesSelector(Schema schema) {
        if (schema == null) {
            return;
        }
        this.jpaProject.setUserOverrideDefaultSchema(schema.getName());
        JptCorePlugin.setUserOverrideDefaultSchemaName((IProject)this.jpaProject.getProject(), (String)schema.getName());
        this.updateTablesListViewer(this.filterEmptyTables(schema.tables()));
        GenerateEntitiesFromSchemaWizard wizard = (GenerateEntitiesFromSchemaWizard)this.getWizard();
        this.customizer = wizard.createORMGenCustomizer(schema);
        if (this.tableTable != null && this.customizer != null) {
            this.restoreWizardState();
        }
        this.doStatusUpdate();
    }

    private Collection<org.eclipse.jpt.db.Table> filterEmptyTables(Iterator<org.eclipse.jpt.db.Table> tables) {
        ArrayList<org.eclipse.jpt.db.Table> nonEmptyTables = new ArrayList<org.eclipse.jpt.db.Table>();
        while (tables.hasNext()) {
            org.eclipse.jpt.db.Table candidateTable = tables.next();
            if (candidateTable.columnsSize() <= 0) continue;
            nonEmptyTables.add(candidateTable);
        }
        return nonEmptyTables;
    }

    private boolean restoreWizardState() {
        boolean pageComplete = false;
        List preSelectedTableNames = this.customizer.getTableNames();
        if (preSelectedTableNames != null && preSelectedTableNames.size() > 0) {
            HashSet<String> set = new HashSet<String>();
            for (String s : preSelectedTableNames) {
                set.add(s);
            }
            TableItem[] items = this.tableTable.getTable().getItems();
            int i = 0;
            while (i < items.length) {
                TableItem item = items[i];
                org.eclipse.jpt.db.Table element = (org.eclipse.jpt.db.Table)item.getData();
                if (element != null) {
                    boolean check = set.contains(element.getName());
                    if (item.getChecked() != check) {
                        item.setChecked(check);
                        pageComplete = true;
                    }
                }
                ++i;
            }
        }
        return pageComplete;
    }

    private void fillColumns(Control c, int columns) {
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = columns;
        layoutData.verticalAlignment = 4;
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = false;
        c.setLayoutData((Object)layoutData);
    }

    public final void performHelp() {
        this.getHelpSystem().displayHelp("org.eclipse.jpt.ui.GenerateEntitiesFromSchemaWizard");
    }

    protected final IWorkbenchHelpSystem getHelpSystem() {
        return PlatformUI.getWorkbench().getHelpSystem();
    }

    private class TableTableContentProvider
    implements IStructuredContentProvider {
        TableTableContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return ((Collection)inputElement).toArray();
        }
    }

    private class TableTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableTableLabelProvider() {
        }

        public String getText(Object element) {
            return ((org.eclipse.jpt.db.Table)element).getName();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element == null) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return ((org.eclipse.jpt.db.Table)element).getName();
                }
            }
            throw new IllegalArgumentException("invalid column index: " + columnIndex);
        }
    }
}

