/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.ui.details.AttributeMappingUiProvider;
import org.eclipse.jpt.ui.details.DefaultAttributeMappingUiProvider;
import org.eclipse.jpt.ui.details.DefaultMappingUiProvider;
import org.eclipse.jpt.ui.details.MappingUiProvider;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.MapAsComposite;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentAttributeMapAsComposite
extends MapAsComposite<PersistentAttribute> {
    public PersistentAttributeMapAsComposite(Pane<? extends PersistentAttribute> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    @Override
    protected String getMappingKey() {
        return ((PersistentAttribute)this.getSubject()).getMappingKey();
    }

    @Override
    protected MapAsComposite.MappingChangeHandler buildMappingChangeHandler() {
        return new MapAsComposite.MappingChangeHandler(){

            @Override
            public String getLabelText() {
                String mappingKey = PersistentAttributeMapAsComposite.this.getMappingKey();
                if (mappingKey != MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY) {
                    return JptUiMappingsMessages.MapAsComposite_mappedAttributeText;
                }
                if (((PersistentAttribute)PersistentAttributeMapAsComposite.this.getSubject()).isVirtual()) {
                    return JptUiMappingsMessages.MapAsComposite_virtualAttributeText;
                }
                return JptUiMappingsMessages.MapAsComposite_unmappedAttributeText;
            }

            @Override
            public String getMappingText() {
                String mappingKey = PersistentAttributeMapAsComposite.this.getMappingKey();
                if (mappingKey == null) {
                    return JptUiMappingsMessages.MapAsComposite_changeMappingType;
                }
                if (((PersistentAttribute)PersistentAttributeMapAsComposite.this.getSubject()).getSpecifiedMapping() == null) {
                    return PersistentAttributeMapAsComposite.this.getDefaultProvider(((PersistentAttribute)PersistentAttributeMapAsComposite.this.getSubject()).getDefaultMappingKey()).getLinkLabel();
                }
                return PersistentAttributeMapAsComposite.this.getProvider(mappingKey).getLinkLabel();
            }

            @Override
            public void morphMapping(MappingUiProvider<?> provider) {
                ((PersistentAttribute)PersistentAttributeMapAsComposite.this.getSubject()).setSpecifiedMappingKey(provider.getKey());
            }

            @Override
            public String getName() {
                return ((PersistentAttribute)PersistentAttributeMapAsComposite.this.getSubject()).getName();
            }

            @Override
            public Iterator<? extends MappingUiProvider<?>> providers() {
                return PersistentAttributeMapAsComposite.this.attributeMappingUiProviders();
            }
        };
    }

    protected Iterator<AttributeMappingUiProvider<? extends AttributeMapping>> attributeMappingUiProviders() {
        return this.getJpaPlatformUi().attributeMappingUiProviders(((PersistentAttribute)this.getSubject()).getContentType());
    }

    @Override
    protected DefaultMappingUiProvider<?> getDefaultProvider() {
        return this.getDefaultProvider(((PersistentAttribute)this.getSubject()).getDefaultMappingKey());
    }

    @Override
    protected DefaultMappingUiProvider<?> getDefaultProvider(String mappingKey) {
        return this.getJpaPlatformUi().getDefaultAttributeMappingUiProvider(mappingKey, ((PersistentAttribute)this.getSubject()).getContentType());
    }

    protected Iterator<DefaultAttributeMappingUiProvider<? extends AttributeMapping>> defaultAttributeMappingUiProviders() {
        return this.getJpaPlatformUi().defaultAttributeMappingUiProviders(((PersistentAttribute)this.getSubject()).getContentType());
    }

    @Override
    protected void addPropertyNames(Collection<String> propertyNames) {
        super.addPropertyNames(propertyNames);
        propertyNames.add("defaultMapping");
        propertyNames.add("specifiedMapping");
        propertyNames.add("name");
    }

    @Override
    protected void propertyChanged(String propertyName) {
        super.propertyChanged(propertyName);
        if (propertyName == "specifiedMapping" || propertyName == "defaultMapping" || propertyName == "name") {
            this.updateDescription();
        }
    }
}

