/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.eclipselink.core.resource.java.TransformerAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SourceTransformerAnnotation
extends SourceAnnotation<Attribute>
implements TransformerAnnotation {
    final DeclarationAnnotationElementAdapter<String> transformerClassDeclarationAdapter;
    final AnnotationElementAdapter<String> transformerClassAdapter;
    String transformerClass;
    final DeclarationAnnotationElementAdapter<String> methodDeclarationAdapter;
    final AnnotationElementAdapter<String> methodAdapter;
    String method;

    SourceTransformerAnnotation(JavaResourcePersistentAttribute parent, Attribute attribute, DeclarationAnnotationAdapter daa) {
        super((JavaResourceNode)parent, (Member)attribute, daa);
        this.transformerClassDeclarationAdapter = new ConversionDeclarationAnnotationElementAdapter(daa, this.getTransformerClassElementName(), false, SimpleTypeStringExpressionConverter.instance());
        this.transformerClassAdapter = new ShortCircuitAnnotationElementAdapter((Member)attribute, this.transformerClassDeclarationAdapter);
        this.methodDeclarationAdapter = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)this.getMethodElementName(), (boolean)false);
        this.methodAdapter = new ShortCircuitAnnotationElementAdapter((Member)attribute, this.methodDeclarationAdapter);
    }

    public void initialize(CompilationUnit astRoot) {
        this.transformerClass = this.buildTransformerClass(astRoot);
        this.method = this.buildMethod(astRoot);
    }

    public void update(CompilationUnit astRoot) {
        this.setTransformerClass(this.buildTransformerClass(astRoot));
        this.setMethod(this.buildMethod(astRoot));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.transformerClass);
    }

    @Override
    public String getTransformerClass() {
        return this.transformerClass;
    }

    @Override
    public void setTransformerClass(String transformerClass) {
        if (this.attributeValueHasNotChanged(this.transformerClass, transformerClass)) {
            return;
        }
        String old = this.transformerClass;
        this.transformerClass = transformerClass;
        this.transformerClassAdapter.setValue((Object)transformerClass);
        this.firePropertyChanged("transformerClass", old, transformerClass);
    }

    private String buildTransformerClass(CompilationUnit astRoot) {
        return (String)this.transformerClassAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getTransformerClassTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.transformerClassDeclarationAdapter, astRoot);
    }

    abstract String getTransformerClassElementName();

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public void setMethod(String method) {
        if (this.attributeValueHasNotChanged(this.method, method)) {
            return;
        }
        String old = this.method;
        this.method = method;
        this.methodAdapter.setValue((Object)method);
        this.firePropertyChanged("method", old, method);
    }

    private String buildMethod(CompilationUnit astRoot) {
        return (String)this.methodAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getMethodTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.methodDeclarationAdapter, astRoot);
    }

    abstract String getMethodElementName();
}

